/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: value.h
 */
 
gboolean value_less_than_integer (value_t value, value_type_t type, gint number);

gchar* convert_value_to_string (value_t value, value_type_t type, value_format_t format);

void convert_string_to_value (gchar *string, value_type_t type, gint maxlen, value_t *value);

value_list_t* allocate_value_list (guint count, value_type_t type, guint size);

void duplicate_value (value_t source_value, value_type_t type, gboolean is_list, guint list_count, 
                      gint maxlen, value_t *target_value);

void clear_value (value_t *value, value_type_t type, gboolean is_list, guint list_count);

gfloat convert_value_to_float (value_t value, value_type_t type);

void convert_float_to_value (gfloat float_value, value_type_t type, value_t *value);

gdouble convert_value_to_double (value_t value, value_type_t type);

void convert_double_to_value (gdouble double_value, value_type_t type, value_t *value);

u_int64_t convert_value_to_ui64 (value_t value, value_type_t type);

gchar* convert_sector_value_to_string (value_t value, value_type_t type, value_unit_t *new_unit);

value_unit_t get_unit_from_mnemonic (gchar *mnemonic);

gfloat convert_sector_value_to_float_with_unit (value_t value, value_type_t type, 
                                                value_unit_t conversion_unit);

value_unit_t select_readable_unit_for_sector_value (value_t value, value_type_t type);

void convert_size_value_to_sector_value (value_t size_value, value_type_t size_type, 
                                         value_unit_t size_unit, 
                                         value_t *sec_value, value_type_t sec_type);

void convert_float_to_sector_value (gfloat size, value_type_t type, value_unit_t unit, value_t *value);

void convert_size_string_to_sector_value (gchar *string, value_type_t type_out, value_t *value_out);

gchar *convert_value_to_string_with_unit (value_t value, value_type_t type, value_unit_t unit, value_format_t format);

gchar *make_value_readable_string (value_t value, value_type_t type, value_format_t format, 
                                   value_unit_t unit, gboolean ok_to_convert);

gchar* validate_string_as_numeric_value (gchar *string, value_type_t type);

gboolean values_are_equal (value_t value1, value_t value2, value_type_t type);

gboolean value_in_value_list (value_t value, value_list_t *vlist, value_type_t type);
