/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: disk_cb.c
 */ 
 
#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"
#include "destroy.h"
#include "disk_cb.h"
#include "transfer.h"

/*
 *
 *   void on_destroy_disk_button_clicked (GtkButton *, gpointer)
 *
 *   Description:
 *      This routine initiates the destroy API call using the handle
 *      of the disk associated with the last row  selected. It then 
 *      creates and displays the results popup which destroys both 
 *      windows when dismissed.
 * 
 *   Entry:
 *      button    - address of the GtkButton widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      See description.
 *
 */
void on_destroy_disk_button_clicked (GtkButton *button, gpointer user_data)
{
    gchar *error_msg   = _("An error was encountered attempting to destroy the logical disk.");
    gchar *success_msg = _("The logical disk was successfully destroyed.");

    on_destroy_thing_button_clicked (button, error_msg, success_msg);
}

/*
 *
 *   void on_destroy_disk_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of regions that can be destroyed.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable disks
 *
 */
void on_destroy_disk_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_destroy_thing_clist_realize (widget, DISK);
}

/*
 *
 *   void on_remove_disk_from_container_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of disks that can be removed from their consuming
 *      container.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable disks
 *
 */
void on_remove_disk_from_container_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_remove_thing_from_container_clist_realize (widget, DISK);
}
