/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: print_message.c
 */ 

#ifndef _LVM_HELP_PRINT_MESSAGE_
#define _LVM_HELP_PRINT_MESSAGE_

/* Function: print_message
 *
 *	This function is used to display messages from the engine.
 */
int print_message(	char	* message_text,
			int	* answer,
			char	** choices )
{
	if ( message_text ) {
		printf("\nEngine Message:\n");
		printf("%s\n", message_text);

		if ( answer && choices ) {
			printf("Default choice selected: %s\n\n", choices[*answer]);
		}
	}
	return 0;
}

#endif

