/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: screener.c
 */

/*
 * Change History:
 *
 * 6/2001  B. Rafanello  Initial version.
 *
 */

/*
 *
 * This file will need to change in order to provide proper national
 * language support.  But, for development purposes, this will do.
 *
 */

/* Identify this file. */
#define ERROR_C      1

/*--------------------------------------------------
 * Necessary include files
 --------------------------------------------------*/

#include <stdio.h>   /* printf */
#include <string.h>  /* strerror */
#include "token.h"   /* TokenType, Token, MaxIdentifierLength */
#include "error.h"
#include "dlist.h"
#include <asm/errno.h>
//#include "../../Engine/handlemgr.h"

/*--------------------------------------------------
 * Private constants
 --------------------------------------------------*/
#define HANDLE_MANAGER_NOT_INITIALIZED   221
#define HANDLE_MANAGER_BAD_HANDLE        222


/*--------------------------------------------------
 * Private functions
 --------------------------------------------------*/



/*--------------------------------------------------
 * Public Functions
 --------------------------------------------------*/

void Report_Scanner_Error(Scanner_Errors Error, char * Parameter1, char * Parameter2, uint Column, uint Row )
{

  switch (Error)
  {
    case Bad_Command_File :
      printf("\n\nBad command file specified: %s\n\n", Parameter1);
      break;
    case Invalid_Character :
      printf("\n\nAn invalid character was encountered!  In\n%s\nthe character %c is invalid.\n\n",Parameter1,*Parameter2);
      break;
    case Scanner_Out_Of_Memory :
      printf("\n\n Out of memory condition encountered!  Current Buffer:\n%s\nCurrent Character: %c\n\n",Parameter1, *Parameter2);
      break;
    default:
      printf("\n\nUnknown error! \n\n");
  }

  return;

}

void Report_Parser_Error(Parser_Errors Error, char * Filename, TokenType * Token)
{

  switch (Error)
  {
    case Engine_Open_Failure:
      printf("\n\nUnable to open the EVMS Engine!\n\n");
      break;
    case SetInput_Failure:
      printf("\n\nUnable to set the input source for parsing!\n\n");
    case Out_Of_Memory:
      printf("\n\nOut of memory!\n\n");
      break;
    case Expecting_Command_Start:
      printf("\n\nExpecting the start of a new command.\n\n");
      break;
    case Expecting_Command_Name:
      printf("\n\nExpecting command name.\n\n");
      break;
    case Expecting_Command_Name_Or_File:
      printf("\n\nExpecting a command name or a filename.\n\n");
      break;
    case Expecting_Command_File_Name:
      printf("\n\nExpecting the name of a command file.\n\n");
      break;
    case Expecting_Command_Separator:
      printf("\n\nExpecting the command separator.\n\n");
      break;
    case Expecting_Colon_Separator:
      printf("\n\nExpecting a colon.\n\n");
      break;
    case Expecting_Comma_Separator:
      printf("\n\nExpecting a comma.\n\n");
      break;
    case Expecting_Allocate_Or_Assign_Command :
      printf("\n\nExpecting either the Allocate or Assign keyword.\n\n");
    case Expecting_Create_Or_Check_Command:
      printf("\n\nExpecting the Create or Check commands.\n\n");
      break;
    case Expecting_Defrag_Or_Delete_Command:
      printf("\n\nExpecting the Defragment or Delete commands.\n\n");
      break;
    case Expecting_Format_Command:
      printf("\n\nExpecting the Format command.\n\n");
      break;     
    case Expecting_Expand_Command:
      printf("\n\nExpecting the Expand command.\n\n");
      break;
    case Expecting_Probe_Command:
      printf("\n\nExpecting the Probe command.\n\n");
      break;
    case Expecting_Shrink_Command:
      printf("\n\nExpecting the shrink command.\n\n");
      break;
    case Expecting_Shrink_Parameters :
      printf("\n\nExpecting the parameters required to shrink an object/volume.\n\n");
      break;
    case Expecting_Revert_Or_Rename:
      printf("\n\nExpecting either the Remove, Revert, or Rename keywords.\n\n");
      break;
    case Expecting_Help_Command:
      printf("\n\nExpecting the Help command.\n\n");
      break;
    case Expecting_Query_Command:
      printf("\n\nExpecting the Query command.\n\n");
      break;
    case Expecting_Creation_Parameters:
      printf("\n\nExpecting Volume, Object, Container, or Region.\n\n");
      break;
    case Expecting_Name_Or_Compatibility:
      printf("\n\nExpecting the Compatibility keyword or the Name keyword.\n\n");
      break;
    case Expecting_Compatibility_Keyword:
      printf("\n\nExpecting the Compatibility keyword.\n\n");
      break;
    case Expecting_Volume_Parameter:
      printf("\n\nExpecting the Volume parameter.\n\n");
      break;
    case Expecting_Object_Parameter:
      printf("\n\nExpecting the Object parameter.\n\n");
      break;
    case Expecting_Container_Parameter:
      printf("\n\nExpecting the Container parameter.\n\n");
      break;
    case Expecting_Expand_Parameters:
      printf("\n\nExpecting the parameters for an Expand operation .\n\n");
      break;
    case Expecting_Query_Parameters:
      printf("\n\nExpecting either Plugins, Volumes, Regions, Objects, Containers, \nDisks, Segments, Accepatble, Children, Parent, Expand Points, \nShrink Points, or Extended Info keywords.\n\n");
      break;
    case Expecting_Query_Expand_Points_Keywords:
      printf("\n\nExpecting the Expand Points keywords.\n\n");
      break;
    case Expecting_Query_Shrink_Points_Keywords:
      printf("\n\nExpecting the Shrink Points keywords.\n\n");
      break;
    case Expecting_Plugins_Or_Parent_Parameter:
      printf("\n\nExpecting the Plugins or Parent keyword.\n\n");
      break;
    case Expecting_Volumes_Parameter:
      printf("\n\nExpecting the Volumes keyword.\n\n");
      break;
    case Expecting_Regions_Parameter:
      printf("\n\nExpecting the Regions keyword.\n\n");
      break;
    case Expecting_Disks_Parameter:
      printf("\n\nExpecting the Disks keyword.\n\n");
      break;
    case Expecting_Segments_Parameter:
      printf("\n\nExpecting the Segments keyword.\n\n");
      break;
    case Expecting_Objects_Parameter:
      printf("\n\nExpecting the Objects keyword.\n\n");
      break;
    case Expecting_Acceptable_Parameter:
      printf("\n\nExpecting the Acceptable keyword.\n\n");
      break;
    case Expecting_List_Options_Keywords :
      printf("\n\nExpecting the List Options keywords.\n\n");
      break;
    case Expecting_Volume_Or_Object:
      printf("\n\nExpecting a volume or object to be specified.\n\n");
      break;
    case Expecting_Containers_Or_Children_Parameter:
      printf("\n\nExpecting the Containers or Children keywords.\n\n");
      break;
    case Expecting_Help_Parameters:
      printf("\n\nExpecting the topic to provide help information on.\n\n");
      break;
    case Expecting_Plugin_Type_Parameter:
      printf("\n\nExpecting either Feature, Region Manager, Segment Manager, Device Manager, Filesystem Interface Module, Distributed Lock Manager, or Cluster Management.\n\n");
      break;
    case Expecting_Feature_Identifier:
      printf("\n\nExpecting the identifier of a feature.\n\n");
      break;
    case Expecting_Plugin_Identifier:
      printf("\n\nExpecting the identifier of a plugin module.\n\n");
      break;
    case Expecting_Object_Identifier:
      printf("\n\nExpecting the identifier of a storage object.\n\n");
      break;
    case Expecting_Region_Or_Object:
      printf("\n\nExpecting the identifier of a region or object.\n\n");
      break;
    case Expecting_Offset:
      printf("\n\nExpecting an offset to be specified.\n\n");
      break;
    case Expecting_Start_KeyWord:
      printf("\n\nExpecting the Start keyword.\n\n");
      break;
    case Expecting_End_KeyWord:
      printf("\n\nExpecting the End keyword.\n\n");
      break;
    case Expecting_Offset_Parameters:
      printf("\n\nExpecting either Start, End, or a numeric offset.\n\n");
      break;
    case Expecting_Size_Parameters:
      printf("\n\nExpecting a numeric value.\n\n");
      break;
    case Expecting_Size_Value:
      printf("\n\nExpecting a numeric value.\n\n");
      break;
    case Expecting_EQ_Keyword:
      printf("\n\nExpecting the EQ keyword.\n\n");
      break;
    case Expecting_LT_Keyword:
      printf("\n\nExpecting the LT keyword.\n\n");
      break;
    case Expecting_GT_Keyword:
      printf("\n\nExpecting the GT keyword.\n\n");
      break;
    case Expecting_GT_LT_Parameter:
      printf("\n\nExpecting either the GT or LT keywords.\n\n");
      break;
    case Expecting_Units_Parameter:
      printf("\n\nExpecting a unit of measure.  Supported units of measure are: \n     For disks: Kilobytes (KB), Megabytes (MB), Gigabytes (GB), Terrabytes (TB), Sectors.\n     For time: Hours (h), Minutes (min), Seconds (s), Milliseconds (ms), Microseconds (us)\n\n");
      break;
    case Expecting_Disk_Units_Parameter:
      printf("\n\nExpecting a unit of measure.  Supported units of measure are: \n     For disks: Kilobytes (KB), Megabytes (MB), Gigabytes (GB), Terrabytes (TB), Sectors.\n\n");
      break;
    case Expecting_Number_Or_String:
      printf("\n\nExpecting either a numeric value or a string.\n\n");
      break;
    case Expecting_Number:
      printf("\n\nExpecting a numeric value.\n\n");
      break;
    case Expecting_Name:                                          /* Name = "string" */
      printf("\n\nExpecting a name.\n\n");
      break;
    case Expecting_Field_Name:
      printf("\n\nExpecting an extended info field name.\n\n");
      break;
    case Expecting_Name_Value:                                    /* Name portion of Name Value Pair */
      printf("\n\nExpecting the name portion of a Name Value pair.\n\n");
      break;
    case Expecting_Equal_Sign_Separator:
      printf("\n\nExpecting an equal sign.\n\n");
      break;
    case Expecting_Open_Brace_Separator:
      printf("\n\nExpecting an open brace.\n\n");
      break;
    case Expecting_Closing_Brace_Separator:
      printf("\n\nExpecting a closing brace.\n\n");
      break;
    case Expecting_Open_Paren_Separator:
      printf("\n\nExpecting an open parenthesis.\n\n");
      break;
    case Expecting_Closing_Paren_Separator:
      printf("\n\nExpecting a closing parenthesis.\n\n");
      break;
    case Expecting_Name_Value_Pair:
      printf("\n\nExpecting a name-value pair.\n\n");
      break;
    case Expecting_Query_Volume_Parameters:
      printf("\n\nExpecting the parameters for a volume query.\n\n");
      break;
    case Expecting_Query_Plugin_Parameters:
      printf("\n\nExpecting the parameters for a plugin query.\n\n");
      break;
    case Expecting_Query_Region_Parameters:
      printf("\n\nExpecting the parameters for a region query.\n\n");
      break;
    case Expecting_Query_Acceptable_Parameters:
      printf("\n\nExpecting the parameters for an Acceptable query.\n\n");
      break;
    case Expecting_Query_Acceptable_Create:
      printf("\n\nExpecting the type of item to create: \n     Volume, Storage Object, Region, Segment, or Container.\n\n");
      break;
    case Expecting_Region_Creation_Parameters:
      printf("\n\nExpecting the parameters for a region creation.\n\n");
      break;
    case Expecting_Object_List:
      printf("\n\nExpecting a list of storage objects or regions.\n\n");
      break;
    case Expecting_Query_Disks_Parameters:
      printf("\n\nExpecting the parameters for a disk query.\n\n");
      break;
    case Expecting_Volume_Identifier:
      printf("\n\nExpecting the identifier of a volume.\n\n");
      break;
    case Expecting_Region_Identifier:
      printf("\n\nExpecting the identifier of a region.\n\n");
      break;
    case Expecting_Container_Identifier:
      printf("\n\nExpecting the identifier of a container.\n\n");
      break;
    case Expecting_Unclaimed_Identifier:
      printf("\n\nExpecting the Unclaimed keyword.\n\n");
      break;
    case Expecting_Disk_Identifier:
      printf("\n\nExpecting the identifier of a disk.\n\n");
      break;
    case Expecting_Expandable_Shrinkable_Identifier:
      printf("\n\nExpecting the Expandable or Shrinkable keywords.\n\n");
      break;
    case Expecting_Query_Extended_Info_Keywords:
      printf("\n\nExpecting the Extended Info keywords.\n\n");
      break;
    case Expecting_Freespace_Identifier :
      printf("\n\nExpecting the Freespace keyword.\n\n");
      break;
    case Expecting_EVMS_Identifier:
      printf("\n\nExpecting the identifier for a plug-in, volume, storage object, region,\n     container, segment, or disk.\n\n");
    case Internal_Error_Encountered:
      printf("\n\nAn internal error occurred!\n\n");
      break;
    case Bad_Command_File_Name :
      printf("\n\nAn invalid command file was specified.\n\n");
      break;
    default:
      printf("\n\nUnknown Error!\n\n");
      break;
  }

  if (Filename != NULL)
    printf("Command File being processed: %s\n\n", Filename);

  if ( Token != NULL)
  {
    printf("Current Token: %s\n",Token->TokenText);
    printf("Token found at column %u, line %u.\n",Token->TokenColumn,Token->TokenRow);
  }

  return;

}


void Report_Standard_Error(int Error)
{
  char *  Error_Text;  /* Used with strerror */

  if ( Error < 0 )
    Error = -Error;

  switch (Error)
  {
    case INVALID_OPTION:
      printf("\n\nOne of the options specified was incorrect.\n\n");
      break;
    case INTERNAL_ERROR_BOD:
      printf("\n\nInternal error!  Bad Option Descriptor returned by EVMS Engine.\n\n");
      break;
    case ENOMEM:
      printf("\n\nOut of memory!\n\n");
      break;
    case EIO :
      printf("\n\nI/O error!\n\n");
      break;
    case EINVAL:
      printf("\n\nA command line parameter was out of range!\n\n");
      break;
    case ENOENT:
      printf("\n\nThe specified item could not be found!\n\n");
      break;
    case DLIST_CORRUPTED:
      printf("\n\nInternal Error!  Corrupted dlist_t!\n\n");
      break;
    case DLIST_BAD:
      printf("\n\nInternal Error!  Bad dlist_t!\n\n");
      break;
    case DLIST_NOT_INITIALIZED :
      printf("\n\nInternal Error!  Uninitialized dlist_t!\n\n");
      break;
    case DLIST_EMPTY :
      printf("\n\nInternal Error!  Empty dlist_t!\n\n");
      break;
    case DLIST_ITEM_SIZE_WRONG :
      printf("\n\nInternal Error!  Item size does not match dlist_t entry!\n\n");
      break;
    case DLIST_BAD_ITEM_POINTER :
      printf("\n\nInternal Error!  Bad item pointer for dlist_t!\n\n");
      break;
    case DLIST_ITEM_SIZE_ZERO :
      printf("\n\nInternal Error!  Items of size 0 not allowed in DLISTs!\n\n");
      break;
    case DLIST_ITEM_TAG_WRONG :
      printf("\n\nInternal Error!  Item tag does not agree with what is in the dlist_t!\n\n");
      break;
    case DLIST_END_OF_LIST :
      printf("\n\nInternal Error!  End of dlist_t reached earlier than expected!\n\n");
      break;
    case DLIST_ALREADY_AT_START :
      printf("\n\nInternal Error!  Already at start of dlist_t!\n\n");
      break;
    case DLIST_BAD_HANDLE :
      printf("\n\nInternal Error!  Bad handle for an item in a dlist_t!\n\n");
      break;
    case DLIST_INVALID_INSERTION_MODE :
      printf("\n\nInternal Error!  Invalid insertion mode for a dlist_t!\n\n");
      break;
    case HANDLE_MANAGER_NOT_INITIALIZED:
      printf("\n\nInternal Error!  The handle manager has not been initialized yet \nand a handle has been requested!\n\n");
      break;
    case HANDLE_MANAGER_BAD_HANDLE :
      printf("\n\nThe specified handle is invalid!\n\n");
      break;
    default:
      Error_Text = strerror(Error);
      if ( Error_Text == NULL)
        printf("\n\nUnknown error!\n\n");
      else
        printf("\n\n%s\n\n",Error_Text);
      break;
  }

  return;
}

