/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: os2regmgr.h
 *
 */

#ifndef   ORM_HEADER
#define   ORM_HEADER 1

#include <common.h>
#include <linux/evms/evms_os2.h>

typedef storage_object_t LOGICALDISK;
typedef storage_object_t DISKSEG;

extern plugin_record_t     ORM_PluginRecord;
extern engine_functions_t  * ORM_EngFncs;

// these logging macros expect args ....
#define LOG_DEFAULT( args... )  ORM_EngFncs->write_log_entry( DEFAULT, &ORM_PluginRecord, ##args )
#define LOG_DETAILS( args... )  ORM_EngFncs->write_log_entry( DETAILS, &ORM_PluginRecord, ##args )
#define LOG_ERROR( args... )    ORM_EngFncs->write_log_entry( ERROR, &ORM_PluginRecord, ##args )
#define LOG_DEBUG( args... )    ORM_EngFncs->write_log_entry( DEBUG, &ORM_PluginRecord, ##args )
#define LOGENTRY()              ORM_EngFncs->write_log_entry( ENTRY_EXIT, &ORM_PluginRecord, "%s: entry\n", __FUNCTION__ )
#define LOGEXIT()               ORM_EngFncs->write_log_entry( ENTRY_EXIT, &ORM_PluginRecord, "%s: exit\n", __FUNCTION__ )
#define LOGEXITRC()             ORM_EngFncs->write_log_entry( ENTRY_EXIT, &ORM_PluginRecord, "%s: exit, RC=%d\n", __FUNCTION__, rc )


#define SET_STRING_FIELD( a, b )   \
a = ORM_EngFncs->engine_alloc( strlen( b ) + 1 ); \
if ( a ) {          \
    strcpy( a, b ); \
}                   \
else {              \
    LOG_DEBUG( "RC= ENOMEM\n"); \
    LOGEXIT();\
    return ENOMEM; \
}


// Meta data for each drive link in an OS/2 LVM Volume
typedef struct os2_drivelink_s {
    sector_count_t           start_sector;              // starting sector number of link
    sector_count_t           sector_count;              // total useable sectors in this link
    char                    *link_data;                 // points to the link sequencing table
    u_int32_t                Partition_Serial_Number;   // serial number of this link
    u_int32_t                bbr_is_active;             // is Bad Block Relocation active
    char                    *bbr_data;                  // points to the BBR table
    storage_object_t        *object;                    // evms child storage object
    struct os2_drivelink_s  *next;                      // next drive link in the chain
} os2_drivelink_t;


#define  COMPATIBILITY_VOLUME                   0x00000001
#define  LVM_VOLUME                             0x00000002
#define  HIDDEN_VOLUME                          0x00000004
#define  VOLUME_IS_COMPLETE                     0x00000008

#define  ORM_PDATA_SIGNATURE                    0x4f532f32   /* OS/2 */

typedef struct orm_private_data_s {
     u_int32_t         signature;              // used to validate disk private data area
     u_int32_t         flags;                  // see DISK_HAS_xxxx flags above
     sector_count_t    size_in_sectors;        // total useable sectors in this volume
     u_int32_t         Volume_Serial_Number;   // SN of the volume
     u_int32_t         drive_link_count;       // total # of children in drive link
     os2_drivelink_t  *drive_link;             // pointer to drive link chain
} orm_private_data_t;


storage_object_t *  orm_get_first_object_in_list( dlist_t list );
BOOLEAN             orm_ican_modify( storage_object_t *obj );
int                 PluginInit( plugin_record_t * pr );
void                PluginCleanup( plugin_record_t * pr );


#endif
