
/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: liblocaldskmgr.h
 *
 */

typedef struct ld_private_data_s {
    unsigned long   kernel_disk_handle;
    int             dev_handle;
} ld_private_data_t;


#define LOG_CRITICAL(msg, args...)              EngFncs->write_log_entry(CRITICAL, &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_WARNING(msg, args...)               EngFncs->write_log_entry(WARNING,  &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_SERIOUS(msg, args...)               EngFncs->write_log_entry(SERIOUS,  &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_ERROR(msg, args...)                 EngFncs->write_log_entry(ERROR,    &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_DEFAULT(msg, args...)               EngFncs->write_log_entry(DEFAULT,  &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_DETAILS(msg, args...)               EngFncs->write_log_entry(DETAILS,  &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)
#define LOG_DEBUG(msg, args...)                 EngFncs->write_log_entry(DEBUG,    &LD_PluginRecord, "%s:  " msg, __FUNCTION__ , ## args)

#define LOG_PROC_ENTRY()                        EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Enter.\n", __FUNCTION__);

#define LOG_PROC_EXIT_INT(rc)                   EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.  Return value is %d.\n", __FUNCTION__, rc);
#define LOG_PROC_EXIT_UINT(rc)                  EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.  Return value is %u (0x%08x).\n", __FUNCTION__, rc, rc);
#define LOG_PROC_EXIT_PTR(ptr)                  EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.  Returned pointer is %p.\n", __FUNCTION__, ptr);
#define LOG_PROC_EXIT_BOOLEAN(result)           EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.  Result is %s.\n", __FUNCTION__, result ? "TRUE" : "FALSE");
#define LOG_PROC_EXIT_BOOLEAN_INT(result, rc)   EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.  Result is %s.  Return value is %d.\n", __FUNCTION__, result ? "TRUE" : "FALSE",rc);
#define LOG_PROC_EXIT_VOID()                    EngFncs->write_log_entry(ENTRY_EXIT, &LD_PluginRecord, "%s:  Exit.\n", __FUNCTION__);

#define SET_STRING_FIELD(a,b)\
a = EngFncs->engine_alloc( strlen(b)+1 );\
if (a ) {\
    strcpy(a, b);\
}\
else {\
    return ENOMEM;\
}

/* Extended info option indecies */
#define LD_INFO_NAME_INDEX          0
#define LD_INFO_SIZE_INDEX          1
#define LD_INFO_CYLINDERS_INDEX     2
#define LD_INFO_HEADS_INDEX         3
#define LD_INFO_SECTORS_INDEX       4
#define LD_INFO_SECTOR_SIZE_INDEX   5
#define LD_INFO_BLOCK_SIZE_INDEX    6
#define LD_INFO_BOOT_LIMIT_INDEX    7
#define LD_INFO_SEGMENTS_INDEX      8

#define LD_INFO_COUNT               9
