/*
 *
 *   Copyright (c) International Business Machines  Corp., 2000
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: bbr.h
 *
 */

#ifndef BAD_BLOCK_RELOCATION_HEADER
#define BAD_BLOCK_RELOCATION_HEADER


typedef storage_object_t LOGICALDISK;
typedef storage_object_t DISKSEG;


extern plugin_record_t             *BBR_PluginRecord_Ptr;
extern struct engine_functions_s   *BBREngFncs;


// these logging macros expect args ....
#define LOG_WARNING(args...) BBREngFncs->write_log_entry(WARNING,BBR_PluginRecord_Ptr, ##args)
#define LOG_INFO(args...)    BBREngFncs->write_log_entry(DEFAULT,BBR_PluginRecord_Ptr, ##args)
#define LOG_ERROR(args...)   BBREngFncs->write_log_entry(ERROR,BBR_PluginRecord_Ptr, ##args)
#define LOG_DEBUG(args...)   BBREngFncs->write_log_entry(DEBUG,BBR_PluginRecord_Ptr, ##args)

//
#define LOGENTRY()           BBREngFncs->write_log_entry(ENTRY_EXIT,BBR_PluginRecord_Ptr,"%s: entry\n",__FUNCTION__ )
#define LOGEXIT()            BBREngFncs->write_log_entry(ENTRY_EXIT,BBR_PluginRecord_Ptr,"%s: exit\n",__FUNCTION__ )
#define LOGEXITRC()          BBREngFncs->write_log_entry(ENTRY_EXIT,BBR_PluginRecord_Ptr,"%s: exit, RC= %d\n",__FUNCTION__ , rc)


#define SET_STRING_FIELD(a,b)\
a = BBREngFncs->engine_alloc( strlen(b)+1 );\
if (a ) {\
    strcpy(a, b);\
}\
else {\
    LOG_DEBUG("RC= ENOMEM\n");\
    LOGEXIT();\
    return ENOMEM;\
}

#define POPUP_MSG(answer,choices,args...) BBREngFncs->user_message(BBR_PluginRecord_Ptr,answer,choices, ##args)


// need an object that is exactly 1 sector in size;
typedef struct vsector_s {
    char  one_sector[EVMS_VSECTOR_SIZE];
} vsector_t;


// macro to read sectors from storage object
#define READ(object, start, len, buffer)  ((struct plugin_functions_s *)(object->plugin->functions.plugin))->read(object, start, len, buffer)

// macro to write sectors to a storage object
#define WRITE(object, start, len, buffer) ((struct plugin_functions_s *)(object->plugin->functions.plugin))->write(object, start, len, buffer)

// macro to pull the BBR child object ptr from the BBR private data area
#define GET_BBR_CHILD( bbrobject ) ((BBR_Private_Data *)bbrobject->private_data)->child

// minimum number of replacement blocks to use for a partition (roughly 2 tracks)
#define BBR_MIN_REPLACEMENT_BLOCKS  126

// maximum number of replacement blocks to use for a partition (roughly 65 tracks)
#define BBR_MAX_REPLACEMENT_BLOCKS  4095


// BBR storage object private data area
typedef struct _bbr_pdata {

    // private data can be verified by this signature
    u_int32_t                   signature;

    // child object that we consumed
    storage_object_t           *child;

    // Feature Header information
    u_int64_t                   feature_header_padding;
    u_int64_t                   feature_header_data1_size;
    u_int64_t                   feature_header_data2_size;
    u_int64_t                   feature_header_data1_start_lsn;
    u_int64_t                   feature_header_data2_start_lsn;
    u_int64_t                   feature_header_sequence_number;
    char                        feature_header_object_name[EVMS_VOLUME_NAME_SIZE];

    // Replacement Blocks information
    u_int64_t                   replacement_blocks_lsn;
    u_int64_t                   replacement_blocks_needed;
    u_int64_t                   replacement_blocks_size_in_sectors;

    // BBR Table information
    u_int64_t                   bbr_table_lsn1;
    u_int64_t                   bbr_table_lsn2;
    u_int64_t                   bbr_table_size_in_sectors;
    evms_bbr_table_t           *bbr_table;

    // feature data information
    u_int64_t                   sequence_number;

    // Block size
    u_int32_t                   block_size;

    // for expand, move, shrink ... previous metadata info
    u_int64_t                   active_replacement_blocks_lsn;
    u_int64_t                   active_replacement_blocks_needed;
    u_int64_t                   active_bbr_table_lsn1;
    u_int64_t                   active_bbr_table_lsn2;
    u_int64_t                   active_bbr_table_size_in_sectors;
    evms_bbr_table_t           *active_bbr_table;

    // flag to tell commit code to move replacement blocks
    BOOLEAN                     repl_blocks_moved;

} BBR_Private_Data;



// EVMS functions exported by the BBR shared object
int             get_bbr_disk_info( storage_object_t *child, geometry_t *geometry );
int             PluginInit( plugin_record_t *pPlugRec );
void            PluginCleanup( plugin_record_t *pPlugRec);




#endif
