/*----------------------------------------------------------------------
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * include file:  evmsn.h
 *---------------------------------------------------------------------*/

/*----------------------------------------------------------------------
 * Change History:
 *
 * 9/2001  John Stiles   Initial version.
 *
 *---------------------------------------------------------------------*/


/* Identify this file. */
#define EVMSN_H   1

#ifdef EVMSN_C
#  define EXTERN /* */
#else
#  define EXTERN extern
#endif

/*----------------------------------------------------------------------
 * Necessary include files
 *---------------------------------------------------------------------*/
#include <frontend.h>
#include "logging.h"
// include of messages.h is below.


/*----------------------------------------------------------------------
 * Set of gettext macros for internationalization.
 *---------------------------------------------------------------------*/
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#include "messages.h"

/*----------------------------------------------------------------------
 * Global Variables
 *---------------------------------------------------------------------*/

EXTERN int  GL_use_color;              /* do we use colors.                */
EXTERN int  GL_screen_cols;            /* screen width ( columns )         */
EXTERN int  GL_screen_lines;           /* screen height ( lines )          */
EXTERN int  GL_screen_context;         /* what screen we are using         */


/*----------------------------------------------------------------------
 * Global Constants
 *---------------------------------------------------------------------*/
#define  ESC_PRESSED       7001
#define  NO_OBJECTS_FOUND  7002

#define REQUIRED_ENGINE_VER_MAJOR       4
#define REQUIRED_ENGINE_VER_MINOR       0
#define REQUIRED_ENGINE_VER_PATCHLEVEL  1

// cbreak values for special keys
#ifndef SYSLINUX_C

#  define  KEY_BACKSPACE     0x8
#  define  KEY_TAB           0x9
#  define  KEY_ENTER         0xd
#  define  KEY_ESC           0x1b
#  define  KEY_END           0x46
#  define  KEY_HOME          0x48
#  define  KEY_CURSORUP      0x103
#  define  KEY_CURSORDOWN    0x102
#  define  KEY_CURSORLEFT    0x104
#  define  KEY_CURSORRIGHT   0x105
#  define  KEY_DELETE        0x107
#  define  KEY_F1            0x109
#  define  KEY_F2            0x10a
#  define  KEY_F3            0x10b
#  define  KEY_F4            0x10c
#  define  KEY_F5            0x10d
#  define  KEY_F6            0x10e
#  define  KEY_F7            0x10f
#  define  KEY_F8            0x110
#  define  KEY_F9            0x111
#  define  KEY_F10           0x112
#  define  KEY_INSERT        0x14b
#  define  KEY_PAGEDOWN      0x152
#  define  KEY_PAGEUP        0x153
#  define  KEY_RESIZE        0x19a
#  define  KEY_VOLUMES       0x701
#  define  KEY_OBJECTS       0x702
#  define  KEY_REGIONS       0x703
#  define  KEY_CONTAINERS    0x704
#  define  KEY_SEGMENTS      0x705
#  define  KEY_DISKS         0x706
#  define  KEY_PLUGINS       0x707
#  define  KEY_VIEWMENU      0x801
#  define  KEY_COMMIT        0x802
#  define  KEY_CURSORACT     0x803
#  define  KEY_EXITPGM       0x804

#endif

// values for function key contexts
enum key_contexts {
         KEYS_DEFAULT = 1,
         KEYS_PREV,
         KEYS_EXIT };

// values for screen contexts
enum screen_contexts {
         SC_VOLUMES = 1,
         SC_OBJECTS,
         SC_REGIONS,
         SC_CONTAINERS,
         SC_SEGMENTS,
         SC_DISKS,
         SC_PLUGINS,
         SC_BLANK,
         SC_NONE };

// values for screen placement
#define  XPOS_TITLE        0
#define  YPOS_TITLE        0
#define  XPOS_BOX1LEFT     0
#define  XPOS_BOX1RIGHT    1
#define  YPOS_BOX1TOP      1
#define  YPOS_BOX1BOTTOM   4
#define  XPOS_BOX2LEFT     1
#define  XPOS_BOX2RIGHT    2
#define  XPOS_BOX2TEXT     3
#define  YPOS_BOX2TOP      2
#define  YPOS_BOX2BOTTOM   5
#define  YPOS_BOX2TEXT     5
#define  XPOS_BOX3LEFT     8
#define  XPOS_BOX3RIGHT    3
#define  XPOS_BOX3TEXT     10
#define  YPOS_BOX3TOP      3
#define  YPOS_BOX3BOTTOM   6
#define  YPOS_BOX3TEXT     6
#define  XPOS_BOX4LEFT     11
#define  XPOS_BOX4RIGHT    4
#define  XPOS_BOX4TEXT     13
#define  YPOS_BOX4TOP      6
#define  YPOS_BOX4BOTTOM   8
#define  YPOS_BOX4TEXT     7
#define  XPOS_FUNCKEYS     0
#define  YPOS_FUNCKEYS     1
#define  XPOS_STATUS       0
#define  YPOS_STATUS       3

// values for screen colors
enum screen_colors {
         COLOR_DEFAULT = 1,
         COLOR_BAR,
         COLOR_TITLE,
         COLOR_FKEYS };

// special screen characters
#define  ITEM_SELECTED_CHAR      'X'
#define  LINE_CONTINUED_CHAR     '>'


/*----------------------------------------------------------------------
 * There are No Private Constants
 * There are No Private Type Definitions
 * There are No Private Global Variables.
 *---------------------------------------------------------------------*/


/*----------------------------------------------------------------------
 * Macro Definitions
 *---------------------------------------------------------------------*/
#define  CALC_SCREEN2_LINES  ( GL_screen_lines - YPOS_BOX2TOP - YPOS_BOX2BOTTOM - 2 )

#define  CALC_SCREEN3_LINES  ( GL_screen_lines - YPOS_BOX3TOP - YPOS_BOX3BOTTOM - 2 )

#define  CALC_SCREEN4_LINES  ( GL_screen_lines - YPOS_BOX4TOP - YPOS_BOX4BOTTOM - 2 )

#define  BLANK_BUFFER( buffer_name, buffer_size )           \
         {                                                  \
           memset( buffer_name, ' ', buffer_size );         \
           buffer_name[buffer_size] = '\0';                 \
         }                                                  \


/*----------------------------------------------------------------------
 * Function Prototypes
 *---------------------------------------------------------------------*/

// actions.c  :
int resize_object( object_handle_t, task_action_t );
int create_new_object( evms_plugin_code_t, int, char * );
int assign_object( evms_plugin_code_t, int, char * );
int destroy_object( object_handle_t, char * );
int remove_object( object_handle_t, char * );
int remove_object_from_container( object_handle_t, char * );         
int object_create_evms( object_handle_t );
int object_create_compat( object_handle_t );
int object_extended_info( object_handle_t );
int set_object_info( object_handle_t object );         
int get_plugin_selection( handle_array_t *plugin_objects, plugin_handle_t *selected_plugin, char *panel_title );
int set_options_menu( task_handle_t task_context, char *set_opt_msg );         

// control.c  :
int key_scroller( int *, int *, int, int );
int screen_scroller( int *, int, int );
int select_box( char *, char *, char *, char * );
int naming_box( char *, int , char * );
int control_loop( int );

// display.c  :
void draw_frame( void );
void draw_fnkeys( int );
void draw_box2( char * );
void draw_box3( char * );
void draw_box4( char * );
void draw_help_panel( int );
void draw_sector_size( sector_count_t, char * );
void draw_value_type( value_type_t, value_format_t, value_t *, int, char * );
int draw_value_units( value_unit_t, char * );
int comp_value_type( value_type_t, value_t *, value_t * );
int copy_value_string( value_type_t, value_t *, char * );
int copy_value_type( value_type_t, value_t *, value_t * );
void free_value_type( value_type_t, value_t * );
sector_count_t convert_to_sector_count( value_type_t, value_t * );
int convert_from_sector_count( value_type_t, sector_count_t, value_t * );
void draw_status_line( char * );
int  text_entry( int, int, int, char * );
int  number_entry( int, int, int, char * );

// syslinux.c  :
void kb_video_setup( void );
int  update_screen_info( void );
void signal_user( void );
void clear_screen( void );
void print_string( int, int, int, char * );
void move_cursor( int, int );
int  get_inputc( void );
void kb_video_shutdown( void );
void drawhline( int, int, int );
void drawvline( int, int, int );
void drawbleft( int, int, int );
void drawbright( int, int, int );

// objects.c  :
int topmost_actions( object_handle_t );
int draw_topmost( int, int *, handle_array_t * );
int region_actions( object_handle_t );
int draw_regions( int, int *, handle_array_t * );
int container_actions( object_handle_t );
int draw_containers( int, int *, handle_array_t * );
int segment_actions( object_handle_t );
int draw_segments( int, int *, handle_array_t * );
int disk_actions( object_handle_t );
int draw_disks( int, int *, handle_array_t * );
int plugin_information( object_handle_t );
int draw_plugins( int, int *, handle_array_t * );
int tree_object_view( object_handle_t, int );

// volumes.c  :
int volume_actions( object_handle_t );
int draw_volumes( int, int *, handle_array_t * );

