/*
 *
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: container_cb.c
 */ 
 
#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"
#include "destroy.h"
#include "thing.h"
#include "readable.h"
#include "logging.h"
#include "plugin_cb.h"
#include "container_cb.h"

/*
 *
 *   void on_destroy_container_button_clicked (GtkButton *, gpointer)
 *
 *   Description:
 *      This routine initiates the destroy API call using the handle
 *      of the container associated with the last row  selected. It then 
 *      creates and displays the results popup which destroys both 
 *      windows when dismissed.
 * 
 *   Entry:
 *      button    - address of the GtkButton widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      See description.
 *
 */
void on_destroy_container_button_clicked (GtkButton *button, gpointer user_data)
{
    gchar *error_msg   =  _("An error was encountered attempting to destroy the storage container.");
    gchar *success_msg = _("The storage container was successfully destroyed.");

    on_destroy_thing_button_clicked(button, error_msg, success_msg);
}

/*
 *
 *   void on_destroy_container_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of containers that can be destroyed.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable containers
 *
 */
void on_destroy_container_clist_realize (GtkWidget *widget, gpointer user_data)
{
    on_destroy_thing_clist_realize(widget, CONTAINER);
}

/*
 *
 *   void on_expand_container_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of containers that can be expanded.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with suitable containers
 *
 */
void on_expand_container_clist_realize (GtkWidget *widget, gpointer user_data)
{
    gint            rc=0;
    GtkCList       *clist = GTK_CLIST (widget);
    handle_array_t *things;

    rc = evms_get_container_list (0, &things);

    if (rc != SUCCESS) 
    {
        log_error ("%s: evms_get_container_list() returned error code %d.\n", __FUNCTION__, rc);
    }
    else
    {
        guint    i;
        gboolean is_selected = (things->count == 1);

        set_selection_window_clist_column_titles (clist, _("Size"), 
                                                  make_object_type_readable_string (CONTAINER), NULL);
        
        for (i=0; i < things->count; i++)
        {
/*            if (evms_can_expand (things->handle[i]) == 0) */
                add_thing_to_selection_list (clist, things->handle[i], is_selected);
        }

        evms_free (things);
    }    
}

/*
 *
 *   void on_container_plugin_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of plugins that support containers.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with available plugins that support containers
 *
 */
void on_container_plugin_clist_realize (GtkWidget *widget, gpointer user_data)
{
    set_selection_window_clist_column_titles (GTK_CLIST (widget), _("Container Plugin"), NULL, NULL);
    
    on_plugin_selection_clist_realize (GTK_CLIST (widget), 0, SUPPORTS_CONTAINERS);
}
