/*
 *   Copyright (c) International Business Machines  Corp., 2001
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: LvmUtils/helpers
 * File: get_lvmregmgr.c
 */

#ifndef _LVM_HELP_GET_LVMREGMGR_
#define _LVM_HELP_GET_LVMREGMGR_ 1

/* Function: get_lvmregmgr
 *
 *	Search for the LVM Region Manager plugin and return the handle if
 *	found, or error code (negative) if an error occurs (refer to
 *	LvmUtils/README). NOTE - it does to a printf(error_warning) if an error
 *	occurs, but leaves the caller to do the CloseEVMSEngine and it's own
 *	cleanup.
 */
int get_lvmregmgr( object_handle_t * handle )
{
	int rc;

	if ( opts.verbose ) {
		printf("%s -- Searching for the LVM Region Manager\n", cmd);
	}

	if ( (rc = evms_get_plugin_by_ID(SetPluginID(EVMS_OEM_IBM, EVMS_REGION_MANAGER, 0x01), handle)) ) {
		printf("%s -- Unable to locate the LVM Region Manager. (%d)\n", cmd, rc);
		printf("%s -- Please ensure that it was compiled and loaded.\n", cmd);
		*handle = 0;
		return EEXIST;
	}

	if ( opts.verbose ) {
		printf("%s -- Found LVM Region Manager handle (%u)\n", cmd, *handle);
	}

	return 0;
}

#endif

