
/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more etails.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * status.c
 * code for making the status changing widgets
 *
 */

#include <gtk/gtk.h>
#include <time.h>
#include "service.h"
#include "globals.h"
#include "status.h"
#include "contact.h"
#include "account.h"
#include "chat_window.h"
#include "about.h"
#include "util.h"
#include "add_contact_window.h"
#include "dialog.h"
#include "away_window.h"
#include "message_parse.h"
#include "importicq.h"
#include "sound.h"
#include "trigger.h"
#include "pixmaps/tb_preferences.xpm"
#include "pixmaps/tb_trash.xpm"
#include "pixmaps/login_icon.xpm"
#include "pixmaps/blank_icon.xpm"
#include "pixmaps/logoff_icon.xpm"

/*** MIZHI
 * log window
 */
#include "log_window.h"

enum {
	TARGET_STRING,
	TARGET_ROOTWIN,
	TARGET_URL
};

static GtkTooltips * status_tips=NULL;


static GtkTargetEntry contact_list_drop_types[] =
{
	{ "STRING",     0, TARGET_STRING },
	{ "text/plain", 0, TARGET_STRING },
	{ "text/uri-list", 0, TARGET_URL },
	{ "application/x-rootwin-drop", 0, TARGET_ROOTWIN }
};

static gint n_contact_list_drop_types=
  sizeof(contact_list_drop_types)/sizeof(contact_list_drop_types[0]);

  /*
static GtkTargetEntry account_list_drop_types[] =
{
//	{ "application/x-eb-account", 0, EB_ACCOUNT }
};

static gint n_account_list_drop_types=
  sizeof(account_list_drop_types)/sizeof(account_list_drop_types[0]);
*/

void import_licq_accounts(); /* From importlicq.c */

void show_all_accounts();
void show_online_only();

GtkWidget *statuswindow = NULL;
GtkWidget *away_menu;

static GtkWidget *contact_list[2];
static GtkWidget * scrollwindow[2];
static GtkWidget * status_bar = 0;
static GtkWidget * status_message;
static int show_online = 0;

static time_t last_sound_played = 0;

gboolean contact_drag_drop( GtkWidget * widget,
						   GdkDragContext *context,
						   gint x,
						   gint y,
						   guint time)
{
	grouplist * gl = gtk_object_get_user_data(GTK_OBJECT(widget));
	GtkWidget * source = gtk_drag_get_source_widget(context);
	struct contact * con = gtk_object_get_user_data(GTK_OBJECT(source));
	g_print("drop to %s\n", gl->name);
	move_contact(gl->name, con);
	MakeEditContactList();
	write_contact_list();
	return TRUE;
}

static void delete_event( GtkWidget *widget,
				   GdkEvent *event,
				   gpointer data )
{
	GList * node = accounts;
	while(node)
	{
		if(((eb_local_account*)(node->data))->connected)
          RUN_SERVICE(((eb_local_account*)(node->data)))->logout(node->data);
		node = node->next;
	}

	gtk_main_quit();
}
static GtkWidget * file_selector;

static void store_filename(GtkFileSelection *selector, eb_account * ea) 
{
	     char *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(file_selector));
		 eb_local_account * ela = find_suitable_local_account( NULL, ea->service_id);
		 strcpy(filename, selected_filename);
		 RUN_SERVICE(ela)->send_im(ela, ea, "EB_COMMAND SEND_FILE");
}



static void send_file_callback(GtkWidget * w, eb_account * ea )
{

	file_selector = gtk_file_selection_new("Please select a file to send");

     
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                             "clicked", GTK_SIGNAL_FUNC (store_filename), ea);
                             
     /* Ensure that the dialog box is destroyed when the user clicks a button. */
     
     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);

     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);
     
     /* Display that dialog */
     
     gtk_widget_show (file_selector);

}

static void send_file_with_contact_callback(GtkWidget * w, struct contact * conn )
{
	eb_account * ea = find_suitable_remote_account( NULL, conn );

	file_selector = gtk_file_selection_new("Please select a file to send");

  	file_selector = gtk_file_selection_new("Please select a file for editing.");
     
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                             "clicked", GTK_SIGNAL_FUNC (store_filename), ea);
                             
     /* Ensure that the dialog box is destroyed when the user clicks a button. */
     
     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->ok_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);

     gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION(file_selector)->cancel_button),
                                            "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
                                            (gpointer) file_selector);
     
     /* Display that dialog */
     
     gtk_widget_show (file_selector);

}

/*** MIZHI
 * For displaying the logs
 */
static void view_log_callback(GtkWidget * w, struct contact * conn)
{  
  /*  if (cw->lw == NULL) { */
  if (conn->logwindow == NULL) {
    conn->logwindow = eb_log_window_new(conn);
  }
}

static void edit_trigger_callback(GtkWidget * w, struct contact * conn)
{
	show_trigger_window(conn);
}


static void get_info(GtkWidget * w, eb_account *ea )
{
   
  eb_local_account * el;
  //eb_account * ea = find_suitable_remote_account( NULL, conn );

  if(ea) {
      el = find_suitable_local_account(NULL, ea->service_id);
      RUN_SERVICE(ea)->get_info(el ,ea);  
  }  else {
      g_warning("Couldn't find suitable local acount for info request");
      return;
  }  

}

void update_status_message(gchar * message )
{
	if(status_bar)
	{
		gtk_widget_destroy(status_message);
		status_message = gtk_label_new(message);
		gtk_container_add(GTK_CONTAINER(status_bar), status_message);
		gtk_widget_show(status_message);
	}
}


void collapse_contact( GtkTreeItem * treeItem, gpointer data )
{
	struct contact * c = data;
	c->expanded = FALSE;
}

void expand_contact( GtkTreeItem * treeItem, gpointer data )
{
	struct contact * c = data;
	c->expanded = TRUE;
}

static void show_online_callback(GtkWidget *w, gpointer data)
{
	show_online = (int)data;
	if (show_online)
		show_all_accounts();
	else
		show_online_only();
}

static GtkWidget *make_info_menu(struct contact *c)
{
  GList *iterator;
  GtkWidget *InfoMenu = gtk_menu_new();
  GtkWidget *button;

  for(iterator=c->accounts; iterator; iterator=iterator->next)
  {
    eb_account * account = (eb_account*)iterator->data;
    if(account->online){
      button = gtk_menu_item_new_with_label(account->handle);
      gtk_signal_connect(GTK_OBJECT(button), "activate", GTK_SIGNAL_FUNC(get_info),account);
      gtk_menu_append(GTK_MENU(InfoMenu), button);
      gtk_widget_show(button);
    }
  }
  return InfoMenu;
}
    
static void show_chat_contact(GtkWidget *widget, GdkEventButton * event,
                         gpointer d )
{
	if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	{
    		eb_chat_window_display_contact((struct contact *)d);
	}
	else if (event->type == GDK_BUTTON_PRESS && event->button == 3)
	{
		GtkWidget * menu, *button, *infomenu;

		menu = gtk_menu_new();
		button = gtk_menu_item_new_with_label("Send File");
		gtk_signal_connect(GTK_OBJECT(button), "activate",
						GTK_SIGNAL_FUNC(send_file_with_contact_callback), d);
		gtk_menu_append(GTK_MENU(menu), button);
		gtk_widget_show(button);

		button = gtk_menu_item_new_with_label("Info");
		gtk_menu_append(GTK_MENU(menu), button);

		infomenu = make_info_menu((struct contact *)d);
		gtk_menu_item_set_submenu (GTK_MENU_ITEM (button), infomenu);
		gtk_widget_show(button);

		button = gtk_menu_item_new_with_label("Edit Trigger");
		gtk_signal_connect(GTK_OBJECT(button), "activate",
				GTK_SIGNAL_FUNC(edit_trigger_callback), d);
		gtk_menu_append(GTK_MENU(menu), button);
		gtk_widget_show(button);

		/*** MIZHI
		* code for viewing the logs
		*/
		button = gtk_menu_item_new_with_label("View Log");
		gtk_signal_connect(GTK_OBJECT(button), "activate",
				GTK_SIGNAL_FUNC(view_log_callback), d);
		gtk_menu_append(GTK_MENU(menu), button);
		gtk_widget_show(button);


		gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
						event->button, event->time );
	}
}

static void edit_contact(GtkWidget *widget, GdkEventButton * event,
                         gpointer d )
{
	 if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	 {
     		edit_contact_window_new((struct contact *)d);
	 }
}

static void edit_group(GtkWidget *widget, GdkEventButton * event,
                         gpointer d )
{
	 if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	 {
     		edit_group_window_new((grouplist *)d);
	 }
}

static void show_chat_account(GtkWidget *widget, GdkEventButton * event,
                         gpointer d )
{
#if 0
  if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
    {
      eb_chat_window_display_account((eb_account *)d);
    }
  else if (event->type == GDK_BUTTON_PRESS && event->button == 3)
    {
      GtkWidget * menu, *button;

      menu = gtk_menu_new();
      button = gtk_menu_item_new_with_label("Send File");
      gtk_signal_connect(GTK_OBJECT(button), "activate",
			 GTK_SIGNAL_FUNC(send_file_callback), d);
      gtk_menu_append(GTK_MENU(menu), button);
      gtk_widget_show(button);
#endif
 	if (event->type == GDK_2BUTTON_PRESS && event->button == 1)
	{
    		 eb_chat_window_display_account((eb_account *)d);
	}
	else if (event->type == GDK_BUTTON_PRESS && event->button == 3)
	{
		GtkWidget * menu, *button, *info_button;

#if 0
      gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
		     event->button, event->time );
    }
#endif
		menu = gtk_menu_new();
		button = gtk_menu_item_new_with_label("Send File");
		gtk_signal_connect(GTK_OBJECT(button), "activate",
						   GTK_SIGNAL_FUNC(send_file_callback), d);
                info_button = gtk_menu_item_new_with_label("Info");
                gtk_signal_connect(GTK_OBJECT(info_button), "activate",
                                                   GTK_SIGNAL_FUNC(get_info),d);
		gtk_menu_append(GTK_MENU(menu), button);
                gtk_menu_append(GTK_MENU(menu), info_button);
		gtk_widget_show(button);
		gtk_widget_show(info_button);

		gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
						event->button, event->time );
	}
}

static void add_callback(GtkWidget *widget, GtkTree *tree)
{
	show_add_contact_window();
}
static void remove_callback(GtkWidget *widget, GtkTree *tree)
{
	GList *i;
	tree = GTK_TREE(contact_list[LIST_EDIT]);
	i = GTK_TREE_SELECTION(tree);
	if(i)
	{
		GtkTreeItem * gti = i->data;
		GtkTree * tree;
		if(!i->data)
		{
			g_warning("i->data == NULL");
			return;
		}
		tree = (GtkTree *) GTK_TREE_ITEM_SUBTREE(gti);
		if(!tree)
		{
			/* No Subtree == Account */
			g_warning("Delete Account");
			remove_account( gtk_object_get_user_data(GTK_OBJECT(i->data)));
		}
		else if( GTK_TREE(tree)->level == 2 )
		{
			g_warning("Delete Contact");
			remove_contact( gtk_object_get_user_data(GTK_OBJECT(i->data)));
		}
		else
		{
			g_warning("Delete Group");
			remove_group( gtk_object_get_user_data(GTK_OBJECT(i->data)));
		}

		MakeEditContactList();
		write_contact_list();
	}
}
	

struct Status
{
    eb_local_account * ela;
    gint status;
};

void eb_edit_accounts( GtkWidget * widget, gpointer stats )
{
	eb_new_user();
}

void build_prefs_callback( GtkWidget * widget, gpointer stats )
{
	build_prefs();
}

void launch_group_chat( GtkWidget * widget, gpointer userdata )
{
	open_join_chat_window();

}

void eb_status( GtkWidget * widget, gpointer stats )
{
    struct Status *s;
    s = (struct Status *)stats;
    if (eb_services[s->ela->service_id].sc->get_current_state(s->ela) != s->status)
    	eb_services[s->ela->service_id].sc->set_current_state(s->ela, s->status);
#ifdef DEBUG
    printf("%s set to state %d.\n", eb_services[s->ela->service_id].name, s->status );
#endif

}

void eb_import_gaim( GtkWidget *widget, gpointer stats )
{
	import_gaim_accounts();
	write_contact_list();
	MakeEditContactList();
}

void eb_import_licq( GtkWidget *widget, gpointer stats )
{
	import_licq_accounts();
	write_contact_list();
	MakeEditContactList();
}

void eb_import_icq99( GtkWidget * widget, gpointer stats )
{
	import_icq99_contacts();
}

void eb_import_gnomeicu( GtkWidget * widget, gpointer stats )
{
	import_gnomeicu_accounts();
	write_contact_list();
	MakeEditContactList();
}

void eb_sign_on_all(GtkWidget *widget, gpointer foo) {

  GList *node = accounts ;
  while(node) {
    if(!(((eb_local_account*)(node->data))->connected))
      RUN_SERVICE(((eb_local_account*)(node->data)))->login(node->data) ;
    node = node->next ;
  }

}

void eb_sign_off_all(GtkWidget *widget, gpointer foo) {

  GList *node = accounts ;
  while(node) {
    if(((eb_local_account*)(node->data))->connected)
      RUN_SERVICE(((eb_local_account*)(node->data)))->logout(node->data) ;
    node = node->next ;
  }

}

gint get_contact_position( struct contact * ec)
{
	gint i=0;
	GList *l;
	
	for (l = ec->group->members; l && (l->data != ec); l=l->next) 
	{
		struct contact * contact = l->data;
		if (contact->list_item)
			i++;
	}
	return i;
}

gint get_account_position( eb_account * ea)
{
	gint i=0;
	GList *l;
	
	for (l = ea->account_contact->accounts; l && (l->data != ea); l=l->next) {
		eb_account * account = l->data;
		if (account->list_item)
			i++;
	}
	return i;
}

/* makes all accounts visible on the contact list */
void show_all_accounts()
{
	GList * grps, * contacts, * accounts;
	
	for (grps = groups; grps; grps = grps->next) 
	{
		grouplist * grp = grps->data;
		for (contacts = grp->members; contacts; contacts = contacts->next) 
		{
			struct contact * con = contacts->data;
			for (accounts = con->accounts; accounts; accounts = accounts->next) 
			{
				add_account_line(accounts->data);
				buddy_update_status(accounts->data);
			}
		}
	}
}

/* shows a contact tree and its accounts and explicity draws
   each account rather than waiting for a login message from
   the server.  Useful for reshowing a contact after removing
   it from the buddy list. */
void add_contact_and_accounts(struct contact * c)
{
	GList *l;
	for (l = c->accounts; l; l = l->next) 
	{
		eb_account * ea = l->data;
		if (show_online || ea->online) 
		{
			add_account_line(ea);
			buddy_update_status(ea);
		}
	}
}

/* makes only online accounts visible on the contact list */
void show_online_only()
{
	GList * grps, * contacts, * accounts;
	
	for (grps = groups; grps; grps = grps->next) 
	{
		grouplist * grp = grps->data;
		for (contacts = grp->members; contacts; contacts = contacts->next) 
		{
			struct contact * con = contacts->data;
			for (accounts = con->accounts; accounts; accounts = accounts->next) 
			{
				eb_account * ea = accounts->data;
				if (!ea->online)
					remove_account_line(ea);
				else
					buddy_update_status(ea);
			}
			if (!con->online)
				remove_contact_line(con);
		}
	}
}

static GdkPixmap * iconlogin_pm = NULL;
static GdkBitmap * iconlogin_bm = NULL;
static GdkPixmap * iconblank_pm = NULL;
static GdkBitmap * iconblank_bm = NULL;
static GdkPixmap * iconlogoff_pm = NULL;
static GdkBitmap * iconlogoff_bm = NULL;

/* makes a contact visible on the buddy list */
void add_contact_line( struct contact * ec)
{
	GtkWidget * box;
	
	if (ec->list_item)
		return;
	
	ec->list_item = gtk_tree_item_new();
	ec->tree = gtk_tree_new();

	box = gtk_hbox_new(FALSE, 1);
	ec->pix = gtk_pixmap_new(iconblank_pm, iconblank_bm);
	ec->label = gtk_label_new(ec->nick);
	ec->status = gtk_label_new("");

	gtk_box_pack_start(GTK_BOX(box), ec->pix, FALSE, FALSE, 1);
	gtk_widget_show(ec->pix);
	gtk_misc_set_alignment(GTK_MISC(ec->label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(box), ec->label, TRUE, TRUE, 1);
	gtk_widget_show(ec->label);
	gtk_box_pack_start(GTK_BOX(box), ec->status, FALSE, FALSE, 1);
	gtk_widget_show(ec->status);

	gtk_container_add(GTK_CONTAINER(ec->list_item), box);
	gtk_widget_show(box);

	ec->icon_handler = -1;

	gtk_object_set_user_data(GTK_OBJECT(ec->list_item), ec);
	
	if (!ec->group->contacts_shown) {
		ec->group->tree = gtk_tree_new();
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(ec->group->list_item),
			ec->group->tree);
		if(strcmp("Unknown",ec->group->name) !=0 &&
		   strcmp("Ignore",ec->group->name) !=0)
		gtk_tree_item_expand(GTK_TREE_ITEM(ec->group->list_item));
	}
	
	ec->group->contacts_shown++;
	gtk_tree_insert(GTK_TREE(ec->group->tree), ec->list_item,
		get_contact_position(ec));


	gtk_tree_item_set_subtree(GTK_TREE_ITEM(ec->list_item), ec->tree);
	if(ec->expanded)
		gtk_tree_item_expand(GTK_TREE_ITEM(ec->list_item));
	else
		gtk_tree_item_collapse(GTK_TREE_ITEM(ec->list_item));

	gtk_signal_connect(GTK_OBJECT(ec->list_item),  "button_press_event",
				  GTK_SIGNAL_FUNC(show_chat_contact),
				  (struct contact*)ec );
	gtk_signal_connect(GTK_OBJECT(ec->list_item), "expand",
				  GTK_SIGNAL_FUNC(expand_contact), (struct contact*)ec);
	gtk_signal_connect(GTK_OBJECT(ec->list_item), "collapse",
				  GTK_SIGNAL_FUNC(collapse_contact), (struct contact*)ec );
		
	gtk_widget_show(ec->list_item);	
}

/* makes an account visible on the buddy list, making the contact visible
   if necessary */
void add_account_line( eb_account * ea)
{
	GtkWidget * box, * label;
	
	if (ea->list_item)
		return;
	
	add_contact_line(ea->account_contact);

	ea->list_item = gtk_tree_item_new();

	box = gtk_hbox_new(FALSE, 1);
	ea->pix = gtk_pixmap_new(iconblank_pm, iconblank_bm);
	label = gtk_label_new(ea->handle);
	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ea->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		ea->status = gtk_label_new(c);
		g_free(c);
	}

	gtk_box_pack_start(GTK_BOX(box), ea->pix, FALSE, FALSE, 1);
	gtk_widget_show(ea->pix);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.5);
	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 1);
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(box), ea->status, FALSE, FALSE, 1);
	gtk_widget_show(ea->status);

	gtk_container_add(GTK_CONTAINER(ea->list_item), box);
	gtk_widget_show(box);

	ea->icon_handler = -1;

	gtk_object_set_user_data(GTK_OBJECT(ea->list_item), ea);
	gtk_tree_insert(GTK_TREE(ea->account_contact->tree), ea->list_item,
		get_account_position(ea));

	gtk_signal_connect(GTK_OBJECT(ea->list_item),  "button_press_event",
				  GTK_SIGNAL_FUNC(show_chat_account),
				  (eb_account *)ea );

	gtk_widget_show(ea->list_item);

}

/* makes a group visible on the contact list */
void add_group_line(grouplist * eg)
{
	GtkWidget * box;

	/* Might call add_group() - which calls add_group_line() 
	   before contact_list exists - this is OK so just return */
	if (eg->list_item || !contact_list[LIST_ONLINE])
		return;
		
	eg->list_item = gtk_tree_item_new();

	box = gtk_hbox_new(FALSE, 1);

	eg->label = gtk_label_new(eg->name);
	gtk_label_set_justify(GTK_LABEL(eg->label), GTK_JUSTIFY_LEFT);

	gtk_box_pack_start(GTK_BOX(box), eg->label, FALSE, FALSE, 1);
	gtk_widget_show(eg->label);

	gtk_container_add(GTK_CONTAINER(eg->list_item), box);
	gtk_widget_show(box);

	gtk_object_set_user_data(GTK_OBJECT(eg->list_item), (gpointer)eg);
	eg->contacts_online = 0;
	eg->contacts_shown = 0;
	eg->tree = NULL;
	gtk_tree_append(GTK_TREE(contact_list[LIST_ONLINE]), eg->list_item);
	gtk_widget_show(eg->list_item);
}

/* hides an account on the buddy list (removes it from the tree) */
void remove_account_line( eb_account * ea)
{

	if (!ea->list_item)
		return;

	gtk_container_remove(GTK_CONTAINER(ea->account_contact->tree), ea->list_item);
	ea->list_item = NULL;
	ea->pix = NULL;
	ea->status = NULL;
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = -1;
}

/* hides an account on the buddy list, hiding any child accounts in the
   process */
void remove_contact_line( struct contact * ec)
{
	GList * accounts;
	
	if (!ec->list_item)
		return;
		
	for (accounts = ec->accounts; accounts; accounts = accounts->next) {
		eb_account * ea = accounts->data;
		if (ea->list_item)
			remove_account_line(ea);
	}
	
	ec->group->contacts_shown--;
	gtk_container_remove(GTK_CONTAINER(ec->group->tree), ec->list_item);
	ec->list_item = NULL;
	ec->tree = NULL;
	ec->pix = NULL;
	ec->status = NULL;
	ec->label = NULL;
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
	ec->icon_handler = -1;
}

/* hides a group on the buddy list */
void remove_group_line( grouplist * eg)
{
	GList * contacts;
	
	if (!eg->list_item)
		return;
		
	for (contacts = eg->members; contacts; contacts = contacts->next) {
		struct contact * ec = contacts->data;
		if (ec->list_item)
			remove_contact_line(ec);
	}
		
	gtk_container_remove(GTK_CONTAINER(contact_list[LIST_ONLINE]), eg->list_item);
	eg->list_item = NULL;
	eg->tree = NULL;
	eg->label = NULL;
}

/* timeout function called 10 seconds after a contact logs off
   (removes the logoff icon and hides the contact if necessary) */
gint hide_contact(struct contact * ec)
{
	GList * l;
	
	if (ec->icon_handler == -1)
		return FALSE;
	ec->icon_handler = -1;
	
	if (!show_online)		
		remove_contact_line(ec);
	else
		for (l = ec->accounts; l; l = l->next) {
			eb_account * account = l->data;
			buddy_update_status(account);
		}
	
	return FALSE;
}

/* timeout function called 10 seconds after an account logs off
   (removes the logoff icon and hides the account if necessary)
   This timeout is only set when other accounts in the parent
   contact are remaining shown */
gint hide_account(eb_account * ea)
{
	if (ea->icon_handler == -1)
		return FALSE;
	ea->icon_handler = -1;
			
	if (!ea->list_item)
		return FALSE;
			
	if (!show_online)
		remove_account_line(ea);
	else
		buddy_update_status(ea);
	return FALSE;
}

/* update the status info (pixmap and state) of a contact */
void contact_update_status(struct contact * ec)
{
	GdkPixmap * pm;
	GdkBitmap * bm;
	eb_account * ea = NULL;
	GList * l;
	int width, height;
	int width2, height2;
	int width3, height3;

	/* find the account who's status information should be reflected in
	   the contact line (preferably the default protocol account, but
	   if that one is not logged on, use another) */
	for (l = ec->accounts; l; l = l->next) 
	{
		eb_account * account = l->data;
		if (!ea)
			ea = account;
		if (!ea->online && account->online)
			ea = account;
		if (ec->default_chatb != ea->service_id && account->online &&
				ec->default_chatb == account->service_id)
			ea = account;
	}

	if (!ea)
		return;

	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ec->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		gtk_label_set_text(GTK_LABEL(ec->status), c);
		g_free(c);
	}
	gtk_label_set_text(GTK_LABEL(ec->label), ec->nick);

	/* set the icon if there isn't another timeout about to alter the icon */
	if (ec->icon_handler == -1) 
	{
		RUN_SERVICE(ea)->get_status_pixmap(ea, &pm, &bm);
		gtk_pixmap_set(GTK_PIXMAP(ec->pix), pm, bm);
	}

	width = contact_list[0]->allocation.width;
	height = contact_list[0]->allocation.height;

	if(GTK_WIDGET_VISIBLE(GTK_SCROLLED_WINDOW(scrollwindow[0])->vscrollbar))
	{
		width3 = GTK_SCROLLED_WINDOW(scrollwindow[0])->vscrollbar->allocation.width;
		height3 = GTK_SCROLLED_WINDOW(scrollwindow[0])->vscrollbar->allocation.height;
	}
	else
	{
		width3 = 0, height3 = 0;
	}

	width2 = scrollwindow[0]->allocation.width;
	height2 = scrollwindow[0]->allocation.height;

	if(width+width3> width2)
	{
		gtk_widget_set_usize(scrollwindow[0],width+width3+2,height2);
	}
	
}

/* update the status info (pixmap and state) of an account */
void buddy_update_status(eb_account * ea)
{
	GdkPixmap * pm;
	GdkBitmap * bm;
	
	if (!ea || !ea->list_item)
		return;
	
	{
		char * c = g_strndup(RUN_SERVICE(ea)->get_status_string(ea), 20);
		if(strlen(c) == 20)
		{
			c[19] = c[18] = c[17] = '.';
			if(!status_tips)
			{
				status_tips = gtk_tooltips_new();
			}
			/*
			 * that 3rd parameter is not a bug, it really is a useless
			 * parameter
			 */

			gtk_tooltips_set_tip(GTK_TOOLTIPS(status_tips), ea->list_item,
					RUN_SERVICE(ea)->get_status_string(ea),
					"status info here");
		}
		gtk_label_set_text(GTK_LABEL(ea->status), c);
		g_free(c);
	}

	/* update the icon if another timeout isn't about to change it */
	if (ea->icon_handler == -1) {
		RUN_SERVICE(ea)->get_status_pixmap(ea, &pm, &bm);
		gtk_pixmap_set(GTK_PIXMAP(ea->pix), pm, bm);
	}

	/* since the contact's status info  might be a copy of this
	   account's status info, we should refresh that also */	
	contact_update_status(ea->account_contact);	
}

/* the timeout function called after a contact logs in (to take the
   "open door" icon away) */
gint set_contact_icon(struct contact * ec)
{
	/* abort if another timeout already took care of it */
	if (ec->icon_handler == -1)
		return FALSE;
	ec->icon_handler = -1;
		
	contact_update_status(ec);
	return FALSE;
}

/* the timeout function called after an account logs in (to take the
   "open door" icon away) */
gint set_account_icon(eb_account * ea)
{
	/* abort if another timeout already took care of it */
	if (ea->icon_handler == -1)
		return FALSE;
	ea->icon_handler = -1;

	buddy_update_status(ea);
	return FALSE;
}

/* function called when a contact logs in */
void contact_login(struct contact * ec)
{
	char buff[1024];
	ec->group->contacts_online++;

	/* display the "open door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ec->pix), iconlogin_pm, iconlogin_bm);
	
	/* remove any other timeouts (if a user just logged out immediately before) */
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
		
	/* timeout to set the contact icon in 10 seconds */
	ec->icon_handler = gtk_timeout_add(10000, (GtkFunction)set_contact_icon,
		(gpointer) ec);

	if((time(NULL) - last_sound_played > 0) && do_online_sound)
	{
		play_sound(BUDDY_ARRIVE);
		last_sound_played = time(NULL);
	}
	
	do_trigger_online(ec);
	
	eb_chat_window_do_timestamp(ec, 1);
	g_snprintf(buff, 1024, "%s is now online", ec->nick);
	update_status_message(buff);
}

/* function called when a contact logs off */
void contact_logoff(struct contact * ec)
{
	char buff[1024];
	/* display the "closed door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ec->pix), iconlogoff_pm, iconlogoff_bm);
	ec->group->contacts_online--;
	
	/* remove any other timeouts (if the user just logged in) */
	if (ec->icon_handler != -1)
		gtk_timeout_remove(ec->icon_handler);
		
	/* timeout to remove the contact from the list */
	ec->icon_handler = gtk_timeout_add(10000, (GtkFunction)hide_contact,
		(gpointer) ec);

	if((time(NULL) - last_sound_played > 0) && do_online_sound)
	{
		play_sound(BUDDY_LEAVE);
		last_sound_played = time(NULL);
	}

	do_trigger_offline(ec);

	eb_chat_window_do_timestamp(ec, 0);
	g_snprintf(buff, 1024, "%s is now offline", ec->nick);
	update_status_message(buff); 
}

/* timeout called every 30 seconds for each online account to update
   its status */
gint refresh_buddy_status(eb_account * ea)
{
	/* remove the timeout if the account is no longer displayed */
	if (!ea->list_item || ea->status_handler == -1) {
		ea->status_handler = -1;
		return FALSE;
	}
	
	/* don't refresh if a "door" icon is being displayed */
	if (ea->icon_handler != -1)
		return TRUE;
		
	buddy_update_status(ea);
	return TRUE;
}

/* called to signify that a buddy has logged in, and updates the GUI
   accordingly */
void buddy_login(eb_account * ea)
{
	
	/* don't do anything if this has already been done */
	if (ea->online)
		return;
	
	ea->account_contact->online++;
	ea->online = TRUE;
	
	if (do_ignore_unknown && !strcmp("Unknown", ea->account_contact->group->name))
		return;
	
	add_account_line(ea);
	
	/* sets the "open door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ea->pix), iconlogin_pm, iconlogin_bm);

	/* set the timeout to remove the "open door" icon */
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = gtk_timeout_add(10000, (GtkFunction)set_account_icon,
		(gpointer) ea);
	
	/* if there is only one account (this one) logged in under the
	   parent contact, we must login the contact also */
	if (ea->account_contact->online == 1)
		contact_login(ea->account_contact);
		
	buddy_update_status(ea);
	
	/* make sure the status gets updated often */
	ea->status_handler = gtk_timeout_add(30000,
		(GtkFunction)refresh_buddy_status, (gpointer) ea);
}

/* called to signify that a buddy has logged off, and updates the GUI
   accordingly */
void buddy_logoff(eb_account * ea)
{
	
	/* don't do anything if this has already been done */
	if (!ea || !ea->online)
		return;
	
	ea->account_contact->online--;
	ea->online = FALSE;

	if (do_ignore_unknown && !strcmp("Unknown", ea->account_contact->group->name))
		return;

	/* sets the "closed door" icon */
	gtk_pixmap_set(GTK_PIXMAP(ea->pix), iconlogoff_pm, iconlogoff_bm);

	/* removes any previously set timeouts for the account */ 
	if (ea->icon_handler != -1)
		gtk_timeout_remove(ea->icon_handler);
	ea->icon_handler = -1;
	if (ea->status_handler != -1)
		gtk_timeout_remove(ea->status_handler);
	ea->status_handler = -1;
	
	/* if this is the last account of the parent contact to log off,
	   we must log off the contact also */
	if (ea->account_contact->online == 0)
		contact_logoff(ea->account_contact);

	/* timeout to remove the "close door" icon */
	ea->icon_handler = gtk_timeout_add(10000, (GtkFunction)hide_account,
		(gpointer) ea);

}

/* Generates the contact list tree (should only be called once) */
GtkWidget* MakeContactList()
{
	GList * l1;
	gint type = LIST_ONLINE;
	
	scrollwindow[type] = gtk_scrolled_window_new(NULL, NULL);
	contact_list[type] = gtk_tree_new();

	for( l1 = groups; l1; l1=l1->next )
	{
		grouplist * grp = l1->data;
		add_group_line(grp);
	}
	
	gtk_widget_show(contact_list[type]);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwindow[type]),
		contact_list[type]);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow[type]),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrollwindow[type], 150, 200);
	return scrollwindow[type];
}

/* Generates or regenerates the "Edit Contacts" tree.  This can be
   called to refresh the list */
GtkWidget* MakeEditContactList()
{
	GList * l1;
	GList * l2;
	GList * l3;
	gint type = LIST_EDIT;
	
	if (!contact_list[type])
		scrollwindow[type]=gtk_scrolled_window_new(NULL,NULL);
	else
		gtk_widget_destroy(contact_list[type]);

	contact_list[type] = gtk_tree_new();
	gtk_tree_set_view_lines(GTK_TREE(contact_list[type]), TRUE);
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwindow[type]),contact_list[type]);
	gtk_tree_set_view_lines(GTK_TREE(contact_list[type]), TRUE);
	
	/*for each group */

	for( l1 = groups; l1; l1=l1->next )
	{
		GtkWidget * gnodes;
		GtkWidget * clist2;

		gnodes = gtk_tree_item_new_with_label(((grouplist*)(l1->data))->name);
		gtk_object_set_user_data(GTK_OBJECT(gnodes), l1->data);
		clist2 = gtk_tree_new();
		gtk_tree_append(GTK_TREE(contact_list[type]), gnodes);
		gtk_tree_item_set_subtree(GTK_TREE_ITEM(gnodes), clist2);
		gtk_drag_dest_set(gnodes,
						  GTK_DEST_DEFAULT_ALL,
						  contact_list_drop_types,
						  n_contact_list_drop_types-1,
						  GDK_ACTION_MOVE|GDK_ACTION_COPY);
		gtk_signal_connect(GTK_OBJECT(gnodes), "drag_drop",
							GTK_SIGNAL_FUNC(contact_drag_drop),
							l1->data);
		
		/*for each contact within that group*/

		for( l2 = ((grouplist*)l1->data)->members; l2; l2=l2->next )
		{
			GtkWidget * cnodes;
			GtkWidget * clist3;
			struct contact * con = (struct contact*)l2->data;
			
			cnodes = gtk_tree_item_new_with_label(con->nick);
			
			gtk_object_set_user_data(GTK_OBJECT(cnodes), l2->data);
						
			clist3 = gtk_tree_new();
			gtk_tree_append(GTK_TREE(clist2), cnodes);
			/*
			gtk_drag_dest_set(cnodes,
						  GTK_DEST_DEFAULT_ALL,
						  contact_list_drop_types,
						  n_contact_list_drop_types-1,
						  GDK_ACTION_MOVE|GDK_ACTION_COPY);
			*/
			gtk_tree_item_set_subtree(GTK_TREE_ITEM(cnodes), clist3);
			
			/*for each account that the contact has*/
			
			for( l3 = con->accounts; l3; l3=l3->next )
			{
				GtkWidget * anodes;
				eb_account * account = (eb_account*)l3->data;

				anodes = gtk_tree_item_new_with_label(account->handle);
				gtk_tree_append(GTK_TREE(clist3), anodes);
				/*
				gtk_drag_dest_set(anodes,
						  GTK_DEST_DEFAULT_ALL,
						  contact_list_drop_types,
						  n_contact_list_drop_types-1,
						  GDK_ACTION_MOVE|GDK_ACTION_COPY);
				*/

				gtk_object_set_user_data(GTK_OBJECT(anodes), l3->data);

				gtk_widget_show(anodes);

			}
			gtk_drag_source_set(cnodes, 
						GDK_BUTTON1_MASK|GDK_BUTTON3_MASK,
						contact_list_drop_types,
						n_contact_list_drop_types,
						GDK_ACTION_COPY|GDK_ACTION_MOVE);
			gtk_tree_item_expand(GTK_TREE_ITEM(cnodes));
			gtk_signal_connect(GTK_OBJECT(cnodes),  "button_press_event",
						  GTK_SIGNAL_FUNC(edit_contact),
						  (struct contact*)l2->data );
			gtk_widget_show(cnodes);
								
		}
		
		gtk_tree_item_expand(GTK_TREE_ITEM(gnodes));
		if ( !( do_ignore_unknown && !strcmp( ((grouplist*)l1->data)->name, "Unknown" ) ) )
		{
			gtk_widget_show(gnodes);
			
			gtk_signal_connect(GTK_OBJECT(gnodes),  "button_press_event",
						  GTK_SIGNAL_FUNC(edit_group),
						  l1->data );
		}

	}
	
	gtk_widget_show(contact_list[type]);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrollwindow[type]),GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(scrollwindow[type], 150,200);
	return scrollwindow[type];
}

GtkWidget* MakeStatusMenu(eb_local_account * ela)
{
  GtkWidget* status_menu_item;
  GtkWidget* status_menu;
  GList * status_label;
  GList * temp_list;
  GtkWidget* hbox, *label;
  GtkStyle* style;
  GSList * group = NULL;
  GSList * widgets = NULL;
  int x;
  gchar string[255];
  status_menu = gtk_menu_new();
  style = gtk_widget_get_style(status_menu);

  gtk_widget_realize(status_menu);
  status_label = eb_services[ela->service_id].sc->get_states();

  status_menu_item = gtk_tearoff_menu_item_new();
  gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
  gtk_widget_show(status_menu_item);
  for(temp_list = status_label, x = 0; temp_list; x++, temp_list=temp_list->next)
  {
      struct Status * stats = g_new0(struct Status, 1);
      stats->ela = ela;
      stats->status= x;
      status_menu_item = gtk_radio_menu_item_new(group);
	  group = gtk_radio_menu_item_group(GTK_RADIO_MENU_ITEM(status_menu_item));
	  widgets = g_slist_append(widgets, status_menu_item);
      hbox = gtk_hbox_new(FALSE, 3);
      label = gtk_label_new((gchar*)temp_list->data);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
      gtk_widget_show(label);
      gtk_widget_show(hbox);
      gtk_widget_show(status_menu_item);
      gtk_container_add(GTK_CONTAINER(status_menu_item), hbox);
      gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
      gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
                         eb_status, (gpointer) stats );

  }

  ela->status_menu = widgets;

  g_snprintf(string, 255, "%s [%s]", ela->handle, get_service_name(ela->service_id));

  ela->status_button = gtk_menu_item_new_with_label(string);
  
  /* The following doesn't work!  Why? */
  /*
  gtk_menu_set_active(GTK_MENU(status_menu), 
                   eb_services[ela->service_id].sc->get_current_state(ela) );
  */

  /* So why not use "gtk_check_menu_item_set_active"?  Well, that method
     emits a signal.  What was happening was that it would send a signal
	 from the zeroth status item (usually "online") for some reason
	 _and_ from the one we want.  It's as if the signal from the zeroth item
	 was already in some queue.  Anyway, this would cause a status change to 
	 online and then back again for each protocol.  This causes unpredictable 
	 behavior when the user is offline. */
  
  /* First deactivate zeroth status radio item */
  GTK_CHECK_MENU_ITEM(g_slist_nth(widgets, 0)->data)->active = 0 ;
  /* Now, activate the desired status radio item */
  GTK_CHECK_MENU_ITEM(
    g_slist_nth(
	             widgets, 
                 eb_services[ela->service_id].sc->get_current_state(ela)
			   )->data
  )->active = 1 ;
  
  gtk_menu_item_set_submenu(GTK_MENU_ITEM(ela->status_button), status_menu);
  
  g_list_free(status_label);

  return ela->status_button;
}

/*This function is to be eventually phased out*/

/*
GtkWidget* MakeStatusButton(eb_local_account * ela)
{
  GtkWidget* status_menu_item;
  GtkWidget* status_menu;
  GList * status_label;
  GList * temp_list;
  GtkWidget* hbox, *label;
  GtkStyle* style;
  int x;
  status_menu = gtk_menu_new();
  style = gtk_widget_get_style(status_menu);

  gtk_widget_realize(status_menu);
  status_label = eb_services[ela->service_id].sc->get_states();

  for(temp_list = status_label, x = 0; temp_list; x++, temp_list=temp_list->next)
  {
      struct Status * stats = g_new0(struct Status, 1);
      stats->ela = ela;
      stats->status= x;
      status_menu_item = gtk_menu_item_new();
      hbox = gtk_hbox_new(FALSE, 3);
      label = gtk_label_new((gchar*)temp_list->data);
      gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
      gtk_widget_show(label);
      gtk_widget_show(hbox);
      gtk_widget_show(status_menu_item);
      gtk_container_add(GTK_CONTAINER(status_menu_item), hbox);
      gtk_menu_append(GTK_MENU(status_menu), status_menu_item);
      gtk_signal_connect(GTK_OBJECT(status_menu_item), "activate",
                         eb_status, (gpointer) stats );

  }

  ela->status_button = gtk_option_menu_new();
  gtk_menu_set_active(GTK_MENU(status_menu),
					 eb_services[ela->service_id].sc->get_current_state(ela) );
  gtk_option_menu_set_menu(GTK_OPTION_MENU(ela->status_button), status_menu);
  
  g_list_free(status_label);

  return ela->status_button;
}
*/
#include <X11/Xlib.h>

void eb_status_window()
{
		GtkWidget *statusbox;
      GtkWidget *vbox;
      GtkWidget *label;
		// GtkWidget *frame; Code that uses this is commented out below
		GtkWidget *vbox2;
		GtkWidget *notebook;
		GtkWidget *menubox;
		GtkWidget *menu;
		GtkWidget *submenu;
		GtkWidget *menuitem;
		GtkWidget *submenuitem;
		GtkWidget *hbox;
		GtkWidget *button_box;
		GdkPixmap *pm;
		GdkBitmap *bm;
		GtkWidget *pic;

		int win_x, win_y, win_w, win_h;
		int flags;


        GList * list;
        statuswindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	/* The next line allows you to make the window smaller than the orig. size */
	gtk_window_set_policy(GTK_WINDOW(statuswindow), TRUE, TRUE, TRUE);
        gtk_widget_realize(statuswindow);

		iconlogin_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconlogin_bm,
			NULL, (gchar **) login_icon_xpm);
		iconblank_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconblank_bm,
			NULL, (gchar **) blank_icon_xpm);
		iconlogoff_pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &iconlogoff_bm,
			NULL, (gchar **) logoff_icon_xpm);

	/* handle geometry - ivey */

	if (geometry[0] != 0) { 
	    flags = XParseGeometry(geometry, &win_x, &win_y, &win_w, &win_h);
	    /* proper negative handling comes later... 
		if ((flags & XValue) && (flags & XNegative))
		    *win_x = DisplayWidth(display, screenNum) - *win_x;
		if ((flags & YValue) && (flags & YNegative))
		    *win_y = DisplayHeight(display, screenNum) - *win_y;
	    */
	    gtk_window_set_position(GTK_WINDOW(statuswindow), GTK_WIN_POS_NONE); 
	    gtk_widget_set_uposition(statuswindow, win_x, win_y); 
	    gtk_widget_set_usize(statuswindow, win_w, win_h);
	}
		statusbox = gtk_vbox_new(FALSE, 0);
		
		menubox = gtk_handle_box_new();
		gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(menubox), GTK_POS_LEFT);
		gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(menubox), GTK_POS_LEFT);
		gtk_handle_box_set_shadow_type(GTK_HANDLE_BOX(menubox), GTK_SHADOW_NONE);
		menu = gtk_menu_bar_new();
		

		menuitem = gtk_menu_item_new_with_label("File");
		gtk_widget_show(menuitem);
	
		submenu = gtk_menu_new();
		submenuitem = gtk_tearoff_menu_item_new();
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_widget_show(submenuitem);
		
		/* The import sub menu */

		submenuitem = gtk_menu_item_new_with_label("Import");
		gtk_menu_append(GTK_MENU(submenu), submenuitem );
		{
			GtkWidget * import_menu = gtk_menu_new();
			label = gtk_tearoff_menu_item_new();
			gtk_menu_append(GTK_MENU(import_menu), label);
			gtk_widget_show(label);
		
            label = gtk_menu_item_new_with_label("Gaim BuddyList");
            gtk_menu_append(GTK_MENU(import_menu), label);
        	gtk_signal_connect(GTK_OBJECT(label), "activate",
                         eb_import_gaim, NULL );
            gtk_widget_show(label);  
		
            label = gtk_menu_item_new_with_label("GnomeICU Contact List");
            gtk_menu_append(GTK_MENU(import_menu), label);
        	gtk_signal_connect(GTK_OBJECT(label), "activate",
                         eb_import_gnomeicu, NULL );
            gtk_widget_show(label);  

            label = gtk_menu_item_new_with_label("ICQ99 Contact List");
            gtk_menu_append(GTK_MENU(import_menu), label);
        	gtk_signal_connect(GTK_OBJECT(label), "activate",
                         eb_import_icq99, NULL );
            gtk_widget_show(label);  

            label = gtk_menu_item_new_with_label("Licq Contact List");
            gtk_menu_append(GTK_MENU(import_menu), label);
        	gtk_signal_connect(GTK_OBJECT(label), "activate",
                         eb_import_licq, NULL );
            gtk_widget_show(label);  

			gtk_menu_item_set_submenu(GTK_MENU_ITEM(submenuitem), import_menu);
			gtk_widget_show(import_menu);
		}
		gtk_widget_show(submenuitem);
		
		/* The Set status menus */

		submenuitem = gtk_menu_item_new_with_label("Set Status");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		{
			GtkWidget * account_menu = gtk_menu_new();
			label = gtk_tearoff_menu_item_new();
			gtk_menu_append(GTK_MENU(account_menu), label); 
			gtk_widget_show(label);
        	for(list = accounts; list; list  = g_list_next(list) )
        	{
	
        	    label = MakeStatusMenu(list->data);
				((eb_local_account*)(list->data))->status_button = label;
				gtk_menu_append(GTK_MENU(account_menu), label);
    	        gtk_widget_show(label);
       		 }
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(submenuitem), account_menu);
			gtk_widget_show(account_menu);
		}
		gtk_widget_show(submenuitem);

		submenuitem = gtk_menu_item_new_with_label("Sign On All") ;
		gtk_menu_append(GTK_MENU(submenu), submenuitem ) ; 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu) ;
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								  eb_sign_on_all,
								  NULL) ;
		gtk_widget_show(submenuitem) ;
		gtk_widget_show(submenu) ;
        
		submenuitem = gtk_menu_item_new_with_label("Sign Off All") ;
		gtk_menu_append(GTK_MENU(submenu), submenuitem ) ; 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu) ;
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								  eb_sign_off_all,
								  NULL) ;
		gtk_widget_show(submenuitem) ;
		gtk_widget_show(submenu) ;
        
		submenuitem = gtk_menu_item_new_with_label("Exit");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
		gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
								 GTK_SIGNAL_FUNC(delete_event),
								 GTK_OBJECT(statuswindow));
		gtk_widget_show(submenuitem);
		gtk_widget_show(submenu);
		
		
		gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);

		menuitem = gtk_menu_item_new_with_label("Tools");
		gtk_widget_show(menuitem);
	
		submenu = gtk_menu_new();
		submenuitem = gtk_tearoff_menu_item_new();
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
		gtk_widget_show(submenuitem);

                submenuitem = gtk_menu_item_new_with_label("Preferences");
                gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         build_prefs_callback, NULL );
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_widget_show(submenuitem);  
		
      			 submenuitem = gtk_menu_item_new_with_label("Group Chat");
                gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         launch_group_chat, NULL );
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_widget_show(submenuitem);
      
		submenuitem = gtk_menu_item_new_with_label("Set As Away");
		gtk_menu_append(GTK_MENU(submenu), submenuitem);
		{
			away_menu = gtk_menu_new();

			load_away_messages();
			build_away_menu();

			gtk_menu_item_set_submenu(GTK_MENU_ITEM(submenuitem), away_menu);
			gtk_widget_show(away_menu);
		}
		gtk_widget_show(submenuitem);	

		submenuitem = gtk_menu_item_new_with_label("Edit Accounts (requires restart)");
		gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
      gtk_signal_connect(GTK_OBJECT(submenuitem), "activate",
                         eb_edit_accounts, NULL );
		gtk_widget_show(submenuitem);
		
		gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem), submenu);
		gtk_widget_show(submenu);
		
		gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);
		gtk_widget_show(menuitem);

                menuitem = gtk_menu_item_new_with_label("Help");
                gtk_widget_show(menuitem);
				gtk_menu_item_right_justify(GTK_MENU_ITEM(menuitem));
                gtk_menu_bar_append(GTK_MENU_BAR(menu),menuitem);                                

                submenu = gtk_menu_new();

				submenuitem = gtk_tearoff_menu_item_new();
				gtk_menu_append(GTK_MENU(submenu), submenuitem ); 
				gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
				gtk_widget_show(submenuitem);
                
				submenuitem = gtk_menu_item_new_with_label("About");
                gtk_menu_append(GTK_MENU(submenu), submenuitem );
                gtk_menu_item_set_submenu(GTK_MENU_ITEM(menuitem),submenu);
                gtk_signal_connect_object(GTK_OBJECT(submenuitem), "activate",
		                         GTK_SIGNAL_FUNC(show_about), NULL);

                gtk_widget_show(submenuitem);

		gtk_container_add(GTK_CONTAINER(menubox), menu );
		gtk_widget_show(menu);
		gtk_box_pack_start(GTK_BOX(statusbox), menubox, FALSE, FALSE, 0 );
		gtk_widget_show(menubox);
		
		notebook = gtk_notebook_new();
        vbox = gtk_vbox_new(FALSE, 0);
        hbox = gtk_hbox_new(FALSE, 0);

		label = gtk_radio_button_new_with_label(NULL, "Online Only");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5);
		gtk_signal_connect(GTK_OBJECT(label), "clicked", GTK_SIGNAL_FUNC(show_online_callback), (gpointer)0);
		gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(label),TRUE);
		gtk_widget_show(label);
		
		
		label = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(label)), "Show All");
		gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, TRUE, 5);
		gtk_signal_connect(GTK_OBJECT(label), "clicked", GTK_SIGNAL_FUNC(show_online_callback), (gpointer)1);
		gtk_widget_show(label);
		
        gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
		gtk_widget_show(hbox);

#ifdef DEBUG
        printf("%d\n", g_list_length(accounts));
#endif
		MakeContactList();
        gtk_widget_show(scrollwindow[LIST_ONLINE]);
        gtk_box_pack_start(GTK_BOX(vbox),scrollwindow[LIST_ONLINE],TRUE,TRUE,0);
  /*
		vbox2 = gtk_vbutton_box_new();
        for(list = accounts; list; list  = g_list_next(list) )
        {
			char buff[1024];
            printf("I am here\n");
			sprintf(buff,"%s: %s",
				eb_services[((eb_local_account*)list->data)->service_id].name,
				((eb_local_account*)list->data)->handle);
	
			frame=gtk_frame_new(buff);
			((eb_local_account*)(list->data))->status_frame = frame;
            label = MakeStatusButton(list->data);
			((eb_local_account*)(list->data))->status_button = label;
			gtk_container_add(GTK_CONTAINER(frame), label);
            gtk_widget_show(label);
			gtk_widget_show(frame);
        	gtk_box_pack_start(GTK_BOX(vbox2),frame,FALSE,FALSE,5);
        }


		gtk_widget_show(vbox2);
		gtk_box_pack_start(GTK_BOX(vbox), vbox2,FALSE,FALSE,5);
  */
		

		
		gtk_widget_show(vbox);
		gtk_notebook_append_page( GTK_NOTEBOOK(notebook), vbox, gtk_label_new("Status"));

		vbox = gtk_vbox_new(FALSE, 5);
		MakeEditContactList();
        gtk_box_pack_start(GTK_BOX(vbox),scrollwindow[LIST_EDIT],TRUE,TRUE,5);

		gtk_widget_show(scrollwindow[LIST_EDIT]);


		vbox2 = gtk_hbox_new(TRUE, 5);
		button_box = gtk_hbox_new(FALSE, 5);
		pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &bm, NULL, tb_preferences_xpm);
		pic = gtk_pixmap_new(pm, bm);

		gtk_box_pack_start(GTK_BOX(button_box), pic, FALSE, FALSE, 2 );
		gtk_widget_show(pic);

		pic = gtk_label_new("Add");
		gtk_box_pack_start(GTK_BOX(button_box), pic,FALSE, FALSE,2 );
		gtk_widget_show(pic);
		
		
		label = gtk_button_new();
		gtk_container_add(GTK_CONTAINER(label), button_box);
		gtk_widget_show(button_box);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
						   GTK_SIGNAL_FUNC(add_callback), NULL);
		gtk_widget_show(label);
		gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, TRUE, 5);
		gtk_widget_set_usize(vbox2, 200,25 );

		button_box = gtk_hbox_new(FALSE, 5);
		pm = gdk_pixmap_create_from_xpm_d(statuswindow->window, &bm, NULL, tb_trash_xpm);
		pic = gtk_pixmap_new(pm, bm);

		gtk_box_pack_start(GTK_BOX(button_box), pic, FALSE, FALSE, 2 );
		gtk_widget_show(pic);

		pic = gtk_label_new("Remove");
		gtk_box_pack_start(GTK_BOX(button_box), pic,FALSE, FALSE,2 );
		gtk_widget_show(pic);
		
		label = gtk_button_new();
		gtk_container_add(GTK_CONTAINER(label), button_box);
		gtk_widget_show(button_box);

		gtk_widget_show(label);
		gtk_signal_connect(GTK_OBJECT(label), "clicked",
						   GTK_SIGNAL_FUNC(remove_callback), NULL);
		gtk_box_pack_start(GTK_BOX(vbox2), label, TRUE, TRUE, 5);
		
		gtk_widget_show(vbox2);
		gtk_box_pack_start(GTK_BOX(vbox), vbox2, FALSE, FALSE, 5);

		gtk_widget_show(vbox);
		gtk_notebook_append_page( GTK_NOTEBOOK(notebook), vbox,
								  gtk_label_new("Edit Contacts"));

		gtk_widget_show(notebook);
        gtk_box_pack_start(GTK_BOX(statusbox), notebook,TRUE, TRUE,0);

		hbox = gtk_handle_box_new();
		gtk_handle_box_set_handle_position(GTK_HANDLE_BOX(hbox), GTK_POS_LEFT);
		gtk_handle_box_set_snap_edge(GTK_HANDLE_BOX(hbox), GTK_POS_LEFT);
		status_message = gtk_label_new("Welcome To Everybuddy");
		status_bar = gtk_frame_new(NULL);
		gtk_frame_set_shadow_type(GTK_FRAME(status_bar), GTK_SHADOW_IN );
		gtk_widget_show(status_message);
		gtk_container_add(GTK_CONTAINER(status_bar), status_message);
		gtk_widget_show(status_bar);
		gtk_container_add(GTK_CONTAINER(hbox), status_bar);
		gtk_widget_show(hbox);
		
        gtk_box_pack_start(GTK_BOX(statusbox), hbox ,FALSE, FALSE,0);
        gtk_window_set_title(GTK_WINDOW(statuswindow), "EveryBuddy");
		eb_icon(statuswindow->window);
		gtk_widget_show(statusbox);
		
		gtk_container_add(GTK_CONTAINER(statuswindow), statusbox );
		
		gtk_signal_connect (GTK_OBJECT (statuswindow), "delete_event",
				            GTK_SIGNAL_FUNC (delete_event), NULL);
      gtk_widget_show(statuswindow);
		MakeEditContactList();
}
