/*
 * EveryBuddy
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */ 

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "away_window.h"
#include "dialog.h"
#include "globals.h"
#include "service.h"
#include "pixmaps/ok.xpm"
#include "pixmaps/cancel.xpm"

static GtkWidget *awaybox = NULL;
GtkWidget * away_window;
GtkWidget * away_message;
GtkWidget * title;
GtkWidget * save_later;
GList *away_messages;
gint is_away = 0;
gint away_open = 0;

static void destroy_away()
{
	GList * list;
    eb_local_account * ela = NULL;

	is_away = 0;

	for (list = accounts; list; list = g_list_next(list)) {
    	ela = list->data;
		eb_services[ela->service_id].sc->set_away(ela, NULL);
    }
}

static void imback()
{
	if (awaybox)
		gtk_widget_destroy(awaybox);
	awaybox = NULL;
}

static void destroy( GtkWidget *widget, gpointer data)
{
	away_open = 0;
}

void load_away_messages()
{
	FILE * fp;
	char buff[2048];
	away * my_away = NULL;

	g_snprintf (buff, 1024, "%saway_messages", config_dir);

	if(!(fp = fopen(buff, "r")))
		return;

	away_messages = NULL;

	while ( fgets(buff, 248, fp))
	{
                g_strchomp(buff);
                if (!g_strncasecmp(buff, "<AWAY_MESSAGE>", 2048))
                {
                        my_away = g_new0(away, 1);
                } else if (!g_strncasecmp( buff, "</AWAY_MESSAGE>", 2048))
                {
                        away_messages = g_list_append(away_messages, my_away);

                } else if (!g_strncasecmp(buff, "<TITLE>", 2048)) 
                {
                        do {
                                fgets(buff, 2048, fp);
                                g_strchomp(buff);
                                strncpy(my_away->title, buff, sizeof(buff));

                        } while (!g_strncasecmp(buff, "</TITLE>", 2048));
                } else if (!g_strncasecmp(buff, "<MESSAGE>", 2048))
                {
                        my_away->message = g_string_new(NULL);
                        while (g_strncasecmp(buff, "</MESSAGE>", 2048))
                        {
                                fgets(buff, 2048, fp);
                                g_strchomp(buff);
                                if (!g_strncasecmp(buff, "</MESSAGE>", 2048))
                                {
                                        break;
                                }
                                g_string_append(my_away->message, buff);
				g_string_append_c(my_away->message, '\n');
                        }
                }
        }

	fclose(fp);
}


void build_away_menu()
{
	GList * l;
	GtkWidget * label;
	GList * away_list = away_messages;
	away * my_away = NULL;

	l = gtk_container_children(GTK_CONTAINER(away_menu));
	
	while (l) 
	{
		gtk_widget_destroy(GTK_WIDGET(l->data));
		l = l->next;
	}

	label = gtk_tearoff_menu_item_new();
	gtk_menu_append(GTK_MENU(away_menu), label);
	gtk_widget_show(label);

	label = gtk_menu_item_new_with_label("New Away Message");
	gtk_menu_append(GTK_MENU(away_menu), label);
	gtk_signal_connect(GTK_OBJECT(label), "activate",
				show_away2, NULL );
	gtk_widget_show(label);

	while (away_list)
	{
		my_away = (away *)away_list->data;
		
		label = gtk_menu_item_new_with_label(my_away->title);
		gtk_menu_append(GTK_MENU(away_menu), label);
		gtk_signal_connect(GTK_OBJECT(label), "activate",
				show_away, my_away->message->str);
			
		gtk_widget_show(label);

		away_list = away_list->next;
	}
	gtk_widget_show(away_menu);
}

void write_away_messages()
{
	GList * away_list = away_messages;
	FILE *fp;
	char buff2[2048];
	away * my_away;

    g_snprintf(buff2, 1024, "%saway_messages",config_dir);

    if(!(fp = fdopen(creat(buff2,0700),"w")))
        return;

	while (away_list)
	{
		my_away = (away *)away_list->data;

		fprintf(fp,"<AWAY_MESSAGE>\n");
		fprintf(fp,"<TITLE>\n");
		strncpy(buff2, my_away->title, strlen(my_away->title) + 1);
		g_strchomp(buff2);
		fprintf(fp,"%s\n",buff2);
		fprintf(fp,"</TITLE>\n");
		fprintf(fp,"<MESSAGE>\n");
		strncpy(buff2, my_away->message->str, strlen(my_away->message->str) + 1);
		g_strchomp(buff2);
		fprintf(fp,"%s\n",buff2);
		fprintf(fp,"</MESSAGE>\n");
		fprintf(fp,"</AWAY_MESSAGE>\n");

		away_list = away_list->next;
	}	
	fclose(fp);
}

static void ok_callback( GtkWidget * widget, gpointer data)
{
	GString * a_title = g_string_sized_new(1024);
	GString * a_message = g_string_sized_new(1024);
	gint save = GTK_TOGGLE_BUTTON(save_later)->active;
	away * my_away;

	gchar buff[2048];

	strcpy(buff, gtk_entry_get_text(GTK_ENTRY(title)));
	g_string_append(a_title, buff); 

	strcpy(buff, gtk_entry_get_text(GTK_ENTRY(away_message)));
	g_string_append(a_message, buff);
	
	if (save == 1)
	{
		my_away = g_new0(away, 1);
		strncpy(my_away->title, a_title->str, strlen(a_title->str));
		my_away->message = g_string_new(NULL);
		g_string_append(my_away->message, a_message->str);
		away_messages = g_list_append(away_messages, my_away);
		write_away_messages();
		build_away_menu();
	}
	
	show_away(NULL, a_message->str);

	g_string_free(a_title, TRUE);
	g_string_free(a_message, TRUE);

	gtk_widget_destroy(away_window);
}

static void cancel_callback( GtkWidget *widget, gpointer data)
{
	gtk_widget_destroy(away_window);
}

void show_away2(GtkWidget *w, void *null)
{
	if ( !away_open )
	{
		GtkWidget * vbox;
		GtkWidget * hbox;
		GtkWidget * hbox2;
		GtkWidget * label;
		GtkWidget * frame;
		GtkWidget * table;
		GtkWidget * separator;
		GtkWidget * button;
		GtkWidget * iconwid;
		GdkPixmap * icon;
		GdkBitmap * mask;

		away_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_widget_realize(away_window);

		vbox = gtk_vbox_new(FALSE, 5);
	
		/* make the window not resizable */

		table = gtk_table_new(2, 3, FALSE);

		label = gtk_label_new("Title:");
		gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 0, 1);
		gtk_widget_show(label);

		title = gtk_entry_new();
		gtk_table_attach_defaults(GTK_TABLE(table), title, 1, 2, 0, 1);
		gtk_widget_show(title);
		
		label = gtk_label_new("Away Message:");
		gtk_table_attach_defaults(GTK_TABLE(table), label, 0, 1, 1, 2);
		gtk_widget_show(label);

		away_message = gtk_entry_new();
		gtk_table_attach_defaults(GTK_TABLE(table), away_message, 1, 2, 1, 2);
		gtk_widget_show(away_message);

		save_later = gtk_check_button_new_with_label("Save for later use");
		gtk_table_attach_defaults(GTK_TABLE(table), save_later, 1, 2, 2, 3);
		gtk_widget_show(save_later);

		frame = gtk_frame_new("New Away Message");
		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_widget_show(table);

		gtk_table_set_row_spacings (GTK_TABLE(table), 5);
		gtk_table_set_col_spacings (GTK_TABLE(table), 5);

		gtk_container_set_border_width(GTK_CONTAINER(away_window), 5);
		gtk_container_set_border_width(GTK_CONTAINER(table), 5);

		gtk_box_pack_start(GTK_BOX(vbox), frame, FALSE, FALSE, 5);
		gtk_widget_show(frame);

		/* seperator goes here */
	
		separator = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
		gtk_widget_show(separator);

		/* 'Set away' and 'Cancel' buttons go here */

		hbox = gtk_hbox_new(FALSE, 5);
		hbox2 = gtk_hbox_new(TRUE, 5);

		gtk_widget_set_usize(hbox2, 200, 25);

		/* put in the pixmap and label for the 'Set away' button */

		icon = gdk_pixmap_create_from_xpm_d(away_window->window, &mask, NULL, ok_xpm);
		iconwid = gtk_pixmap_new(icon, mask);
		label = gtk_label_new("Set Away");

		gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);

		gtk_widget_show(iconwid);
		gtk_widget_show(label);

		button = gtk_button_new();

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(ok_callback), NULL);

		gtk_widget_show(hbox);

		gtk_container_add(GTK_CONTAINER(button), hbox);
		gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		/* now start on the cancel button */

		hbox = gtk_hbox_new(FALSE, 5);

		icon = gdk_pixmap_create_from_xpm_d(away_window->window, &mask, NULL, cancel_xpm);
		iconwid = gtk_pixmap_new(icon, mask);
		label = gtk_label_new("Cancel");

		gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);

		gtk_widget_show(iconwid);
		gtk_widget_show(label);

		button = gtk_button_new();

		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(cancel_callback), NULL);

		gtk_widget_show(hbox);

		gtk_container_add(GTK_CONTAINER(button), hbox);

		gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 0);
		gtk_widget_show(button);

		hbox = gtk_hbox_new(FALSE, 0);
		
		gtk_box_pack_end(GTK_BOX(hbox), hbox2, FALSE, FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

		gtk_widget_show(hbox);
		gtk_widget_show(hbox2);
		gtk_widget_show(vbox);
		
		gtk_container_add(GTK_CONTAINER(away_window), vbox);
		
		gtk_window_set_policy(GTK_WINDOW(away_window), FALSE, FALSE, TRUE);		
		
		gtk_widget_show(away_window);
	}

	gtk_window_set_title(GTK_WINDOW(away_window), "New Away Message");
	eb_icon(away_window->window);
	gtk_signal_connect(GTK_OBJECT(away_window), "destroy",
			GTK_SIGNAL_FUNC(destroy), NULL);
	away_open = 1; 
}

void show_away(GtkWidget *w, gchar *a_message)
{
	GList * list;
    eb_local_account * ela = NULL;

	if (!is_away) 
	{
		GtkWidget *label;
		GtkWidget *vbox;

		awaybox = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_widget_realize(awaybox);

		vbox = gtk_vbox_new(FALSE, 0);

		label = gtk_label_new("You are currently away, click \"I'm back\" to return");

		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
		gtk_widget_show(label);

		label = gtk_label_new("This is the away message that will \nbe sent to people messaging you.\nYou may edit this message if you wish.");

		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 5);
		gtk_widget_show(label);


		away_message = gtk_entry_new();
		gtk_entry_set_text(GTK_ENTRY(away_message), (strlen(a_message)>0 ? a_message : "User is currently away") );
		gtk_box_pack_start(GTK_BOX(vbox), away_message, TRUE, TRUE, 5);
		gtk_widget_show(away_message);

		label = gtk_button_new_with_label("I'm Back");
		gtk_signal_connect_object(GTK_OBJECT(label), "clicked",
		                  GTK_SIGNAL_FUNC(imback), GTK_OBJECT(awaybox));

		gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, FALSE, 0);
		GTK_WIDGET_SET_FLAGS(label, GTK_CAN_DEFAULT);
		gtk_widget_grab_default(label);
		gtk_widget_show(label);

	
		gtk_signal_connect_object(GTK_OBJECT(awaybox), "destroy",
                                  GTK_SIGNAL_FUNC(destroy_away), GTK_OBJECT(awaybox));

		gtk_container_add(GTK_CONTAINER(awaybox), vbox);
		gtk_widget_show(vbox);
	}

	gtk_window_set_title(GTK_WINDOW(awaybox), "Away");
	eb_icon(awaybox->window);
	gtk_container_border_width(GTK_CONTAINER(awaybox), 2);
	gtk_widget_show(awaybox);
	is_away = 1;
    
	for (list = accounts; list; list = g_list_next(list)) {
    	ela = list->data;
		eb_services[ela->service_id].sc->set_away(ela, a_message);
    }
}

