/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "account.h"
#include "service.h"
#include "contact.h"
#include "globals.h"

/*
 * Saves the contact list to (the list of people you see go on and off
 * line)
 */

void write_contact_list()
{
    FILE * fp;
    char buff2[1024];
    GList * l1;
    GList * l2;
    GList * l3;

	/*
	 * The contact list is a 3 dimensional linked list, at the top
	 * level you have a list of groups, each group can have several
	 * contacts, each contact can have several accounts.  Please see
	 * the Nomenclature file in the docs directory for details
	 */
	
    g_snprintf(buff2, 1024, "%scontacts", config_dir);
    if(!(fp = fdopen(creat(buff2,0700),"w")))
        return;


    for(l1 = groups; l1; l1=l1->next )
    {
		fprintf(fp,"<GROUP>\n\tNAME=\"%s\"\n", ((grouplist*)l1->data)->name);
        for(l2 = ((grouplist*)l1->data)->members; l2; l2=l2->next )
        {
			struct contact * c = (struct contact*)l2->data;
			fprintf(fp, "\t<CONTACT>\n\t\tNAME=\"%s\"\n\t\tDEFAULT_PROTOCOL=\"%s\"\n", 
					c->nick, eb_services[c->default_chatb].name);

			fprintf(fp, "\t\tTRIGGER_TYPE=\"%s\"\n\t\tTRIGGER_ACTION=\"%s\"\n\t\tTRIGGER_PARAM=\"%s\"\n",
					get_trigger_type_text(c->trigger.type), 
					get_trigger_action_text(c->trigger.action),
					c->trigger.param);
					
            for(l3 = ((struct contact*)l2->data)->accounts; l3; l3=l3->next)
            {
                eb_account * account = (eb_account*)l3->data;
				fprintf( fp, "\t\t<ACCOUNT %s>\n\t\t\tNAME=\"%s\"\n\t\t</ACCOUNT>\n",
						 eb_services[account->service_id].name,
					 	 account->handle );	 

            }
			fprintf( fp, "\t</CONTACT>\n" );
        }
		fprintf( fp, "</GROUP>\n" );
    }

	fclose(fp);
}

/*
 * To load the accounts file we currently use flex and bison for
 * speed and robustness.... so all that we have to do is just
 * call account parse after opening the file and we are home free
 */

int load_accounts()
{
    FILE * fp;
    char buff2[1024];
	extern int accountparse();
	extern FILE * accountin;
	
    g_snprintf(buff2, 1024, "%saccounts",config_dir);

    if(!(fp = fopen(buff2,"r")))
        return 0;
    accounts = NULL;
	
	accountin = fp;
	accountparse();
#ifdef DEBUG
    printf("closing fp\n");
#endif
    fclose(fp);
    return accounts != NULL;
}

/*
 * to load the contact list we also use flex and bison, so we just
 * call the parser,  (isn't life so simple now :) )
 */

int load_contacts()
{
    FILE * fp;
    char buff2[1024];
	extern int contactparse();
	extern FILE * contactin;

    g_snprintf(buff2, 1024, "%scontacts",config_dir);

    if(!(fp = fopen(buff2,"r")))
        return 0;
	contactin = fp;
	groups = NULL;

	contactparse();

    fclose(fp);
    return 1;
}


