/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <stdio.h>
#include <gtk/gtk.h>
#include "globals.h"
#include "plugin_api.h"
#include "plugin.h"
#include "dialog.h"

static void eb_gtk_dialog_callback(GtkWidget *widget, gpointer data)
{
	callback_data *cd=data;
	int result=0;

	result=(int)gtk_object_get_user_data(GTK_OBJECT(widget));
	cd->action(cd->data, result);
	g_free(cd);
}

/* End local structures and functions */

/* GUI Functions */
ebmImportData *ebmImportData_new()
{
	ebmImportData *eid=g_new0(ebmImportData, 1);
	((ebmCallbackData *)eid)->CDType=ebmIMPORTDATA;
	return(eid);
}


ebmContactData *ebmContactData_new()
{
	ebmContactData *ecd=g_new0(ebmContactData, 1);
	((ebmCallbackData *)ecd)->CDType=ebmCONTACTDATA;
	return(ecd);
}

void *eb_add_menu_item(char *label, char *menu_name, eb_menu_callback callback, ebmType type, void *data)
{
	menu_item_data *mid=NULL;
	menu_data *md=NULL;

	eb_debug(DBG_CORE, ">Adding %s to menu %s\n", label, menu_name);
	md = GetPref(menu_name);
	if(!md)  {
		eb_debug("Unknown menu requested: %s\n", menu_name);
		return(NULL);
	}
	/* Make sure they're expecting the right kind of structure to be passed back */
	if(type!=md->type) {
		eb_debug("Incorrect ebmType passed, not adding menu item: %s\n", label);
		return(NULL);
	}
	mid=g_new0(menu_item_data, 1);
	mid->user_data=data;
	mid->label=label;
	mid->callback=callback;
	md->menu_items = g_list_append(md->menu_items, mid);
	if(md->redraw_menu) {
		eb_debug(DBG_CORE, "Calling redraw_menu for %s\n", menu_name);
		md->redraw_menu();
	}
	eb_debug(DBG_CORE, "<Successfully added menu item\n");
	/* Return the menu_item_data pointer, so that g_list_remove can be used */
	return((void *)mid);
}

int eb_remove_menu_item(char *menu_name, void *tag)
{
	menu_data *md=NULL;
	menu_item_data *mid=(menu_item_data *)tag;

	if(mid) {
		eb_debug(DBG_CORE, ">Request to remove %s from menu %s\n", mid->label, menu_name);
	}
	if(!tag) {
		eb_debug(DBG_CORE, "<Received request to delete from menu %s, with empty tag\n", menu_name);
		return(-1);
	}
	md=GetPref(menu_name);
	if(!md) {
		eb_debug(DBG_CORE, "<Requested menu %s does not exist, returning failure\n", menu_name);
		return(-1);
	}
	md->menu_items=g_list_remove(md->menu_items, tag);
	if(md->redraw_menu) {
		eb_debug(DBG_CORE, "Calling redraw_menu\n");
		md->redraw_menu();
	}
	eb_debug(DBG_CORE, "<Returning success\n");
	return(0);
}

void eb_do_dialog(char *message, char *title, eb_callback_action action, void *data)
{
	callback_data *cd=g_new0(callback_data,1);
	cd->action=action;
	cd->data=data;
	do_dialog(message, title, eb_gtk_dialog_callback, cd);
}

void eb_set_active_menu_status(GSList *status_menu, int status)
{
	gtk_check_menu_item_set_active
		(GTK_CHECK_MENU_ITEM
		 	(
			 g_slist_nth(status_menu, status)->data
			 ), TRUE
		);
}

/* File */
int eb_input_add(int fd, eb_input_condition condition, eb_input_function function,
		 void *callback_data)
{
	return(gdk_input_add(fd, condition, function, callback_data));
}

void eb_input_remove(int tag)
{
	gdk_input_remove(tag);
}


/* Debugging */
#ifdef __STDC__
int EB_DEBUG(char *func, char *file, int line, char *fmt, ...)
#else
int EB_DEBUG(char *func, char *file, int line, char *fmt, va_alist)
	char *fmt;
	va_dcl
#endif
{
	va_list ap;
	static int indent=0;

#ifdef __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif
	if(fmt && fmt[0]=='>')
		indent++;

	fprintf(stderr, "%*.*s%s[%i]:%s - ", indent, indent, " ", file, line, func);
	vfprintf(stderr, fmt, ap);
	fflush(stderr);
	va_end(ap);

	if(fmt && fmt[0]=='<')
		indent--;
	if(indent<0)
		indent=0;
	return(0);
}

const char *eb_config_dir()
{
	return(config_dir);
}
