/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
 * prefs.c
 *
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "dialog.h"
#include "service.h"
#include "util.h"
#include "libproxy/libproxy.h"
#include "pixmaps/ok.xpm"
#include "pixmaps/cancel.xpm"
#include "sound.h"
#include "config.h"
#include "input_list.h"
#include "value_pair.h"
#include "globals.h"
#include "status.h"
#include "gtkspell.h"
#include "plugin.h"

static gint is_prefs_open = 0;
static GList *GLOBAL_PREFS=NULL;

extern void update_contact_window_length ();

/*
 * Preferences Dialog
 */

void build_general_prefs(GtkWidget *); /* Sat Apr 28 2001 S. K. Mandal*/
void build_sound_tab(GtkWidget *);
void build_connections_tab(GtkWidget *);
void build_sound_prefs(GtkWidget *);
void build_logs_prefs(GtkWidget *);
void build_proxy_prefs(GtkWidget *);
void build_connections_prefs(GtkWidget *);
void build_chat_prefs(GtkWidget *);
void build_encoding_prefs(GtkWidget *);
void build_modules_prefs(GtkWidget *);
static void cancel_callback(GtkWidget * widget, gpointer data);
static void destroy(GtkWidget * widget, gpointer data);

/*
 * Global preference handling functions 
 */

void AddPref(char *key, void *data);
void *SetPref(char *key, void *data);
void *GetPref(char *key);
void iSetLocalPref(char *key, int data);
void fSetLocalPref(char *key, float data);
void cSetLocalPref(char *key, char * data);
char *cGetLocalPref(char *key);
int iGetLocalPref(char *key);

void build_prefs()
{
     if(!is_prefs_open)
     {
	  GtkWidget *hbox;
	  GtkWidget *label;
	  GtkWidget *button;
	  GtkWidget *hbox2;
	  GtkWidget *prefs_vbox;
	  GtkWidget *iconwid;
	  GdkPixmap *icon;
	  GdkBitmap *mask;
	  GtkWidget *prefs_window;

	  prefs_vbox = gtk_vbox_new(FALSE, 5);
	  prefs_window = gtk_window_new(GTK_WINDOW_DIALOG);
	  /* set current parent to prefs so error dialogs know who real
	   * parent is */
	  current_parent_widget = prefs_window;
	  gtk_widget_realize(prefs_window);
	  gtk_window_set_title(GTK_WINDOW(prefs_window), "EveryBuddy Preferences");
	  eb_icon(prefs_window->window);
	  gtk_signal_connect(GTK_OBJECT(prefs_window), "destroy",
			      GTK_SIGNAL_FUNC(destroy), NULL);

	  /*
       ************************************************************
	   Below the different tabs are defined for the preferences
	   window.  In which the user can make everybuddy work more
	   the way he/she wants it too.
	   ************************************************************
       */

	  {
	       GtkWidget *prefs_note = gtk_notebook_new();
           SetPref("widget::prefs_note", prefs_note);
	       build_general_prefs(prefs_note);
	       build_logs_prefs(prefs_note);
	       build_sound_prefs(prefs_note);
	       build_chat_prefs(prefs_note);
	       build_connections_prefs(prefs_note);
	       gtk_box_pack_start(GTK_BOX(prefs_vbox), prefs_note, FALSE, FALSE, 0);
	       build_proxy_prefs(prefs_note);
#ifdef HAVE_ICONV_H
	       build_encoding_prefs(prefs_note);
#endif
	       build_modules_prefs(prefs_note);
	  }
   
	  /*Okay Button*/
	  hbox = gtk_hbox_new(FALSE, 5);
	  hbox2 = gtk_hbox_new(TRUE, 5);
	  gtk_widget_set_usize(hbox2, 200,25);
   
	  icon = gdk_pixmap_create_from_xpm_d(prefs_window->window, &mask, NULL, ok_xpm);
	  iconwid = gtk_pixmap_new(icon, mask);
	  label = gtk_label_new("Ok");
   
	  gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
	  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
   
	  gtk_widget_show(iconwid);
	  gtk_widget_show(label);
   
	  button = gtk_button_new();
   
	  gtk_signal_connect_object (GTK_OBJECT (button), "clicked",
				     GTK_SIGNAL_FUNC (gtk_widget_destroy),
				     GTK_OBJECT (prefs_window));
	  gtk_widget_show(hbox);
   
	  gtk_container_add (GTK_CONTAINER (button), hbox);
   
	  gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
	  gtk_widget_show(button);
   
	  /*Cancel Button*/
	  hbox = gtk_hbox_new(FALSE, 5);
	  icon = gdk_pixmap_create_from_xpm_d(prefs_window->window, &mask, NULL, cancel_xpm);
	  iconwid = gtk_pixmap_new(icon, mask);
	  label = gtk_label_new("Cancel");
   
	  gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
	  gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
      
	  gtk_widget_show(iconwid);
	  gtk_widget_show(label);
   
	  button = gtk_button_new();
   
	  gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			     cancel_callback, prefs_window);
	  gtk_widget_show(hbox);
   
	  gtk_container_add (GTK_CONTAINER (button), hbox);
   
	  gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 5);
	  gtk_widget_show(button);
   
	  /*End Buttons*/
	  hbox = gtk_hbox_new(FALSE, 5);
	
	  gtk_box_pack_end(GTK_BOX(hbox), hbox2, FALSE, FALSE, 5);
	  gtk_widget_show(hbox2);
   
	  gtk_box_pack_start(GTK_BOX(prefs_vbox), hbox, FALSE, FALSE, 5);
	  gtk_widget_show(hbox);
	  gtk_widget_show(prefs_vbox);
	  gtk_container_add(GTK_CONTAINER(prefs_window), prefs_vbox);

	  gtk_widget_show(prefs_window);
	  is_prefs_open = 1;
     }
}

/*
 * General Preferences Dialog
 * Sat Apr 28 2001 Sourav K. Mandal <Sourav.Mandal@ikaran.com>
 *
 */

static GtkWidget * length_contact_window_entry;
const gint length_contact_window_def = 16;
const gint length_contact_window_max = 48;
gint length_contact_window_old = 16;

void verify_length_contact_window ()
{
  gint length_contact_window;

  length_contact_window = iGetLocalPref("length_contact_window");

  if (length_contact_window < 1)
    {
      length_contact_window = length_contact_window_old;
    }
  else if (length_contact_window > length_contact_window_max)
    {
      length_contact_window = length_contact_window_old;
    }
  iSetLocalPref("length_contact_window", length_contact_window);
}    

gint do_login_on_startup = 0;
gint do_login_on_startup_old = 0 ;

gint do_applet_show_on_startup = 1 ;
gint do_applet_show_on_startup_old = 1 ;

gint do_everybuddy_debug = 0;
gint do_everybuddy_debug_old = 0;

gint do_everybuddy_debug_html = 0;
gint do_everybuddy_debug_html_old = 0;

gint do_plugin_debug = 0;
gint do_plugin_debug_old = 0;

#ifdef HAVE_ISPELL
gint do_spell_checking = 1;
gint do_spell_checking_old = 1;
#endif

gint use_alternate_browser = 0;
gint use_alternate_browser_old = 0;
static GtkWidget * alternate_browser_entry;

void set_use_alternate_browser(GtkWidget * w, int * data);

void build_general_prefs(GtkWidget *prefs_note) {
    GtkWidget *vbox = gtk_vbox_new(FALSE, 5) ;
    GtkWidget *brbutton;
    GtkWidget *label;
    GtkWidget *hbox;

    char buff [10];
    char buff2 [256];
    buff [0] = '\0';
    buff2[0] = '\0';

    length_contact_window_entry = gtk_entry_new ();
    length_contact_window_old = iGetLocalPref("length_contact_window");

    vbox = gtk_vbox_new(FALSE, 0);
    hbox = gtk_hbox_new(FALSE, 0);

    g_snprintf(buff2, 256, "Length of Contact List (num. lines, 1 -> %d):",
	       length_contact_window_max);
    label = gtk_label_new(buff2);
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show(label);
    
    g_snprintf(buff, 10, "%d", iGetLocalPref("length_contact_window"));
    gtk_entry_set_text(GTK_ENTRY(length_contact_window_entry), buff);
    gtk_box_pack_start(GTK_BOX(hbox), length_contact_window_entry,
		       FALSE, FALSE, 0);
    gtk_widget_show(length_contact_window_entry);
    gtk_widget_show(hbox);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);

    do_login_on_startup_old = do_login_on_startup;
    eb_button("Log in on startup", &do_login_on_startup, vbox);

    do_applet_show_on_startup_old = do_applet_show_on_startup ;
    eb_button(
#ifdef USE_APPLET
	      "Show Applet on startup? (Compiled using Applet)",
#else
	      "Show Applet on startup? (When compiled using Applet)",
#endif
	      &do_applet_show_on_startup, vbox);

#ifdef HAVE_ISPELL
    do_spell_checking_old = do_spell_checking;
    eb_button("Use spell checking", &do_spell_checking, vbox);
#endif

    do_everybuddy_debug_old = do_everybuddy_debug;
    eb_button("Enable General Debug Messages", &do_everybuddy_debug, vbox);
    do_everybuddy_debug_html_old = do_everybuddy_debug_html;
    eb_button("Enable HTML Debug Messages", &do_everybuddy_debug_html, vbox);
    do_plugin_debug_old = do_plugin_debug;
    eb_button("Enable Plugin Debug Messages", &do_plugin_debug, vbox);
    use_alternate_browser_old = use_alternate_browser;
    alternate_browser_entry = gtk_entry_new();

    if (cGetLocalPref("alternate_browser")) {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), cGetLocalPref("alternate_browser"));
    } else {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), "");
    }

    brbutton = eb_button("Use alternate browser", &use_alternate_browser, vbox);
    gtk_signal_connect(GTK_OBJECT(brbutton), "clicked",
	    GTK_SIGNAL_FUNC(set_use_alternate_browser), (gpointer)brbutton);

    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new("Full path to alternate browser:");
    gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
    gtk_widget_show(label);

    gtk_box_pack_start(GTK_BOX(hbox), alternate_browser_entry, TRUE, TRUE, 10);
    gtk_widget_show(alternate_browser_entry);
    gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
    gtk_widget_show(hbox);

    gtk_widget_show(vbox);

    if(use_alternate_browser == 0)
    {
	gtk_widget_set_sensitive(alternate_browser_entry, FALSE);
    }

    gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox,
	    gtk_label_new("General"));
}

void cancel_general_prefs() {
  char buff [10];
  buff [0] = '\0';

    do_login_on_startup = do_login_on_startup_old;
    do_everybuddy_debug = do_everybuddy_debug_old;
    do_everybuddy_debug_html = do_everybuddy_debug_html_old;
    do_plugin_debug = do_plugin_debug_old;
    iSetLocalPref("length_contact_window", length_contact_window_old);
    g_snprintf (buff, 10, "%d", length_contact_window_old);
    gtk_entry_set_text(GTK_ENTRY(length_contact_window_entry), buff);
    
    do_applet_show_on_startup = do_applet_show_on_startup_old;
#ifdef HAVE_ISPELL
    do_spell_checking = do_spell_checking_old ;
#endif
    use_alternate_browser = use_alternate_browser_old;
    if (cGetLocalPref("alternate_browser")) {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), cGetLocalPref("alternate_browser"));
    } else {
	gtk_entry_set_text(GTK_ENTRY(alternate_browser_entry), "");
    }
}

void write_general_prefs(FILE *fp) {
    fprintf(fp,"do_login_on_startup=%d\n", do_login_on_startup) ;
    fprintf(fp,"do_everybuddy_debug=%d\n", do_everybuddy_debug) ;
    fprintf(fp,"do_everybuddy_debug_html=%d\n", do_everybuddy_debug_html) ;
    fprintf(fp,"do_plugin_debug=%d\n", do_plugin_debug) ;
    eb_debug (DBG_CORE, "length_contact_window=%d\n", iGetLocalPref("length_contact_window"));
    iSetLocalPref("length_contact_window", atol(gtk_entry_get_text
				 (GTK_ENTRY(length_contact_window_entry))));
    verify_length_contact_window ();
    update_contact_window_length ();
    eb_debug (DBG_CORE, "length_contact_window=%d\n", iGetLocalPref("length_contact_window"));
    fprintf(fp,"length_contact_window=%d\n", iGetLocalPref("length_contact_window"));
    fprintf(fp,"do_applet_show_on_startup=%d\n", do_applet_show_on_startup) ;
#ifdef HAVE_ISPELL
    fprintf(fp,"do_spell_checking=%d\n", do_spell_checking) ;
#endif
    fprintf(fp,"use_alternate_browser=%d\n", use_alternate_browser);
    if (strlen(cGetLocalPref("alternate_browser")) > 0) {
	fprintf(fp,"alternate_browser=%s\n", cGetLocalPref("alternate_browser"));
    }
}

void set_use_alternate_browser(GtkWidget * w, int * data)
{
     if(use_alternate_browser == 0)
     {
	  gtk_widget_set_sensitive(alternate_browser_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(alternate_browser_entry, TRUE);
     }
}

void destroy_general_prefs()
{
	cSetLocalPref("alternate_browser", gtk_entry_get_text(GTK_ENTRY(alternate_browser_entry)));
}


/*
 * Logs Preferences Dialog
 */

gint do_logging = 1;
gint do_logging_old = 1;
gint do_strip_html = 1;
gint do_strip_html_old = 1;
gint do_restore_last_conv = 0;
gint do_restore_last_conv_old = 0;

void build_logs_prefs(GtkWidget *prefs_note)
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);

     do_logging_old = do_logging;
     do_strip_html_old = do_strip_html;
     do_restore_last_conv_old = do_restore_last_conv;

     eb_button("Log all conversations", &do_logging, vbox);
     eb_button("Restore last Conversation", &do_restore_last_conv, vbox);
     eb_button("Strip HTML tags", &do_strip_html, vbox);
     gtk_widget_show(vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Logs"));
}

void cancel_logs_prefs() 
{
     /* Values */
     do_logging = do_logging_old;
     do_strip_html = do_strip_html_old;
     do_restore_last_conv = do_restore_last_conv_old;
}

void write_logs_prefs(FILE *fp)
{
     fprintf(fp,"do_logging=%d\n", do_logging);
     fprintf(fp,"do_strip_html=%d\n", do_strip_html);
     fprintf(fp,"do_restore_last_conv=%d\n", do_restore_last_conv);
}


/*
 * Chat Preferences Dialog
 */

gint do_escape_close = 1;
gint do_escape_close_old = 1;
gint do_convo_timestamp = 1;
gint do_convo_timestamp_old = 1;
gint do_enter_send = 1;
gint do_enter_send_old = 1;
gint do_ignore_unknown = 0;
gint do_ignore_unknown_old = 0;
gint do_multi_line = 1;
gint do_multi_line_old = 1;
gint do_raise_window = 1;
gint do_raise_window_old = 1;
gint do_send_idle_time = 1;
gint do_send_idle_time_old = 1;
gint do_timestamp = 1;
gint do_timestamp_old = 1;
gint do_tabbed_chat = 0;
gint do_tabbed_chat_old = 0;
/* Orientation:  0 => bottom, 1 => top, 2=> left, 3 => right */
gint do_tabbed_chat_orient = 0;
gint do_tabbed_chat_orient_old = 0;
gint do_ignore_fore = 0;
gint do_ignore_fore_old = 0;
gint do_ignore_back = 0;
gint do_ignore_back_old = 0;
gint do_ignore_font = 0;
gint do_ignore_font_old = 0;

gint accel_prev_tab[2] =     { GDK_Left, GDK_CONTROL_MASK };
gint accel_prev_tab_old[2] = { GDK_Left, GDK_CONTROL_MASK };
gint accel_next_tab[2] =     { GDK_Right, GDK_CONTROL_MASK };
gint accel_next_tab_old[2] = { GDK_Right, GDK_CONTROL_MASK };
guint accel_change_handler_id = 0;

/*
  Callback function for setting element of Tabbed Chat Orientation radio
  button group.  Ignores w and sets global to variable
*/
void set_tco_element (GtkWidget * w, int data)
{
  do_tabbed_chat_orient = data;
  write_prefs ();
}

/* apparently all signal handlers are supposed to be boolean... */
static gboolean newkey_callback (GtkWidget *keybutton, GdkEventKey *event, gint *userdata) {
	GtkWidget *label = GTK_BIN(keybutton)->child;
	/* remove stupid things like.. numlock scrolllock and capslock
	 * mod1 = alt, mod2 = numlock, mod3 = modeshift/altgr, mod4 = meta, mod5 = scrolllock */
	
	gint state = event->state & (GDK_SHIFT_MASK | GDK_CONTROL_MASK | GDK_MOD1_MASK | GDK_MOD4_MASK);
	if (state != 0) {
			/* this unfortunately was the only way I could do this without using
			 * a key release event
			 */
		switch(event->keyval) {
				case GDK_Shift_L:
				case GDK_Shift_R:
				case GDK_Control_L:
				case GDK_Control_R:
				case GDK_Caps_Lock:
				case GDK_Shift_Lock:
				case GDK_Meta_L:
				case GDK_Meta_R:
				case GDK_Alt_L:
				case GDK_Alt_R:
				case GDK_Super_L:
				case GDK_Super_R:
				case GDK_Hyper_L:
				case GDK_Hyper_R:
						/* don't let the user set a modifier as a hotkey */
						break;
				default:
					userdata[0] = event->keyval;
					userdata[1] = state;
					gtk_label_set_text(GTK_LABEL(label), gtk_accelerator_name(userdata[0], userdata[1]));
					gtk_signal_disconnect(GTK_OBJECT(keybutton), accel_change_handler_id);
					gtk_grab_remove(keybutton);
					accel_change_handler_id = 0;
		}
	}
	/* eat the event and make focus keys (arrows) not change the focus */
	return gtk_true();
}

static void getnewkey (GtkWidget * keybutton, gpointer userdata) {
	GtkWidget *label = GTK_BIN(keybutton)->child;

	if(accel_change_handler_id == 0) {
		gtk_label_set_text(GTK_LABEL(label), "Please press new key and modifier now.");
	
		gtk_object_set_data(GTK_OBJECT(keybutton), "accel", userdata);
		
		/* it's sad how this works: It grabs the events in the event mask
		 * of the widget the mouse is over, NOT the grabbed widget.
		 * Oh, and persistantly clicking makes the grab go away...
		 */
		gtk_grab_add(keybutton);
		
		accel_change_handler_id = gtk_signal_connect_after (GTK_OBJECT(keybutton),
					"key_press_event",
					GTK_SIGNAL_FUNC (newkey_callback),
					userdata);
	}
}

static void add_key_set(gchar *labelString,
					gint *userdata,
					GtkWidget *vbox)
{
     GtkWidget *hbox;
     GtkWidget *label;
     GtkWidget *button;
     hbox = gtk_hbox_new(FALSE, 2);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 255, 10);
	 gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
     gtk_widget_show (label);

	 /* do I need to free whats returned from gtk_accelerator? */
     button = gtk_button_new_with_label(gtk_accelerator_name(userdata[0], userdata[1]));
	 
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(getnewkey), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);

     gtk_widget_show(hbox);
}

void build_chat_prefs(GtkWidget *prefs_note) 
{
     GtkWidget *vbox;
     GtkWidget *hbox;
     GSList *group;
     GtkWidget *label;

     vbox = gtk_vbox_new(FALSE, 5);

     /* Values */
     do_ignore_unknown_old = do_ignore_unknown;
     do_send_idle_time_old = do_send_idle_time;
     do_raise_window_old = do_raise_window;
     do_timestamp_old = do_timestamp;
     do_multi_line_old = do_multi_line;
     do_enter_send_old = do_enter_send;
     do_convo_timestamp_old = do_convo_timestamp;
     do_escape_close_old = do_escape_close;
     do_tabbed_chat_old = do_tabbed_chat;
     do_tabbed_chat_orient_old = do_tabbed_chat_orient_old;

	 do_ignore_fore_old = do_ignore_fore;
	 do_ignore_back_old = do_ignore_back;
	 do_ignore_font_old = do_ignore_font;

	 accel_next_tab_old[0] = accel_next_tab[0];
	 accel_next_tab_old[1] = accel_next_tab[1];
	 accel_prev_tab_old[0] = accel_prev_tab[0];
	 accel_prev_tab_old[1] = accel_prev_tab[1];
	 accel_change_handler_id = 0;

     eb_button("Send idle/away status to servers", &do_send_idle_time, vbox);
     eb_button("Raise window on incoming message", &do_raise_window, vbox);
     eb_button("Timestamp when a user logs on/off", &do_timestamp, vbox);
     eb_button("Ignore unknown users", &do_ignore_unknown, vbox);
     eb_button("Enable multi-line chat", &do_multi_line, vbox);
     eb_button("Press enter to send", &do_enter_send, vbox);
     eb_button("Timestamps on Messages", &do_convo_timestamp, vbox);
     eb_button("Escape Closes Chat", &do_escape_close, vbox);
     eb_button("Use tabbed chat windows", &do_tabbed_chat, vbox);

     /*
       Radio button group for tabbed chat orientation
     */

     /* Setup box to hold it */
     hbox = gtk_hbox_new(FALSE, 5);

     /* setup intro label */
     label = gtk_label_new ("Tabbed Chat Orientation:");
     gtk_widget_show (label);
     gtk_box_pack_start (GTK_BOX(hbox), label, FALSE, FALSE, 5);

     /* Setup group -- set to NULL to create new group */
     group = NULL;

     /* Create buttons */
     group = eb_radio (group, "Bottom", do_tabbed_chat_orient, 0, hbox,
		       set_tco_element);
     group = eb_radio (group, "Top",    do_tabbed_chat_orient, 1, hbox,
		       set_tco_element);
     group = eb_radio (group, "Left",   do_tabbed_chat_orient, 2, hbox,
		       set_tco_element);
     group = eb_radio (group, "Right",  do_tabbed_chat_orient, 3, hbox,
		       set_tco_element);
    
     /* Put it in the vbox and make it visible */
     gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
     gtk_widget_show (hbox);

     /*
       End Radio Button Group
     */

     eb_button("Ignore Foreground Colors", &do_ignore_fore, vbox);
     eb_button("Ignore Background Colors", &do_ignore_back, vbox);
     eb_button("Ignore Fonts", &do_ignore_font, vbox);

	 add_key_set("Previous Tab Hotkey (requires a modifier)", accel_prev_tab, vbox);
	 add_key_set("Next Tab Hotkey (requires a modifier)", accel_next_tab, vbox);

     gtk_widget_show(vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Chat"));
}

void cancel_chat_prefs()
{
     do_ignore_unknown = do_ignore_unknown_old;
     do_send_idle_time = do_send_idle_time_old;
     do_raise_window = do_raise_window_old;
     do_timestamp = do_timestamp_old;
     do_multi_line = do_multi_line_old;
     do_enter_send = do_enter_send_old;
     do_convo_timestamp = do_convo_timestamp_old;
     do_escape_close = do_escape_close_old;
     do_tabbed_chat = do_tabbed_chat_old;
     do_tabbed_chat_orient = do_tabbed_chat_orient_old;
	 do_ignore_fore = do_ignore_fore_old;
	 do_ignore_back = do_ignore_back_old;
	 do_ignore_font = do_ignore_font_old;	 
	 
	 accel_next_tab[0] = accel_next_tab_old[0];
	 accel_next_tab[1] = accel_next_tab_old[1];
	 accel_prev_tab[0] = accel_prev_tab_old[0];
	 accel_prev_tab[1] = accel_prev_tab_old[1];
}

void write_chat_prefs(FILE *fp)
{
     fprintf(fp,"do_ignore_unknown=%d\n", do_ignore_unknown);
     fprintf(fp,"do_send_idle_time=%d\n", do_send_idle_time);
     fprintf(fp,"do_raise_window=%d\n", do_raise_window);
     fprintf(fp,"do_timestamp=%d\n", do_timestamp);
     fprintf(fp,"do_multi_line=%d\n", do_multi_line);
     fprintf(fp,"do_enter_send=%d\n", do_enter_send);
     fprintf(fp,"do_convo_timestamp=%d\n", do_convo_timestamp);
     fprintf(fp,"do_escape_close=%d\n", do_escape_close);
     fprintf(fp,"do_tabbed_chat=%d\n", do_tabbed_chat);
     fprintf(fp,"do_tabbed_chat_orient=%d\n", do_tabbed_chat_orient);
	 fprintf(fp,"do_ignore_fore=%d\n", do_ignore_fore);
	 fprintf(fp,"do_ignore_back=%d\n", do_ignore_back);
	 fprintf(fp,"do_ignore_font=%d\n", do_ignore_font);
	 fprintf(fp,"accel_next_tab=%s\n", gtk_accelerator_name(accel_next_tab[0], accel_next_tab[1]));
	 fprintf(fp,"accel_prev_tab=%s\n", gtk_accelerator_name(accel_prev_tab[0], accel_prev_tab[1]));
}

/*
 * Proxies Preferences Dialog
 */
static GtkWidget * proxy_server_entry;
static GtkWidget * proxy_port_entry;
static GtkWidget * proxy_user_entry;
static GtkWidget * proxy_password_entry;
static gint new_proxy_type;
static gint do_proxy_auth;
static gint do_proxy_auth_old;

static void set_proxy_type(GtkWidget *w, int *data);

void build_proxy_prefs(GtkWidget *prefs_note)
{
     GtkWidget *label;
     GtkWidget *button;
     GtkWidget *hbox;
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
     char buff[10];   

     proxy_server_entry = gtk_entry_new();
     proxy_port_entry = gtk_entry_new();
     proxy_user_entry = gtk_entry_new();
     proxy_password_entry = gtk_entry_new();

     label = gtk_label_new("Warning: Not all services are available through\nproxy, please see the README for details.");
     gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);
     button = gtk_radio_button_new_with_label(NULL, "Direct Connection");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_NONE);
	
     if(proxy_type == PROXY_NONE)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use HTTP Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_HTTP);

     if(proxy_type == PROXY_HTTP)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

	
     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use SOCKS4 Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_SOCKS4);

     if(proxy_type == PROXY_SOCKS4)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     button = gtk_radio_button_new_with_label(gtk_radio_button_group(GTK_RADIO_BUTTON(button)),
					       "Use SOCKS5 Proxy");
     gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 0);
     gtk_widget_show(button);
     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_proxy_type), (gpointer)PROXY_SOCKS5);

     if(proxy_type == PROXY_SOCKS5)
     {
	  gtk_toggle_button_set_state(GTK_TOGGLE_BUTTON(button), TRUE);
     }

     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Proxy Server:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     if(proxy_host)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), proxy_host);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), "");
     }

     gtk_box_pack_start(GTK_BOX(hbox), proxy_server_entry, TRUE, TRUE, 10);
     gtk_widget_show(proxy_server_entry);

     label = gtk_label_new("Proxy Port:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     g_snprintf(buff, 10, "%d", proxy_port);
     gtk_entry_set_text(GTK_ENTRY(proxy_port_entry), buff);
     gtk_box_pack_start(GTK_BOX(hbox), proxy_port_entry, FALSE, FALSE, 0);
     gtk_widget_show(proxy_port_entry);

     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);
     gtk_widget_show(hbox);

	 do_proxy_auth_old = do_proxy_auth ;
	 eb_button("Proxy requires authentication", &do_proxy_auth, vbox);

     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Proxy User ID:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     if(proxy_user)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_user_entry), proxy_user);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_user_entry), "");
     }

     gtk_box_pack_start(GTK_BOX(hbox), proxy_user_entry, TRUE, TRUE, 10);
     gtk_widget_show(proxy_user_entry);

     label = gtk_label_new("Proxy Password:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     if(proxy_password)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_password_entry), proxy_password);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_password_entry), "");
     }

	 gtk_entry_set_visibility(GTK_ENTRY(proxy_password_entry), FALSE);

     gtk_box_pack_start(GTK_BOX(hbox), proxy_password_entry, FALSE, FALSE, 0);
     gtk_widget_show(proxy_password_entry);

     gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 3);
     gtk_widget_show(hbox);

     if(proxy_type == PROXY_NONE)
     {
	  gtk_widget_set_sensitive(proxy_server_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_port_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_user_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_password_entry, FALSE);
     }

     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Proxy"));
     gtk_widget_show(vbox);
}

void cancel_proxy_prefs()
{
     char buff[10];

     new_proxy_type = proxy_type;
	
     if(proxy_host)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), proxy_host);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_server_entry), "");
     }

     g_snprintf(buff, 10, "%d", proxy_port);
     gtk_entry_set_text(GTK_ENTRY(proxy_port_entry), buff);

	 do_proxy_auth = do_proxy_auth_old ;

     if(proxy_user)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_user_entry), proxy_user);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_user_entry), "");
     }

     if(proxy_password)
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_password_entry), proxy_password);
     }
     else
     {
	  gtk_entry_set_text(GTK_ENTRY(proxy_password_entry), "");
     }

}

void destroy_proxy()
{
     proxy_set_proxy(new_proxy_type,
		     gtk_entry_get_text(GTK_ENTRY(proxy_server_entry)),
		     atol(gtk_entry_get_text(GTK_ENTRY(proxy_port_entry))));
	 proxy_set_auth(do_proxy_auth,
		 gtk_entry_get_text(GTK_ENTRY(proxy_user_entry)),
		 gtk_entry_get_text(GTK_ENTRY(proxy_password_entry)));
}

void write_proxy_prefs(FILE *fp)
{
     fprintf(fp,"proxy_type=%d\n", proxy_type);
     if(proxy_host)
     {
	  fprintf(fp,"proxy_host=%s\n", proxy_host);
     }
     fprintf(fp,"proxy_port=%d\n", proxy_port);
     fprintf(fp,"do_proxy_auth=%d\n", do_proxy_auth);
     if (proxy_user)
     {
      fprintf(fp,"proxy_user=%s\n", proxy_user);
     }
     if (proxy_password)
     {
      fprintf(fp,"proxy_password=%s\n", proxy_password);
     }
}


static void set_proxy_type(GtkWidget * w, int * data)
{
     new_proxy_type = (int)data;
     if(new_proxy_type == PROXY_NONE)
     {
	  gtk_widget_set_sensitive(proxy_server_entry, FALSE);
	  gtk_widget_set_sensitive(proxy_port_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(proxy_server_entry, TRUE);
	  gtk_widget_set_sensitive(proxy_port_entry, TRUE);
     }
}


/*
 * Encoding Preferences Dialog
 */

static GtkWidget * modules_path_text;

#ifdef HAVE_ICONV_H
#define ENCODE_LEN 64
gint use_recoding = 0;

static GtkWidget * local_encoding_entry;
static GtkWidget * remote_encoding_entry;

void set_use_of_recoding(GtkWidget * w, int * data);

/* Encoding conversion Configuration tabs */
void build_encoding_prefs(GtkWidget * prefs_note)
{
     GtkWidget * hbox;
     GtkWidget * label;
     GtkWidget * button;
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);

     local_encoding_entry = gtk_entry_new();
     remote_encoding_entry = gtk_entry_new();

     label = gtk_label_new("Warning: conversion is made using "
			   "iconv() wich is UNIX98 standard and we hope you have it :-)\n"
			   "For list of possible encodings run 'iconv --list'.");
     gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     button = eb_button("Use recoding in conversations", &use_recoding, vbox);

     gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(set_use_of_recoding), (gpointer)button);

     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Local encoding:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     gtk_entry_set_text(GTK_ENTRY(local_encoding_entry), cGetLocalPref("local_encoding"));
     gtk_box_pack_start(GTK_BOX(hbox), local_encoding_entry, TRUE, TRUE, 10);
     gtk_widget_show(local_encoding_entry);
     gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
     gtk_widget_show(hbox);


     hbox = gtk_hbox_new(FALSE, 0);
     label = gtk_label_new("Remote encoding:");
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 0);
     gtk_widget_show(label);

     gtk_entry_set_text(GTK_ENTRY(remote_encoding_entry), cGetLocalPref("remote_encoding"));
     gtk_box_pack_start(GTK_BOX(hbox), remote_encoding_entry, TRUE, TRUE, 10);
     gtk_widget_show(remote_encoding_entry);
     gtk_widget_show(hbox);

     gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Recoding"));
     gtk_widget_show(vbox);

     if(use_recoding == 0)
     {
	  gtk_widget_set_sensitive(local_encoding_entry, FALSE);
	  gtk_widget_set_sensitive(remote_encoding_entry, FALSE);
     }

}

void destroy_encodings() 
{
     cSetLocalPref("local_encoding", gtk_entry_get_text(GTK_ENTRY(local_encoding_entry)));
     cSetLocalPref("remote_encoding", gtk_entry_get_text(GTK_ENTRY(remote_encoding_entry)));
}

void set_use_of_recoding(GtkWidget * w, int * data)
{
     //new_proxy_type = (int)data;
     if(use_recoding == 0)
     {
	  gtk_widget_set_sensitive(local_encoding_entry, FALSE);
	  gtk_widget_set_sensitive(remote_encoding_entry, FALSE);
     }
     else
     {
	  gtk_widget_set_sensitive(local_encoding_entry, TRUE);
	  gtk_widget_set_sensitive(remote_encoding_entry, TRUE);
     }
}

void write_encoding_prefs(FILE *fp)
{
	 char *enc=NULL;

     fprintf(fp,"use_recoding=%d\n", use_recoding);
	 enc = cGetLocalPref("local_encoding");
     if(strlen(enc) > 0)
	  fprintf(fp,"local_encoding=%s\n", enc);
	 enc = cGetLocalPref("remote_encoding");
     if(strlen(enc) > 0)
	  fprintf(fp,"remote_encoding=%s\n", enc);
}

#endif

/* Used when loading service modules later, so passwords and user names are still available
 * as service:username */
void save_account_info(char *service, GList *pairs)
{
	char buff[256];

	g_snprintf(buff, 256, "%s:%s", service, value_pair_get_value(pairs, "SCREEN_NAME"));
	SetPref(buff, pairs);
}

void reload_service_accounts(int service_id)
{
	GList * node = accounts;
	GList * account_pairs;
	eb_local_account *oela=NULL, *nela=NULL;
	char buff[256], buff2[1024];

	while(node)
	{
		oela=node->data;
		if(oela->service_id != service_id || oela->connected) {
			node = node->next;
			continue;
		}
		eb_debug(DBG_CORE, "Account: handle:%s service: %s\n", oela->handle, get_service_name(oela->service_id));
		g_snprintf(buff, 256, "%s:%s", get_service_name(oela->service_id), oela->handle);
		account_pairs = GetPref(buff);
		nela = eb_services[oela->service_id].sc->read_local_account_config(account_pairs);
		if(!nela) {
			g_snprintf(buff2, 256, "Unable to create account for %s, check config file\n", buff);
			do_error_dialog(buff2, "Invalid account");
			oela->service_id=get_service_id("NO SERVICE");
		}
		else {
			nela->service_id = oela->service_id;
			node->data=nela;
			//FIXME: This should probably be left to the service to clean up, though at this point, it may not exist
			g_free(oela->handle);
			g_free(oela->protocol_local_account_data);
			g_free(oela);
		}
		node = node->next;
	}
}

void build_modules_list(GtkWidget * module_list)
{
	char *module_info[7];
	GList *plugins=NULL;
	eb_PLUGIN_INFO *epi=NULL;

	for(plugins=GetPref(EB_PLUGIN_LIST); plugins; plugins=plugins->next) {
		epi=plugins->data;
		eb_debug(DBG_CORE, "Adding plugin %s\n", epi->name);
		module_info[0]=PLUGIN_TYPE_TXT[epi->pi.type-1];
		module_info[1]=epi->pi.brief_desc;
		module_info[2]=PLUGIN_STATUS_TXT[epi->status];
		module_info[3]=epi->pi.version;
		module_info[4]=epi->pi.date;
		module_info[5]=epi->name;
		if(epi->status_desc)
			module_info[6]=(char *)epi->status_desc;
		else
			module_info[6]="";
		gtk_clist_append(GTK_CLIST(module_list), module_info);
	}
}

void rebuild_set_status_menu()
{
	GtkWidget *set_status_submenuitem;

	set_status_submenuitem = GetPref("widget::set_status_submenuitem");
	gtk_menu_item_remove_submenu(GTK_MENU_ITEM(set_status_submenuitem));
	eb_set_status_window(set_status_submenuitem);
	gtk_widget_draw(GTK_WIDGET(set_status_submenuitem), NULL);
}

void rebuild_import_menu()
{
	GtkWidget *import_submenuitem;

	import_submenuitem = GetPref("widget::import_submenuitem");
	if(!import_submenuitem) {
		eb_debug(DBG_CORE, "Not rebuilding import menu, it's never been built.\n");
		return;
	}
	gtk_menu_item_remove_submenu(GTK_MENU_ITEM(import_submenuitem));
	eb_import_window(import_submenuitem);
	gtk_widget_draw(GTK_WIDGET(import_submenuitem), NULL);
}

void rebuild_connections_prefs()
{
	GtkWidget *prefs_note, *connections_tab;
	static int connections_page=0;

	connections_tab = GetPref("widget::connections_tab");
	prefs_note = GetPref("widget::prefs_note");
	connections_page = gtk_notebook_page_num(GTK_NOTEBOOK(prefs_note), connections_tab);
	gtk_notebook_remove_page(GTK_NOTEBOOK(prefs_note), connections_page);
	SetPref("connections_page_num", &connections_page);
	build_connections_prefs(prefs_note);
	// Remove the page number for future builds of the prefs screen that are not from a reload
	SetPref("connections_page_num", NULL);
	/* Need to refresh the widget -- 
	 *      This forces the widget to redraw itself. */
	gtk_widget_draw(GTK_WIDGET(prefs_note), NULL);
}

void reload_modules(GtkWidget * w, int * data)
{
	 GtkWidget *module_list;
	 char *ptr=NULL;
	 char *modules_path=NULL;

	 module_list = GetPref("widget::module_list");
	 gtk_clist_clear(GTK_CLIST(module_list));

	 eb_debug(DBG_CORE, "Reloading modules\n");
	 modules_path = gtk_editable_get_chars(GTK_EDITABLE(modules_path_text), 0, -1);
	 ptr=modules_path;
	 while( (ptr=strchr(ptr, '\n')) )
		ptr[0]=':';
	 cSetLocalPref("modules_path", modules_path);
	 load_modules();
	 build_modules_list(module_list);
	 rebuild_connections_prefs();
	 rebuild_set_status_menu();
	 rebuild_import_menu();
}

typedef struct {
	GtkCList *clist;
	eb_PLUGIN_INFO *epi;
	gint row;
}Plugin_Callback_Data;

static void reload_plugin_callback(GtkWidget * reload_button, gpointer userdata)
{
	Plugin_Callback_Data *PCD=(Plugin_Callback_Data *)userdata;
	char *name=NULL, *path=NULL, buffer[1024];
	char *module_info[7];

	strncpy(buffer, PCD->epi->name, 1023);
	name=rindex(buffer, '/');
	if(name) {
		name[0]='\0';
		name++;
		path=buffer;
	}
	else {
			name=buffer;
			path=NULL;
	}
	if(PCD->epi->status==PLUGIN_LOADED)
	{
		eb_debug(DBG_CORE, "Unloading plugin %s\n", PCD->epi->name);
		if(unload_module(PCD->epi)!=0) {
			eb_debug(DBG_CORE, "Could not unload plugin %s\n", PCD->epi->name);
			return;
		}
		load_module(path, name);
	}
	else {
			load_module(path, name);
	}
	module_info[0]=PLUGIN_TYPE_TXT[PCD->epi->pi.type-1];
	module_info[1]=PCD->epi->pi.brief_desc;
	module_info[2]=PLUGIN_STATUS_TXT[PCD->epi->status];
	module_info[3]=PCD->epi->pi.version;
	module_info[4]=PCD->epi->pi.date;
	module_info[5]=PCD->epi->name;
	if(PCD->epi->status_desc)
		module_info[6]=(char *)PCD->epi->status_desc;
	else
		module_info[6]="";
	gtk_clist_remove(PCD->clist, PCD->row);
	gtk_clist_insert(PCD->clist, PCD->row, module_info);
	if(PCD->epi->pi.type==PLUGIN_SERVICE)
	{
		rebuild_connections_prefs();
		rebuild_set_status_menu();
	}
}

#define PLUGIN_TYPE_COL 0
#define PLUGIN_BRIEF_COL 1
#define PLUGIN_STATUS_COL 2
#define PLUGIN_VERSION_COL 3
#define PLUGIN_DATE_COL 4
#define PLUGIN_PATH_COL 5
#define PLUGIN_ERROR_COL 6

static void unload_plugin_callback(GtkWidget * reload_button, gpointer userdata)
{
	Plugin_Callback_Data *PCD=(Plugin_Callback_Data *)userdata;

	/*FIXME: Should set a pref so this module is not automatically loaded next time */
	eb_debug(DBG_CORE, "Unloading plugin %s\n", PCD->epi->name);
	if(unload_module(PCD->epi)==0) {
		gtk_clist_set_text(PCD->clist, PCD->row, PLUGIN_STATUS_COL, PLUGIN_STATUS_TXT[PLUGIN_NOT_LOADED]);
		eb_debug(DBG_CORE, "Unloaded plugin %s\n", PCD->epi->name);
		if(PCD->epi->pi.type==PLUGIN_SERVICE)
		{
			rebuild_connections_prefs();
			rebuild_set_status_menu();
		}
	}
	else
		eb_debug(DBG_CORE, "Could not unload plugin %s\n", PCD->epi->name);
}

void update_plugin_prefs(GtkWidget * w, input_list *prefs)
{
	eb_debug(DBG_MOD, "updating prefs\n");
	eb_input_accept(prefs);
}

/* Sort the clist based upon the column passed */
void plugin_column_sort(GtkCList *clist, gint column, gpointer userdata)
{
	eb_debug(DBG_CORE, "Sorting on column: %i\n", column);
	gtk_clist_set_sort_column(GTK_CLIST(clist), column);
	gtk_clist_sort(GTK_CLIST(clist));
}

void plugin_selected(GtkCList *clist, gint row, gint column, GdkEventButton *event, gpointer userdata)
{
	char *plugin_path=NULL;
	eb_PLUGIN_INFO *epi=NULL;

	eb_debug(DBG_CORE, "row: %i column: %i button: %i\n", row, column, event->button);

	gtk_clist_get_text(GTK_CLIST(clist), row, PLUGIN_PATH_COL, &plugin_path);
	eb_debug(DBG_CORE, "plugin: %s\n", plugin_path);
	epi=FindPluginByName(plugin_path);

	if(!epi) {
			fprintf(stderr, "Unable to find plugin %s in plugin list!\n", plugin_path);
			return;
	}
	if (event->button == 3)
	{
		GtkWidget *menu;
		Plugin_Callback_Data *PCD=g_new0(Plugin_Callback_Data, 1);
		GtkWidget *button;

		menu = gtk_menu_new();

		PCD->clist=clist;
		PCD->epi=epi;
		PCD->row=row;
		if(epi->status==PLUGIN_LOADED) { // Is this an already loaded plugin? 
			eb_debug(DBG_CORE, "Adding Reload button\n");
			button = gtk_menu_item_new_with_label("Reload");
			gtk_signal_connect(GTK_OBJECT(button), "activate",
				GTK_SIGNAL_FUNC(reload_plugin_callback), PCD);
			gtk_menu_append(GTK_MENU(menu), button);
			gtk_widget_show(button);
			eb_debug(DBG_CORE, "Adding Unload button\n");
			button = gtk_menu_item_new_with_label("Unload");
			gtk_signal_connect(GTK_OBJECT(button), "activate",
				GTK_SIGNAL_FUNC(unload_plugin_callback), PCD);
			gtk_menu_append(GTK_MENU(menu), button);
			gtk_widget_show(button);
		}
		else
		{
			eb_debug(DBG_CORE, "Adding Reload button\n");
			button = gtk_menu_item_new_with_label("Load");
			gtk_signal_connect(GTK_OBJECT(button), "activate",
				GTK_SIGNAL_FUNC(reload_plugin_callback), PCD);
			gtk_menu_append(GTK_MENU(menu), button);
			gtk_widget_show(button);
		}
		gtk_widget_show(menu);
		gtk_menu_popup(GTK_MENU(menu), NULL, NULL, NULL, NULL,
			event->button, event->time );
	}
	else if(event->button == 1)
	{
		GtkWidget *plugin_prefs_w=GetPref("widget::plugin_prefs_w");
		eb_debug(DBG_MOD, "Setting prefs for %s\n", plugin_path);
		if(!plugin_prefs_w)
		{
			g_warning("plugin_prefs_w not defined, not building plugin prefs window!");
			return;
		}
		/* If the window already has a child, destroy it. */
		if(GTK_BIN(plugin_prefs_w)->child!=NULL)
		{
			gtk_widget_destroy(GTK_BIN(plugin_prefs_w)->child);
		}

		if(epi->pi.prefs)
		{
			GtkWidget *button;
			GtkWidget *hbox;
			GtkWidget *vbox;
			vbox = gtk_vbox_new(FALSE, 5);
			eb_input_render(epi->pi.prefs, vbox);

			hbox = gtk_hbox_new(TRUE, 50);
			button = eb_push_button("Update", hbox);
			gtk_widget_show(hbox);

			gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
			gtk_signal_connect(GTK_OBJECT(button), "clicked",
					GTK_SIGNAL_FUNC(update_plugin_prefs), (gpointer)epi->pi.prefs);
			gtk_scrolled_window_add_with_viewport
	  			(GTK_SCROLLED_WINDOW(plugin_prefs_w),
	   			vbox);
//			gtk_container_add(GTK_CONTAINER(plugin_prefs_w), vbox);
			gtk_widget_show(vbox);
			gtk_widget_show(plugin_prefs_w);
		}
		else
			eb_debug(DBG_MOD, "No prefs defined for %s\n", plugin_path);
	}
}

void build_modules_prefs(GtkWidget * prefs_note)
{
	GtkWidget * hbox;
	GtkWidget * label;
	GtkWidget * button;
	GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
	GtkWidget *vbox2 = NULL;
	GtkWidget * module_list=NULL;
	GtkWidget *w;
	int Columns=7, col=0;
	char *titles[7] = {"Type", "Brief Description", "Status", "Version", "Date Last Modified" ,"Path to module", "Error Text"};
	char *modules_path, *ptr=NULL;
	int mod_path_pos=0;

	modules_path_text = gtk_text_new(NULL, NULL);
	gtk_editable_set_editable(GTK_EDITABLE(modules_path_text), TRUE);

	vbox2 = gtk_vbox_new(TRUE, 5);
	hbox = gtk_hbox_new(FALSE, 0);

	label = gtk_label_new("Module Paths");
	gtk_box_pack_start(GTK_BOX(vbox2), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	
	button = eb_push_button("Rescan", vbox2);
	gtk_box_pack_start(GTK_BOX(hbox), vbox2, FALSE, FALSE, 0);
	gtk_widget_show(vbox2);

	gtk_signal_connect(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(reload_modules), (gpointer)button);


	modules_path = cGetLocalPref("modules_path");
	ptr=modules_path;
	while( (ptr=strchr(ptr, ':')) )
		ptr[0]='\n';
	gtk_widget_set_usize(modules_path_text, 200, 75);
	gtk_editable_insert_text(GTK_EDITABLE(modules_path_text), modules_path, strlen(modules_path), &mod_path_pos);
	gtk_box_pack_start(GTK_BOX(hbox), modules_path_text, TRUE, TRUE, 10);
	gtk_widget_show(modules_path_text);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 10);
	gtk_widget_show(hbox);

	w=gtk_scrolled_window_new(NULL, NULL);
	gtk_widget_set_usize(w, 400, 200);
	/* Need to create a new one each time window is created as the old one was destroyed */
	module_list=gtk_clist_new_with_titles(Columns, titles);
	gtk_container_add(GTK_CONTAINER(w), module_list);
	gtk_widget_show(w);
	gtk_box_pack_start(GTK_BOX(vbox), w, TRUE, TRUE, 10);
	SetPref("widget::module_list", module_list);
	build_modules_list(module_list);
	gtk_clist_set_reorderable(GTK_CLIST(module_list), TRUE);
	gtk_clist_set_auto_sort(GTK_CLIST(module_list), TRUE);
	gtk_clist_column_titles_active(GTK_CLIST(module_list));
	gtk_signal_connect(GTK_OBJECT(module_list), "click-column",
			GTK_SIGNAL_FUNC(plugin_column_sort), NULL);
	gtk_clist_set_selection_mode(GTK_CLIST(module_list), GTK_SELECTION_SINGLE);
	for(col=0;col<Columns;col++)
		gtk_clist_set_column_auto_resize(GTK_CLIST(module_list), col, TRUE);
	/* Make sure right mouse button works */
	gtk_clist_set_button_actions(GTK_CLIST(module_list), 1, GTK_BUTTON_SELECTS);
	gtk_clist_set_button_actions(GTK_CLIST(module_list), 2, GTK_BUTTON_SELECTS);
	gtk_clist_set_button_actions(GTK_CLIST(module_list), 3, GTK_BUTTON_SELECTS);
	gtk_signal_connect(GTK_OBJECT(module_list), "select-row",
			GTK_SIGNAL_FUNC(plugin_selected), NULL);

	label = gtk_label_new("Plugin Prefs");
	gtk_box_pack_start(GTK_BOX(vbox), label, FALSE, FALSE, 0);
	gtk_widget_show(label);
	w=gtk_scrolled_window_new(NULL, NULL);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(w),
		GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);
	gtk_widget_set_usize(w, 0, 100);
	gtk_widget_show(w);
	SetPref("widget::plugin_prefs_w", w);
	gtk_box_pack_start(GTK_BOX(vbox), w, TRUE, TRUE, 10);

	 
	gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Modules"));
	gtk_widget_show(vbox);
	gtk_widget_show(GTK_WIDGET(module_list));
}

void destroy_modules() 
{
	char *modules_path=NULL;
	char *ptr=NULL;

	modules_path=gtk_editable_get_chars(GTK_EDITABLE(modules_path_text), 0, -1);
	ptr=modules_path;
	while( (ptr=strchr(ptr, '\n')) )
		ptr[0]=':';
	cSetLocalPref("modules_path", modules_path);
}

void write_module_prefs(FILE *fp)
{
	GList *plugins=NULL;
	GList *master_prefs=NULL;
	GList *current_prefs=NULL;
	eb_PLUGIN_INFO *epi=NULL;

	fprintf(fp,"modules_path=%s\n", cGetLocalPref("modules_path"));

	fprintf(fp,"plugins\n");
	for(plugins=GetPref(EB_PLUGIN_LIST); plugins; plugins=plugins->next) {
		epi=plugins->data;
		fprintf(fp, "\t%s\n", epi->name);
		master_prefs=GetPref(epi->name);
		master_prefs=value_pair_remove(master_prefs, "load");
		current_prefs=eb_input_to_value_pair(epi->pi.prefs);
		master_prefs=value_pair_update(master_prefs, current_prefs);
		if(epi->status==PLUGIN_LOADED)
			value_pair_add(master_prefs, "load", "1");
		else
			value_pair_add(master_prefs, "load", "0");
		value_pair_print_values(master_prefs, fp, 2);
		fprintf(fp, "\tend\n");
	}
	fprintf(fp,"end\n");
}


/*
 * Connections Preferences Dialog
 */

void build_connections_prefs(GtkWidget *prefs_note)
{
     void *page_num=NULL;

     GtkWidget *connections_tab = gtk_vbox_new(FALSE, 5);
     connections_tab = gtk_vbox_new(FALSE, 5);
     build_connections_tab(connections_tab);
     gtk_widget_show(connections_tab);
	 page_num=GetPref("connections_page_num");
	 /* Make sure we put the pref in the right place */
	 if(page_num)
     	gtk_notebook_insert_page(GTK_NOTEBOOK(prefs_note), connections_tab, gtk_label_new("Connections"), *(int *)page_num);
	else
     	gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), connections_tab, gtk_label_new("Connections"));
	 SetPref("widget::connections_tab", connections_tab);

     gtk_widget_show(prefs_note);
}

void cancel_connections_prefs()
{
     int i;
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_cancel(eb_services[i].sc->get_prefs());
	  }
     }
}

void destroy_connections()
{
     int i;
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_accept(eb_services[i].sc->get_prefs());
	  }
     }
}

gint compare_ptr_key(gconstpointer a, gconstpointer b) {
		if(!strcmp( ((ptr_list *)a)->key, (char *)b))
			return(0);
		return(1);
}

void AddPref(char *key, void *data) {
	ptr_list *PrefData;

	PrefData = g_new0(ptr_list, 1);
	strcpy(PrefData->key, key);
	PrefData->value=(void *)data;
	GLOBAL_PREFS = g_list_append(GLOBAL_PREFS, PrefData);
	return;
}

/* Find old pref data, and replace with new, returning old data */
void *SetPref(char *key, void *data) {
	ptr_list *PrefData=NULL;
	void *old_data=NULL;
	GList *ListData = g_list_find_custom(GLOBAL_PREFS, key, compare_ptr_key);

	if(!ListData) {
		AddPref(key, data);
		return(NULL);
	}
	PrefData=(ptr_list *)ListData->data;
	old_data=PrefData->value;
	PrefData->value=data;
	return(old_data);
}

void *GetPref(char *key) {
	ptr_list *PrefData=NULL;
	GList *ListData = g_list_find_custom(GLOBAL_PREFS, key, compare_ptr_key);

	if(!ListData)
		return(NULL);
	PrefData = ListData->data;
	if(!PrefData)
		return(NULL);
	return(PrefData->value);
}

void cSetLocalPref(char *key, char *data) {
	char newkey[MAX_PREF_NAME_LEN];
	char *oldvalue=NULL;

	sprintf(newkey, "Local::%s", key);
	oldvalue = SetPref(newkey, strdup(data));
	if(oldvalue)
		g_free(oldvalue);
	return;
}

void iSetLocalPref(char *key, int data) {
	char value[MAX_PREF_NAME_LEN];

	g_snprintf(value, MAX_PREF_LEN, "%i", data);
	cSetLocalPref(key, value);
	return;
}

void fSetLocalPref(char *key, float data) {
	char value[MAX_PREF_LEN];

	g_snprintf(value, MAX_PREF_LEN, "%f", data);
	cSetLocalPref(key, value);
	return;
}

char *cGetLocalPref(char *key) {
	char newkey[MAX_PREF_NAME_LEN];
	char *value=NULL;

	sprintf(newkey, "Local::%s", key);
	value = (char *)GetPref(newkey);
	if(!value)
		value="";
	return(value);
}

float fGetLocalPref(char *key) {
	float value=0;

	value=atof(cGetLocalPref(key));
	return(value);
}

int iGetLocalPref(char *key) {
	int value=0;

	value=atoi(cGetLocalPref(key));
	return(value);
}

void write_connections_prefs(FILE *fp)
{
     int i;
	 GList *master_service_prefs = NULL;

     fprintf(fp,"connections\n");
     for(i = 0; i < NUM_SERVICES; i++)
     {
	  GList * service_prefs;
	  fprintf(fp, "\t%s\n", eb_services[i].name);
	  if(eb_services[i].sc->write_prefs_config)
	  {
		  service_prefs = eb_services[i].sc->write_prefs_config();
		  master_service_prefs = (GList *)GetPref(eb_services[i].name);
		  if(master_service_prefs) {
		  	master_service_prefs = value_pair_update(master_service_prefs, service_prefs);
		  }
		  else {	/* Happens when there was an epmty prefs file */
			master_service_prefs = service_prefs;
			AddPref(eb_services[i].name, service_prefs);
		  }
		  value_pair_print_values(master_service_prefs, fp, 2);
//		  value_pair_free(service_prefs);
	  }
	  fprintf(fp, "\tend\n");
     }
}


/*
 * Connections Preferences sub-dialogs
 */

void build_connections_tab(GtkWidget * parent_window)
{
     GtkWidget * service_vbox;
     GtkWidget * con_note;
     gint i;

     con_note = gtk_notebook_new();

     for(i = 0; i < NUM_SERVICES; i++)
     {
	  service_vbox = gtk_vbox_new(FALSE, 5);
	  gtk_widget_show(service_vbox);
			

	  if(eb_services[i].sc->get_prefs)
	  {
		  eb_input_render(eb_services[i].sc->get_prefs(),
				  service_vbox);
	  }

	  gtk_notebook_append_page(GTK_NOTEBOOK(con_note), service_vbox, gtk_label_new(eb_services[i].name));
     }

     gtk_widget_show(con_note);
     gtk_container_add(GTK_CONTAINER(parent_window), con_note);
	

}

/*
 * Sound Preferences Dialog
 */

//gchar *sounddevice_old = "/dev/audio"; //defaults at "/dev/audio"
//gint use_sounddevice_old = 0;
//gint use_typical_sound_method_old = 0;
gint do_away_sound = 1;
gint do_away_sound_old = 1;
gint do_no_sound_when_away = 0;
gint do_no_sound_when_away_old = 0;
gint do_no_sound_for_ignore = 1;
gint do_no_sound_for_ignore_old = 1;
gint do_online_sound = 1;
gint do_online_sound_old = 1;
gint do_play_send = 1;
gint do_play_send_old = 1;
gint do_play_first = 1;
gint do_play_first_old = 1;
gint do_play_receive = 1;
gint do_play_receive_old = 1;

// todo: allocate these 14KB of buffers dynamically
//gchar *sounddevice = "/dev/audio"; //defaults at "/dev/audio"
//gint use_sounddevice = 0;
//gint use_typical_sound_method = 0;

gchar BuddyArriveFilename_old[1024] = BuddyArriveDefault;
gchar BuddyAwayFilename_old[1024] = BuddyLeaveDefault;
gchar BuddyLeaveFilename_old[1024] = BuddyLeaveDefault;
gchar FirstMsgFilename_old[1024] = RecieveDefault;
gchar RecieveFilename_old[1024] = RecieveDefault;
gchar SendFilename_old[1024] = SendDefault;

gfloat volume_sound_old = 0;

static GtkWidget *arrivesoundentry;
static GtkWidget *awaysoundentry;
static GtkWidget *leavesoundentry;
static GtkWidget *sendsoundentry;
static GtkWidget *recievesoundentry;
static GtkWidget *firstmsgsoundentry;
static GtkWidget *volumesoundentry;

GtkWidget *add_sound_file_selection_box(gchar *, GtkWidget *, gchar *, int);
GtkWidget *add_sound_volume_selection_box(gchar *, GtkWidget *, GtkAdjustment *);
/* Main Sound Preferences Funtion, hooks in the rest */

void build_sound_prefs(GtkWidget *prefs_note) 
{
     GtkWidget *vbox = gtk_vbox_new(FALSE, 5);
     build_sound_tab(vbox);
     gtk_widget_show (vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(prefs_note), vbox, gtk_label_new("Sound"));

     gtk_widget_show(prefs_note);

}

     /* This is the sound sub-tabs code */

void build_sound_tab(GtkWidget * parent_window)
{

     GtkWidget * sound_vbox;
     GtkWidget * sound_note;

     sound_note = gtk_notebook_new();

     /* Values */
     do_no_sound_when_away_old = do_no_sound_when_away;
     do_no_sound_for_ignore_old = do_no_sound_for_ignore;
     do_online_sound_old = do_online_sound;
     do_play_send_old = do_play_send;
     do_play_first_old = do_play_first;
     do_play_receive_old = do_play_receive;
//	use_typical_sound_method_old = use_typical_sound_method;
//	use_sounddevice_old = use_sounddevice;
//	sounddevice_old = sounddevice;
     strcpy(BuddyArriveFilename_old, cGetLocalPref("BuddyArriveFilename"));
     strcpy(BuddyAwayFilename_old, cGetLocalPref("BuddyAwayFilename"));
     strcpy(BuddyLeaveFilename_old, cGetLocalPref("BuddyLeaveFilename"));
     strcpy(SendFilename_old, cGetLocalPref("SendFilename"));
     strcpy(RecieveFilename_old, cGetLocalPref("RecieveFilename"));
     strcpy(FirstMsgFilename_old, cGetLocalPref("FirstMsgFilename"));
     volume_sound_old = iGetLocalPref("SoundVolume");

     /* General Tab */
 
    sound_vbox = gtk_vbox_new(FALSE, 5);
     gtk_widget_show(sound_vbox);

     eb_button("Disable sounds when away", &do_no_sound_when_away, sound_vbox);
     eb_button("Disable sounds for Ignored people", &do_no_sound_for_ignore, sound_vbox);
     eb_button("Enable sounds when sending to a person that is away",&do_away_sound, sound_vbox);
     eb_button("Play sounds when signing on or off", &do_online_sound, sound_vbox);
     eb_button("Play a sound when sending a message", &do_play_send, sound_vbox);
     eb_button("Play a sound when receiving a message", &do_play_receive, sound_vbox);
     eb_button("Play a sound when receiving first message", &do_play_first, sound_vbox);

    gtk_notebook_append_page(GTK_NOTEBOOK(sound_note), sound_vbox, gtk_label_new("General"));

     /* Files Tab */

     sound_vbox = gtk_vbox_new(FALSE, 5);
     gtk_widget_show(sound_vbox);

     arrivesoundentry = 
	  add_sound_file_selection_box("Buddy Arrive Sound: ",
				       sound_vbox,
				       cGetLocalPref("BuddyArriveFilename"),
				       BUDDY_ARRIVE);
     awaysoundentry = 
	  add_sound_file_selection_box("Buddy Away Sound: ",
				       sound_vbox,
				       cGetLocalPref("BuddyAwayFilename"),
				       BUDDY_AWAY);
     leavesoundentry = 
	  add_sound_file_selection_box("Buddy Leave Sound: ",
				       sound_vbox,
				       cGetLocalPref("BuddyLeaveFilename"),
				       BUDDY_LEAVE);

     sendsoundentry = 
	  add_sound_file_selection_box("Send Sound: ",
				       sound_vbox,
				       cGetLocalPref("SendFilename"),
				       SEND);

     firstmsgsoundentry = 
	  add_sound_file_selection_box("1st Message Receive: ",
				       sound_vbox,
				       cGetLocalPref("FirstMsgFilename"),
				       FIRSTMSG);

     recievesoundentry = 
	  add_sound_file_selection_box("Receive Sound: ",
				       sound_vbox,
				       cGetLocalPref("RecieveFilename"),
				       RECEIVE);
     volumesoundentry =
       add_sound_volume_selection_box("Relative Volume (dB)",
				      sound_vbox,
				      GTK_ADJUSTMENT(gtk_adjustment_new(iGetLocalPref("SoundVolume"),
							 -40,0,1,5,0)));

     gtk_widget_show(sound_vbox);
     gtk_notebook_append_page(GTK_NOTEBOOK(sound_note), sound_vbox, 
			      gtk_label_new("Files"));

     gtk_widget_show(sound_note);
     gtk_container_add(GTK_CONTAINER(parent_window), sound_note);

}

void cancel_sound_prefs()
{
     /* Values */
//	use_typical_sound_method = use_typical_sound_method_old;
//	use_sounddevice = use_sounddevice_old;
//	sounddevice = sounddevice_old;
     do_play_send = do_play_send_old;
     do_play_first = do_play_first_old;
     do_play_receive = do_play_receive_old;
     do_online_sound = do_online_sound_old;
     do_no_sound_when_away = do_no_sound_when_away_old;
     do_no_sound_for_ignore = do_no_sound_for_ignore_old;
     do_away_sound = do_away_sound_old;
	 cSetLocalPref("BuddyArriveFilename", BuddyArriveFilename_old);
	 cSetLocalPref("BuddyAwayFilename", BuddyAwayFilename_old);
	 cSetLocalPref("BuddyLeaveFilename", BuddyLeaveFilename_old);
	 cSetLocalPref("SendFilename", SendFilename_old);
	 cSetLocalPref("RecieveFilename", RecieveFilename_old);
	 cSetLocalPref("FirstMsgFilename", FirstMsgFilename_old);
     fSetLocalPref("SoundVolume", volume_sound_old);

     /* Widgets */
     gtk_entry_set_text (GTK_ENTRY (arrivesoundentry), cGetLocalPref("BuddyArriveFilename"));
     gtk_entry_set_text (GTK_ENTRY (awaysoundentry), cGetLocalPref("BuddyAwayFilename"));
     gtk_entry_set_text (GTK_ENTRY (leavesoundentry), cGetLocalPref("BuddyLeaveFilename"));
     gtk_entry_set_text (GTK_ENTRY (sendsoundentry), cGetLocalPref("SendFilename"));
     gtk_entry_set_text (GTK_ENTRY (recievesoundentry), cGetLocalPref("RecieveFilename"));
     gtk_entry_set_text (GTK_ENTRY (firstmsgsoundentry), cGetLocalPref("FirstMsgFilename"));
}

static void setsoundfilename(GtkWidget * fileselector, int userdata);
static void getsoundfile (GtkWidget * sendf_button, gpointer userdata);
static void soundfile_entry_changed(GtkEntry * entry, int userdata);
static void testsoundfile (GtkWidget * sendf_button, int userdata);
static void soundvolume_changed(GtkAdjustment * adjust, int userdata);

GtkWidget *add_sound_file_selection_box(gchar *labelString,
					GtkWidget *vbox,
					gchar *initialFilename,
					int userdata) 
{
     GtkWidget *hbox;
     GtkWidget *widget;
     GtkWidget *label;
     GtkWidget *button;
     hbox = gtk_hbox_new(FALSE, 3);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 125, 10);
     gtk_widget_show (label);

     widget = gtk_entry_new ();
     gtk_entry_set_text (GTK_ENTRY (widget), initialFilename);
     gtk_widget_ref (widget);
     gtk_signal_connect(GTK_OBJECT(widget), "changed", 
			GTK_SIGNAL_FUNC(soundfile_entry_changed), 
			(gpointer) userdata);
     gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
     gtk_widget_show (widget);

     button = gtk_button_new_with_label ("Browse");
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(getsoundfile), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);

     button = gtk_button_new_with_label ("Preview");
     gtk_signal_connect(GTK_OBJECT(button), "clicked", 
			GTK_SIGNAL_FUNC(testsoundfile), 
			(gpointer)userdata);
     gtk_box_pack_start(GTK_BOX(hbox), button, FALSE, FALSE, 5);
     gtk_widget_show (button);
     gtk_widget_show(hbox);
     return widget;
}

GtkWidget *add_sound_volume_selection_box(gchar *labelString,
					  GtkWidget *vbox,
					  GtkAdjustment *adjust)
{
     GtkWidget *hbox;
     GtkWidget *widget;
     GtkWidget *label;
     int dummy=0;
     hbox = gtk_hbox_new(FALSE, 3);
     gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);

     label = gtk_label_new (labelString);
     gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 3);
     gtk_widget_set_usize(label, 125, 10);
     gtk_widget_show (label);

     widget=gtk_hscale_new(adjust);
     /*     widget = gtk_entry_new ();
	    gtk_entry_set_text (GTK_ENTRY (widget), initialFilename); */
     gtk_widget_ref (widget);
     gtk_signal_connect(GTK_OBJECT(adjust), "value_changed", 
			GTK_SIGNAL_FUNC(soundvolume_changed), 
			(gpointer) dummy);
     gtk_box_pack_start(GTK_BOX(hbox), widget, TRUE, TRUE, 0);
     gtk_widget_show (widget);

     gtk_widget_show(hbox);
     return widget;
}

GtkWidget *soundfileselector;

static void getsoundfile (GtkWidget * sendf_button, gpointer userdata)
{
//	GtkWidget *file_selector;
     eb_debug(DBG_CORE, "Just entered getsoundfile\n");
     soundfileselector = gtk_file_selection_new("Please select a file to use.");
   
     gtk_signal_connect(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->ok_button),
			"clicked", GTK_SIGNAL_FUNC (setsoundfilename), userdata);
   
     gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->ok_button),
			       "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			       (gpointer) soundfileselector);

     gtk_signal_connect_object(GTK_OBJECT (GTK_FILE_SELECTION(soundfileselector)->cancel_button),
			       "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			       (gpointer) soundfileselector);
                                            
     gtk_widget_show (soundfileselector);	
}

static void soundfile_entry_changed(GtkEntry * entry, int userdata)
{
     switch(userdata) 
     {
     case BUDDY_ARRIVE: 
	  cSetLocalPref("BuddyArriveFilename", gtk_entry_get_text(GTK_ENTRY (arrivesoundentry)));
	  break;
     case BUDDY_LEAVE:	
	  cSetLocalPref("BuddyLeaveFilename", gtk_entry_get_text(GTK_ENTRY (leavesoundentry)));
	  break;
     case SEND:		
	  cSetLocalPref("SendFilename", gtk_entry_get_text(GTK_ENTRY (sendsoundentry)));
	  break;
     case RECEIVE:		
	  cSetLocalPref("RecieveFilename", gtk_entry_get_text(GTK_ENTRY (recievesoundentry)));
	  break;
     case BUDDY_AWAY: 	
	  cSetLocalPref("BuddyAwayFilename", gtk_entry_get_text(GTK_ENTRY (awaysoundentry)));
	  break;
     case FIRSTMSG:		
	  cSetLocalPref("FirstMsgFilename", gtk_entry_get_text(GTK_ENTRY (firstmsgsoundentry)));
	  break;
     }
}

static void setsoundfilename(GtkWidget * fileselector, int userdata)
{
     gchar *selected_filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(soundfileselector));

     eb_debug(DBG_CORE, "Just entered setsoundfilename and the selected file is %s\n", selected_filename);
     switch(userdata) 
     {
     case BUDDY_ARRIVE: 	
	  cSetLocalPref("BuddyArriveFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (arrivesoundentry), 
			      selected_filename);
	  break;
     case BUDDY_LEAVE:	
	  cSetLocalPref("BuddyLeaveFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (leavesoundentry), 
			      selected_filename);
	  break;
     case SEND:		
	  cSetLocalPref("SendFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (sendsoundentry), selected_filename);
	  break;
     case RECEIVE:		
	  cSetLocalPref("RecieveFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (recievesoundentry), 
			      selected_filename);
	  break;
     case BUDDY_AWAY: 	
	  cSetLocalPref("BuddyAwayFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (awaysoundentry), selected_filename);
	  break;
     case FIRSTMSG:		
	  cSetLocalPref("FirstMsgFilename", selected_filename);
	  gtk_entry_set_text (GTK_ENTRY (firstmsgsoundentry), 
			      selected_filename);
	  break;

     }
}

static void testsoundfile (GtkWidget * sendf_button, int userdata)
{
     switch(userdata) 
     {
     case BUDDY_ARRIVE:
	  playsoundfile(cGetLocalPref("BuddyArriveFilename"));
	  break;
		
     case BUDDY_LEAVE:
	  playsoundfile(cGetLocalPref("BuddyLeaveFilename"));
	  break;
	
     case SEND:
	  playsoundfile(cGetLocalPref("SendFilename"));
	  break;
	
     case RECEIVE:
	  playsoundfile(cGetLocalPref("RecieveFilename"));
	  break;
	
     case BUDDY_AWAY:
	  playsoundfile(cGetLocalPref("BuddyAwayFilename"));
	  break;
	
     case FIRSTMSG:
	  playsoundfile(cGetLocalPref("FirstMsgFilename"));
	  break;

     }
}

static void soundvolume_changed(GtkAdjustment * adjust, int userdata)
{
  fSetLocalPref("SoundVolume", adjust->value);
}

void write_sound_prefs(FILE *fp)
{
     fprintf(fp,"do_play_send=%d\n", do_play_send);
     fprintf(fp,"do_play_first=%d\n", do_play_first);
     fprintf(fp,"do_play_receive=%d\n", do_play_receive);
     fprintf(fp,"do_online_sound=%d\n", do_online_sound);
//	fprintf(fp,"use_typical_sound_method=%d\n", use_typical_sound_method);
//	fprintf(fp,"use_sounddevice=%d\n", use_sounddevice);
     fprintf(fp,"do_away_sound=%d\n", do_away_sound);
     fprintf(fp,"do_no_sound_when_away=%d\n", do_no_sound_when_away);
     fprintf(fp,"BuddyArriveFilename=%s\n", cGetLocalPref("BuddyArriveFilename"));
     fprintf(fp,"BuddyAwayFilename=%s\n", cGetLocalPref("BuddyAwayFilename"));
     fprintf(fp,"BuddyLeaveFilename=%s\n", cGetLocalPref("BuddyLeaveFilename"));
     fprintf(fp,"SendFilename=%s\n", cGetLocalPref("SendFilename"));
     fprintf(fp,"RecieveFilename=%s\n", cGetLocalPref("RecieveFilename"));
     fprintf(fp,"FirstMsgFilename=%s\n", cGetLocalPref("FirstMsgFilename"));
     fprintf(fp,"SoundVolume=%f\n", fGetLocalPref("SoundVolume"));
}

/*
 * Reading/Writing Prefs
 */
void write_prefs()
{
     gchar buff[1024];
     FILE * fp;
     // todo: write to temp file and rename at end to prevent damaged files
     g_snprintf(buff, 1024, "%sprefs",config_dir);
     fp = fopen(buff, "w");
     write_general_prefs(fp);
     write_logs_prefs(fp);
     write_sound_prefs(fp);
     write_chat_prefs(fp);
#ifdef HAVE_ICONV_H
     write_encoding_prefs(fp);
#endif
     write_proxy_prefs(fp);
     write_module_prefs(fp);
     write_connections_prefs(fp);
     fprintf(fp, "end\n");
     fclose(fp);
}

#define PLUGIN_PREF 1
#define SERVICE_PREF 2

// todo: re-organize to separate pref reading into modules
void eb_read_prefs()
{
	gchar buff[1024];
	int pref_type=0;
	FILE * fp;
	gchar *param=buff;
	gchar *val=buff;

	/* Set some default values */
	iSetLocalPref("length_contact_window", length_contact_window_def);
	cSetLocalPref("modules_path", MODULE_DIR);
	cSetLocalPref("BuddyArriveFilename", BuddyArriveDefault);
	cSetLocalPref("BuddyAwayFilename", BuddyLeaveDefault);
	cSetLocalPref("BuddyLeaveFilename", BuddyLeaveDefault);
	cSetLocalPref("FirstMsgFilename", RecieveDefault);
	cSetLocalPref("RecieveFilename", RecieveDefault);
	cSetLocalPref("SendFilename", SendDefault);

	g_snprintf(buff, 1024, "%sprefs",config_dir);
	fp = fopen(buff, "r");
	if(!fp)
	{
		/* This would cause things to crash if there is no file, as services
		* are not loaded yet.  It will be called when actual changes are made
		* to preferences, until then, it doesn't need to be written.
		*/
//		write_prefs();
		verify_length_contact_window ();
		return;
	}
	while(!feof(fp))
	{
		fgets(buff, 1024, fp);
		param=buff;
		if(feof(fp))
			break;
		g_strstrip(param);
		pref_type=0;
		if(!strcasecmp(buff, "plugins"))
			pref_type=PLUGIN_PREF;
		else if(!strcasecmp(buff, "connections"))
			pref_type=SERVICE_PREF;
		if(pref_type!=0)
		{
			for(;;)
			{
				int id=-1;
				char *plugin_name=NULL;
				GList * session_prefs = NULL;
				fgets(buff, 1024, fp);
				param=buff;
				g_strstrip(param);
				if(!strcasecmp(param, "end"))
				{
					break;
				}
				switch(pref_type) {
				case PLUGIN_PREF:
					plugin_name=strdup(param);
					break;
				case SERVICE_PREF:
					id = get_service_id(param);
					break;
				default:
					break;
				}

				for(;;)
				{
					fgets(buff, 1024, fp);
					param=buff;
					g_strstrip(param);
					if(!strcasecmp(param, "end"))
					{
						switch(pref_type) {
						case PLUGIN_PREF:
							AddPref(plugin_name, session_prefs);
							break;
						case SERVICE_PREF:
							AddPref(get_service_name(id), session_prefs);
							break;
						default:
							break;
						}
						break;
					}
					else
					{
						val=param;

						while(*val != 0 && *val !='=')
							val++;
						if(*val=='=')
						{
							*val='\0';
							val++;
						}

						/*
						* if quoted strip off the quotes
						*/

						if(*val == '"')
						{
							val++;
							val[strlen(val)-1] = '\0';
						}
						session_prefs = value_pair_add(session_prefs,
							param, val);
					}
				}
			}
			continue;
		} /* if(pref_type !=0) */
		val=param;

		while(*val != 0 && *val !='=')
			val++;
		if(*val=='=')
		{
			*val='\0';
			val++;
		}
		cSetLocalPref(param, val);
	}
	do_logging            =iGetLocalPref("do_logging");
	do_strip_html         =iGetLocalPref("do_strip_html");
	do_play_send          =iGetLocalPref("do_play_send");
	do_play_first         =iGetLocalPref("do_play_first");
	do_play_receive       =iGetLocalPref("do_play_receive");
	do_ignore_unknown     =iGetLocalPref("do_ignore_unknown");
	do_send_idle_time     =iGetLocalPref("do_send_idle_time");
	do_raise_window       =iGetLocalPref("do_raise_window");
	do_timestamp          =iGetLocalPref("do_timestamp");
	do_online_sound       =iGetLocalPref("do_online_sound");
	do_multi_line         =iGetLocalPref("do_multi_line");
	do_ignore_fore        =iGetLocalPref("do_ignore_fore");
	do_ignore_back        =iGetLocalPref("do_ignore_back");
	do_ignore_font        =iGetLocalPref("do_ignore_font");
	do_convo_timestamp    =iGetLocalPref("do_convo_timestamp");
	do_escape_close       =iGetLocalPref("do_escape_close");
	do_enter_send         =iGetLocalPref("do_enter_send");
#ifdef HAVE_ICONV_H
	use_recoding          =iGetLocalPref("use_recoding");
#endif
	do_restore_last_conv  =iGetLocalPref("do_restore_last_conv");
	/*
	use_typical_sound_method=iGetLocalPref("use_typical_sound_method");
	use_sounddevice=cGetLocalPref("use_sounddevice");
	*/
	do_away_sound         =iGetLocalPref("do_away_sound");
	do_no_sound_when_away =iGetLocalPref("do_no_sound_when_away");
	do_no_sound_for_ignore=iGetLocalPref("do_no_sound_for_ignore");
	do_tabbed_chat        =iGetLocalPref("do_tabbed_chat");
	do_tabbed_chat_orient =iGetLocalPref("do_tabbed_chat_orient");
#ifdef HAVE_ISPELL
	do_spell_checking     =iGetLocalPref("do_spell_checking");
#endif
	use_alternate_browser =iGetLocalPref("use_alternate_browser");
	do_applet_show_on_startup=iGetLocalPref("do_applet_show_on_startup");
	do_login_on_startup   =iGetLocalPref("do_login_on_startup");
	do_everybuddy_debug   =iGetLocalPref("do_everybuddy_debug");
	do_everybuddy_debug_html=iGetLocalPref("do_everybuddy_debug_html");
	do_plugin_debug       =iGetLocalPref("do_plugin_debug");

	 verify_length_contact_window ();
	 gtk_accelerator_parse(cGetLocalPref("accel_next_tab"), &accel_next_tab[0], (GdkModifierType *)&accel_next_tab[1]);
	 gtk_accelerator_parse(cGetLocalPref("accel_prev_tab"), &accel_prev_tab[0], (GdkModifierType *)&accel_prev_tab[1]);
     proxy_set_proxy(iGetLocalPref("proxy_type"), cGetLocalPref("proxy_host"), iGetLocalPref("proxy_port"));
     proxy_set_auth(iGetLocalPref("do_proxy_auth"), cGetLocalPref("proxy_user"), cGetLocalPref("proxy_password"));
     fclose(fp);
}

/*
 * Cancel button
 */
static void cancel_callback(GtkWidget * widget, gpointer data)
{
     GtkWidget * w = data;
     cancel_general_prefs();
     cancel_logs_prefs();
     cancel_chat_prefs();
     cancel_sound_prefs();
     cancel_connections_prefs();
     cancel_proxy_prefs();

     gtk_widget_destroy(w);
}

/*
 * Destroy prefs window
 */
static void destroy(GtkWidget * widget, gpointer data)
{
     destroy_connections();
     is_prefs_open = 0;
     destroy_proxy();
     destroy_general_prefs();
     /* reset current parent so error dialogs work correctly */
     current_parent_widget = NULL;
#ifdef HAVE_ICONV_H
     destroy_encodings();
#endif
	 destroy_modules();
     /* it'd be nice to check validity of recoding here 
	and cancel change if not supported */

#ifdef HAVE_ISPELL
     if ((!do_spell_checking) && (gtkspell_running()))
	     gtkspell_stop();
#endif

     write_prefs();
}
