/*
 * EveryBuddy 
 *
 * Copyright (C) 1999, Torrey Searle <tsearle@uci.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <gtk/gtk.h>
#include <string.h>
#include "contact.h"
#include "service.h"
#include "status.h"
#include "account.h"
#include "util.h"
#include "globals.h"
#include "dialog.h"
#include "pixmaps/tb_preferences.xpm"
#include "pixmaps/cancel.xpm"

static gint window_open = 0;
eb_account *account;
static GtkWidget *add_unknown_contact_window;
static GtkWidget *nick;
static GtkWidget *group;

#define COMBO_TEXT(x) gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(x)->entry))

static void destroy(GtkWidget *widget, gpointer data)
{
    window_open = 0;
}

static void ok_callback(GtkWidget *widget, gpointer data)
{
	grouplist *gl;
	struct contact *con;
	eb_account *a;
   
	a = RUN_SERVICE(account)->new_account(account->handle);

	remove_contact(account->account_contact);
	account = a;

	gl = find_grouplist_by_name(COMBO_TEXT(group));
	con = find_contact_by_nick(COMBO_TEXT(nick));

	if(!gl)
	{
		add_group(COMBO_TEXT(group));
		gl = find_grouplist_by_name(COMBO_TEXT(group));
	}
	
	if(!con)
	{
		con = add_new_contact(COMBO_TEXT(group), COMBO_TEXT(nick), account->service_id);
	}
	add_account(con->nick, account);
	update_contact_list ();
	write_contact_list();
	gtk_widget_destroy(add_unknown_contact_window);
}

static GList * get_groups()
{
    GList * node = NULL;
    GList * newlist = NULL;
    node = groups;

    while(node)
    {
        newlist = g_list_append(newlist, ((grouplist *)node->data)->name);
        node = node->next;
    }

    return newlist;
}

static GList * get_contacts(gchar * group)
{
    GList * node = NULL, *newlist = NULL;
    grouplist * g;

    g = find_grouplist_by_name(group);

    if(g)
        node = g->members;

    while(node)
    {
        newlist = g_list_append(newlist, ((struct contact *)node->data)->nick);
        node = node->next;
    }

    return newlist;
}


void  group_changed(GtkEditable *editable, gpointer user_data)
{
		GList * list = get_contacts(COMBO_TEXT(group));
		gtk_combo_set_popdown_strings(GTK_COMBO(nick), list );
		g_list_free(list);
}

void add_unknown_account_window_new(eb_account *ea)
{
	gchar buff[1024];

	if(!window_open)
	{
		GtkWidget *vbox;
		GtkWidget *hbox;
		GtkWidget *hbox2;
		GtkWidget *label;
		GtkWidget *button;
		GtkWidget *iconwid;
		GtkWidget *table;
		GtkWidget *frame;
		GtkWidget *separator;
		GList *list;
		GdkPixmap *icon;
		GdkBitmap *mask;    
      
		add_unknown_contact_window = gtk_window_new(GTK_WINDOW_DIALOG);
		gtk_widget_realize(add_unknown_contact_window);
		gtk_container_set_border_width(GTK_CONTAINER(add_unknown_contact_window), 5);
          
		table = gtk_table_new(2, 2, FALSE);
		gtk_table_set_row_spacings(GTK_TABLE(table), 5);
		gtk_table_set_row_spacings(GTK_TABLE(table), 5);
		gtk_container_set_border_width(GTK_CONTAINER(table), 5);
		hbox = gtk_hbox_new(FALSE, 5);
		vbox = gtk_vbox_new(FALSE, 5);
      
		/*Entry for Group Name*/
      
		label = gtk_label_new("Group Name:");
		gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_widget_show(label);
		gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 0, 1, GTK_EXPAND, GTK_EXPAND, 0, 0);
		gtk_widget_show(hbox);
		
		group = gtk_combo_new();
		list = get_groups();
		gtk_combo_set_popdown_strings(GTK_COMBO(group), list);
		g_list_free(list);
		gtk_signal_connect(GTK_OBJECT(GTK_COMBO(group)->entry), "changed",
				GTK_SIGNAL_FUNC(group_changed), NULL);
		gtk_table_attach(GTK_TABLE(table), group, 1, 2, 0, 1, GTK_EXPAND, GTK_EXPAND, 0, 0);
		gtk_widget_show(group);

		/*Entry for Contact Name*/
      
		hbox = gtk_hbox_new(FALSE, 5);

		label = gtk_label_new("Contact Name:");
		gtk_box_pack_end(GTK_BOX(hbox), label, FALSE, FALSE, 5);
		gtk_widget_show(label);
		gtk_table_attach(GTK_TABLE(table), hbox, 0, 1, 1, 2, GTK_EXPAND, GTK_EXPAND, 0, 0);
		gtk_widget_show(hbox);
		
		nick = gtk_combo_new();
		list = get_contacts(COMBO_TEXT(group));
		gtk_combo_set_popdown_strings(GTK_COMBO(nick), list);
		g_list_free(list);
		gtk_table_attach(GTK_TABLE(table), nick, 1, 2, 1, 2, GTK_EXPAND, GTK_EXPAND, 0, 0);
		gtk_widget_show(nick);
      
		/*Lets create the frame to put this in*/
		
		frame = gtk_frame_new(NULL);
		gtk_frame_set_label(GTK_FRAME(frame), "Add Unknown Contact");

		gtk_container_add(GTK_CONTAINER(frame), table);
		gtk_widget_show(table);

		gtk_box_pack_start(GTK_BOX(vbox), frame, TRUE, TRUE, 0);
		gtk_widget_show(frame);
		
		hbox = gtk_hbox_new(FALSE, 5);
		hbox2 = gtk_hbox_new(TRUE, 5);
		gtk_widget_set_usize(hbox2, 200,25 );
	
        /*Lets try adding a seperator*/

        separator = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
        gtk_widget_show(separator);

		/*Add Button*/
      
		icon = gdk_pixmap_create_from_xpm_d(add_unknown_contact_window->window, &mask, NULL, tb_preferences_xpm);
		iconwid = gtk_pixmap_new(icon, mask);
		label = gtk_label_new("Add");
      
		gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
      
		gtk_widget_show(iconwid);
		gtk_widget_show(label);
      
		button = gtk_button_new();
      
		gtk_signal_connect(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(ok_callback), NULL);
		gtk_widget_show(hbox);
      
		gtk_container_add(GTK_CONTAINER (button), hbox);
      
		gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 0);
		gtk_widget_show(button);
		
		/*Cancel Button*/
      
		hbox = gtk_hbox_new(FALSE, 5);
		icon = gdk_pixmap_create_from_xpm_d(add_unknown_contact_window->window, &mask, NULL, cancel_xpm);
		iconwid = gtk_pixmap_new(icon, mask);
		label = gtk_label_new("Cancel");
      
		gtk_box_pack_start(GTK_BOX(hbox), iconwid, FALSE, FALSE, 2);
		gtk_box_pack_start(GTK_BOX(hbox), label, FALSE, FALSE, 2);
      
		gtk_widget_show(iconwid);
		gtk_widget_show(label);
      
		button = gtk_button_new();
      
		gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
				GTK_SIGNAL_FUNC(gtk_widget_destroy),
				GTK_OBJECT(add_unknown_contact_window));
		gtk_widget_show(hbox);
      
		gtk_container_add(GTK_CONTAINER (button), hbox);
      
		gtk_box_pack_start(GTK_BOX(hbox2), button, TRUE, TRUE, 0);
		gtk_widget_show(button);
      
		/*Buttons End*/
      
		hbox = gtk_hbox_new(FALSE, 0);
		table = gtk_table_new(1, 1, FALSE);
		
		gtk_box_pack_end(GTK_BOX(hbox), hbox2, FALSE, FALSE, 0);
		gtk_widget_show(hbox2);
		
		gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 0);
		gtk_widget_show(hbox);
      
		gtk_table_attach(GTK_TABLE(table), vbox, 0, 1, 0, 1, GTK_EXPAND, GTK_EXPAND, 0, 0);
		gtk_widget_show(vbox);
		
		gtk_container_add(GTK_CONTAINER (add_unknown_contact_window), table);
		gtk_widget_show(table);
		
		gtk_signal_connect(GTK_OBJECT(add_unknown_contact_window), "destroy",
				GTK_SIGNAL_FUNC(destroy), NULL);
		gtk_widget_show(add_unknown_contact_window);
	}
	
	g_snprintf(buff, 1024, "Add %s to Contact List", ea->handle);
	gtk_window_set_title(GTK_WINDOW(add_unknown_contact_window), buff);
	eb_icon(add_unknown_contact_window->window);
	account = ea;
	window_open = 1;
}
