/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-mime-tools.h,v 1.6 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_MIME_TOOLS_H

#define ETPAN_MIME_TOOLS_H

#include "etpan-app-types.h"
#include <libetpan/libetpan.h>

#if 0
int etpan_get_mime(struct etpan_app * app, struct mailfolder * folder,
    char * content, size_t content_len, int check_security,
    struct mailmime ** result_mime);
#endif

struct mailmime *
etpan_mime_new_file_part(struct etpan_app * app,
    int use_filename, char * filename,
    char * default_content_type, int default_encoding);

char * etpan_encode_mime_header(struct etpan_app * app,
    char * phrase);

char * etpan_decode_mime_header(struct etpan_app * app,
    char * phrase);

int etpan_mailbox_encode(struct etpan_app * app,
    struct mailimf_mailbox * mb);

int etpan_mailbox_list_encode(struct etpan_app * app,
    struct mailimf_mailbox_list * mb_list);

int etpan_group_encode(struct etpan_app * app,
    struct mailimf_group * group);

int etpan_addr_encode(struct etpan_app * app, 
    struct mailimf_address * addr);

int etpan_addr_list_encode(struct etpan_app * app,
    struct mailimf_address_list * addr_list);

int etpan_mailbox_decode(struct etpan_app * app,
    struct mailimf_mailbox * mb);

int etpan_mailbox_list_decode(struct etpan_app * app,
    struct mailimf_mailbox_list * mb_list);

int etpan_group_decode(struct etpan_app * app,
    struct mailimf_group * group);

int etpan_addr_decode(struct etpan_app * app, 
    struct mailimf_address * addr);

int etpan_addr_list_decode(struct etpan_app * app,
    struct mailimf_address_list * addr_list);

int etpan_mime_is_text(struct mailmime * build_info);

struct mailmime_parameter *
mailmime_param_new_with_data(char * name, char * value);

#if 0
int etpan_delete_possible(struct mailmime * mime);
#endif

char * etpan_get_content_type_str(struct mailmime_content * content);


struct mailimf_mailbox_list *
etpan_get_from_field(struct etpan_app * app,
    struct etpan_account_info * account);
#if 0
struct mailimf_mailbox_list *
etpan_get_from_field(char * display_charset,
    struct etpan_account_info * account);
#endif

int etpan_address_list_write(FILE * f, int * col,
    struct etpan_app * app, struct mailimf_address_list * addr_list);

int etpan_mailbox_list_write(FILE * f, int * col,
    struct etpan_app * app, struct mailimf_mailbox_list * mb_list);

#if 0
struct mailmime_parameter *
mailmime_parameter_dup(struct mailmime_parameter * param);

struct mailmime_composite_type *
mailmime_composite_type_dup(struct mailmime_composite_type * composite_type);

struct mailmime_discrete_type *
mailmime_discrete_type_dup(struct mailmime_discrete_type * discrete_type);

struct mailmime_type * mailmime_type_dup(struct mailmime_type * type);

struct mailmime_content *
mailmime_content_dup(struct mailmime_content * dup_content);

struct mailmime_fields *
mailmime_fields_dup(struct mailmime_fields * mime_fields);

int mailmime_substitute(struct mailmime * old_mime,
    struct mailmime * new_mime);
#endif

int etpan_fetch_mime_body_to_file(struct etpan_app * app,
    char * filename, size_t size, struct mailfolder * folder,
    mailmessage * msg, struct mailmime * mime);

#if 0
int etpan_get_part_from_file(struct etpan_app * app,
    struct mailfolder * folder,
    char * filename,
    int check_security,
    struct mailmime ** result_mime);
#endif

#endif
