/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-app.h,v 1.9 2003/12/15 16:08:53 hoa Exp $
 */

#ifndef ETPAN_APP_DECL_H

#define ETPAN_APP_DECL_H

#include <libetpan/libetpan.h>
#include <libetpan/carray.h>
#include "etpan-app-types.h"

#ifndef CONFIG_H

#define CONFIG_H
#include "config.h"
#endif

struct etpan_app * etpan_app_new(char * config_path);

void etpan_app_free(struct etpan_app * app);

void etpan_app_log(struct etpan_app * app, char * format, ...);

void etpan_app_debug_file(struct etpan_app * app, char * format, ...);

#define ETPAN_APP_LOG(args) (etpan_app_log args)

#ifdef DEBUG_ETPAN_APP
#define ETPAN_APP_DEBUG_FILE(args) (etpan_app_debug_file args)
#define ETPAN_APP_DEBUG(args) (etpan_app_log args)
#else
#define ETPAN_APP_DEBUG_FILE(args) do { } while (0)
#define ETPAN_APP_DEBUG(args) do { } while (0)
#endif

void etpan_app_set_console(struct etpan_app * app,
    struct etpan_subapp * console);

#endif
