/*
 * etPan! -- a mail user agent
 *
 * Copyright (C) 2001, 2002 - DINH Viet Hoa
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the libEtPan! project nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * $Id: etpan-tools.h,v 1.12 2004/12/16 15:54:15 hoa Exp $
 */

#ifndef ETPAN_TOOLS_H

#define ETPAN_TOOLS_H

#include <libetpan/libetpan.h>

#include "etpan-cfg-account.h"
#include "etpan-cfg-mime.h"
#include "etpan-cfg-vfolder.h"
#include "etpan-app.h"
#include <pthread.h>
#include <stdio.h>
#include <inttypes.h>

int etpan_get_tmp_name(char * filename, size_t size);

int etpan_write_data(char * filename, char * data, size_t len);

int etpan_quote_filename(char * result, size_t size, char * path);

int etpan_regexp_match(char * regexp, const char * str);

void etpan_resize_term(int * row, int * col);

FILE * etpan_get_tmp_file(char * filename, size_t size);

FILE * etpan_get_mime_tmp_file(char * filename, size_t size);

struct mailfolder *
etpan_get_folder(struct etpan_app * app, char * folder_name);

char * etpan_get_folder_name(struct etpan_app * app,
    struct mailfolder * folder);

void etpan_strip_string(char * str);

char * etpan_dup_file(char * source_filename);

char * etpan_encode_base64(const char * in, int len);

char * etpan_decode_base64(const char * in, int len);

int etpan_mkdir(char * path);

char * etpan_quote_mailbox(char * mb);

char * etpan_get_home_dir(void);

int etpan_privacy_encrypt_next(struct mailprivacy * privacy,
    char * privacy_driver, char * privacy_encryption,
    char ** pprivacy_driver, char ** pprivacy_encryption,
    int direction);

int etpan_prepare_file_for_edition(char * source_filename);

#endif
