# -*- coding: utf-8 -*-

# Copyright (c) 2006 - 2008 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing the Tasks configuration page.
"""

from PyQt4.QtCore import pyqtSignature
from PyQt4.QtGui import QPixmap, QIcon

from KdeQt import KQColorDialog

from ConfigurationPageBase import ConfigurationPageBase
from Ui_TasksPage import Ui_TasksPage

import Preferences

class TasksPage(ConfigurationPageBase, Ui_TasksPage):
    """
    Class implementing the Tasks configuration page.
    """
    def __init__(self):
        """
        Constructor
        """
        ConfigurationPageBase.__init__(self)
        self.setupUi(self)
        self.setObjectName("TasksPage")
        
        self.tasksColours = {}
        
        # set initial values
        self.tasksMarkerEdit.setText(Preferences.getTasks("TasksMarkers"))
        self.tasksMarkerBugfixEdit.setText(\
            Preferences.getTasks("TasksMarkersBugfix"))
        
        self.tasksColours["TasksColour"] = \
            Preferences.getTasks("TasksColour")
        size = self.tasksColourButton.size()
        pm = QPixmap(size.width()/2, size.height()/2)
        pm.fill(self.tasksColours["TasksColour"])
        self.tasksColourButton.setIconSize(pm.size())
        self.tasksColourButton.setIcon(QIcon(pm))
        
        self.tasksColours["TasksBugfixColour"] = \
            Preferences.getTasks("TasksBugfixColour")
        size = self.tasksBugfixColourButton.size()
        pm = QPixmap(size.width()/2, size.height()/2)
        pm.fill(self.tasksColours["TasksBugfixColour"])
        self.tasksBugfixColourButton.setIconSize(pm.size())
        self.tasksBugfixColourButton.setIcon(QIcon(pm))
        
        self.tasksColours["TasksBgColour"] = \
            Preferences.getTasks("TasksBgColour")
        size = self.tasksBgColourButton.size()
        pm = QPixmap(size.width()/2, size.height()/2)
        pm.fill(self.tasksColours["TasksBgColour"])
        self.tasksBgColourButton.setIconSize(pm.size())
        self.tasksBgColourButton.setIcon(QIcon(pm))
        
        self.tasksColours["TasksProjectBgColour"] = \
            Preferences.getTasks("TasksProjectBgColour")
        size = self.tasksProjectBgColourButton.size()
        pm = QPixmap(size.width()/2, size.height()/2)
        pm.fill(self.tasksColours["TasksProjectBgColour"])
        self.tasksProjectBgColourButton.setIconSize(pm.size())
        self.tasksProjectBgColourButton.setIcon(QIcon(pm))
        
    def save(self):
        """
        Public slot to save the Tasks configuration.
        """
        Preferences.setTasks("TasksMarkers", self.tasksMarkerEdit.text())
        Preferences.setTasks("TasksMarkersBugfix",
            self.tasksMarkerBugfixEdit.text())
        for key in self.tasksColours.keys():
            Preferences.setTasks(key, self.tasksColours[key])
        
    def __selectTasksColour(self, colourstr, button):
        """
        Private method used by the buttons selecting the tasks colours.
        
        @param colourstr Colour to be set. (string)
        @param button Reference to a QButton to show the colour on.
        """
        colour = KQColorDialog.getColor(self.tasksColours[colourstr])
        if colour.isValid():
            self.tasksColours[colourstr] = colour
            size = button.iconSize()
            pm = QPixmap(size.width(), size.height())
            pm.fill(colour)
            button.setIcon(QIcon(pm))
        
    @pyqtSignature("")
    def on_tasksColourButton_clicked(self):
        """
        Private slot to set the colour for standard tasks.
        """
        self.__selectTasksColour("TasksColour", 
            self.tasksColourButton)
        
    @pyqtSignature("")
    def on_tasksBugfixColourButton_clicked(self):
        """
        Private slot to set the colour for bugfix tasks.
        """
        self.__selectTasksColour("TasksBugfixColour", 
            self.tasksBugfixColourButton)
        
    @pyqtSignature("")
    def on_tasksBgColourButton_clicked(self):
        """
        Private slot to set the background colour for global tasks.
        """
        self.__selectTasksColour("TasksBgColour", 
            self.tasksBgColourButton)
        
    @pyqtSignature("")
    def on_tasksProjectBgColourButton_clicked(self):
        """
        Private slot to set the backgroundcolour for project tasks.
        """
        self.__selectTasksColour("TasksProjectBgColour", 
            self.tasksProjectBgColourButton)
    
def create(dlg):
    """
    Module function to create the configuration page.
    
    @param dlg reference to the configuration dialog
    """
    page = TasksPage()
    return page
