# -*- coding: utf-8 -*-

# Copyright (c) 2004 - 2006 Detlev Offenbach <detlev@die-offenbachs.de>
#

"""
Module implementing an icon provider for QFileDialog.
"""

from qt import QFileIconProvider, QPixmap, QFileDialog

import UI.PixmapCache

class IconProvider(QFileIconProvider):
    """
    Class providing icons to QFileDialog.

    The icons provided are for Python (*.py, *.pyx, *.ptl)), Qt-Designer (*.ui),
    QT-Linguist (*.ts), IDL (*.idl), graphics, eric3 keyboard shortcuts (*.e3k, *.e3kz), 
    and eric3 project (*.e3p, *.e3pz) files.
    """
    def __init__(self):
        """
        Constructor
        """
        QFileIconProvider.__init__(self)
        
        # generate file icons for later use
        self.iconFilePython = UI.PixmapCache.getPixmap("filePython.png")
        self.iconFilePython2 = UI.PixmapCache.getPixmap("filePython2.png")
        self.iconFileRuby = UI.PixmapCache.getPixmap("fileRuby.png")
        self.iconFileDesigner = UI.PixmapCache.getPixmap("fileDesigner.png")
        self.iconFileLinguist = UI.PixmapCache.getPixmap("fileLinguist.png")
        self.iconFileProject = UI.PixmapCache.getPixmap("fileProject.png")
        self.iconFileIDL = UI.PixmapCache.getPixmap("fileIDL.png")
        self.iconFilePixmap = UI.PixmapCache.getPixmap("filePixmap.png")
        self.iconFileShortcuts = UI.PixmapCache.getPixmap("fileShortcuts.png")

    def pixmap(self,finfo):
        """
        Method to retrieve the pixmap for a file.
        
        @param finfo The file info object. (QFileInfo)
        @return The pixmap for the file. (QPixmap)
        """
        ext = unicode(finfo.extension())
        if ext == 'py':
            pm = self.iconFilePython
        elif ext in ['pyx', 'ptl']:
            pm = self.iconFilePython2
        elif ext == 'rb':
            pm = self.iconFileRuby
        elif ext == 'ui':
            pm = self.iconFileDesigner
        elif ext in ['ts', 'qm']:
            pm = self.iconFileLinguist
        elif ext in ['e3p', 'e3pz']:
            pm = self.iconFileProject
        elif ext == 'idl':
            pm = self.iconFileIDL
        elif ext in ['png', 'jpg', 'xpm', 'bmp', 'xbm', 'pnm', 'pbm',
                     'pgm', 'ppm', 'gif', 'mng']:
            pm = self.iconFilePixmap
        elif ext in ['e3k', 'e3kz']:
            pm = self.iconFileShortcuts
        else:
            pm = None

        return pm
