#!/usr/bin/env entity

<object default-lang="javascript">
  <window name="main" title="Gtk GL Area Test" ondelete="entity:exit" width="400" height="300">
    <button label="add" onclick="add_buttons"/>
    <button label="remove" onclick="remove_buttons"/>
    <valign name="main" expand="true" height="300">
      <glarea expand="true" name="main">
        <glut-text x="40" y="70" color="#335566" text="Hello World"/>
        <gl-point x="10" y="15" color="#ffaa00"/>
        <gl-point x="10" y="45" color="#ffaa00"/>
        <gl-point name="2" x="30" y="15" color="#00ffaa"/>
        <gl-line name="line" width="6" x1="50" y1="0" x2="0" y2="99" color="#0099ff"
	 xdirection="1"/>
	
	<gl-matrix rotate-angle="0" rotate-x="0" rotate-y="0" rotate-z="1.0"
	           translate-x="50" translate-y="50" translate-z="0">
	    <gl-line width="2" x1="-20" y1="-15" x2="20" y2="-15" color="#ffffff"/>
	    <gl-line width="2" x1="20" y1="-15" x2="20" y2="15" color="#ffffff"/>
	    <gl-line width="2" x1="20" y1="15" x2="-20" y2="15" color="#ffffff"/>
    	    <gl-line width="2" x1="-20" y1="15" x2="-20" y2="-15" color="#ffffff"/>
        </gl-matrix>
	 
      </glarea>
    </valign>
    <timer interval="5" action="update_gl"/>
    <?javascript

    function update_gl (node)
    {
	gl = enode ("gl-point");
	gl.attribval.x--;

	if (parseInt (gl.attribval.x) < 1) {
	    gl.attribval.x = "100";
	}

	line = enode ("gl-line.line");
	line.attribval.x2 += line.attribval.xdirection;

	matrix = enode ("gl-matrix");
	matrix.attribval["rotate-angle"]+=5;
	if (matrix.attribval["rotate-angle"] >= 360)
	    matrix.attribval["rotate-angle"] = 0;

	if (line.attribval.x2 > 100) {
	    line.attribval.xdirection = -1;
	}

	if (line.attribval.x2 < 1) {
	    line.attribval.xdirection = 1;
	}

	enode ("glarea.main").attrib.redraw = "true";
    }
    ?>
	
  </window>
</object>
