#include <gtk/gtk.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static gint
rendgtk_progress_value_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *progress;
    gfloat opt;

    progress = enode_get_kv (node, "top-widget");
    if (!progress)
	return (TRUE);

    opt = erend_get_percentage (value);

    EDEBUG (("progress-renderer", "Setting value in progress to %f\n",
	     opt));
    if (opt <= 1.0)
	gtk_progress_bar_update (GTK_PROGRESS_BAR (progress), opt);

    while (gtk_events_pending ())
	gtk_main_iteration ();

    return (TRUE);
}

static gint
rendgtk_progress_steps_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *progress;
    progress = enode_get_kv (node, "top-widget");
    if (!progress)
	return (TRUE);

    gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (progress),
				    GTK_PROGRESS_DISCRETE);
    gtk_progress_bar_set_activity_step (GTK_PROGRESS_BAR (progress),
					erend_get_integer (value));

    return (TRUE);
}

static gint
rendgtk_progress_blocks_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *progress;
    progress = enode_get_kv (node, "top-widget");
    if (!progress)
	return (TRUE);


    gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (progress),
				    GTK_PROGRESS_DISCRETE);
    gtk_progress_bar_set_discrete_blocks (GTK_PROGRESS_BAR (progress),
					  erend_get_integer (value));
    /* Wonder what this does...I'll set it for now and hope it does * what
     * people want.  MW */
    gtk_progress_bar_set_activity_blocks (GTK_PROGRESS_BAR (progress),
					  erend_get_integer (value));
    return (TRUE);
}

static gint
rendgtk_progress_activity_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *progress;
    gfloat new_val;
    GtkAdjustment *adj;

    progress = enode_get_kv (node, "top-widget");
    if (!progress)
	return (TRUE);

    gtk_progress_set_activity_mode (GTK_PROGRESS (progress),
				    erend_value_is_true (value));
    
    adj = GTK_PROGRESS (progress)->adjustment;

    new_val = adj->value + 1;
    if (new_val > adj->upper)
	new_val = adj->lower;

    gtk_progress_set_value (GTK_PROGRESS (progress), new_val);

    EDEBUG (("progress-renderer", "in progress bar activity setting, checking for gtk events"));

    while (gtk_events_pending ())
	gtk_main_iteration ();

    return (TRUE);
}

static gint
rendgtk_progress_showtext_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *progress;

    progress = enode_get_kv (node, "top-widget");
    if (progress)
	gtk_progress_set_show_text (GTK_PROGRESS (progress),
				    erend_value_is_true (value));
    return (TRUE);
}

static void
rendgtk_progress_render (ENode * node)
{
    GtkWidget *progress;
    GtkProgressBarOrientation orient;

    progress = gtk_progress_bar_new ();

    orient = GTK_PROGRESS_LEFT_TO_RIGHT;
    gtk_progress_bar_set_orientation (GTK_PROGRESS_BAR (progress), orient);
    gtk_progress_bar_set_bar_style (GTK_PROGRESS_BAR (progress),
				    GTK_PROGRESS_CONTINUOUS);

    enode_set_kv (node, "top-widget", progress);
    enode_set_kv (node, "bottom-widget", progress);

    enode_attribs_sync (node);
    rendgtk_show_cond (node, progress);
}

void
progress_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    element = g_new0 (Element, 1);

    element->render_func = rendgtk_progress_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "progress";
    element->description =
	"Create a new progress widget to display activity of a process.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_PROGRESS_BAR);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "show-text";
    e_attr->description = "If the text of the percentage is to be shown";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_progress_showtext_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "value";
    e_attr->description =
	"What percentage of the way done the meter should read.";
    e_attr->value_desc = "percentage";
    e_attr->set_attr_func = rendgtk_progress_value_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "steps";
    e_attr->description = "I really don't know what this does. [MW]";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_progress_steps_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "blocks";
    e_attr->description = "The number of blocks to cut the meter into.";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_progress_blocks_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "activity";
    e_attr->description = "If set the meter bounces back and forth.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_progress_activity_attr_set;
    element_register_attrib (element, e_attr);
}



