#include <gtk/gtk.h>
#include <stdio.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


/* We only build image support if we have IMLIB, and * GDK_PIXBUF isn't
 * available */

#ifdef USE_IMLIB
#ifndef USE_GDK_PIXBUF

#include <gdk_imlib.h>

#define RENDIMAGE_VER "0.1"
#define RENDIMAGE_NAME "GDK_IMLIB"

/* These should probly be jacked up a bit more.. */
#define MAX_IMAGE_WIDTH 1024
#define MAX_IMAGE_HEIGHT 768

/*************************************************************************
 * GDK IMLIB IMAGE LOADER 						 *
 *************************************************************************/

static GtkWidget *
rendgtk_load_image (ENode * node, gchar * filename, gint width, gint height)
{
    GdkImlibImage *img;
    GtkWidget *pw;
    GdkBitmap *mask = NULL;
    GdkPixmap *pixmap = NULL;
    gchar *realfile;
    char s_height[255];
    char s_width[255];

    realfile = eutils_file_search (node, filename);

    if (!realfile) {
	/* FIXME: Should use onerror handler */
	g_warning ("Unable to locate file '%s'", filename);
	return (NULL);
    }

    img = gdk_imlib_load_image (realfile);

    if (!img)
	return (NULL);

    if (width < 0)
	width = img->rgb_width;

    if (height < 0)
	height = img->rgb_height;


    gdk_imlib_render (img, width, height);

    pixmap = gdk_imlib_move_image (img);
    mask = gdk_imlib_move_mask (img);

    pw = gtk_pixmap_new (pixmap, mask);

    gdk_imlib_kill_image (img);
    gdk_imlib_free_pixmap (pixmap);
    /* need to free mask ? */

    /* Set the node attribs */
    sprintf (s_height, "%d", height);
    sprintf (s_width, "%d", width);
    enode_attrib_str (node, "width", s_width);
    enode_attrib_str (node, "height", s_height);

    g_free (realfile);
    return (pw);
}


static gint
rendgtk_image_idle_load (gpointer user_data)
{
    ENode *node = user_data;
    EBuf *value;
    GtkWidget *image;
    gint width;
    gint height;
    EBuf *val;

    value = enode_attrib (node, "src", NULL);

    val = enode_attrib (node, "width", NULL);
    if (ebuf_not_empty (val))
	width = erend_get_integer (val);
    else
	width = -1;

    val = enode_attrib (node, "height", NULL);
    if (ebuf_not_empty (val))
	height = erend_get_integer (val);
    else
	height = -1;

    image = rendgtk_load_image (node, value->str, width, height);

    if (image) {
	ENode *parent = NULL;
	GtkWidget *widget = NULL;
	GtkWidget *old_image;

	old_image = enode_get_kv (node, "rendgtk-image-widget");
	if (old_image)
	    gtk_widget_destroy (GTK_WIDGET (old_image));

	parent = enode_parent (node, NULL);
	if (!parent)
	    return (FALSE);

	widget = enode_get_kv (parent, "bottom-widget");

	gtk_container_add (GTK_CONTAINER (widget), image);
	rendgtk_show_cond (node, image);
	enode_set_kv (node, "rendgtk-image-widget", image);
	enode_set_kv (node, "top-widget", image);

	EDEBUG (("image-renderer", "image '%s' loaded", value->str));
    } else {
	EDEBUG (("image-renderer", "failed to load '%s'", value->str));
    }

    return (FALSE);
}

static gint
rendgtk_image_src_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    gtk_idle_add (rendgtk_image_idle_load, node);
    return (TRUE);
}

static gint
rendgtk_image_width_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    return (TRUE);
}


static gint
rendgtk_image_height_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    return (TRUE);
}

void
rendgtk_image_render (ENode * node)
{
    static gint initialized = FALSE;

    enode_attrib_str (node, "_renderer-version", RENDIMAGE_VER);
    enode_attrib_str (node, "_renderer-name", RENDIMAGE_NAME);

    if (!initialized) {
	gdk_imlib_init ();
	initialized = TRUE;
    }

    enode_attribs_sync (node);
}

#endif				/* USE_IMLIB */
#endif				/* ! USE_GDK_PIXBUF */

#ifndef USE_IMLIB
#ifndef USE_GDK_PIXBUF

/*************************************************************************
 * STRAIGHT PIXMAP LOADER 						 *
 *************************************************************************/

#define RENDIMAGE_VER "0.1"
#define RENDIMAGE_NAME "XPM"

static GtkWidget *
rendgtk_load_xpm_image (ENode * node, gchar * filename, GdkWindow * window,
			GdkColor * background)
{
    GtkWidget *wpixmap;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    gchar *realfile;

    realfile = eutils_file_search (node, filename);

    if (!realfile) {
	/* FIXME: Should use onerror handler */
	g_warning ("Unable to locate file '%s'", filename);
	return (NULL);
    }

    EDEBUG (
	    ("image-renderer", "attempting to load real imagefile '%s'",
	     realfile));

    pixmap = gdk_pixmap_create_from_xpm (window, &mask, background, realfile);
    wpixmap = gtk_pixmap_new (pixmap, mask);

    g_free (realfile);
    return (wpixmap);
}

static gint
rendgtk_image_idle_load (gpointer user_data)
{
    ENode *node = user_data;
    ENode *parent;
    GtkWidget *image;
    static GtkWidget *widget = NULL;
    EBuf *value;

    value = enode_attrib (node, "src", NULL);

    /* to make life easier, this is the only place that the image is actually
     * loaded */

    EDEBUG (("image-renderer", "attempting to load image '%s'", value->str));

    parent = enode_parent (node, NULL);
    widget = enode_get_kv (parent, "bottom-widget");

    /* I'm an evil, cruel, mean bastard.  We create a window that never gets
     * shown so we don't have to * mess with gdk window/style crap */
    if (!widget) {
	widget = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize (widget);
    } else {
	EDEBUG (
		("image-renderer",
		 "Using parent gdk window for style guidelines.."));
	gtk_widget_realize (widget);
    }

    image =
	rendgtk_load_xpm_image (node, value->str, widget->window,
				&widget->style->bg[GTK_STATE_NORMAL]);
    EDEBUG (("image-renderer", "image returned - %p", image));

    if (image) {
	GtkWidget *old_image;
	old_image = enode_get_kv (node, "rendgtk-image-widget");
	if (old_image)
	    gtk_widget_destroy (GTK_WIDGET (old_image));

	gtk_container_add (GTK_CONTAINER (widget), image);
	rendgtk_show_cond (node, image);

	enode_set_kv (node, "top-widget", image);
	enode_set_kv (node, "rendgtk-image-widget", image);

	EDEBUG (("image-renderer", "image '%s' loaded", value->str));
    } else {
	EDEBUG (("image-renderer", "failed to load '%s'", value->str));
    }

    return (FALSE);
}


static gint
rendgtk_image_src_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    gtk_idle_add (rendgtk_image_idle_load, node);
    return (TRUE);
}

static gint
rendgtk_image_width_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    return (TRUE);
}

static gint
rendgtk_image_height_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    return (TRUE);
}

void
rendgtk_image_render (ENode * node)
{
    enode_attrib_str (node, "_renderer-version", RENDIMAGE_VER);
    enode_attrib_str (node, "_renderer-name", RENDIMAGE_NAME);

    EDEBUG (("image-renderer", "rendering image"));

    enode_attribs_sync (node);
}

#endif				/* USE_IMLIB */
#endif
#ifndef USE_GDK_PIXBUF

void
image_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

#ifdef USE_IMLIB
    EDEBUG (("image-renderer", "IMLIB Image renderer registering "));
#else
    EDEBUG (("image-renderer", "XPM Image renderer registering "));
#endif				/* USE_IMLIB */

    /* image */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_image_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = NULL;
    element->tag = "image";
    element->description = "Display an image from a file.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_EVENT_BOX);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "_renderer-version";
    e_attr->description = "Version number of the image renderer.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "_renderer-name";
    e_attr->description = "Name of the image renderer.";
    e_attr->value_desc = "string";
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "src";
    e_attr->description = "Set the location of the image file on disk.";
    e_attr->value_desc = "filename";
    e_attr->set_attr_func = rendgtk_image_src_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "width";
    e_attr->description = "Set the width of the image.";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_image_width_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "height";
    e_attr->description = "Set the height of the image.";
    e_attr->value_desc = "integer";
    e_attr->set_attr_func = rendgtk_image_height_attr_set;
    element_register_attrib (element, e_attr);
}
#endif				/* ! USE_GDK_PIXBUF */


