#!/usr/bin/env python
# -*- coding: utf-8 -*-

##############################################################################
# Copyright 2006, 2007, 2008, 2009 Jussi Ylänen
#
# This file is part of Ensymble developer utilities for Symbian OS(TM).
#
# Ensymble is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Ensymble is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Ensymble; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##############################################################################

"""
The Ensymble developer utilities for Symbian OS™ is a collection of Python®
modules and command line programs for Symbian OS software development.

Current focus of Ensymble development is to provide useful tools for making
Python for S60 (PyS60) programs. A long term goal of Ensymble is to provide a
cross-platform, open-source way to do Symbian OS software development,
supporting Symbian OS versions 9.1 and later.

SIS files made with Ensymble work from S60 3rd Edition phones onwards. For 1st
and 2nd Edition phones there's py2sisng.
"""
__version__ = '0.29'
__license__ = 'GPLv2'

__author__  = 'Jussi Ylänen'
__email__   = 'steve@lonetwin.net'
__maintainer__ = 'Steven Fernandez'

