#include "SDL_opengl.h"
#include "biosphere.h"


#include <iostream>

namespace models {

static GLuint biosphere_dl=0;

void biosphere::draw() {
	dldraw();
}
void biosphere::dldraw() {
	if (biosphere_dl==0) { sdraw(); return; }
	glCallList(biosphere_dl);
}

void biosphere::gen_dl() {
	biosphere_dl=glGenLists(1);
	glNewList(biosphere_dl,GL_COMPILE);
	sdraw();
	glEndList();
	std::cout << " loaded biosphere " << biosphere_dl << std::endl;
}
namespace mtl_biosphere {
typedef enum MTL {
m_basis,
m_glas,
m_streben,
m_last
};
} //namespace
void biosphere::material (int id) {
	switch (id) {
		case mtl_biosphere::m_basis:
static const GLfloat m_basis_diffuse[] = {0.526667,0.640360,0.646667};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_basis_diffuse);
static const GLfloat m_basis_ambient[] = {0.700000,0.860000,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_basis_ambient);
static const GLfloat m_basis_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_basis_emissive);
			break;
		case mtl_biosphere::m_glas:
static const GLfloat m_glas_diffuse[] = {0.406667,0.906667,1.00000};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_glas_diffuse);
static const GLfloat m_glas_ambient[] = {0.433333,0.806667,1.00000};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_glas_ambient);
static const GLfloat m_glas_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_glas_emissive);
			break;
		case mtl_biosphere::m_streben:
static const GLfloat m_streben_diffuse[] = {0.267400,0.267400,0.267400};
			glMaterialfv(GL_FRONT,GL_DIFFUSE, m_streben_diffuse);
static const GLfloat m_streben_ambient[] = {0.214120,0.214120,0.214120};
			glMaterialfv(GL_FRONT,GL_AMBIENT, m_streben_ambient);
static const GLfloat m_streben_emissive[] = {0.00000e+0,0.00000e+0,0.00000e+0};
			glMaterialfv(GL_FRONT,GL_EMISSION, m_streben_emissive);
			break;
	}
}
float biosphere::minx() { return -5.44721 ; }
float biosphere::miny() { return -0.0899513 ; }
float biosphere::minz() { return -5.49254 ; }
float biosphere::maxx() { return 5.4325; }
float biosphere::maxy() { return 4.95067; }
float biosphere::maxz() { return 5.38717; }
float biosphere::radius() { return 9.11278; }
void biosphere::sdraw() {
const float vertices[269][3]={
	{1.80956955,4.72993192,-5.2685917e-2},
	{1.63298701,4.56163584,0.62676543},
	{1.27740507,4.72993192,1.23207279},
	{0.67209771,4.56163584,1.58765474},
	{-7.3536392e-3,4.70993546,1.81251299},
	{-0.68680499,4.56163584,1.58765474},
	{-1.32624843,4.70993546,1.26620888},
	{-1.64769429,4.56163584,0.62676543},
	{-1.87255254,4.70993546,-5.2685917e-2},
	{-1.64769429,4.56163584,-0.73213726},
	{-1.32624843,4.70993546,-1.37158071},
	{-0.68680499,4.56163584,-1.69302657},
	{-7.3536392e-3,4.72993192,-1.86960910},
	{0.67209771,4.56163584,-1.69302657},
	{1.27740507,4.72993192,-1.33744462},
	{1.63298701,4.56163584,-0.73213726},
	{3.37600928,3.69553070,-5.2685917e-2},
	{3.02360067,3.55590045,1.20277647},
	{2.38504522,3.69553070,2.33971295},
	{1.24810874,3.55590045,2.97826840},
	{-7.3536392e-3,3.69553070,3.33067700},
	{-1.26281602,3.55590045,2.97826840},
	{-2.42587913,3.65858206,2.36583958},
	{-3.03830795,3.55590045,1.20277647},
	{-3.42766519,3.65858206,-5.2685917e-2},
	{-3.03830795,3.55590045,-1.30814830},
	{-2.42587913,3.65858206,-2.47121141},
	{-1.26281602,3.55590045,-3.08364023},
	{-7.3536392e-3,3.65858206,-3.47299747},
	{1.24810874,3.55590045,-3.08364023},
	{2.38504522,3.69553070,-2.44508478},
	{3.02360067,3.55590045,-1.30814830},
	{4.42736268,2.14041805,-5.2685917e-2},
	{3.95277901,2.05071107,1.58765474},
	{3.12846434,2.14041805,3.08313206},
	{1.63298701,2.05071107,3.90744674},
	{-7.3536392e-3,2.09214233,4.40202686},
	{-1.64769429,2.05071107,3.90744674},
	{-3.15731125,2.09214233,3.09727169},
	{-3.96748629,2.05071107,1.58765474},
	{-4.46206641,2.09214233,-5.2685917e-2},
	{-3.96748629,2.05071107,-1.69302657},
	{-3.15731125,2.09214233,-3.20264353},
	{-1.64769429,2.05071107,-4.01281857},
	{-7.3536392e-3,2.14041805,-4.48740223},
	{1.63298701,2.05071107,-4.01281857},
	{3.12846434,2.14041805,-3.18850390},
	{3.95277901,2.05071107,-1.69302657},
	{5.43249962,-8.8817842e-16,-4.4688261e-2},
	{4.65751695,-8.9951326e-2,1.95432152},
	{3.84485868,2.2204460e-16,3.78821601},
	{1.87203942,-8.9951326e-2,4.31152921},
	{6.4401606e-4,0.0000000e+0,5.38716734},
	{-2.01436108,-8.9951326e-2,4.61218467},
	{-3.84825557,-6.6613381e-16,3.79952640},
	{-4.72508384,-8.9951326e-2,1.82670714},
	{-5.44720689,-2.2204460e-16,-4.4688261e-2},
	{-4.72508384,-8.9951326e-2,-1.93207897},
	{-3.84825557,-6.6613381e-16,-3.90489824},
	{-2.01436108,-8.9951326e-2,-4.71755650},
	{6.4401606e-4,-1.1102230e-15,-5.49253917},
	{1.87203942,-8.9951326e-2,-4.77041611},
	{3.84485868,2.2204460e-16,-3.89358785},
	{4.65751695,-8.9951326e-2,-2.05969336},
	{-2.5412610e-2,4.95066647,-5.2685917e-2},
	{1.72308787,4.56163584,-0.27916970},
	{1.72308787,4.56163584,0.17379787},
	{1.37640150,4.56163584,1.01077279},
	{1.05610507,4.56163584,1.33106922},
	{0.21913014,4.56163584,1.67775559},
	{-0.23383742,4.56163584,1.67775559},
	{-1.07081234,4.56163584,1.33106922},
	{-1.39110878,4.56163584,1.01077279},
	{-1.73779514,4.56163584,0.17379787},
	{-1.73779514,4.56163584,-0.27916970},
	{-1.39110878,4.56163584,-1.11614462},
	{-1.07081234,4.56163584,-1.43644106},
	{-0.23383742,4.56163584,-1.78312742},
	{0.21913014,4.56163584,-1.78312742},
	{1.05610507,4.56163584,-1.43644106},
	{1.37640150,4.56163584,-1.11614462},
	{3.22827724,3.55590045,0.17379787},
	{3.22827724,3.55590045,-0.27916970},
	{2.12043468,3.55590045,2.39539884},
	{2.44073112,3.55590045,2.07510240},
	{-0.23383742,3.55590045,3.18294497},
	{0.21913014,3.55590045,3.18294497},
	{-2.45543840,3.55590045,2.07510240},
	{-2.13514196,3.55590045,2.39539884},
	{-3.24298452,3.55590045,-0.27916970},
	{-3.24298452,3.55590045,0.17379787},
	{-2.13514196,3.55590045,-2.50077067},
	{-2.45543840,3.55590045,-2.18047424},
	{0.21913014,3.55590045,-3.28831680},
	{-0.23383742,3.55590045,-3.28831680},
	{2.44073112,3.55590045,-2.18047424},
	{2.12043468,3.55590045,-2.50077067},
	{4.23401263,2.05071107,0.17379787},
	{4.23401263,2.05071107,-0.27916970},
	{2.83159699,2.05071107,3.10656115},
	{3.15189343,2.05071107,2.78626472},
	{-0.23383742,2.05071107,4.18868036},
	{0.21913014,2.05071107,4.18868036},
	{-3.16660071,2.05071107,2.78626472},
	{-2.84630427,2.05071107,3.10656115},
	{-4.24871991,2.05071107,-0.27916970},
	{-4.24871991,2.05071107,0.17379787},
	{-2.84630427,2.05071107,-3.21193299},
	{-3.16660071,2.05071107,-2.89163655},
	{0.21913014,2.05071107,-4.29405219},
	{-0.23383742,2.05071107,-4.29405219},
	{3.15189343,2.05071107,-2.89163655},
	{2.83159699,2.05071107,-3.21193299},
	{4.95093919,-7.5704868e-2,0.44690853},
	{4.95093919,-7.5704868e-2,-0.55228037},
	{3.14542222,-7.5704868e-2,3.80662319},
	{3.78895055,-8.9951326e-2,3.25422300},
	{-0.50694809,-7.5704868e-2,4.90560692},
	{0.33870108,-8.9951326e-2,4.61652916},
	{-3.86666275,-7.5704868e-2,3.10008995},
	{-3.31426255,-8.9951326e-2,3.74361828},
	{-5.03008379,-8.9951326e-2,-0.39874064},
	{-5.03008379,-8.9951326e-2,0.29336880},
	{-3.31426255,-8.9951326e-2,-3.84899011},
	{-3.86666275,-7.5704868e-2,-3.20546178},
	{0.33870108,-8.9951326e-2,-5.07541607},
	{-0.50694809,-7.5704868e-2,-5.01097875},
	{3.78895055,-8.9951326e-2,-3.35959483},
	{3.14542222,-7.5704868e-2,-3.91199503},
	{7.9317952e-2,4.86975272,-0.26192965},
	{-9.4025230e-2,4.86975272,-0.26192965},
	{-0.21659737,4.86975272,-0.13935751},
	{-0.21659737,4.86975272,3.3985674e-2},
	{-9.4025230e-2,4.86975272,0.15655781},
	{7.9317952e-2,4.86975272,0.15655781},
	{0.20189009,4.86975272,3.3985674e-2},
	{0.20189009,4.86975272,-0.13935751},
	{4.78580642,0.41231481,-5.2685917e-2},
	{4.34018916,0.42725035,1.76324857},
	{3.38192234,0.41231481,3.33659007},
	{1.78276377,0.42725035,4.30555066},
	{-7.3536392e-3,0.41231481,4.74047414},
	{-1.82328812,0.42725035,4.29485688},
	{-3.39662962,0.41231481,3.33659007},
	{-4.36559022,0.42725035,1.73743149},
	{-4.80051370,0.41231481,-5.2685917e-2},
	{-4.36559022,0.42725035,-1.84280332},
	{-3.39662962,0.41231481,-3.44196190},
	{-1.82328812,0.42725035,-4.40022871},
	{-7.3536392e-3,0.41231481,-4.84584598},
	{1.78276377,0.42725035,-4.41092250},
	{3.38192234,0.41231481,-3.44196190},
	{4.34018916,0.42725035,-1.86862040},
	{4.65890184,0.42604231,0.19214096},
	{4.58717994,0.27521914,6.9126712e-2},
	{4.58717994,0.27521914,-0.17449855},
	{4.65890184,0.42604231,-0.29751280},
	{3.11906851,0.42604231,3.41997372},
	{3.15533767,0.27521914,3.28227447},
	{3.32760674,0.27521914,3.11000539},
	{3.46477476,0.42725035,3.07339880},
	{-0.25218052,0.42604231,4.61356956},
	{-0.12916627,0.27521914,4.54184766},
	{0.11445899,0.27521914,4.54184766},
	{0.23733619,0.42725035,4.61295532},
	{-3.48001328,0.42604231,3.07373623},
	{-3.34231402,0.27521914,3.11000539},
	{-3.17004495,0.27521914,3.28227447},
	{-3.13343836,0.42725035,3.41944248},
	{-4.67299488,0.42725035,-0.29737575},
	{-4.60188721,0.27521914,-0.17449855},
	{-4.60188721,0.27521914,6.9126712e-2},
	{-4.67299488,0.42725035,0.19200392},
	{-3.13343836,0.42725035,-3.52481431},
	{-3.17004495,0.27521914,-3.38764630},
	{-3.34231402,0.27521914,-3.21537723},
	{-3.48001328,0.42604231,-3.17910806},
	{0.23733619,0.42725035,-4.71832715},
	{0.11445899,0.27521914,-4.64721949},
	{-0.12916627,0.27521914,-4.64721949},
	{-0.25218052,0.42604231,-4.71894139},
	{3.46477476,0.42725035,-3.17877064},
	{3.32760674,0.27521914,-3.21537723},
	{3.15533767,0.27521914,-3.38764630},
	{3.11906851,0.42604231,-3.52534555},
	{4.65868567,0.28646037,-5.2685917e-2},
	{-3.30674168,0.28646037,-3.35207395},
	{3.29203440,0.28646037,3.24670212},
	{3.29203440,0.28646037,-3.35207395},
	{-4.67339295,0.28646037,-5.2685917e-2},
	{4.18046499,0.27521914,1.68196536},
	{-7.3536392e-3,0.28646037,4.61335339},
	{-7.3536392e-3,0.28646037,-4.71872523},
	{-3.30674168,0.28646037,3.24670212},
	{-1.74200491,0.27521914,-4.24050454},
	{4.18046499,0.27521914,-1.78733719},
	{-4.19517227,0.27521914,1.68196536},
	{1.72729763,0.27521914,4.13513271},
	{-4.19517227,0.27521914,-1.78733719},
	{-1.74200491,0.27521914,4.13513271},
	{1.72729763,0.27521914,-4.24050454},
	{4.24115432,0.48150158,1.70710370},
	{4.32391657,0.30285163,1.75337361},
	{1.75243598,0.48150158,4.19582204},
	{1.77823996,0.30285163,4.28706155},
	{-1.76714325,0.48150158,4.19582204},
	{-1.81341316,0.30285163,4.27858429},
	{-4.25586159,0.48150158,1.70710370},
	{-4.34710111,0.30285163,1.73290768},
	{-4.25586159,0.48150158,-1.81247553},
	{-4.34710111,0.30285163,-1.83827952},
	{-1.76714325,0.48150158,-4.30119387},
	{-1.81341316,0.30285163,-4.38395613},
	{1.75243598,0.48150158,-4.30119387},
	{1.77823996,0.30285163,-4.39243339},
	{4.24115432,0.48150158,-1.81247553},
	{4.32391657,0.30285163,-1.85874544},
	{4.54614781,0.48150158,0.17379787},
	{4.63977521,0.38935765,9.8303271e-2},
	{4.62880824,0.30462097,0.21790782},
	{4.54614781,0.48150158,-0.27916970},
	{4.63977521,0.38935765,-0.20367510},
	{4.62880824,0.30462097,-0.32327965},
	{3.05230989,0.48150158,3.32727405},
	{3.17189721,0.38935765,3.34009589},
	{3.07956920,0.30462097,3.41691426},
	{3.37260633,0.48150158,3.00697762},
	{3.38542816,0.38935765,3.12656493},
	{3.45158352,0.30288725,3.05884877},
	{-0.23383742,0.48150158,4.50081553},
	{-0.15834283,0.38935765,4.59444293},
	{-0.27794738,0.30462097,4.58347597},
	{0.21913014,0.48150158,4.50081553},
	{0.14363555,0.38935765,4.59444293},
	{0.23829701,0.30288725,4.59333928},
	{-3.38731361,0.48150158,3.00697762},
	{-3.40013544,0.38935765,3.12656493},
	{-3.47695381,0.30462097,3.03423692},
	{-3.06701717,0.48150158,3.32727405},
	{-3.18660448,0.38935765,3.34009589},
	{-3.11888832,0.30288725,3.40625124},
	{-4.56085509,0.48150158,-0.27916970},
	{-4.65448249,0.38935765,-0.20367510},
	{-4.65337884,0.30288725,-0.29833656},
	{-4.56085509,0.48150158,0.17379787},
	{-4.65448249,0.38935765,9.8303271e-2},
	{-4.65337884,0.30288725,0.19296473},
	{-3.06701717,0.48150158,-3.43264589},
	{-3.18660448,0.38935765,-3.44546772},
	{-3.11888832,0.30288725,-3.51162308},
	{-3.38731361,0.48150158,-3.11234945},
	{-3.40013544,0.38935765,-3.23193676},
	{-3.47695381,0.30462097,-3.13960876},
	{0.21913014,0.48150158,-4.60618736},
	{0.14363555,0.38935765,-4.69981477},
	{0.23829701,0.30288725,-4.69871111},
	{-0.23383742,0.48150158,-4.60618736},
	{-0.15834283,0.38935765,-4.69981477},
	{-0.27794738,0.30462097,-4.68884780},
	{3.37260633,0.48150158,-3.11234945},
	{3.38542816,0.38935765,-3.23193676},
	{3.45158352,0.30288725,-3.16422060},
	{3.05230989,0.48150158,-3.43264589},
	{3.17189721,0.38935765,-3.44546772},
	{3.07956920,0.30462097,-3.52228609},
	{1.20577965,0.25158870,4.56952197},
	{0.89335190,0.25162578,4.63166042},
	{0.90839990,-5.0410500e-2,4.68811887},
	{1.21983734,-5.0410500e-2,4.62617011},
};
const float normals[269][3]={
	{0.34233909,0.93957647,-3.6368602e-17},
	{0.35310199,0.92408176,0.14625963},
	{0.23515976,0.93944178,0.24929708},
	{0.14625963,0.92408176,0.35310199},
	{-1.4238526e-2,0.93903472,0.34352738},
	{-0.14625963,0.92408176,0.35310199},
	{-0.25197166,0.93807313,0.23775846},
	{-0.35310199,0.92408176,0.14625963},
	{-0.34640037,0.93808677,7.2188515e-17},
	{-0.35310199,0.92408176,-0.14625963},
	{-0.25197166,0.93807313,-0.23775846},
	{-0.14625963,0.92408176,-0.35310199},
	{-1.4112030e-2,0.93831432,-0.34549543},
	{0.14625963,0.92408176,-0.35310199},
	{0.23515976,0.93944178,-0.24929708},
	{0.35310199,0.92408176,-0.14625963},
	{0.70322248,0.71096986,-1.5076578e-16},
	{0.65279895,0.70762868,0.27039818},
	{0.49725339,0.71096986,0.49725339},
	{0.27039818,0.70762868,0.65279895},
	{3.7695328e-17,0.70745092,0.70676248},
	{-0.27039818,0.70762868,0.65279895},
	{-0.50003277,0.70706043,0.50003277},
	{-0.65279895,0.70762868,0.27039818},
	{-0.70715313,0.70706043,-3.7705727e-17},
	{-0.65279895,0.70762868,-0.27039818},
	{-0.50003277,0.70706043,-0.50003277},
	{-0.27039818,0.70762868,-0.65279895},
	{-3.0149437e-16,0.71057932,-0.70361711},
	{0.27039818,0.70762868,-0.65279895},
	{0.49725339,0.71096986,-0.49725339},
	{0.65279895,0.70762868,-0.27039818},
	{0.92179524,0.38767710,-3.8579524e-17},
	{0.85337100,0.38315969,0.35347784},
	{0.65180767,0.38767710,0.65180767},
	{0.35347784,0.38315969,0.85337100},
	{1.5429102e-16,0.38708564,0.92204377},
	{-0.35347784,0.38315969,0.85337100},
	{-0.65267728,0.38473983,0.65267728},
	{-0.85337100,0.38315969,0.35347784},
	{-0.92302506,0.38473983,-1.1636580e-16},
	{-0.85337100,0.38315969,-0.35347784},
	{-0.65267728,0.38473983,-0.65267728},
	{-0.35347784,0.38315969,-0.85337100},
	{-4.2666084e-16,0.38537242,-0.92276113},
	{0.35347784,0.38315969,-0.85337100},
	{0.65180767,0.38767710,-0.65180767},
	{0.85337100,0.38315969,-0.35347784},
	{0.64710475,-0.76240110,-1.1464151e-4},
	{0.68579255,-0.67276949,0.27761448},
	{0.41291347,-0.78638891,0.45945070},
	{0.23885848,-0.94610571,0.21870210},
	{-9.3368325e-2,-0.82109395,0.56310485},
	{-0.27761448,-0.67276949,0.68579255},
	{-0.45945070,-0.78638891,0.41291347},
	{-0.68123164,-0.67276949,0.28862548},
	{-0.58705089,-0.80954550,-2.7083593e-3},
	{-0.68123164,-0.67276949,-0.28862548},
	{-0.45945070,-0.78638891,-0.41291347},
	{-0.27761448,-0.67276949,-0.68579255},
	{-3.2906789e-2,-0.78638891,-0.61685462},
	{0.28862548,-0.67276949,-0.68123164},
	{0.41291347,-0.78638891,-0.45945070},
	{0.68579255,-0.67276949,-0.27761448},
	{-1.6073427e-2,0.99987022,1.0874743e-3},
	{0.33883572,0.86481060,-0.37053066},
	{0.33883572,0.86481060,0.37053066},
	{0.49851930,0.86665360,-1.9749714e-2},
	{-2.5615594e-2,0.86254695,0.50532821},
	{0.36121605,0.86855144,0.33932488},
	{-0.37389869,0.86285835,0.34011061},
	{1.4229617e-2,0.86807790,0.49622402},
	{-0.50298935,0.86405690,-2.0183693e-2},
	{-0.34111665,0.86597632,0.36568353},
	{-0.34111665,0.86597632,-0.36568353},
	{-0.50298935,0.86405690,2.0183693e-2},
	{1.4229617e-2,0.86807790,-0.49622402},
	{-0.37515891,0.86202665,-0.34083110},
	{0.36244422,0.86783088,-0.33985843},
	{-2.5615594e-2,0.86254695,-0.50532821},
	{0.49851930,0.86665360,1.9749714e-2},
	{0.63899076,0.64255648,0.42286166},
	{0.63899076,0.64255648,-0.42286166},
	{0.15282635,0.64255648,0.75084304},
	{0.75084304,0.64255648,0.15282635},
	{-0.42298990,0.64113723,0.64033006},
	{0.42298990,0.64113723,0.64033006},
	{-0.75202156,0.64096183,0.15372541},
	{-0.15372541,0.64096183,0.75202156},
	{-0.64045982,0.64096183,-0.42305927},
	{-0.64045982,0.64096183,0.42305927},
	{-0.15372541,0.64096183,-0.75202156},
	{-0.75202156,0.64096183,-0.15372541},
	{0.42261789,0.64248417,-0.63922470},
	{-0.42261789,0.64248417,-0.63922470},
	{0.75084304,0.64255648,-0.15282635},
	{0.15282635,0.64255648,-0.75084304},
	{0.82255147,0.34322638,0.45343659},
	{0.82255147,0.34322638,-0.45343659},
	{0.26100363,0.34322638,0.90225981},
	{0.90225981,0.34322638,0.26100363},
	{-0.45322363,0.34304283,0.82274538},
	{0.45322363,0.34304283,0.82274538},
	{-0.90357969,0.34158646,0.25857773},
	{-0.25857773,0.34158646,0.90357969},
	{-0.82176939,0.34158646,-0.45608526},
	{-0.82176939,0.34158646,0.45608526},
	{-0.25857773,0.34158646,-0.90357969},
	{-0.90357969,0.34158646,-0.25857773},
	{0.45614863,0.34181380,-0.82163967},
	{-0.45614863,0.34181380,-0.82163967},
	{0.90225981,0.34322638,-0.26100363},
	{0.26100363,0.34322638,-0.90225981},
	{0.65347165,-0.66692505,0.35803042},
	{0.65381081,-0.66734991,-0.35661676},
	{0.17481887,-0.74039295,0.64904286},
	{0.68501369,-0.69610845,0.21491688},
	{-0.35661676,-0.66734991,0.65381081},
	{-0.10299920,-0.95706596,0.27095369},
	{-0.71448019,-0.66734991,0.21014793},
	{-0.21491688,-0.69610845,0.68501369},
	{-0.63551384,-0.69641495,-0.33335923},
	{-0.63634701,-0.69610845,0.33240864},
	{-0.21491688,-0.69610845,-0.68501369},
	{-0.71448019,-0.66734991,-0.21014793},
	{0.33240864,-0.69610845,-0.63634701},
	{-0.35661676,-0.66734991,-0.65381081},
	{0.68501369,-0.69610845,-0.21491688},
	{0.21014793,-0.66734991,-0.71448019},
	{9.8440430e-2,0.96061287,-0.25986995},
	{-0.12085492,0.96031519,-0.25137387},
	{-0.25850480,0.96048894,-0.10313228},
	{-0.25850480,0.96048894,0.10313228},
	{-0.11381262,0.96097043,0.25215576},
	{9.1393045e-2,0.96107387,0.26073803},
	{0.25351020,0.96119942,0.10875780},
	{0.25351020,0.96119942,-0.10875780},
	{0.80632701,0.59146794,1.5560184e-3},
	{0.81655010,0.46768176,0.33840760},
	{0.60098086,0.57624334,0.55386426},
	{0.33809780,0.46768176,0.81667842},
	{9.1690062e-2,0.53343666,0.84085567},
	{-0.33840760,0.46768176,0.81655010},
	{-0.55334590,0.57699465,0.60073746},
	{-0.81667842,0.46768176,0.33809780},
	{-0.82733052,0.56170993,2.4808870e-3},
	{-0.81667842,0.46768176,-0.33809780},
	{-0.55334590,0.57699465,-0.60073746},
	{-0.33840760,0.46768176,-0.81655010},
	{3.3316466e-2,0.57624334,-0.81659881},
	{0.33809780,0.46768176,-0.81667842},
	{0.60098086,0.57624334,-0.55386426},
	{0.81655010,0.46768176,-0.33840760},
	{0.91036304,0.40781070,-7.0210969e-2},
	{-0.20153601,-0.96835820,-0.14719252},
	{-0.20340061,-0.96815219,0.14597786},
	{0.91036304,0.40781070,7.0210969e-2},
	{0.69337053,0.40781070,0.59407722},
	{-4.2781372e-2,-0.95612317,-0.28982449},
	{-0.26422969,-0.96430383,-1.7343515e-2},
	{0.57319671,0.44005081,0.69123138},
	{7.0210969e-2,0.40781070,0.91036304},
	{0.14597786,-0.96815219,-0.20340061},
	{-0.26998096,-0.91110527,-0.31144415},
	{-8.3463117e-2,0.44005081,0.89408567},
	{-0.59407722,0.40781070,0.69337053},
	{0.24704789,-0.96815219,-4.0604021e-2},
	{1.7343515e-2,-0.96430383,-0.26422969},
	{-0.69123138,0.44005081,0.57319671},
	{-0.89408567,0.44005081,8.3463117e-2},
	{0.20144850,-0.96421267,0.17237295},
	{0.19910232,-0.96430383,-0.17457489},
	{-0.89408567,0.44005081,-8.3463117e-2},
	{-0.69123138,0.44005081,-0.57319671},
	{1.7343515e-2,-0.96430383,0.26422969},
	{0.24704789,-0.96815219,4.0604021e-2},
	{-0.59407722,0.40781070,-0.69337053},
	{-8.3463117e-2,0.44005081,-0.89408567},
	{-0.17457489,-0.96430383,0.19910232},
	{0.14597786,-0.96815219,0.20340061},
	{7.0210969e-2,0.40781070,-0.91036304},
	{0.57319671,0.44005081,-0.69123138},
	{-0.26422969,-0.96430383,1.7343515e-2},
	{-4.0604021e-2,-0.96815219,0.24704789},
	{0.69337053,0.40781070,-0.59407722},
	{-0.18884165,-0.98200615,-1.6608968e-3},
	{0.10680748,-0.98079593,0.16319162},
	{-0.16319162,-0.98079593,-0.10680748},
	{-0.16319162,-0.98079593,0.10680748},
	{0.19400380,-0.98099614,-3.0164307e-3},
	{-0.37530974,-0.91373970,-0.15563534},
	{-0.11234510,-0.97495835,-0.19192395},
	{-3.9869607e-2,-0.98079593,0.19091819},
	{0.10680748,-0.98079593,-0.16319162},
	{0.15563534,-0.91373970,0.37530974},
	{-0.37530974,-0.91373970,0.15563534},
	{0.37543487,-0.91373970,-0.15533326},
	{-0.19683200,-0.79132375,-0.57884703},
	{0.37543487,-0.91373970,0.15533326},
	{0.15563534,-0.91373970,-0.37530974},
	{-0.15533326,-0.91373970,0.37543487},
	{0.72717401,0.61710037,0.30067440},
	{0.88008620,0.30396083,0.36476855},
	{0.30158077,0.61710037,0.72679858},
	{0.38195371,0.30379376,0.87282342},
	{-0.30067440,0.61710037,0.72717401},
	{-0.36476855,0.30396083,0.88008620},
	{-0.72679858,0.61710037,0.30158077},
	{-0.88024523,0.30396083,0.36438461},
	{-0.72679858,0.61710037,-0.30158077},
	{-0.88024523,0.30396083,-0.36438461},
	{-0.30067440,0.61710037,-0.72717401},
	{-0.36476855,0.30396083,-0.88008620},
	{0.30158077,0.61710037,-0.72679858},
	{0.36438461,0.30396083,-0.88024523},
	{0.72717401,0.61710037,-0.30067440},
	{0.88008620,0.30396083,-0.36476855},
	{0.77321144,0.61103692,0.16964068},
	{0.85372619,0.46034244,0.24338534},
	{0.92725868,0.29020092,0.23658985},
	{0.77321144,0.61103692,-0.16964068},
	{0.85500569,0.45896483,-0.24148820},
	{0.92804335,0.28913221,-0.23481507},
	{0.42678897,0.61103692,0.66669713},
	{0.43382238,0.45896483,0.77533827},
	{0.47880330,0.22619349,0.84828291},
	{0.66337871,0.61472202,0.42666795},
	{0.78022252,0.46620663,0.41701822},
	{0.82534372,0.30805678,0.47318998},
	{-0.17252053,0.61114102,0.77249163},
	{-0.24476048,0.45866243,0.85423714},
	{-0.23481507,0.28913221,0.92804335},
	{0.17026563,0.61483652,0.77005563},
	{0.31651979,0.41357742,0.85367965},
	{0.20922258,0.30647299,0.92860122},
	{-0.66822451,0.61114102,0.42424363},
	{-0.77710867,0.45866243,0.43096508},
	{-0.82226507,0.28913221,0.49018642},
	{-0.42411557,0.61483652,0.66490754},
	{-0.41412629,0.46589546,0.78194682},
	{-0.47318998,0.30805678,0.82534372},
	{-0.77005563,0.61483652,-0.17026563},
	{-0.84720037,0.46482983,-0.25726400},
	{-0.91914588,0.30732866,-0.24641418},
	{-0.77005563,0.61483652,0.17026563},
	{-0.84575141,0.46589546,0.26008840},
	{-0.91820199,0.30805678,0.24901030},
	{-0.42411557,0.61483652,-0.66490754},
	{-0.41412629,0.46589546,-0.78194682},
	{-0.47318998,0.30805678,-0.82534372},
	{-0.66822451,0.61114102,-0.42424363},
	{-0.77710867,0.45866243,-0.43096508},
	{-0.82226507,0.28913221,-0.49018642},
	{0.16737978,0.61472202,-0.77077938},
	{0.25682422,0.46620663,-0.84657705},
	{0.24901030,0.30805678,-0.91820199},
	{-0.16964068,0.61103692,-0.77321144},
	{-0.24148820,0.45896483,-0.85500569},
	{-0.23481507,0.28913221,-0.92804335},
	{0.66337871,0.61472202,-0.42666795},
	{0.78022252,0.46620663,-0.41701822},
	{0.82534372,0.30805678,-0.47318998},
	{0.42678897,0.61103692,-0.66669713},
	{0.43382238,0.45896483,-0.77533827},
	{0.49018642,0.28913221,-0.82226507},
	{0.26129540,0.50540158,0.82237094},
	{6.2750840e-2,0.48370799,0.87297704},
	{6.3793002e-2,-0.30268005,0.95095491},
	{0.29508499,-0.27442667,0.91521301},
};
//o sphere1_cut2
material(mtl_biosphere::m_basis);
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[113]);
	glVertex3fv(vertices[113]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[114]);
	glVertex3fv(vertices[114]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[48]);
	glVertex3fv(vertices[48]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[115]);
	glVertex3fv(vertices[115]);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[49]);
	glVertex3fv(vertices[49]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[116]);
	glVertex3fv(vertices[116]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[50]);
	glVertex3fv(vertices[50]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[117]);
	glVertex3fv(vertices[117]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[52]);
	glVertex3fv(vertices[52]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[118]);
	glVertex3fv(vertices[118]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[119]);
	glVertex3fv(vertices[119]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[53]);
	glVertex3fv(vertices[53]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[120]);
	glVertex3fv(vertices[120]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[54]);
	glVertex3fv(vertices[54]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[121]);
	glVertex3fv(vertices[121]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[55]);
	glVertex3fv(vertices[55]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[122]);
	glVertex3fv(vertices[122]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[56]);
	glVertex3fv(vertices[56]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[123]);
	glVertex3fv(vertices[123]);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[57]);
	glVertex3fv(vertices[57]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[124]);
	glVertex3fv(vertices[124]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[58]);
	glVertex3fv(vertices[58]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[125]);
	glVertex3fv(vertices[125]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
	glNormal3fv(normals[59]);
	glVertex3fv(vertices[59]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[126]);
	glVertex3fv(vertices[126]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[60]);
	glVertex3fv(vertices[60]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[127]);
	glVertex3fv(vertices[127]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[63]);
	glVertex3fv(vertices[63]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[61]);
	glVertex3fv(vertices[61]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[128]);
	glVertex3fv(vertices[128]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[62]);
	glVertex3fv(vertices[62]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
	glNormal3fv(normals[190]);
	glVertex3fv(vertices[190]);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
	glNormal3fv(normals[197]);
	glVertex3fv(vertices[197]);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
	glNormal3fv(normals[199]);
	glVertex3fv(vertices[199]);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
	glNormal3fv(normals[196]);
	glVertex3fv(vertices[196]);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
	glNormal3fv(normals[198]);
	glVertex3fv(vertices[198]);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
	glNormal3fv(normals[194]);
	glVertex3fv(vertices[194]);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
	glNormal3fv(normals[200]);
	glVertex3fv(vertices[200]);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
	glNormal3fv(normals[195]);
	glVertex3fv(vertices[195]);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[155]);
	glVertex3fv(vertices[155]);
	glNormal3fv(normals[185]);
	glVertex3fv(vertices[185]);
	glNormal3fv(normals[154]);
	glVertex3fv(vertices[154]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[159]);
	glVertex3fv(vertices[159]);
	glNormal3fv(normals[187]);
	glVertex3fv(vertices[187]);
	glNormal3fv(normals[158]);
	glVertex3fv(vertices[158]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[163]);
	glVertex3fv(vertices[163]);
	glNormal3fv(normals[191]);
	glVertex3fv(vertices[191]);
	glNormal3fv(normals[162]);
	glVertex3fv(vertices[162]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[167]);
	glVertex3fv(vertices[167]);
	glNormal3fv(normals[193]);
	glVertex3fv(vertices[193]);
	glNormal3fv(normals[166]);
	glVertex3fv(vertices[166]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[171]);
	glVertex3fv(vertices[171]);
	glNormal3fv(normals[189]);
	glVertex3fv(vertices[189]);
	glNormal3fv(normals[170]);
	glVertex3fv(vertices[170]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[175]);
	glVertex3fv(vertices[175]);
	glNormal3fv(normals[186]);
	glVertex3fv(vertices[186]);
	glNormal3fv(normals[174]);
	glVertex3fv(vertices[174]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[179]);
	glVertex3fv(vertices[179]);
	glNormal3fv(normals[192]);
	glVertex3fv(vertices[192]);
	glNormal3fv(normals[178]);
	glVertex3fv(vertices[178]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[183]);
	glVertex3fv(vertices[183]);
	glNormal3fv(normals[188]);
	glVertex3fv(vertices[188]);
	glNormal3fv(normals[182]);
	glVertex3fv(vertices[182]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[202]);
	glVertex3fv(vertices[202]);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
	glNormal3fv(normals[138]);
	glVertex3fv(vertices[138]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
	glNormal3fv(normals[140]);
	glVertex3fv(vertices[140]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[51]);
	glVertex3fv(vertices[51]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[206]);
	glVertex3fv(vertices[206]);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
	glNormal3fv(normals[142]);
	glVertex3fv(vertices[142]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[208]);
	glVertex3fv(vertices[208]);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
	glNormal3fv(normals[144]);
	glVertex3fv(vertices[144]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[210]);
	glVertex3fv(vertices[210]);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
	glNormal3fv(normals[146]);
	glVertex3fv(vertices[146]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[212]);
	glVertex3fv(vertices[212]);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
	glNormal3fv(normals[148]);
	glVertex3fv(vertices[148]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[214]);
	glVertex3fv(vertices[214]);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
	glNormal3fv(normals[150]);
	glVertex3fv(vertices[150]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[216]);
	glVertex3fv(vertices[216]);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
	glNormal3fv(normals[152]);
	glVertex3fv(vertices[152]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[219]);
	glVertex3fv(vertices[219]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[153]);
	glVertex3fv(vertices[153]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[222]);
	glVertex3fv(vertices[222]);
	glNormal3fv(normals[156]);
	glVertex3fv(vertices[156]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[225]);
	glVertex3fv(vertices[225]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[157]);
	glVertex3fv(vertices[157]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[228]);
	glVertex3fv(vertices[228]);
	glNormal3fv(normals[160]);
	glVertex3fv(vertices[160]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[231]);
	glVertex3fv(vertices[231]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[161]);
	glVertex3fv(vertices[161]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[164]);
	glVertex3fv(vertices[164]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[234]);
	glVertex3fv(vertices[234]);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
	glNormal3fv(normals[204]);
	glVertex3fv(vertices[204]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[237]);
	glVertex3fv(vertices[237]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[165]);
	glVertex3fv(vertices[165]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[240]);
	glVertex3fv(vertices[240]);
	glNormal3fv(normals[168]);
	glVertex3fv(vertices[168]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[243]);
	glVertex3fv(vertices[243]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[169]);
	glVertex3fv(vertices[169]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[246]);
	glVertex3fv(vertices[246]);
	glNormal3fv(normals[172]);
	glVertex3fv(vertices[172]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[249]);
	glVertex3fv(vertices[249]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[173]);
	glVertex3fv(vertices[173]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[252]);
	glVertex3fv(vertices[252]);
	glNormal3fv(normals[176]);
	glVertex3fv(vertices[176]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[255]);
	glVertex3fv(vertices[255]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[177]);
	glVertex3fv(vertices[177]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[258]);
	glVertex3fv(vertices[258]);
	glNormal3fv(normals[180]);
	glVertex3fv(vertices[180]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[261]);
	glVertex3fv(vertices[261]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[181]);
	glVertex3fv(vertices[181]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[264]);
	glVertex3fv(vertices[264]);
	glNormal3fv(normals[184]);
	glVertex3fv(vertices[184]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[266]);
	glVertex3fv(vertices[266]);
	glNormal3fv(normals[267]);
	glVertex3fv(vertices[267]);
	glNormal3fv(normals[268]);
	glVertex3fv(vertices[268]);
	glNormal3fv(normals[265]);
	glVertex3fv(vertices[265]);
glEnd();
material(mtl_biosphere::m_glas);
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[31]);
	glVertex3fv(vertices[31]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
	glNormal3fv(normals[1]);
	glVertex3fv(vertices[1]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
	glNormal3fv(normals[3]);
	glVertex3fv(vertices[3]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
	glNormal3fv(normals[5]);
	glVertex3fv(vertices[5]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
	glNormal3fv(normals[7]);
	glVertex3fv(vertices[7]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
	glNormal3fv(normals[9]);
	glVertex3fv(vertices[9]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
	glNormal3fv(normals[11]);
	glVertex3fv(vertices[11]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
	glNormal3fv(normals[13]);
	glVertex3fv(vertices[13]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
	glNormal3fv(normals[17]);
	glVertex3fv(vertices[17]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
	glNormal3fv(normals[19]);
	glVertex3fv(vertices[19]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
	glNormal3fv(normals[21]);
	glVertex3fv(vertices[21]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
	glNormal3fv(normals[23]);
	glVertex3fv(vertices[23]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
	glNormal3fv(normals[25]);
	glVertex3fv(vertices[25]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
	glNormal3fv(normals[27]);
	glVertex3fv(vertices[27]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
	glNormal3fv(normals[29]);
	glVertex3fv(vertices[29]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[15]);
	glVertex3fv(vertices[15]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[201]);
	glVertex3fv(vertices[201]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[33]);
	glVertex3fv(vertices[33]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[203]);
	glVertex3fv(vertices[203]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[35]);
	glVertex3fv(vertices[35]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[205]);
	glVertex3fv(vertices[205]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[37]);
	glVertex3fv(vertices[37]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[207]);
	glVertex3fv(vertices[207]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[39]);
	glVertex3fv(vertices[39]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[209]);
	glVertex3fv(vertices[209]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[41]);
	glVertex3fv(vertices[41]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[211]);
	glVertex3fv(vertices[211]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[43]);
	glVertex3fv(vertices[43]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[213]);
	glVertex3fv(vertices[213]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[45]);
	glVertex3fv(vertices[45]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[215]);
	glVertex3fv(vertices[215]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[47]);
	glVertex3fv(vertices[47]);
glEnd();
material(mtl_biosphere::m_streben);
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[135]);
	glVertex3fv(vertices[135]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[134]);
	glVertex3fv(vertices[134]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[133]);
	glVertex3fv(vertices[133]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[132]);
	glVertex3fv(vertices[132]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[131]);
	glVertex3fv(vertices[131]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[130]);
	glVertex3fv(vertices[130]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[129]);
	glVertex3fv(vertices[129]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
	glNormal3fv(normals[82]);
	glVertex3fv(vertices[82]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[67]);
	glVertex3fv(vertices[67]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[69]);
	glVertex3fv(vertices[69]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[71]);
	glVertex3fv(vertices[71]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[73]);
	glVertex3fv(vertices[73]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[75]);
	glVertex3fv(vertices[75]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[77]);
	glVertex3fv(vertices[77]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[79]);
	glVertex3fv(vertices[79]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[221]);
	glVertex3fv(vertices[221]);
	glNormal3fv(normals[220]);
	glVertex3fv(vertices[220]);
	glNormal3fv(normals[98]);
	glVertex3fv(vertices[98]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[84]);
	glVertex3fv(vertices[84]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[86]);
	glVertex3fv(vertices[86]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[88]);
	glVertex3fv(vertices[88]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[90]);
	glVertex3fv(vertices[90]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[92]);
	glVertex3fv(vertices[92]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[94]);
	glVertex3fv(vertices[94]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[96]);
	glVertex3fv(vertices[96]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[65]);
	glVertex3fv(vertices[65]);
	glNormal3fv(normals[136]);
	glVertex3fv(vertices[136]);
	glNormal3fv(normals[64]);
	glVertex3fv(vertices[64]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[66]);
	glVertex3fv(vertices[66]);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
	glNormal3fv(normals[0]);
	glVertex3fv(vertices[0]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[68]);
	glVertex3fv(vertices[68]);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
	glNormal3fv(normals[2]);
	glVertex3fv(vertices[2]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[70]);
	glVertex3fv(vertices[70]);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
	glNormal3fv(normals[4]);
	glVertex3fv(vertices[4]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[72]);
	glVertex3fv(vertices[72]);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
	glNormal3fv(normals[6]);
	glVertex3fv(vertices[6]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[74]);
	glVertex3fv(vertices[74]);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
	glNormal3fv(normals[8]);
	glVertex3fv(vertices[8]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[76]);
	glVertex3fv(vertices[76]);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
	glNormal3fv(normals[10]);
	glVertex3fv(vertices[10]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[78]);
	glVertex3fv(vertices[78]);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
	glNormal3fv(normals[12]);
	glVertex3fv(vertices[12]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[80]);
	glVertex3fv(vertices[80]);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
	glNormal3fv(normals[14]);
	glVertex3fv(vertices[14]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[81]);
	glVertex3fv(vertices[81]);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
	glNormal3fv(normals[16]);
	glVertex3fv(vertices[16]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[83]);
	glVertex3fv(vertices[83]);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
	glNormal3fv(normals[18]);
	glVertex3fv(vertices[18]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[85]);
	glVertex3fv(vertices[85]);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
	glNormal3fv(normals[20]);
	glVertex3fv(vertices[20]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[87]);
	glVertex3fv(vertices[87]);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
	glNormal3fv(normals[22]);
	glVertex3fv(vertices[22]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[89]);
	glVertex3fv(vertices[89]);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
	glNormal3fv(normals[24]);
	glVertex3fv(vertices[24]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[91]);
	glVertex3fv(vertices[91]);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
	glNormal3fv(normals[26]);
	glVertex3fv(vertices[26]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[93]);
	glVertex3fv(vertices[93]);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
	glNormal3fv(normals[28]);
	glVertex3fv(vertices[28]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[95]);
	glVertex3fv(vertices[95]);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
	glNormal3fv(normals[30]);
	glVertex3fv(vertices[30]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[97]);
	glVertex3fv(vertices[97]);
	glNormal3fv(normals[217]);
	glVertex3fv(vertices[217]);
	glNormal3fv(normals[218]);
	glVertex3fv(vertices[218]);
	glNormal3fv(normals[137]);
	glVertex3fv(vertices[137]);
	glNormal3fv(normals[32]);
	glVertex3fv(vertices[32]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[99]);
	glVertex3fv(vertices[99]);
	glNormal3fv(normals[223]);
	glVertex3fv(vertices[223]);
	glNormal3fv(normals[224]);
	glVertex3fv(vertices[224]);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[101]);
	glVertex3fv(vertices[101]);
	glNormal3fv(normals[229]);
	glVertex3fv(vertices[229]);
	glNormal3fv(normals[230]);
	glVertex3fv(vertices[230]);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[103]);
	glVertex3fv(vertices[103]);
	glNormal3fv(normals[235]);
	glVertex3fv(vertices[235]);
	glNormal3fv(normals[236]);
	glVertex3fv(vertices[236]);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[105]);
	glVertex3fv(vertices[105]);
	glNormal3fv(normals[241]);
	glVertex3fv(vertices[241]);
	glNormal3fv(normals[242]);
	glVertex3fv(vertices[242]);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[107]);
	glVertex3fv(vertices[107]);
	glNormal3fv(normals[247]);
	glVertex3fv(vertices[247]);
	glNormal3fv(normals[248]);
	glVertex3fv(vertices[248]);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[109]);
	glVertex3fv(vertices[109]);
	glNormal3fv(normals[253]);
	glVertex3fv(vertices[253]);
	glNormal3fv(normals[254]);
	glVertex3fv(vertices[254]);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[111]);
	glVertex3fv(vertices[111]);
	glNormal3fv(normals[259]);
	glVertex3fv(vertices[259]);
	glNormal3fv(normals[260]);
	glVertex3fv(vertices[260]);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[139]);
	glVertex3fv(vertices[139]);
	glNormal3fv(normals[227]);
	glVertex3fv(vertices[227]);
	glNormal3fv(normals[226]);
	glVertex3fv(vertices[226]);
	glNormal3fv(normals[100]);
	glVertex3fv(vertices[100]);
	glNormal3fv(normals[34]);
	glVertex3fv(vertices[34]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[141]);
	glVertex3fv(vertices[141]);
	glNormal3fv(normals[233]);
	glVertex3fv(vertices[233]);
	glNormal3fv(normals[232]);
	glVertex3fv(vertices[232]);
	glNormal3fv(normals[102]);
	glVertex3fv(vertices[102]);
	glNormal3fv(normals[36]);
	glVertex3fv(vertices[36]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[143]);
	glVertex3fv(vertices[143]);
	glNormal3fv(normals[239]);
	glVertex3fv(vertices[239]);
	glNormal3fv(normals[238]);
	glVertex3fv(vertices[238]);
	glNormal3fv(normals[104]);
	glVertex3fv(vertices[104]);
	glNormal3fv(normals[38]);
	glVertex3fv(vertices[38]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[145]);
	glVertex3fv(vertices[145]);
	glNormal3fv(normals[245]);
	glVertex3fv(vertices[245]);
	glNormal3fv(normals[244]);
	glVertex3fv(vertices[244]);
	glNormal3fv(normals[106]);
	glVertex3fv(vertices[106]);
	glNormal3fv(normals[40]);
	glVertex3fv(vertices[40]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[147]);
	glVertex3fv(vertices[147]);
	glNormal3fv(normals[251]);
	glVertex3fv(vertices[251]);
	glNormal3fv(normals[250]);
	glVertex3fv(vertices[250]);
	glNormal3fv(normals[108]);
	glVertex3fv(vertices[108]);
	glNormal3fv(normals[42]);
	glVertex3fv(vertices[42]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[149]);
	glVertex3fv(vertices[149]);
	glNormal3fv(normals[257]);
	glVertex3fv(vertices[257]);
	glNormal3fv(normals[256]);
	glVertex3fv(vertices[256]);
	glNormal3fv(normals[110]);
	glVertex3fv(vertices[110]);
	glNormal3fv(normals[44]);
	glVertex3fv(vertices[44]);
glEnd();
glBegin(GL_POLYGON);
	glNormal3fv(normals[151]);
	glVertex3fv(vertices[151]);
	glNormal3fv(normals[263]);
	glVertex3fv(vertices[263]);
	glNormal3fv(normals[262]);
	glVertex3fv(vertices[262]);
	glNormal3fv(normals[112]);
	glVertex3fv(vertices[112]);
	glNormal3fv(normals[46]);
	glVertex3fv(vertices[46]);
glEnd();
}
} //namespace
