#include <limits.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "../cdialog.h"
#include "../fb.h"

int main(int argc, char *argv[])
{
	gchar cwd[PATH_MAX];

	getcwd(cwd, sizeof(cwd));

	gtk_init(&argc, &argv);
	CDialogInit();
	FileBrowserInit();

	while(TRUE)
	{
	    gboolean status;
	    fb_type_struct **ftype = NULL, *ftype_rtn = NULL;
	    gint total_ftypes = 0;
	    gchar **path_rtn = NULL;
	    gint total_path_rtns = 0;


	    FileBrowserTypeListNew(
		&ftype, &total_ftypes,
		"*.*",
		"All files"
	    );

	    status = FileBrowserGetResponse(
		"Select File",
		"Select", "Cancel",
		cwd,
		ftype, total_ftypes,
		&path_rtn, &total_path_rtns,
		&ftype_rtn
	    );
	    if(status)
	    {
		gchar *buf = g_strdup_printf(
"Selected path is \"%s\"\n\
File type is: \"(%s) %s\"\n\
\n\
Select another path?",
		    (total_path_rtns > 0) ? path_rtn[0] : "*none*",
		    (ftype_rtn != NULL) ? ftype_rtn->ext : "*none*",
		    (ftype_rtn != NULL) ? ftype_rtn->name : "*none*"
		);
		gint response = CDialogGetResponse(
		    "Output", buf, NULL,
		    CDIALOG_ICON_INFO,
		    CDIALOG_BTNFLAG_YES | CDIALOG_BTNFLAG_NO,
		    CDIALOG_BTNFLAG_YES
		);
		g_free(buf);
		if((response == CDIALOG_RESPONSE_NOT_AVAILABLE) ||
		   (response == CDIALOG_RESPONSE_NO) ||
		   (response == CDIALOG_RESPONSE_CANCEL)
		)
		{
		    FileBrowserDeleteTypeList(ftype, total_ftypes);
		    break;
		}
	    }
	    else
	    {
		FileBrowserDeleteTypeList(ftype, total_ftypes);
		break;
	    }

	    FileBrowserDeleteTypeList(ftype, total_ftypes);
	}


	FileBrowserShutdown();
	CDialogShutdown();

	return(0);
}
