/*
		    Endeavour Find Object Procedures
 */

#ifndef EDVFIND_H
#define EDVFIND_H

#include <sys/stat.h>
#include <glib.h>


/* Archive Finding */
extern gint EDVFindArchiveObjectByName(
	edv_core_struct *core_ptr,
	const gchar *arch_path, const gchar *expression,
	gboolean case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(const gchar *, const struct stat *, gpointer)
);

/* Recycled Object Finding */
extern gint EDVFindRecycledObjectByContent(
	const gchar *recycled_index_file, const gchar *expression,
	gboolean case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(
		const gchar *, const struct stat *,
		const gchar *, gint,
		gpointer
	)
);
extern gint EDVFindRecycledObjectByName(
	const gchar *recycled_index_file, const gchar *expression,
	gboolean case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(const gchar *, const struct stat *, gpointer)
);

/* Object Finding */
extern gint EDVFindObjectByContent(
	const gchar *start_dir, const gchar *expression,
	gboolean recursive, gboolean follow_links, gboolean case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(
		const gchar *, const struct stat *,
		const gchar *, gint,
		gpointer
	)
);
extern gint EDVFindObjectByName(
	const gchar *start_dir, const gchar *expression,
	gboolean recursive, gboolean follow_links, gboolean case_sensitive,
	gpointer client_data,
	gint (*progress_cb)(const gchar *, gfloat, gpointer),
	void (*match_cb)(const gchar *, const struct stat *, gpointer)
);


#endif	/* EDVFIND_H */
