/*
			Endeavour Date Formatting
 */

#ifndef EDVDATE_H
#define EDVDATE_H

#include <glib.h>


/*
 *	Date Relativity:
 */
typedef enum {
	EDV_DATE_RELATIVITY_ABSOLUTE,	/* Relative to christian time */
	EDV_DATE_RELATIVITY_CURRENT	/* Relative to current time */
} edv_date_relativity;


extern gchar *EDVDateFormatString(
	gulong t,		/* In systime seconds */
	const gchar *format,	/* Can be NULL to just use ctime() */
	edv_date_relativity relativity
);
extern gchar *EDVDateStringDuration(gulong dt);

extern void EDVDateParseDateDMY(
	const gchar *s,
	gint *day, gint *mon, gint *year
);
extern void EDVDateParseDateYMD(
	const gchar *s,
	gint *year, gint *mon, gint *day
);
extern void EDVDateParseTime(
	const gchar *s,
	gint *hour, gint *min, gint *sec
);


#endif	/* EDVDATE_H */
