/*
                   Endeavour Compile Time Configuration

	See edvcfglist.h for confirmation list.
 */

#ifndef CONFIG_H
#define CONFIG_H


/*
 *	Languages (define only one):
 */
#define PROG_LANGUAGE_ENGLISH		1
/* #define PROG_LANGUAGE_SPANISH	2 */
/* #define PROG_LANGUAGE_FRENCH		3 */
/* *incomplete* #define PROG_LANGUAGE_GERMAN	4 */
/* *incomplete* #define PROG_LANGUAGE_ITALIAN	5 */
/* *incomplete* #define PROG_LANGUAGE_DUTCH	6 */
/* *incomplete* #define PROG_LANGUAGE_NORWEGIAN	7 */
/* *incomplete* #define PROG_LANGUAGE_PORTUGUESE	8 */
/* #define PROG_LANGUAGE_POLISH		9 */


/*
 *      Program name and version:
 */
#define PROG_NAME		"Endeavour"
#define PROG_NAME_FULL		"Endeavour Mark II"
#define PROG_VERSION		"2.5.2"

#define PROG_VERSION_MAJOR	2
#define PROG_VERSION_MINOR	5
#define PROG_VERSION_RELEASE	2

/*
 *      Copyright message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_COPYRIGHT	"\
El derecho de autor (C) 1997-2005 WolfPack Entertainment.\n\
Este programa es protegido por leyes internacionales de derecho de autor\n\
y tratados, la distribucin y/o la modificacin de este software en la\n\
infraccin de la Licencia del Pblico de GNU se prohiben estrictamente.\n\
Violators ser procesado a la extensin ms repleta de la ley.\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_COPYRIGHT  "\
Dposer (C) 1997-2005 WolfPack Entertainment.\n\
Ce programme est protg par international dpose lois et traits, \n\
distribution et/ou de ce logiciel dans violation du GNU Public Permis\n\
strictement est interdit. Violators sera poursuivi  l'tendue plus pleine\n\
de la loi.\n"
#elif defined(PROG_LANGUAGE_GERMAN)
#define PROG_COPYRIGHT  "\
Urheberrecht (C) 1997-2005 WolfPack Entertainment.\n\
Dieses Programm wird von internationalem Urheberrecht Gesetzen und\n\
Vertrgen, Austeilung bzw. nderung dieser Software in bertretung\n\
DER GNU ffentlichkeit Erlaubnis streng verboten wird geschtzt.\n\
Verletzer werden zum vollsten Umfang des Gesetzes strafrechtlich\n\
verfolgt werden.\n"
#elif defined(PROG_LANGUAGE_ITALIAN)
#define PROG_COPYRIGHT  "\
Il copyright (C) 1997-2005 WolfPack Entertainment.\n\
Questo programma  protetto dalle leggi di copyright internazionali e\n\
dai trattati, la distribuzione e/o la modifica di questo software nella\n\
violazione dello GNU la Licenza Pubblica  strettamente proibita. Il\n\
Violators sar perseguito all'estensione la pi piena della legge.\n"
#elif defined(PROG_LANGUAGE_DUTCH)
#define PROG_COPYRIGHT  "\
Auteursrecht (C) 1997-2005 WolfPack Entertainment.\n\
Deze programma wordt door internationale auteursrecht wetten en\n\
verdragen, verdeling en/of wijziging van deze software in overtreding\n\
van de GNU Publiek Vergunning strikt verboden wordt beschermd.\n\
Overtreders zullen te de volste omvang van de wet geprocedeerd worden.\n"
#elif defined(PROG_LANGUAGE_PORTUGUESE)
#define PROG_COPYRIGHT  "\
Os direitos autorais (C) 1997-2005 WolfPack Entertainment.\n\
Este programa  protegido por direitos internacionais leis autorais e\n\
tratados, modificao de e/ou de distribuio deste software em infrao\n\
do GNU Licena Pblica precisamente  proibida. O Violators ser\n\
processado  plena extenso da lei.\n"
#elif defined(PROG_LANGUAGE_NORWEGIAN)
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2005 WolfPack Entertainment.\n\
Dette programet beskytter av internasjonal copyrightlover og traktater,\n\
distribusjon og/eller modifikasjon av denne programvaren i overtredelse\n\
av GNU Public License er streng forbudt. Violators tiltalt til den\n\
fulleste omfang av loven.\n"
#else
#define PROG_COPYRIGHT  "\
Copyright (C) 1997-2005 WolfPack Entertainment.\n\
This program is protected by international copyright laws and treaties,\n\
distribution and/or modification of this software in violation of the\n\
GNU Public License is strictly prohibited. Violators will be prosecuted\n\
to the fullest extent of the law.\n"
#endif


/*
 *	Prefix Directory:
 */
#ifndef PREFIX
# define PREFIX		"/usr"
#endif


/*
 *      Credits Lines:
 */
#define PROG_CREDITS_LINES	{				\
 "                  http://wolfpack.twu.net/Endeavour2/",	\
 " ",								\
 "        Director: Capt Taura Milana",				\
 " ",								\
 "     Programmers: Dan Stimitz",				\
 "                  Capt Taura Milana",				\
 " ",								\
 "    Beta Testing: Dan Stimits",				\
 " ",								\
 "       Packagers: Thierry Vignaud",				\
 "                  Guillaume Rousse",				\
 " ",								\
 "    Contributors: Remi Broemeling",				\
 " ",								\
 "                  WolfPack Entertainment",			\
 " ",								\
 NULL								\
}


/*
 *	Environment Variable Names:
 */
#define ENV_VAR_NAME_BROWSER			"BROWSER"
#define ENV_VAR_NAME_DISPLAY			"DISPLAY"
#define ENV_VAR_NAME_HELPBROWSER		"HELPBROWSER"
#define ENV_VAR_NAME_HOME			"HOME"
#define ENV_VAR_NAME_PATH			"PATH"
#define ENV_VAR_NAME_TMPDIR			"TMPDIR"
#define ENV_VAR_NAME_USER			"USER"
#define ENV_VAR_NAME_USERNAME			"USERNAME"


/*
 *	GTK Font Names:
 */
#define PROG_GTK_FONT_NAME_PREF_BANNER	\
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_EDITABLE \
        "-adobe-courier-medium-r-*-*-14-*-*-*-*-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_TERMINAL \
        "-adobe-courier-medium-r-*-*-12-*-*-*-*-*-iso8859-1"

/* "Fine print" for license and other legal text */
#define PROG_GTK_FONT_NAME_TEXT_LICENSE  \
        "-adobe-courier-medium-r-*-*-10-*-*-*-*-*-iso8859-1"

#define PROG_GTK_FONT_NAME_TEXT_HEADING1 \
        "-adobe-helvetica-medium-r-normal-*-24-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_HEADING2 \
        "-adobe-helvetica-medium-r-normal-*-20-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_HEADING3 \
        "-adobe-helvetica-medium-r-normal-*-18-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_HEADING4 \
        "-adobe-helvetica-medium-r-normal-*-14-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_HEADING5 \
        "-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"
#define PROG_GTK_FONT_NAME_TEXT_HEADING6 \
        "-adobe-helvetica-medium-r-normal-*-8-*-*-*-p-*-iso8859-1"


/*
 *	List of file format extensions supported by Imlib.
 *
 *	Each `entry' consists of two pointers to strings, the first
 *	string is a space separated list of extensions and the second
 *	string is a verbose name of the format.
 *
 *	Last two pointers must be NULL and NULL.
 */
#define IMLIB_IMAGE_FILE_EXTENSIONS	{			\
	".bmp",		"Windows Bitmap",			\
	".dcx",		"ZSoft MultiPage PaintBrush Image",	\
	".fax",		"FAX Group3",				\
	".gbm",		"GBM Image Format",			\
	".gif",		"Compuserve Graphic Interchange Format", \
	".grey",	"Raw Greyscale Image",			\
	".hrz",		"HRZ Image format",			\
	".img",		"IMG Image format",			\
	".jpg .jpeg",	"JPEG Image",				\
	".mng",		"MultiImage Portable Network Graphics",	\
	".mpc",		"ImageMagick Cache",			\
	".pat",		"PAT Image Format",			\
	".pbm",		"Portable Bitmap",			\
	".pcd",		"PhotoCD Image",			\
        ".pcx",         "ZSoft PaintBrush Image",		\
	".pic",		"Apple Macintosh QuickDraw",		\
	".pix",		"Alias/Wavefront RLE",			\
	".pgm",		"PGM Image Format",			\
	".png",		"Portable Network Graphics",		\
	".pnm",		"PNM Image Format",			\
	".ppm",		"PPM Image Format",			\
	".ps",		"Adobe ISO PostScript",			\
	".ps2",		"Adobe ISO PostScript 2",		\
	".ps3",		"Adobe ISO PostScript 3",		\
	".psd",		"Adobe Photoshop Bitmap",		\
	".rle",		"Utah run Length Encoded",		\
	".rgb",		"Raw RGB Image",			\
	".rgba",	"Raw RGBA Image",			\
	".sgi", 	"Irix Image",				\
	".tga",		"Targa Image Format",			\
	".tif .tiff",	"Tempory Image File Format",		\
	".xbm",		"X Bitmap",				\
	".xcf",		"GIMP Image Format",			\
	".xpm",		"X Pixmap",				\
	".xwd",		"X Image",				\
	".wmf",		"Windows Meta File",			\
	NULL, NULL						\
}


/*
 *      List of archive format extensions supported by the Archiver
 *
 *	Each entry contains of two pointers to strings, the first
 *	string is a space separated list of extensions and the second
 *	string is a verbose name of the format
 *
 *	The last two pointers must be NULL and NULL
 */
#define EDV_ARCHIVER_ARCHIVE_FILE_EXTENSIONS	{		\
	".arj",		"ARJ Archive",				\
	".lha", 	"LHA Archive",				\
	".deb",		"Debian Linux Package",			\
	".rar",		"RAR Archive",				\
	".rpm",         "RedHat Linux Package",			\
	".tar",		"UNIX Tape Archive",			\
	".tar.bz2",	"BZip2 Compressed UNIX Tape Archive",	\
	".tar.gz .tgz",	"GZip Compressed UNIZ Tape Archive",	\
	".tar.Z",	"Compressed UNIX Tape Archive",		\
	".xpi",		"PKZip Archive With Java Script",	\
	".zip",		"PKZip Archive",			\
	NULL,		NULL					\
}


/*
 *	Default local data directory:
 *
 *	The home directory will be automatically prefixed.
 */
#define EDV_DEF_LOCAL_DATA_DIR		".endeavour2"

/*
 *      Default global data directory:
 */
#define EDV_DEF_GLOBAL_DATA_DIR		PREFIX "/share/endeavour2"

/*
 *	Default global arch dependent data directory:
 */
#define EDV_DEF_GLOBAL_ARCHDEP_DATA_DIR	PREFIX "/lib/endeavour2"

/*
 *	Default global configuration directory:
 */
#define EDV_DEF_GLOBAL_CONFIG_DIR	"/etc/endeavour2"


/*
 *	Default configuration files (local data dir prefixed):
 */
#define EDV_DEF_CONFIG_FILE		"endeavour2.ini"
#define EDV_DEF_DEVICES_FILE		"devices.ini"
#define EDV_DEF_MIMETYPES_FILE		"mimetypes.ini"
#define EDV_DEF_HISTORY_FILE		"history.log"
#define EDV_DEF_BROWSER_LOCATION_HISTORY_FILE	\
					"browser_location_history.ini"
#define EDV_DEF_IMBR_LOCATION_HISTORY_FILE	\
					"image_browser_location_history.ini"
#define EDV_DEF_ARCHIVER_LOCATION_HISTORY_FILE	\
					"archiver_location_history.ini"
#define EDV_DEF_RUN_HISTORY_FILE	"run_history.ini"

/*
 *	Default recycled index file (local data dir prefixed):
 */
#define EDV_DEF_RECYCLED_INDEX_FILE	"recycled/recycled.ini"

/*
 *	Default interprocess lock link name (local data dir prefixed):
 *
 *	Name of the link created when this program is running, it's 
 *	destination will be a pid
 */
#define EDV_INTERPS_LOCK_LINK		"lock"

/*
 *	Default interprocess temp command file (local data dir prefixed):
 *
 *	File containing a command to be issued to this program's process
 *	that receives a SIGUSR1
 */
#define EDV_INTERPS_CMD_FILE		"cmd"


/*
 *	Default about image file:
 */
#define EDV_DEF_ABOUT_IMAGE_FILE	"images/endeavour_about.xpm"


/*
 *	Default device icon files:
 *
 *	These paths are initially set to all new device entries.
 */
#define EDV_DEF_DEVICE_ICON_SMALL_FILE	EDV_DEF_GLOBAL_DATA_DIR	\
 "/icons/icon_drive_fixed_20x20.xpm"
#define EDV_DEF_DEVICE_ICON_MEDIUM_FILE	EDV_DEF_GLOBAL_DATA_DIR	\
 "/icons/icon_drive_fixed_32x32.xpm"
#define EDV_DEF_DEVICE_ICON_LARGE_FILE	EDV_DEF_GLOBAL_DATA_DIR	\
 "/icons/icon_drive_fixed_48x48.xpm"

/*
 *	Default programs:
 *
 *	Arguments and token strings allowed (see help pages for
 *	supported token strings).
 */
#if defined(DEBIAN)
# define EDV_DEF_VIEWER_CMD		"see"
#else
# define EDV_DEF_VIEWER_CMD		"/usr/bin/iv -q=2 -i --auto_hide_iv_nonimage \"%paths\""
#endif

#if defined(DEBIAN)
# define EDV_DEF_TERMINAL_PROG		"x-terminal-emulator"
# define EDV_DEF_RUN_IN_TERMINAL_CMD	"x-terminal-emulator -e"
#else
# define EDV_DEF_TERMINAL_PROG		"/usr/X11R6/bin/xterm"
# define EDV_DEF_RUN_IN_TERMINAL_CMD	"/usr/X11R6/bin/xterm -e"
#endif

#define EDV_DEF_FORMAT_FRONT_PROG	EDV_DEF_GLOBAL_ARCHDEP_DATA_DIR \
 "/bin/format.front"
#define EDV_DEF_FSCK_FRONT_PROG		EDV_DEF_GLOBAL_ARCHDEP_DATA_DIR \
 "/bin/fsck.front"
#define EDV_DEF_ZIPTOOL_FRONT_PROG	EDV_DEF_GLOBAL_ARCHDEP_DATA_DIR \
 "/bin/ziptool.front"
#define EDV_DEF_DOWNLOAD_FRONT_PROG	EDV_DEF_GLOBAL_ARCHDEP_DATA_DIR \
 "/bin/download.front"
#define EDV_DEF_MAIL_CLIENT_PROG	"/usr/bin/balsa"


/*
 *	Default License File:
 *
 *	Data directory will be prepended.
 */
#define EDV_DEF_LICENSE_FILE		"LICENSE"


/*
 *	Configuration Format Character Constants:
 */
#define EDV_CFG_COMMENT_CHAR		'#'
#define EDV_CFG_DELIMINATOR_CHAR	'='


/*
 *	Default Window Cascade Offset:
 */
#define EDV_DEF_WINDOW_CASCADE_OFFSET_X	30
#define EDV_DEF_WINDOW_CASCADE_OFFSET_Y	30


/*
 *	GtkPaned Handle & Gutter Size:
 */
#define EDV_DEF_PANED_GUTTER_SIZE       10
#define EDV_DEF_PANED_HANDLE_SIZE       10

/*
 *	List Item Vertical Spacing:
 */
#define EDV_LIST_ROW_SPACING		20

/*
 *	List Item Pixmap & Text Spacing:
 */
#define EDV_LIST_PIXMAP_TEXT_SPACING	2

/*
 * 	Default Progress Bar Path Length:
 *
 *	This is the maximum number of characters a path displayed on the
 *	progress dialog can be. It should not be too long, so that it
 *	can be shortened to fit on the entire progress dialog.
 */
#define EDV_DEF_PROGRESS_BAR_PATH_DISPLAY_MAX	45

/*
 *	Default Progress Bar Ticks:
 */
#define EDV_DEF_PROGRESS_BAR_TICKS	25


/*
 *	Default File Browser Geometry:
 */
#define EDV_DEF_BROWSER_WIDTH		800
#define EDV_DEF_BROWSER_HEIGHT		600
#define EDV_DEF_BROWSER_PANED_POSITION	200


/*
 *	Default Image Browser Geometry:
 */
#define EDV_DEF_IMBR_WIDTH		800
#define EDV_DEF_IMBR_HEIGHT		600
#define EDV_DEF_IMBR_PANED_POSITION	330

#define DEF_IMBR_THUMB_WIDTH		100
#define DEF_IMBR_THUMB_HEIGHT		90
#define DEF_IMBR_THUMB_BORDER		2

#define DEF_PRESENTATION_FONT		"-adobe-helvetica-medium-r-normal-*-12-*-*-*-p-*-iso8859-1"


/*
 *	Default Archiver gGometry:
 */
#define EDV_DEF_ARCHIVER_WIDTH		640
#define EDV_DEF_ARCHIVER_HEIGHT		480


/*
 *	Default Recycle Bin Geometry:
 */
#define EDV_DEF_RECBIN_WIDTH		640
#define EDV_DEF_RECBIN_HEIGHT		480


/*
 *	Default Find Window Geometry:
 */
#define EDV_DEF_FINDWIN_WIDTH		640
#define EDV_DEF_FINDWIN_HEIGHT		400


/*
 *	GdkColor initializer values:
 *
 *	These are used mostly in GtkCList cell styles.
 *
 *	The values should be formatted initialze the GdkColor structure.
 */
#define EDV_GDKCOLOR_BLACK			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_WHITE			\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(1.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_LIGHT_GREY			\
{       (gulong)0,                              \
        (gushort)(0.75f * (gushort)-1),		\
        (gushort)(0.75f * (gushort)-1),		\
        (gushort)(0.75f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_GREY			\
{       (gulong)0,                              \
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_GREY			\
{       (gulong)0,                              \
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_RED			\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_RED			\
{	(gulong)0,				\
	(gushort)(0.5f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_ORANGE			\
{       (gulong)0,				\
        (gushort)(1.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_ORANGE		\
{       (gulong)0,				\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.25f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_YELLOW                     \
{       (gulong)0,                              \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_MEDIUM_YELLOW		\
{	(gulong)0,				\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_YELLOW                \
{       (gulong)0,                              \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_GREEN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_MEDIUM_GREEN		\
{	(gulong)0,				\
	(gushort)(0.0f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_GREEN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_CYAN			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(1.0f * (gushort)-1),		\
        (gushort)(1.0f * (gushort)-1)		\
}
#define EDV_GDKCOLOR_DARK_CYAN			\
{       (gulong)0,				\
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1),		\
}
#define EDV_GDKCOLOR_BLUE			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_DARK_BLUE			\
{       (gulong)0,                              \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(0.5f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_PURPLE			\
{       (gulong)0,                              \
        (gushort)(1.0f * (gushort)-1),          \
        (gushort)(0.0f * (gushort)-1),          \
        (gushort)(1.0f * (gushort)-1)           \
}
#define EDV_GDKCOLOR_DARK_PURPLE		\
{       (gulong)0,				\
        (gushort)(0.5f * (gushort)-1),		\
        (gushort)(0.0f * (gushort)-1),		\
        (gushort)(0.5f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_NO_ACCESS_FG	EDV_GDKCOLOR_RED
#define EDV_GDKCOLOR_NO_ACCESS_FG_SELECTED	EDV_GDKCOLOR_RED
#define EDV_GDKCOLOR_NO_ACCESS_FG_INSENSITIVE	\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.5f * (gushort)-1),		\
	(gushort)(0.5f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_DANGLING_LINK_FG	EDV_GDKCOLOR_GREY
#define EDV_GDKCOLOR_DANGLING_LINK_FG_SELECTED	EDV_GDKCOLOR_LIGHT_GREY
#define EDV_GDKCOLOR_DANGLING_LINK_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY

#define EDV_GDKCOLOR_RECURSIVE_LINK_FG	EDV_GDKCOLOR_ORANGE
#define EDV_GDKCOLOR_RECURSIVE_LINK_FG_SELECTED	EDV_GDKCOLOR_ORANGE
#define EDV_GDKCOLOR_RECURSIVE_LINK_FG_INSENSITIVE	\
{	(gulong)0,				\
	(gushort)(1.0f * (gushort)-1),		\
	(gushort)(0.75f * (gushort)-1),		\
	(gushort)(0.25f * (gushort)-1)		\
}

#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG	EDV_GDKCOLOR_LIGHT_GREY
#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG_SELECTED	EDV_GDKCOLOR_WHITE
#define EDV_GDKCOLOR_HIDDEN_OBJECT_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY

#define EDV_GDKCOLOR_EXECUTABLE_FG	EDV_GDKCOLOR_MEDIUM_GREEN
#define EDV_GDKCOLOR_EXECUTABLE_FG_SELECTED	EDV_GDKCOLOR_GREEN
#define EDV_GDKCOLOR_EXECUTABLE_FG_INSENSITIVE	EDV_GDKCOLOR_LIGHT_GREY


/*
 *	Drag & Drop Target Type Names & Info Values:
 */
#define EDV_DND_TYPE_INFO_TEXT_PLAIN		0	/* "text/plain" */
#define EDV_DND_TYPE_INFO_TEXT_URI_LIST		1	/* "text/uri-list" */
#define EDV_DND_TYPE_INFO_STRING		2	/* "STRING" */

#define EDV_DND_TYPE_INFO_RECYCLED_OBJECT	3
#define EDV_DND_TYPE_STRING_RECYCLED_OBJECT	"endeavour_recycled_object"

#define EDV_DND_TYPE_INFO_ARCHIVE_OBJECT	4
#define EDV_DND_TYPE_STRING_ARCHIVE_OBJECT	"endeavour_archive_object"


/*
 *	List of disk object paths (always absolute path) that may never
 *	be deleted. Each entry consists of three pointers, the first
 *	pointer points to the full path of the disk object, the second is
 *	a pointer to an error message string that should be displayed if
 *	the object was attempted to be deleted, and the third pointer is
 *	casted to a gint to indicate an error level code from 0 to 2.
 *
 *	Error level code 0 means can delete and only print warning.
 *	Error level code 1 means can delete and ask user for confirmation.
 *	Error level code 2 means can never be deleted.
 *
 *	Last entry is a set of three NULL pointers.
 *
 *	In addition the user's home directory, endeavour local data 
 *	directory, and recycled objects directory objects may not be 
 *	deleted.
 */
#define EDV_NO_DELETE_LIST	{				\
{ "/",		"Virtual File System (VFS) toplevel directory", 2 },	\
{ "/bin",	"System programs directory", 1 },			\
{ "/etc",	"System configuration directory", 1 },		\
{ "/lib",	"System library directory", 1 },		\
{ "/sbin",	"System server programs directory", 1 },	\
{ "/tmp",	"System tempory files directory", 1 },		\
{ "/home",	"Home directories for users", 1 },		\
{ "/usr",	"System user directory", 1 },			\
{ "/var",	"System runtime files directory", 1 },		\
{ NULL,		NULL, 0 }					\
}

/*
 *	Stdout Help Message:
 */
#if defined(PROG_LANGUAGE_SPANISH)
#define PROG_HELP_MESG	"\
El uso: endeavour2 [path] [options] [GUI_options]\n\
\n\
    [path] especifica el sendero a una ubicacin alterna del startup.\n\
\n\
    [options] puede ser cualquiera del siguiente:\n\
\n\
        --config <file>         Cargue configuracin de <file>.\n\
        --rcfile                Mismo que --config.\n\
        -f                      Mismo que --config.\n\
        --no-splash             No muestre splash en el comienzo.\n\
        --no-stdout-dialog      No muestre stdout los mensajes en un\n\
                                dia'logo.\n\
        --no-stderr-dialog      No muestre stderr los mensajes en un\n\
                                dia'logo.\n\
        --file-browser          Arranque con el File Browser.\n\
        --image-browser         Arranque con el Image Browser.\n\
        --archiver              Arranque con el Archiver.\n\
        --recycle-bin           Arranque con el Recycle Bin.\n\
        --properties            Arranque con el Properties Dialog.\n\
        --options               Arranque con el Options Window.\n\
        --customize             Arranque con el Customize Window.\n\
        --devices               Arranque con el Devices List.\n\
        --mimetypes             Arranque con el MIME Types List.\n\
        --run-dialog            Arranque con el Run Dialog.\n\
        --about-dialog          Arranque con el About Dialog.\n\
        --help                  La pantalla de la ayuda de impresiones\n\
                                (esto) y salidas.\n\
        --version               La informacin de la versin de\n\
                                impresiones y salidas.\n\
\n\
    LA MAYORIA de LOS customizations se pueden realizar en el customize\n\
    y opciones ventanas, ven men de Colocaciones.\n\
\n\
    las opciones de la linea de la Orden hacen caso omiso cualquier\n\
    opcin en la configuracin el archivo.\n\
\n\
    [GUI_options] puede ser cualquier estndar de las opcin a su GUI,\n\
    consulta su manual de GUI para opciones disponibles.\n\
\n"
#elif defined(PROG_LANGUAGE_FRENCH)
#define PROG_HELP_MESG  "\
Usage: endeavour2 [path] [options] [GUI_options]\n\
\n\
    [path] spcifie le sentier  un emplacement de dmarrage.\n\
\n\
    [options] peut tre n'importe quel du suivre:\n\
\n\
        --config <file>         Charger la configuration de <file>.\n\
        --rcfile                Mme comme --config.\n\
        -f                      Mme comme --config.\n\
        --no-splash             Pas splash de spectacle sur le de'but.\n\
        --no-stdout-dialog      Pas les messages de stdout de spectacle\n\
                                dans un dialogue.\n\
        --no-stderr-dialog      Pas les messages de stderr de spectacle\n\
                                dans un dialogue.\n\
        --file-browser          Le dmarrage avec le File Browser.\n\
        --image-browser         Le dmarrage avec le Image Browser.\n\
        --archiver              Le dmarrage avec le Archiver.\n\
        --recycle-bin           Le dmarrage avec le Recycle Bin.\n\
        --properties            Le dmarrage avec le Properties Dialog.\n\
        --options               Le dmarrage avec le Options Window.\n\
        --customize             Le dmarrage avec le Customize Window.\n\
        --devices               Le dmarrage avec le Devices List.\n\
        --mimetypes             Le dmarrage avec le MIME Types List.\n\
        --run-dialog            Le dmarrage avec le Run Dialog.\n\
        --about-dialog          Le dmarrage avec le About Dialog.\n\
        --help                  Caractres (ceci) aide cran et sorties.\n\
        --version               Caractres information de version et\n\
                                sorties.\n\
\n\
    La plupart des customizations peut tre excut dans le personnalise\n\
    de le et les fentres d'options, voir du menu de Montages.\n\
\n\
    Les options de ligne d'ordre annulent n'importe quelles options dans le\n\
    fichier de configuration.\n\
\n\
    [GUI_options] peut tre n'importe quelle norme d'options\n\
     votre GUI, consulter le manuel de votre GUI pour les options\n\
    disponibles.\n\
\n"
#else
#define PROG_HELP_MESG  "\
Usage: endeavour2 [path] [options] [GUI_options]\n\
\n\
    [path] specifies the path to an alternate startup location.\n\
\n\
    [options] can be any of the following:\n\
\n\
        --config <file>         Load configuration from <file>.\n\
        --rcfile                Same as --config.\n\
        -f                      Same as --config.\n\
        --no-splash             Do not show splash on startup.\n\
        --no-stdout-dialog      Do not show stdout messages in a dialog.\n\
        --no-stderr-dialog      Do not show stderr messages in a dialog.\n\
        --file-browser          Start up with the File Browser.\n\
        --image-browser         Start up with the Image Browser.\n\
        --archiver              Start up with the Archiver.\n\
        --recycle-bin           Start up with the Recycle Bin.\n\
        --properties            Start up with the Properties Dialog.\n\
        --options               Start up with the Options Window.\n\
        --customize             Start up with the Customize Window.\n\
        --devices               Start up with the Devices List.\n\
        --mimetypes             Start up with the MIME Types List.\n\
        --run-dialog            Start up with the Run Dialog.\n\
        --about-dialog          Start up with the About Dialog.\n\
        --help                  Prints (this) help screen and exits.\n\
        --version               Prints version information and exits.\n\
\n\
    [GUI_options] can be any of the following\n\
\n\
        --geometry <WxH+X+Y>    Specifies the geometry of the main windows.\n\
        --font <font>           Specifies the font to be used for the lists.\n\
        --fg <color>            Specifies the foreground color for the lists.\n\
        --bg <color>            Specifies the background color for the lists.\n\
        --sfg <color>           Specifies the selected foreground color for\n\
                                the lists.\n\
        --sbg <color>           Specifies the selected background color for\n\
                                the lists.\n\
        --cfg <color>           Specifies the pointer cursor's foreground\n\
                                color.\n\
        --cbg <color>           Specifies the pointer cursor's background\n\
                                color.\n\
        --bg-pixmap <path>      Specifies the background pixmap for the lists.\n\
        --sbg-pixmap <path>     Specifies the selected background pixmap for\n\
                                the lists.\n\
        --name <name>           Specifies the WM window name.\n\
        --class <class>         Specifies the WM class name.\n\
        --title <title>         Specifies the title string to be displayed\n\
                                on the title bars of all major windows.\n\
\n\
    Most customizations can be performed in the Customize and Options\n\
    windows (under the Settings menu).\n\
\n\
    Command line options override any options in the configuration file.\n\
\n\
    [GUI_options] can be any options standard to your GUI, consult your\n\
    GUI's manual for available options.\n\
\n"
#endif


#endif	/* CONFIG_H */
