/**
* Copyright 1981-2007 ECMWF
* 
* Licensed under the GNU Lesser General Public License which
* incorporates the terms and conditions of version 3 of the GNU
* General Public License.
* See LICENSE and gpl-3.0.txt for details.
*/

#include <stdio.h>
#include <sys/times.h>
#include <time.h>

#ifndef CRAY
#include <unistd.h>
#endif

#ifndef CRAY
#ifdef FORTRAN_NO_UNDERSCORE
#define JTIMER jtimer
#else
#define JTIMER jtimer_
#endif
#endif

void JTIMER(const long * param)
{
static struct tms before, after;
static time_t utime, stime;
static long startime, endtime;

/*  If input parameter is zero, initialise the time record */
    if ( *param == 0 )
    {
      startime = times(&before);
    }

/*  Otherwise, publish elapsed time since last initialisation */
    else
    {
      endtime = times(&after);
  
      utime = after.tms_utime - before.tms_utime;
      stime = after.tms_stime - before.tms_stime;
/* Sinisa  CLOCKS_PER_SEC
    The value of this macro is the number of clock ticks per second measured by the clock function. 

	int CLK_TCK is an obsolete name for CLOCKS_PER_SEC. 
*/
      printf("CPU time used in user space = %f sec\n", 
             (float) utime/(float)CLOCKS_PER_SEC);
      printf("CPU time used by the system = %f sec\n", 
             (float) stime/(float)CLOCKS_PER_SEC);
      printf("Wall clock time used by process = %f sec\n", 
             (float) (endtime - startime)/(float)CLOCKS_PER_SEC);
    }

    return;

}
