C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION IRDIWE (KLLEN, KINS, KNSIND, KONS, KILONG,
     1   KIWE, KOLONG, KOWE, KWEIND, KWEDIST, KPR, KERR)
C
C---->
C**** *IRDIWE*
C
C     PURPOSE
C     _______
C
C     Calculate the distances between points in an output longitude
C     array and its West and East neighbours in the input longitude
C     array for a quasi regular input field and regular output field.
C
C     INTERFACE
C     _________
C
C     IERR = IRDIWE (KLLEN, KINS, KNSIND, KONS, KILONG, KIWE, KOLONG,
C    1   KOWE, KWEIND, KWEDIST, KPR, KERR)
C
C     Input parameters
C     ________________
C
C     KLLEN      - This array contains the quasi regular Gaussian
C                  line length definition.
C
C     KINS       - The number of points in the North-South direction
C                  in the input field.
C
C     KNSIND     - This array will contain the array offsets of the
C                  North and South points in the input array required
C                  for interpolation.
C
C     KONS       - The number of points in the North-South direction
C                  in the output field.
C
C     KILONG     - The array of input longitudes.
C
C     KIWE       - The maximum number of points in the West-East
C                  direction for this quasi regular Gaussian grid.
C
C     KOLONG     - The array of output longitudes.
C
C     KOWE       - The number of points in the West-East direction in
C                  the output field.
C
C     KPR        - The debug print switch.
C                  0  , No debugging output.
C                  1  , Produce debugging output.
C
C     KERR       - The error control flag.
C                  -ve, No error message. Return error code.
C                  0  , Hard failure with error message.
C                  +ve, Print error message. Return error code.
C
C     Output parameters
C     ________________
C
C     KWEIND     - This array will contain the array offsets of
C                  the West and East points in the input array
C                  required for interpolation for all lines of
C                  latitude.
C
C     KWEDIST    - This array holds the distances to longitude values
C                  in the input field from the associated longitude
C                  values in the output field. This array is
C                  dimensioned (2, KOWE, 2, KONS).
C
C     Return value
C     ____________
C
C     The error indicator (INTEGER).
C
C     Error and Warning Return Values
C     _______________________________
C
C     None
C
C     Common block usage
C     __________________
C
C     None
C
C     EXTERNALS
C     _________
C
C     IGDIWE     - Calculate the distances between points in an
C                  output longitude array and its West and East
C                  neighbours in the input longitude array for one
C                  line of latitude.
C     INTLOG(R)    - Logs messages.
C
C     METHOD
C     ______
C
C     This routine will create the arrays of offsets and distance as
C     two arrays of length (2, Number of output longitudes, 2,
C     Number of output latitudes).
C
C     The array of offsets is copied from line to line provided the
C     number of points in the quasi regular lines of latitude does
C     not change. When the definition changes IGDIWE is used to
C     generate the offsets and distances for the new line definition.
C
C     REFERENCE
C     _________
C
C     None
C
C     COMMENTS
C     ________
C
C     Program contains sections 0 to 2 and 9
C
C     AUTHOR
C     ______
C
C     K. Fielding      *ECMWF*      Nov 1993
C
C     MODIFICATIONS
C     _____________
C
C     None
C
C----<
C     _______________________________________________________
C
C*    Section 0. Definition of variables.
C     _______________________________________________________
C
C*    Prefix conventions for variable names
C
C     Logical      L (but not LP), global or common.
C                  O, dummy argument
C                  G, local variable
C                  LP, parameter.
C     Character    C, global or common.
C                  H, dummy argument
C                  Y (but not YP), local variable
C                  YP, parameter.
C     Integer      M and N, global or common.
C                  K, dummy argument
C                  I, local variable
C                  J (but not JP), loop control
C                  JP, parameter.
C     REAL         A to F and Q to X, global or common.
C                  P (but not PP), dummy argument
C                  Z, local variable
C                  PP, parameter.
C
C     Implicit statement to force declarations
C
      IMPLICIT NONE
C
#include "parim.h"
C
C     Dummy arguments
      INTEGER KINS, KONS, KIWE, KOWE, KPR, KERR
      INTEGER KLLEN (KINS)
      INTEGER KNSIND (2, KONS)
      INTEGER KILONG (KIWE + 1), KOLONG (KOWE)
      INTEGER KWEIND (2, KOWE, 2, KONS),
     1   KWEDIST (2, KOWE, 2, KONS)
C
C     Local variables
      LOGICAL GWEGLOBE
      INTEGER IIPLAT, IILON, ISTRIDE, IPR, IERR
      INTEGER IBLON, IBNS, IBLAT
      INTEGER JLAT, JLON, JNS, JWE
      INTEGER JPROUTINE
      PARAMETER (JPROUTINE = 23900)
C
C     External functions
      INTEGER IGDIWE
C
C     _______________________________________________________
C
C*    Section 1. Initialisation
C     _______________________________________________________
C
  100 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IRDIWE: Section 1.',JPQUIET)
C
      IRDIWE = 0
C
      IF (KPR .GE. 1) THEN
        CALL INTLOG(JP_DEBUG,'IRDIWE: Input parameters.',JPQUIET)
        CALL INTLOG(JP_DEBUG,'IRDIWE: Max no.input longs = ',KIWE)
        CALL INTLOG(JP_DEBUG,'IRDIWE: No.input lats = ',KINS)
        CALL INTLOG(JP_DEBUG,'IRDIWE: No.output longs = ',KOWE)
        CALL INTLOG(JP_DEBUG,'IRDIWE: No.output lats = ',KONS)
        CALL INTLOG(JP_DEBUG,'IRDIWE: Output field spread = ',KOLONG(1))
        CALL INTLOG(JP_DEBUG,'IRDIWE: to ',KOLONG(KOWE))
      ENDIF
C
      GWEGLOBE = .TRUE.
C
      IBLON = 0
C
      IERR = 0
C
C     _______________________________________________________
C
C*    Section 2. Generate distances and points for all lines
C                of latitude
C     _______________________________________________________
C
  200 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IRDIWE: Section 2.',JPQUIET)
C
      IPR = KPR
      IBLAT = 1
      IBNS  = 1
C
      DO 250 JLAT = 1, KONS
C
         DO 240 JNS = 1, 2
C
            IIPLAT = KNSIND (JNS, JLAT)
            IILON = KLLEN (IIPLAT)
C
            IF (IILON .EQ. IBLON) THEN
C
C     Same line definition as last one calculated
C
               DO 220 JWE = 1, 2
                  DO 210 JLON = 1, KOWE
C
                     KWEIND (JWE, JLON, JNS, JLAT) =
     1                  KWEIND (JWE, JLON, IBNS, IBLAT)
                     KWEDIST (JWE, JLON, JNS, JLAT) =
     1                  KWEDIST (JWE, JLON, IBNS, IBLAT)
C
  210             CONTINUE
  220          CONTINUE
C
            ELSE
C
               IBLON = IILON
               IBNS = JNS
               IBLAT = JLAT
C
               ISTRIDE = JP360 / IILON
C
C     Generate longitude values for this line
C
               DO 230 JLON = 1, IILON
C
                  KILONG (JLON) = (JLON - 1) * ISTRIDE
C
  230          CONTINUE
C
C     Wrap around input grid to simplify routine IGDIWE
C
               KILONG (IILON + 1) = KILONG (1)
C
               IERR = IGDIWE (KILONG, IILON, KOLONG, KOWE, GWEGLOBE,
     1            KWEIND (1, 1, JNS, JLAT), KWEDIST (1, 1, JNS, JLAT),
     2            IPR, KERR)
C
               IF (IERR .GT. 0) THEN
                  IRDIWE = IERR
                  GO TO 900
               ENDIF
C
               IPR = KPR - 1
C
            ENDIF
C
  240    CONTINUE
C
  250 CONTINUE
C
C
C     _______________________________________________________
C
C*    Section 9. Return to calling routine. Format statements
C     _______________________________________________________
C
  900 CONTINUE
C
      IF (KPR.GE.1) CALL INTLOG(JP_DEBUG,'IRDIWE: Section 9.',JPQUIET)
C
C
      RETURN
      END
