C Copyright 1981-2007 ECMWF
C 
C Licensed under the GNU Lesser General Public License which
C incorporates the terms and conditions of version 3 of the GNU
C General Public License.
C See LICENSE and gpl-3.0.txt for details.
C

      INTEGER FUNCTION HGETLSM(KGAUSS,OLDLSM,KSIZE)
C
C---->
C**** HGETLSM
C
C     Purpose
C     -------
C
C     This routine reads a file of reduced gaussian field land-sea
C     mask values.
C
C
C     Interface
C     ---------
C
C     IRET = HGETLSM(KGAUSS,OLDLSM,KSIZE)
C
C
C     Input parameters
C     ----------------
C
C     KGAUSS - Gaussian number of the reduced gaussian field
C     KSIZE  - Number of bytes to read into OLDLSM
C
C
C     Output parameters
C     -----------------
C
C     OLDLSM - The array of values for the reduced gaussian field
C
C     Returns 0 if function successful, non-zero otherwise.
C
C     Common block usage
C     ------------------
C
C     None
C
C
C     Method
C     ------
C
C     Gets pathname from HIRLAM_LSM_PATH and reads land-sea mask
C     from a file.
C
C
C     Externals
C     ---------
C
C     GETENV  - Read environment variable
C     INTLOG  - Log error message.
C     PBOPEN  - Open land-sea mask file
C     PBREAD  - Read land-sea mask file
C     PBCLOSE - Close land-sea mask file
C
C
C     Reference
C     ---------
C
C     None.
C
C
C     Comments
C     --------
C
C     None.
C
C
C     Author
C     ------
C
C     J.D.Chambers      ECMWF      March 2001
C
C
C     Modifications
C     -------------
C
C     Replace PBOPEN, etc by PBOPEN3, etc on VPP.
C     J.D.Chambers      ECMWF      December 2001
C
C----<
C     -----------------------------------------------------------------|
C*    Section 0. Definition of variables.
C     -----------------------------------------------------------------|
C
      IMPLICIT NONE
C
#include "parim.h"
#include "nifld.common"
#include "nofld.common"
C
C     Function arguments
C
      INTEGER KGAUSS, KSIZE
      REAL OLDLSM(*)


C
C     Local variables
C
      CHARACTER*256 FILENAME
      CHARACTER*256 YPNORMAS,YENVBACK
      CHARACTER*56 YPNORMAL
      CHARACTER*7 VPP
      CHARACTER*4 YGAUSS
      INTEGER IOFFS, IOFFSET, IUNIT, IRET
      PARAMETER (YPNORMAL ='/usr/local/lib/metaps/tables/interpolation')

#ifdef TABLE_PATH
      DATA YPNORMAS / TABLE_PATH /
#else
      DATA YPNORMAS / '' /
#endif
C
C     -----------------------------------------------------------------|
C     Section 1.  Initialise.
C     -----------------------------------------------------------------|
C
  100 CONTINUE
C
      HGETLSM = 0
C
      CALL JDEBUG()
C
C     -----------------------------------------------------------------|
C     Section 2.  Build the land-sea mask file pathname
C     -----------------------------------------------------------------|
C
  200 CONTINUE
C
C
C     See if the environment variable points to a directory
C
C
      FILENAME = YPNORMAL
C
      IOFFSET = INDEX(YPNORMAS,' ') - 1
      IF(IOFFSET.GT.0) THEN
          FILENAME = YPNORMAS(1:IOFFSET)//'/land_sea_mask/'
      ENDIF

      CALL GETENV('HIRLAM_LSM_PATH', YENVBACK)
      IOFFSET = INDEX(YENVBACK,' ') - 1
      IF(IOFFSET.GT.0) THEN
          FILENAME = YENVBACK(1:IOFFSET)//'/land_sea_mask/'
      ENDIF
C
C     Complete the filename
C
      IOFFS = INDEX(FILENAME,' ')
      FILENAME(IOFFS:(IOFFS+7)) = '/LSM_GG_'
      IOFFS = INDEX(FILENAME,' ')
      WRITE(YGAUSS,'(I4.4)') KGAUSS
      FILENAME(IOFFS:(IOFFS+4)) = YGAUSS
C
      IOFFS = INDEX(FILENAME,' ')
      CALL INTLOG(JP_DEBUG,'HGETLSM: land-sea mask filename',JPQUIET)
      CALL INTLOG(JP_DEBUG,'HGETLSM: ' // FILENAME(1:(IOFFS-1)),JPQUIET)
C
C     -----------------------------------------------------------------|
C     Section 3.  Read the land-sea mask values
C     -----------------------------------------------------------------|
C
  300 CONTINUE
C
#ifdef __uxp__
      CALL PBOPEN3(IUNIT,FILENAME(1:(IOFFS-1)),'r',IRET)
#else
      CALL PBOPEN(IUNIT,FILENAME(1:(IOFFS-1)),'r',IRET)
#endif
      IF( IRET.NE.0 ) THEN
        CALL INTLOG(JP_DEBUG,'HGETLSM: PBOPEN Iret',IRET)
        CALL INTLOG(JP_DEBUG,'HGETLSM: PBOPEN failed',JPQUIET)
        HGETLSM = 3
        GOTO 900
      ENDIF
C
#ifdef __uxp__
      CALL PBREAD3(IUNIT,OLDLSM,KSIZE,IRET)
#else
      CALL PBREAD(IUNIT,OLDLSM,KSIZE,IRET)
#endif
      IF( IRET.NE.KSIZE ) THEN
        CALL INTLOG(JP_DEBUG,'HGETLSM: PBREAD failed',JPQUIET)
        HGETLSM = 3
        GOTO 900
      ENDIF
C
#ifdef __uxp__
      CALL PBCLOSE3(IUNIT,IRET)
#else
      CALL PBCLOSE(IUNIT,IRET)
#endif
      IF( IRET.NE.0 ) THEN
        CALL INTLOG(JP_DEBUG,'HGETLSM: PBCLOSE failed',JPQUIET)
        HGETLSM = 3
        GOTO 900
      ENDIF
C
C     -----------------------------------------------------------------|
C     Section 9.  Return.
C     -----------------------------------------------------------------|
C
  900 CONTINUE
C
      RETURN
      END
