/*
** 
** Copyright (C) 1993 Swedish University Network (SUNET)
** 
** 
** This program is developed by UDAC, Uppsala University by commission
** of the Swedish University Network (SUNET). 
** 
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITTNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
** 
** 
**                                           Martin.Wendel@its.uu.se
** 				             Torbjorn.Wictorin@its.uu.se
** 
**                                           ITS	
**                                           P.O. Box 887
**                                           S-751 08 Uppsala
**                                           Sweden
** 
*/
#include "emil.h"

void
check_bits(struct data *d)
{
  int offset;
  unsigned char *c;
#ifdef DEBUG
  int deb = 1;
  if (edebug)
    fprintf(stderr, "check_bits: encoding is set to %d, start %lu end %lu\n", d->encoding, d->bodystart, d->bodyend);
#endif
  
  if (d->encoding == 0)
    d->encoding = E7BIT;
  if (d->encoding == E7BIT)
    {
      for (offset = d->bodystart, c = d->contents + offset;
	   offset < d->bodyend;
	   offset++, c++)
	{
	  if (*c == '\0')
	    {
#ifdef DEBUG
	      if (edebug)
		fprintf(stderr, "-   checked 7bit, saw binary.\n");
#endif
	      d->encoding = EBINARY;
	      return;
	    }

	  if (*c & 0x80)
	    {
#ifdef DEBUG
	      if (edebug && deb)
		{
		  fprintf(stderr, "-   checked 7bit, saw 8bit.\n");
		  deb = 0;
		}
#endif
	      d->encoding = E8BIT;
	    }
	}
      return;
    }
  if (d->encoding == E8BIT)
    {
      for (offset = d->bodystart, c = d->contents + offset;
	   offset < d->bodyend;
	   offset++, c++)
	{
	  if (*c == '\0')
	    {
#ifdef DEBUG
	      if (edebug)
		fprintf(stderr, "-   checked 8bit, saw binary.\n");
#endif
	      d->encoding = EBINARY;
	      return;
	    }
	}
    }
  return;
}
