# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests import elisa_test_case
from elisa.core import interface_controller
from elisa.core import config, common

MASTER_SLAVE_CONF = """\
[general]
version = '%(version)s'
install_date = '%(install_date)s'
media_providers = []
metadata_providers = []
service_providers = []
player_engines = []
backends = ['backend1', 'backend2']
frontends = ['frontend1', 'frontend2', 'frontend3']

[backend1]
activity = 'test:elisa_activity'
input_providers = []
mvc_mappings = 'test_mvc_mappings.conf'

[backend2]
master = 'backend1'
mvc_mappings = 'test_mvc_mappings.conf'
input_providers = []

[frontend1]
backend = 'backend1'

[frontend2]
backend = 'backend1'

[frontend3]
backend = 'backend2'
"""

class TestInterfaceController(elisa_test_case.ElisaTestCase):

    def setUp(self):
        elisa_test_case.ElisaTestCase.setUp(self)
        self._interface_controller = common.application.interface_controller

    def test_wrong_backend(self):
        self.assertRaises(Exception, self._interface_controller._create_backend,
                          'boo')

    def test_wrong_frontend(self):
        self.assertRaises(Exception, self._interface_controller._create_frontend,
                          'boo')

    def test_start_stop(self):
        self._interface_controller.start()
        dfr = self._interface_controller.stop()

        def done(r):
            done.called = True

        done.called = False

        dfr.addCallback(done)
        dfr.addCallback(lambda r: self.check_called(done))
        return dfr

class TestMasterSlave(TestInterfaceController):
    default_config = MASTER_SLAVE_CONF
