# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2007 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 2.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
Exceptions for epm.
"""


class ServerError(Exception):
    """Raised when there is a communication problem with a remote server."""


class InstallationError(Exception):
    """Raised when something goes wrong while installing a plugin."""

class AlreadyInstalledError(InstallationError):
    """Raised when trying to install an already installed plugin, without
    requesting an upgrade."""

class UninstallationError(Exception):
    """Raised when something goes wrong while uninstalling a plugin."""


class UpgradeError(Exception):
    """Raised when something goes wrong while upgrading a plugin."""


class NothingToUpgradeError(UpgradeError):
    """Raised when trying to upgrade but there is nothing to do."""

class AlreadyUpToDate(Exception):
    """Raised when the plugins cache of the repository is already up-to-date"""
    
