# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Lionel Martin <lionel@fluendo.com>'
__maintainer2__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core.component import Component
from elisa.core.observers.observable import Observable


class Model(Component, Observable):
    """
    Holds data that can be rendered by several
    L{elisa.base_components.view.View}s.
    It is provided by L{elisa.base_components.activity.Activity} components
    that fill it with data they would like to be displayed.
    Models can inherit from each other to include more information and can
    also be composed of other models to build more complex screens.

    @ivar activity:        reference to the activity which created the Model
    @type activity:        L{elisa.base_components.activity.Activity}
    @ivar activate_action: action fired when the Model gets activated
    @type activate_action: L{elisa.base_components.action.Action}
    @ivar parent:          parent model; None if the model is a root
    @type parent:          L{elisa.base_components.model.Model}
    @ivar loading:         True if the model is not yet filled, False
                           otherwise
    @type loading:         boolean
    """

    def __init__(self):
        Component.__init__(self)
        Observable.__init__(self)

        self.activity = None
        self.activate_action = None
        self.parent = None
        self.loading = False
