from elisa.core.tests.component_test_case import ComponentTestCase

from elisa.plugins.xmlmenu.actions.enqueue_action import EnqueueAction

class SimpleModel(object):
    pass

class TestEnqueueAction(ComponentTestCase):

    component_class = EnqueueAction
    children = []

    def test_action(self):
        self.children = []

        for i in ('a','b', 'c'):
            model = SimpleModel()
            model.has_children = False
            model.uri = i
            self.children.append(model)

        playlist = []
        self.component.parent_model = self
        self.component.playlist_model = playlist
        self.component.empty_playlist_before = False
        self.component(self)
        self.assertEquals(len(playlist), 3)

    def test_clear_before(self):
        self.children = []
        playlist = ['a', 'b', 'c']
        self.component.parent_model = self
        self.component.playlist_model = playlist
        self.component.empty_playlist_before = True
        self.component(self)
        self.assertEquals(len(playlist), 0)

    def test_false_models(self):
        self.children = ['z']

        for i in ('a','b', 'c'):
            model = SimpleModel()
            model.has_children = False
            model.uri = i
            self.children.append(model)
        self.children.append('d')

        playlist = []
        self.component.parent_model = self
        self.component.playlist_model = playlist
        self.component.empty_playlist_before = False
        self.component(self)
        self.assertEquals(len(playlist), 3)


