from elisa.core.tests.elisa_test_case import BoilerPlateApp, DEFAULT_CONFIG, MAPPINGS

from elisa.core import common

from elisa.core.plugin_registry import ComponentNotFound
from twisted.trial.unittest import SkipTest

class SimpleList(list, object):
    # make it hash-able!
    def __hash__(self):
        return id(self)

class StupidModel(object):
    children = SimpleList()
    text = ''

class NodeBuilderTest(object):

    component_path = ''
    entry_identifiers = []


    def setUp(self):
        f = open('test_mvc_mappings.conf','w')
        f.write(MAPPINGS)
        f.close()
        
        common.set_application(BoilerPlateApp(DEFAULT_CONFIG,
                                        load_all_plugins=True))
        plugin_registry = common.application.plugin_registry
        self.xmlmenu = plugin_registry.create_component('xmlmenu:xmltreemenu_activity')

        # This is BAD!
        self.xmlmenu.player_model = None
        try:
            self.component = plugin_registry.create_component(self.component_path)
        except ComponentNotFound:
            raise SkipTest('component not found, maybe missing a dependency?')
            
        self.component.activity = self.xmlmenu
        self.component.model_configs = self.xmlmenu._model_configs

    def test_node_identifier(self):
        if len(self.entry_identifiers) == 0:
            return
        self.assertEquals(self.component.menu_entry_identifiers,
                                            self.entry_identifiers)
