/* $Id: Syntax.h,v 1.3 1997/07/31 14:24:43 uwe Exp $ */
/* Copyright, 1992, AG-Kastens, University Of Paderborn */

#ifndef SYNTAX_H
#define SYNTAX_H

#include "envmod.h"
#include "err.h"
#include "args.h"
#include "List.h"

#define NoProdKind	0
#define PlainProdKind	1
#define LISTOFProdKind	2
#define MulProdKind	3

#define IsTreeOrClassSym	0
#define IsTreeSym		1
#define IsClassSym		2
#define IsTreeAndClassSym	3

typedef struct {
  int		IsSymbol, Id;
  DefTableKey	Key;
  int		SyntPos;
  POSITION	*Coord;
} _PElem, *ProdElem;

#define NoIndex		-1

#define SYMBANY		-1
#define MANYROOTS	-1
#define SyntGenMark	0

extern void PutSymClass FEARGS(( int AtAppl, 
			       DefTableKey SymKey, DefTableKey GramKey ));

extern ProdElem MakeProdElem FEARGS(( int	IsSymbol, int Id,
				    DefTableKey	SyntKey,
				    int SyntPos, POSITION *Coord ));

extern void NewListProds 
	FEARGS(( DefTableKey listkey, DefTableKey listrulekey, 
		Environment env, POSITION *coord ));

extern DefTableKey NewElemProd 
	FEARGS(( DefTableKey listrulekey, DefTableKey listkey, DefTableKey elkey,
		Environment  env, POSITION *coord ));

extern int DifferentProds FEARGS(( TList p1, TList p2 ));

extern void LinkRule FEARGS(( DefTableKey rulekey ));

extern DefTableKey FindNamedProd FEARGS(( TList prod, Environment env, 
				        POSITION *Coord ));

extern int FindSymPos FEARGS(( DefTableKey Key, int Ind, 
			     TList Pro, POSITION *Coord ));

extern int IsInProd FEARGS(( DefTableKey Key, TList Pro));

extern int IsGenPos FEARGS(( TList Pro, int Pos));

extern void SetHEADTAILpos FEARGS(( DefTableKey rulekey ));

extern DefTableKey FindRuleForLhs FEARGS(( DefTableKey symb ));

extern DefTableKey FindSymbOfRulePos 
	FEARGS(( DefTableKey rule, int symbno ));

#endif


