-- Copyright 2000 Luc Taesch and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Top level class for Gnome applications"
	author: "Luc Taesch"
	date: "2000"
	cvs: "$Id: gnome_application.e,v 1.2 2002/02/26 16:47:26 elphick Exp $"

class GNOME_APPLICATION

inherit

	GNOME_APP_NON_PORTABLE_CALLS

feature {ANY} 
   
   initialize_gnome (app_id: STRING; app_version: STRING)  is 
			-- Initialise the Gnome environment; this must be called 
			-- before any other Gnome or GTK+ feature.
		do
			np_gnome_init_tool_kit (app_id, app_version)
		end

	ignore_sig_child is
			-- Use this call to avoid crashing out on receipt of a SIGCLD
			-- signal (as when GNOME_HELP is used to display help.)
		do
			c_ignore_sig_child
		end

feature {NONE}

	c_ignore_sig_child is
		external
			"C"
		end

end -- class GNOME_APPLICATION
