-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkViewport objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_viewport_writer.e,v 1.8 2000/08/31 14:02:17 elphick Exp $"

class GTK_VIEWPORT_WRITER

inherit

	GTK_BIN_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_VIEWPORT"
	
	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			shadow_type := widget_tree.get_string_from_field("shadow_type")
			create_child_class(widget_tree.find_child("widget"), 1)
			self_scrolling := True
		end
			
	shadow_type: STRING

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			Result := precursor
			!!temp.make_with_name("GTK_SHADOWTYPE_ENUM")
			temp.add_undefine_clause("is_equal, copy")
			Result.add(temp)
		end

	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make(default_pointer, default_pointer)")
			code.add_last(name + ".set_shadow_type(" + shadow_type + ")")
			add_widget_code(code)
			precursor(code)
		end

end
