-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for Gtk?Ruler objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_ruler_writer.e,v 1.4 2000/07/10 11:31:12 elphick Exp $"

deferred class GTK_RULER_WRITER

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation, parent_inherit
		end
	
	CHILD

feature

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			metric := widget_tree.get_string_from_field("metric")
			lower := widget_tree.get_real_string_from_field("lower")
			upper := widget_tree.get_real_string_from_field("upper")
			position := widget_tree.get_real_string_from_field("position")
			max_size := widget_tree.get_real_string_from_field("max_size")
		end
			
	metric: STRING
	lower: STRING
	upper: STRING
	position: STRING
	max_size: STRING
	
	append_parent_creation(code: ARRAY[STRING]) is
		do
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".set_metric("+metric+")")
			code.add_last(name + ".set_range("+lower+", "+upper+", "+position+", "+max_size+")")
			add_widget_code(code)
		end

	parent_inherit: INHERIT_LIST is
		local
			temp: KLASS
		do
			!!temp.make_with_name("GTK_RULER_EXTERNALS")
			temp.add_undefine_clause("copy, is_equal")
			!!Result.make
			Result.add(temp)
		end

end
