-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Writes source files for GtkCalendar objects"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: gtk_calendar_writer.e,v 1.4 2000/07/10 11:31:11 elphick Exp $"

class GTK_CALENDAR_WRITER
-- Need to make parent class inherit from gtk_calendar_externals to get
-- constants

inherit

	GTK_ATTRIBUTE_WRITER
		rename
			make as make_attribute
		redefine
			append_parent_creation
		end

	CHILD

creation

	make

feature

	type: STRING is "GTK_CALENDAR"

	make(attr_name: STRING; tree: TAG_TREE; src: STRING) is
		do
			make_attribute(attr_name, tree, src)
			show_heading := widget_tree.get_boolean_from_field("show_heading", True)
			show_day_names := widget_tree.get_boolean_from_field("show_day_names", True)
			no_month_change := widget_tree.get_boolean_from_field("no_month_change", False)
			show_week_numbers := widget_tree.get_boolean_from_field("show_week_numbers", False)
			week_start_monday := widget_tree.get_boolean_from_field("week_start_monday", False)
		end
			
	show_heading: BOOLEAN
	show_day_names: BOOLEAN
	no_month_change: BOOLEAN
	show_week_numbers: BOOLEAN
	week_start_monday: BOOLEAN
	
	append_parent_creation(code: ARRAY[STRING]) is
		local
			options: STRING
		do
			if show_heading then
				options := "Gtk_calendar_show_heading"
			end
			if show_day_names then
				if options = Void then
					options := "Gtk_calendar_show_day_names"
				else
					options.append(" + Gtk_calendar_show_day_names")
				end
			end
			if no_month_change then
				if options = Void then
					options := "Gtk_calendar_no_month_change"
				else
					options.append(" + Gtk_calendar_no_month_change")
				end
			end
			if show_week_numbers then
				if options = Void then
					options := "Gtk_calendar_show_week_numbers"
				else
					options.append(" + Gtk_calendar_show_week_numbers")
				end
			end
			if week_start_monday then
				if options = Void then
					options := "Gtk_calendar_week_start_monday"
				else
					options.append(" + Gtk_calendar_week_start_monday")
				end
			elseif options = Void then
				options := "0"
			end
					
			code.add_last("!!" + name + ".make")
			code.add_last(name + ".display_options(" + options +")")
			add_widget_code(code)
		end

end
