-- Copyright (C) 1999 Daniel Elphick and others
-- Licensed under Eiffel Forum Freeware License, version 1;
-- (see forum.txt)
--
indexing

	description: "Use this to set the classes that a parent must inherit from"
	author: "Daniel Elphick <de397@ecs.soton.ac.uk>"
	cvs: "$Id: inherit_list.e,v 1.5 2000/07/10 11:31:10 elphick Exp $"

class INHERIT_LIST

inherit
	MISC

creation
	
	make

feature

	empty: BOOLEAN is
		do
			Result := list.is_empty
		end
	
	lower: INTEGER is
		do
			Result := list.lower
		end

	upper: INTEGER is
		do
			Result := list.upper
		end

	merge_with(other: INHERIT_LIST) is
		require
			valid_other: other /= Void
		local
			i: INTEGER
		do
			from
				i := other.lower
			variant
				other.upper - i + 1
			until
				i > other.upper
			loop
				add(other @ i)
				i := i + 1
			end
		end
	
	add(klass: KLASS) is
		require
			valid_klass: klass /= Void
		do
			if not list.has(klass) then
				list.add_last(klass)
			end 
		ensure
			klass_added: list.has(klass)
		end

	get_array: ARRAY[STRING] is
		local
			i: INTEGER
		do
			if list.count > 0 then
				Result := (list @ lower).get_inherit_details
				if list.count > 1 then
					from
						i := 1
					until 
						i >= list.count
					loop
						Result.add_last("")
						append_arrays(Result,
									  (list @ (lower + i)).get_inherit_details)
						i := i + 1
					end
				end
			end
		end

feature {INHERIT_LIST}

	infix "@" (index: INTEGER): KLASS is
		require
			valid_index: index >= lower and index <= upper
		do
			Result := list @ index
		end

feature {NONE}

	list: ARRAY[KLASS]

	make is
		do
			!!list.make(1,0)
		end

end
