/* This file is part of EdiTeX, an editor of mathematical
 * expressions based on TeX syntax.
 * 
 * Copyright (C) 2002-2003 Luca Padovani <lpadovan@cs.unibo.it>,
 *                    2003 Paolo Marinelli <pmarinel@cs.unibo.it>.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * For more information, please visit the project's home page
 * http://helm.cs.unibo.it/editex/
 * or send an email to <lpadovan@cs.unibo.it>
 */

#ifndef __Diff_hh__
#define __Diff_hh__

#include <GdomeSmartDOM.hh>

#define XMLNS_NS_URI "http://www.w3.org/2000/xmlns/"
#define DDIFF_NS_URI "http://helm.cs.unibo.it/2002/DDIFF"

namespace GdomeSmartDOMExt
{
 
  using namespace GdomeSmartDOM;

  class Diff
  {
  public:
    typedef bool (*flatNodeEq)(const Node&, const Node&);
    static bool defaultFlatNodeEq(const Node&, const Node&);

  private:
    Diff(const Node& n, const Document& d, flatNodeEq e) : dest(n), doc(d), eq(e) { };

  public:
    static Diff diff(const Document&, const Document&, flatNodeEq = defaultFlatNodeEq);
    static Diff diff(const Element&, const Element&, flatNodeEq = defaultFlatNodeEq);

    Document document(void) const { return doc; };
    Node     node(void) const { return dest; };

    void patch(void) const;

    struct BADDiff
    {
      BADDiff(const std::string& s) : msg(s) { };
      const std::string msg;
    };

  private:
    Node diffNodes(const Node&, const Node&) const;
    bool diffChildren(const Node&, const Node&, const Node&) const;
    void sameChunk(const Node&, unsigned long) const;
    void patchRootNode(const Node&, const Element&) const;
    void patchChildren(const Node&, const Element&) const;

    Document   doc;
    Node       dest;
    flatNodeEq eq;
  };

}

#endif // __ddiff_hh__
