// ------------------------------------------------------------------------
// qeobjectmap.cpp: Object map input widget
// Copyright (C) 2000,2001 Kai Vehmanen (kaiv@wakkanet.fi)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
// ------------------------------------------------------------------------

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qaccel.h>
#include <qlayout.h>
#include <qlistbox.h>
#include <qlabel.h>
#include <qvgroupbox.h>
#include <qhgroupbox.h>
#include <qhbox.h>
#include <qgrid.h>

#include <iostream>
#include <list>
#include <map>
#include <string>

#include <kvu_dbc.h>

#include <eca-object.h>
#include <eca-object-map.h>
#include <eca-version.h>

#include "qeobjectmap.h"

using std::list;
using std::map;
using std::string;

QEObjectMap::QEObjectMap (const ECA_OBJECT_MAP* omap, QWidget *parent, const char *name) 
  : QEInput(parent, name),
    omap_rep(omap) {
  init_layout();
}

QEObjectMap::~QEObjectMap(void) { }

void QEObjectMap::init_layout(void) {
  QBoxLayout* top = new QVBoxLayout(this);

  QGroupBox* objgroup = new QVGroupBox(this, "objgroup");
  QListBox* objlist = new QListBox(objgroup, "objlist");

  empty_rep = false;
  objlist->insertItem("<none>");

#if ECA_LIBECASOUND_VERSION > 7
  const list<string>& omap = omap_rep->registered_objects();
  list<string>::const_iterator p = omap.begin();
#else
  const map<string,string>& omap = omap_rep->registered_objects();
  map<string,string>::const_iterator p = omap.begin();
#endif
  while(p != omap.end()) {
#if ECA_LIBECASOUND_VERSION > 7
    const ECA_OBJECT* obj = omap_rep->object(*p);
    if (obj != 0) 
      objlist->insertItem(obj->name().c_str());
    else
      objlist->insertItem(p->c_str());
#else
    objlist->insertItem(p->second.c_str());
#endif
    ++p;
  }
  if (omap.size() == 0) empty_rep = true;
  top->addWidget(objgroup);

  objlist->setSelected(0, true);
  update_object(0);

  QObject::connect(objlist, SIGNAL(highlighted(int)), this, SLOT(update_object(int)));
}

void QEObjectMap::update_results(void) {}
void QEObjectMap::update_object(int index) {
  // --------
  DBC_REQUIRE(index >= 0);
  // --------

  object_rep = 0;

#if ECA_LIBECASOUND_VERSION > 7
  const list<string>& omap = omap_rep->registered_objects();
  list<string>::const_iterator p = omap.begin();
#else
  const map<string,string>& omap = omap_rep->registered_objects();
  map<string,string>::const_iterator p = omap.begin();
#endif
  if (index > 0) { /* the first object is always null */
    int counter = 1;
    while(p != omap.end()) {
      if (counter == index) {
#if ECA_LIBECASOUND_VERSION > 7
	object_rep = dynamic_cast<const ECA_OBJECT*>(omap_rep->object(*p));
#else
	object_rep = dynamic_cast<const ECA_OBJECT*>(omap_rep->object(p->first, false));
#endif
	if (object_rep == 0) {
	  //  std::cerr << "(qeobjectmap) creation failed; " << *p << ".\n";
	  empty_rep = true;
	}
	emit changed();
      }
      ++p;
      ++counter;
    }
  }
  else {
    object_rep = 0;
    empty_rep = true;
    emit changed();
  }

  // --------
  DBC_ENSURE(object_rep != 0 || empty_rep == true);
  // --------
}
