/* $Id: ntext.h,v 1.4 2003/11/14 01:59:42 bergo Exp $ */

/*

    eboard - chess client
    http://eboard.sourceforge.net
    Copyright (C) 2000-2003 Felipe Paulo Guazzi Bergo
    bergo@seul.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#ifndef NTEXT_H
#define NTEXT_H 1

#include "widgetproxy.h"
#include "stl.h"

// line index
class NLine {
 public:
  unsigned int   Offset;
  int            Length;
  int            Color;
};

// secondary line index
class FLine : public NLine {
 public:
  int   SrcI;  
  int   X,Y,H; // position of last rendering
  bool  valid; // visible ?
};

// a point in the text (a selection has two of this)
class TPoint {
 public:
  TPoint();
  TPoint &operator=(TPoint &src);
  int     operator<(TPoint &src);
  int     operator==(TPoint &src);

  int     operator<(int i);
  int     operator<=(int i);
  int     operator>(int i);
  int     operator>=(int i);
  int     operator==(int i);

  int          SrcI, rs;
  unsigned int Offset, ro;
  int   X,Y;
  bool  atEOL;
};

// a decent text buffer widget
class NText : public WidgetProxy {
 public:
  NText();
  virtual ~NText();

  void setFont(GdkFont *f);
  void append(char *text, int len, int color);
  void pageUp(float pages);
  void pageDown(float pages);

  void lineUp(int n);
  void lineDown(int n);

  void gotoLine(int n);

  void setScrollBack(int n);
  void setBG(int c);

  bool findTextUpward(int top, int bottom, const char *needle, 
		      bool select=true);
  int  getLastFoundLine();
  
  bool saveTextBuffer(const char *path);


  virtual void repaint();
  void softRepaint();
  void safeSoftRepaint();
  void scheduleRepaint(int latency=100);

 private:

  void createGui();
  void formatLine(unsigned int i);
  void formatBuffer();
  void grow(int newsz);
  void setScroll(int topline, int linecount, int nlines);
  void discardLines(int n);
  void discardExcess(bool _repaint=false);
  bool calcTP(TPoint &t, int x,int y);
  void fixEOL();

  bool matchTextInLine(int i, const char *needle, bool select=true);
  void selectByOffset(int first, int last);

  deque<NLine>   lines;
  deque<FLine>   xlines;
  char          *textbuffer;
  int            buffersz, tlen;
  int            bgcolor;
  GdkFont       *font;
  GtkWidget     *body, *sb;
  GtkAdjustment *vsa;
  GdkPixmap     *canvas;
  GdkGC         *cgc;
  int            cw, ch, lw, lh, fmtw;
  int            fh;
  int            leftb, rightb;

  int            IgnoreChg;
  unsigned int   MaxLines;
  bool           WasAtBottom;

  /* selection handling */
  bool           havesel;
  TPoint         A,B;      // selection end points
  int            dropmup;

  int            toid;
  int            lfl;

  /* the usual callback friends */
  friend gboolean ntext_expose(GtkWidget *widget, GdkEventExpose *ee,
			       gpointer data);
  friend gboolean ntext_configure(GtkWidget *widget, GdkEventConfigure *ee,
				  gpointer data);
  friend void     ntext_sbchange(GtkAdjustment *adj, gpointer data);

  friend gboolean ntext_mdown(GtkWidget *widget, GdkEventButton *eb,
			      gpointer data);
  friend gboolean ntext_mup(GtkWidget *widget, GdkEventButton *eb,
			    gpointer data);
  friend gboolean ntext_mdrag(GtkWidget *widget, GdkEventMotion *em,
			      gpointer data);

  friend gboolean ntext_ksel(GtkWidget * widget,
			     GdkEventSelection * event, gpointer data);
  friend void     ntext_getsel(GtkWidget * widget,
			       GtkSelectionData * seldata,
			       guint info, guint time, gpointer data);

  friend gboolean ntext_redraw(gpointer data);
};

#endif
