/* prefs.c - 2000/05/06 */
/*
 *  EasyTAG - Tag editor for MP3 and OGG files
 *  Copyright (C) 2000  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <errno.h>
#include <stdlib.h>
#include <gdk/gdkkeysyms.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <string.h>

#include "prefs.h"
#include "setting.h"
#include "msgbox.h"
#include "bar.h"
#include "misc.h"
#include "scan.h"
#include "easytag.h"
#include "browser.h"
#include "charset.h"
#include "mylocale.h"
#include "../pixmaps/grab.xpm"


/***************
 * Declaration *
 ***************/
static GtkWidget *FileSelection = NULL;



/**************
 * Prototypes *
 **************/
/* Options window */
void OptionsWindow_Quit(void);
void OptionsWindow_Ok_Button(void);
void OptionsWindow_Save_Button(void);
void OptionsWindow_Cancel_Button(void);
void OptionsWindow_Key_Press (GtkWidget *window, GdkEvent *event);
gint Check_Config (void);

void Set_Main_Window_Size_Toggled (void);
void Get_Main_Window_Size (void);

void Set_Pane_Handle_Position1_Toggled (void);
void Get_Pane_Handle_Position1 (void);
void Set_Pane_Handle_Position2_Toggled (void);
void Get_Pane_Handle_Position2 (void);

void Scanner_Window_Position_Check_Button_Toggled (void) ;
void Get_Scanner_Window_Position (void);

void Set_Default_Comment_Check_Button_Toggled (void);

void Show_Command_Check_Button_Toggled (void);
void Use_Character_Set_Translation_Toggled (void);

void Scanner_Convert_Check_Button_Toggled_1 (GtkObject *object_rec, GtkObject *object_emi);

void Sorting_File_Option_Menu_Activate_Item (GtkWidget *widget, ET_Sorting_Type *st);

/* Browser */
static void Options_Browser_Open (GtkWidget *widget);
static void Options_Browser_Ok_Button (GtkWidget *widget);
void        Options_Browser_Destroy (void);


/*************
 * Functions *
 *************/
void Init_OptionsWindow (void)
{
    OptionsWindow = (GtkWidget *)NULL;
}

/*
 * The window for options
 */
#include "../pixmaps/spinner.xpm"
#include "../pixmaps/go.xpm"
#include "../pixmaps/first.xpm"
#include "../pixmaps/previous.xpm"
#include "../pixmaps/next.xpm"
#include "../pixmaps/last.xpm"
#include "../pixmaps/scan.xpm"
#include "../pixmaps/scan_all.xpm"
#include "../pixmaps/delete.xpm"
#include "../pixmaps/delete_all.xpm"
#include "../pixmaps/undo.xpm"
#include "../pixmaps/undo_all.xpm"
#include "../pixmaps/redo.xpm"
#include "../pixmaps/redo_all.xpm"
#include "../pixmaps/save.xpm"
#include "../pixmaps/save_all.xpm"
#include "../pixmaps/exit.xpm"
void Open_OptionsWindow (void)
{
    GtkWidget *OptionsVBox;
    GtkWidget *ButtonBox;
    GtkWidget *Button;
    GtkWidget *Label;
    GtkWidget *Frame;
    GtkWidget *VBox, *vbox;
    GtkWidget *HBox, *hbox;
    GtkWidget *Separator;
    GtkWidget *Table;
    GtkWidget *Icon;
    GtkWidget *Menu, *MenuItem;
    GtkTooltips *Tips;
    gchar temp[MAX_STRING_LEN];
    gchar *msg;
    GList *History_List;
    GList *list = NULL;

    /* Check if already opened */
    if (OptionsWindow)
    {
        gdk_window_show(OptionsWindow->window);
        return;
    }

    /* The window */
    OptionsWindow = gtk_window_new(GTK_WINDOW_DIALOG);
    /* Config */
    gtk_window_set_position(GTK_WINDOW(OptionsWindow),GTK_WIN_POS_CENTER);
    gtk_window_set_policy(GTK_WINDOW(OptionsWindow),FALSE,FALSE,FALSE);
    gtk_window_set_transient_for(GTK_WINDOW(OptionsWindow),GTK_WINDOW(MainWindow));
    gtk_container_border_width(GTK_CONTAINER(OptionsWindow),5);
    /* Title */
    gtk_window_set_title(GTK_WINDOW(OptionsWindow),_("Preferences..."));

    /* Signals connection */
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"destroy",(GtkSignalFunc)OptionsWindow_Quit,NULL);
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"delete_event",(GtkSignalFunc)OptionsWindow_Quit,NULL);
    gtk_signal_connect(GTK_OBJECT(OptionsWindow),"key_press_event",
                (GtkSignalFunc)OptionsWindow_Key_Press,NULL);

    Tips = gtk_tooltips_new_1();

     /* Options */
     /* The vbox */
    OptionsVBox = gtk_vbox_new(FALSE,0);
    gtk_box_set_spacing (GTK_BOX(OptionsVBox),5);
    gtk_container_add(GTK_CONTAINER(OptionsWindow),OptionsVBox);

     /* Options NoteBook */
    OptionsNoteBook = gtk_notebook_new();
    gtk_notebook_popup_enable(GTK_NOTEBOOK(OptionsNoteBook));
    gtk_box_pack_start(GTK_BOX(OptionsVBox),OptionsNoteBook,TRUE,TRUE,0);



    /*
     * Common
     */
    Label = gtk_label_new(_("Common"));
    Frame = gtk_frame_new(_("Common"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),5);


    /* File Browser frame */
    Frame = gtk_frame_new (_("File Browser"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);

    /* Browse subdirectories */
    BrowseSubdir = gtk_check_button_new_with_label(_("Search subdirectories"));
    gtk_box_pack_start(GTK_BOX(vbox),BrowseSubdir,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(BrowseSubdir),BROWSE_SUBDIR);
    gtk_tooltips_set_tip(Tips,BrowseSubdir,_("Search subdirectories for files when reading "
        "a directory into the tree."),NULL);

    /* Load directory on startup */
    /* Check box */
    LoadOnStartup = gtk_check_button_new_with_label(_("Load on startup the directory"));
    gtk_box_pack_start(GTK_BOX(vbox),LoadOnStartup,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(LoadOnStartup),LOAD_ON_STARTUP);
    gtk_tooltips_set_tip(Tips,LoadOnStartup,_("Automatically search files, when EasyTAG starts, "
        "into the following directory. Note that this path may be overriden by the parameter "
        "passed to easytag (easytag /path_to/mp3_files)."),NULL);

    HBox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(vbox),HBox,FALSE,FALSE,2);
    gtk_container_border_width(GTK_CONTAINER(HBox),2);
    /* Combo */
    DefaultPathToMp3 = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(HBox),DefaultPathToMp3,TRUE,TRUE,0);
    gtk_widget_set_usize(DefaultPathToMp3,400,-1);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(DefaultPathToMp3)->entry,_("Specify the directory where "
        "your files are located. This path will be load when EasyTAG starts without parameter."),NULL);
    /* History list */
    History_List = Load_Default_Path_To_MP3_List();
    History_List = Add_String_To_Glist (History_List,DEFAULT_PATH_TO_MP3);
    if (History_List)
        gtk_combo_set_popdown_strings(GTK_COMBO(DefaultPathToMp3),History_List);
    gtk_object_set_data(GTK_OBJECT(DefaultPathToMp3),"History",History_List);
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultPathToMp3)->entry)),"activate",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultPathToMp3));
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultPathToMp3)->entry)),"focus_out_event",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultPathToMp3));

    /* Button */
    Button = gtk_button_new_with_label(_(" Browse... "));
    gtk_box_pack_start(GTK_BOX(HBox),Button,FALSE,FALSE,0);
    gtk_signal_connect_object(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)Options_Browser_Open,
                                GTK_OBJECT(DefaultPathToMp3));

    /* Open the node to show subdirectories */
    OpenSelectedBrowserNode = gtk_check_button_new_with_label(_("Show sub-directories when selecting "
        "a directory"));
    gtk_box_pack_start(GTK_BOX(vbox),OpenSelectedBrowserNode,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OpenSelectedBrowserNode),OPEN_SELECTED_BROWSER_NODE);
    gtk_tooltips_set_tip(Tips,OpenSelectedBrowserNode,_("This expands the selected node into the file "
        "browser to display the sub-directories."),NULL);

    /* Load directory on startup */
    KeepTreeBrowserInMemory = gtk_check_button_new_with_label(_("Keep the tree browser in memory"));
    gtk_box_pack_start(GTK_BOX(vbox),KeepTreeBrowserInMemory,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(KeepTreeBrowserInMemory),KEEP_TREE_BROWSER_IN_MEMORY);
    gtk_tooltips_set_tip(Tips,KeepTreeBrowserInMemory,_("If activated, the subdirectories of a node "
        "aren't regenerated when collapsing and re-expanding this node."),NULL);


    HBox = gtk_hbox_new(FALSE,2);
    gtk_box_pack_start(GTK_BOX(vbox),HBox,FALSE,FALSE,0);
    gtk_container_border_width(GTK_CONTAINER(HBox),2);
    /* Sorting method */
    Label = gtk_label_new(_("Sort the file list by :"));
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    SortingFileOptionMenu = gtk_option_menu_new();
    gtk_box_pack_start(GTK_BOX(HBox),SortingFileOptionMenu,TRUE,TRUE,0);
    gtk_widget_set_usize(GTK_WIDGET(SortingFileOptionMenu),-1,25);
    /* Items of option menu */
    Menu = gtk_menu_new();
    MenuItem = gtk_menu_item_new_with_label(_("Ascending file name"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_FILENAME));
    MenuItem = gtk_menu_item_new_with_label(_("Descending file name"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_FILENAME));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending track number"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_TRACK_NUMBER));
    MenuItem = gtk_menu_item_new_with_label(_("Descending track number"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_TRACK_NUMBER));
    MenuItem = gtk_menu_item_new();
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    MenuItem = gtk_menu_item_new_with_label(_("Ascending creation date"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_ASCENDING_CREATION_DATE));
    MenuItem = gtk_menu_item_new_with_label(_("Descending creation date"));
    gtk_menu_append(GTK_MENU(Menu),MenuItem);
    gtk_signal_connect(GTK_OBJECT(MenuItem),"activate",
        (GtkSignalFunc)Sorting_File_Option_Menu_Activate_Item,
        GINT_TO_POINTER(SORTING_BY_DESCENDING_CREATION_DATE));
    gtk_option_menu_set_menu(GTK_OPTION_MENU(SortingFileOptionMenu),Menu);
    gtk_option_menu_set_history(GTK_OPTION_MENU(SortingFileOptionMenu),SORTING_FILE_MODE); // Cause items loaded in same order of enumeration
    gtk_tooltips_set_tip(Tips,SortingFileOptionMenu,_("Select the type of file sorting "
        "when loading a directory."),NULL);


    /* Tag Rules frame */
    Frame = gtk_frame_new (_("ID3 Tag Rules"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    /* Write ID3v1 tag */
    WriteId3v1Tag = gtk_check_button_new_with_label(_("Write ID3v1.x tag"));
    gtk_box_pack_start(GTK_BOX(vbox),WriteId3v1Tag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WriteId3v1Tag),WRITE_ID3V1_TAG);
    gtk_tooltips_set_tip(Tips,WriteId3v1Tag,_("If activated, an ID3v1 tag will be added or "
        "updated at the end of the MP3 files. Else it will be stripped."),NULL);
    /* Write ID3v2 tag */
    WriteId3v2Tag = gtk_check_button_new_with_label(_("Write ID3v2 tag"));
    gtk_box_pack_start(GTK_BOX(vbox),WriteId3v2Tag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(WriteId3v2Tag),WRITE_ID3V2_TAG);
    gtk_tooltips_set_tip(Tips,WriteId3v2Tag,_("If activated, an ID3v2 tag will be added or "
        "updated at the beginning of the MP3 files. Else it will be stripped."),NULL);
    /* Strip tag when fields (managed by EasyTAG) are empty */
    StripTagWhenEmptyFields = gtk_check_button_new_with_label(_("Strip tags if all fields are set to blank"));
    gtk_box_pack_start(GTK_BOX(vbox),StripTagWhenEmptyFields,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(StripTagWhenEmptyFields),STRIP_TAG_WHEN_EMPTY_FIELDS);
    gtk_tooltips_set_tip(Tips,StripTagWhenEmptyFields,_("As ID3v2 tags may contain other data "
        "than Title, Artist, Album, Year, Track, Genre or Comment, this option allows you to "
        "strip the whole tag when these seven standard data fields have been set to blank."),NULL);

    /* Save configuration */
    SaveConfigBeforeExit = gtk_check_button_new_with_label(_("Save the configuration before "
        "exiting the program"));
    gtk_box_pack_start(GTK_BOX(VBox),SaveConfigBeforeExit,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SaveConfigBeforeExit),SAVE_CONFIG_BEFORE_EXIT);
    gtk_tooltips_set_tip(Tips,SaveConfigBeforeExit,_("If activated, the configuration will be "
        "automatically saved before exiting the program."),NULL);



    /*
     * User Interface
     */
    Label = gtk_label_new (_("User Interface"));
    Frame = gtk_frame_new (_("User Interface"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),4);

    hbox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(VBox),hbox,FALSE,FALSE,0);
    /* Window size */
    SetMainWindowSize = gtk_check_button_new_with_label(_("Set main window size"));
    gtk_box_pack_start(GTK_BOX(hbox),SetMainWindowSize,FALSE,FALSE,0);
    Label = gtk_label_new (_("Width :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    MainWindowWidth = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),MainWindowWidth,FALSE,FALSE,0);
    Label = gtk_label_new (_("Height :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    MainWindowHeight = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),MainWindowHeight,FALSE,FALSE,0);
    MainWindowButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current size "));
    gtk_box_pack_start(GTK_BOX(hbox),MainWindowButton,FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT(MainWindowButton),"clicked",(GtkSignalFunc)Get_Main_Window_Size,NULL);
    gtk_widget_set_usize(MainWindowHeight,40,-1);
    gtk_widget_set_usize(MainWindowWidth,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetMainWindowSize),SET_MAIN_WINDOW_SIZE);
    sprintf(temp,"%i",MAIN_WINDOW_HEIGHT);
    gtk_entry_set_text(GTK_ENTRY(MainWindowHeight),temp);
    sprintf(temp,"%i",MAIN_WINDOW_WIDTH);
    gtk_entry_set_text(GTK_ENTRY(MainWindowWidth),temp);
    /* Placed at the end of the block cause we must have all widgets built */
    gtk_signal_connect(GTK_OBJECT(SetMainWindowSize),"toggled",
        GTK_SIGNAL_FUNC(Set_Main_Window_Size_Toggled),NULL);
    Set_Main_Window_Size_Toggled();
    msg = g_strdup_printf(_("Specify the default size for the main window. You must restart the "
        "program to apply the new size. For your display, the max values are: width=%d and height=%d."),
        gdk_screen_width(),gdk_screen_height());
    gtk_tooltips_set_tip(Tips,SetMainWindowSize,msg,NULL);
    gtk_tooltips_set_tip(Tips,MainWindowWidth,_("Width: set -1 for automatic size"),NULL);
    gtk_tooltips_set_tip(Tips,MainWindowHeight,_("Heigth: set -1 for automatic size"),NULL);
    g_free(msg);

    hbox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(VBox),hbox,FALSE,FALSE,0);
    /* Pane handle position 1 */
    SetPaneHandlePosition1 = gtk_check_button_new_with_label(_("Set right pane handle position"));
    gtk_box_pack_start(GTK_BOX(hbox),SetPaneHandlePosition1,FALSE,FALSE,0);
    Label = gtk_label_new (_("Position :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    PaneHandlePosition1 = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),PaneHandlePosition1,FALSE,FALSE,0);
    sprintf(temp,"%i",PANE_HANDLE_POSITION1);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition1),temp);
    PaneHandleButton1 = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_box_pack_start(GTK_BOX(hbox),PaneHandleButton1,FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT(PaneHandleButton1),"clicked",(GtkSignalFunc)Get_Pane_Handle_Position1,NULL);
    gtk_widget_set_usize(PaneHandlePosition1,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetPaneHandlePosition1),SET_PANE_HANDLE_POSITION1);
    gtk_tooltips_set_tip(Tips,SetPaneHandlePosition1,_("Specify the default position for the pane handle "
        "located between the browser frame and the tag frame. Changes will be applied the next start."),NULL);
    gtk_tooltips_set_tip(Tips,PaneHandlePosition1,_("Position: set -1 for automatic positioning"),NULL);
    gtk_signal_connect(GTK_OBJECT(SetPaneHandlePosition1),"toggled",
        GTK_SIGNAL_FUNC(Set_Pane_Handle_Position1_Toggled),NULL);
    Set_Pane_Handle_Position1_Toggled();

    hbox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(VBox),hbox,FALSE,FALSE,0);
    /* Pane handle position 2 */
    SetPaneHandlePosition2 = gtk_check_button_new_with_label(_("Set left pane handle position"));
    gtk_box_pack_start(GTK_BOX(hbox),SetPaneHandlePosition2,FALSE,FALSE,0);
    Label = gtk_label_new (_("Position :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    PaneHandlePosition2 = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),PaneHandlePosition2,FALSE,FALSE,0);
    sprintf(temp,"%i",PANE_HANDLE_POSITION2);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition2),temp);
    PaneHandleButton2 = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_box_pack_start(GTK_BOX(hbox),PaneHandleButton2,FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT(PaneHandleButton2),"clicked",(GtkSignalFunc)Get_Pane_Handle_Position2,NULL);
    gtk_widget_set_usize(PaneHandlePosition2,40,-1);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetPaneHandlePosition2),SET_PANE_HANDLE_POSITION2);
    gtk_tooltips_set_tip(Tips,SetPaneHandlePosition2,_("Specify the default position for the pane handle "
        "located between the browser tree and the list of files. Changes will be applied the next start."),NULL);
    gtk_tooltips_set_tip(Tips,PaneHandlePosition2,_("Position: set -1 for automatic positioning"),NULL);
    gtk_signal_connect(GTK_OBJECT(SetPaneHandlePosition2),"toggled",
        GTK_SIGNAL_FUNC(Set_Pane_Handle_Position2_Toggled),NULL);
    Set_Pane_Handle_Position2_Toggled();

    /* Separator line */
    Separator = gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX(VBox),Separator,FALSE,FALSE,0);

    ShowHeaderInfos = gtk_check_button_new_with_label(_("Show header informations of file"));
    gtk_box_pack_start(GTK_BOX(VBox),ShowHeaderInfos,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowHeaderInfos),SHOW_HEADER_INFO);
    gtk_tooltips_set_tip(Tips,ShowHeaderInfos,_("If activated, informations about the file as "
        "the bitrate, the time, the size, will be displayed under the filename entry."),NULL);

    /* Show Command Buttons */
    ShowCommandButtons = gtk_check_button_new_with_label(_("Show Command Buttons"));
    gtk_box_pack_start(GTK_BOX(VBox),ShowCommandButtons,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowCommandButtons),SHOW_COMMAND_BUTTONS);
    gtk_tooltips_set_tip(Tips,ShowCommandButtons,_("If activated, the buttons 'Scan', 'Remove', ... "
        "on the right side of the main window will be displayed."),NULL);
    gtk_signal_connect(GTK_OBJECT(ShowCommandButtons),"toggled",
        (GtkSignalFunc)Show_Command_Check_Button_Toggled,NULL);

    /* Buttons to display */
    Frame = gtk_frame_new (_("Command buttons to display"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    Table = gtk_table_new(8,4,FALSE);
    gtk_container_add(GTK_CONTAINER(Frame),Table);
    gtk_container_border_width(GTK_CONTAINER(Table),4);

    ShowSpinButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(spinner_xpm);
    Label = gtk_label_new(_("Spin Button"));
    gtk_container_add(GTK_CONTAINER(ShowSpinButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowSpinButton,1,2,0,1);

    ShowGoButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(go_xpm);
    Label = gtk_label_new(_("GO Button"));
    gtk_container_add(GTK_CONTAINER(ShowGoButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowGoButton,2,3,0,1);

    ShowFirstButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(first_xpm);
    Label = gtk_label_new(_("First"));
    gtk_container_add(GTK_CONTAINER(ShowFirstButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowFirstButton,0,1,1,2);

    ShowPrevButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(previous_xpm);
    Label = gtk_label_new(_("Previous"));
    gtk_container_add(GTK_CONTAINER(ShowPrevButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowPrevButton,1,2,1,2);

    ShowNextButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(next_xpm);
    Label = gtk_label_new(_("Next"));
    gtk_container_add(GTK_CONTAINER(ShowNextButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowNextButton,2,3,1,2);

    ShowLastButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(last_xpm);
    Label = gtk_label_new(_("Last"));
    gtk_container_add(GTK_CONTAINER(ShowLastButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowLastButton,3,4,1,2);

    ShowScanButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(scan_xpm);
    Label = gtk_label_new(_("Scan"));
    gtk_container_add(GTK_CONTAINER(ShowScanButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowScanButton,1,2,2,3);

    ShowScanAllButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(scan_all_xpm);
    Label = gtk_label_new(_("Scan All"));
    gtk_container_add(GTK_CONTAINER(ShowScanAllButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowScanAllButton,2,3,2,3);

    ShowRemoveButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(delete_xpm);
    Label = gtk_label_new(_("Remove"));
    gtk_container_add(GTK_CONTAINER(ShowRemoveButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowRemoveButton,1,2,3,4);

    ShowRemoveAllButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(delete_all_xpm);
    Label = gtk_label_new(_("Remove All"));
    gtk_container_add(GTK_CONTAINER(ShowRemoveAllButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowRemoveAllButton,2,3,3,4);

    ShowUndoButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(undo_xpm);
    Label = gtk_label_new(_("Undo"));
    gtk_container_add(GTK_CONTAINER(ShowUndoButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowUndoButton,1,2,4,5);

    ShowUndoAllButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(undo_all_xpm);
    Label = gtk_label_new(_("Undo All"));
    gtk_container_add(GTK_CONTAINER(ShowUndoAllButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowUndoAllButton,2,3,4,5);

    ShowRedoButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(redo_xpm);
    Label = gtk_label_new(_("Redo"));
    gtk_container_add(GTK_CONTAINER(ShowRedoButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowRedoButton,1,2,5,6);

    ShowRedoAllButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(redo_all_xpm);
    Label = gtk_label_new(_("Redo All"));
    gtk_container_add(GTK_CONTAINER(ShowRedoAllButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowRedoAllButton,2,3,5,6);

    ShowSaveButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(save_xpm);
    Label = gtk_label_new(_("Save"));
    gtk_container_add(GTK_CONTAINER(ShowSaveButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowSaveButton,1,2,6,7);

    ShowSaveAllButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(save_all_xpm);
    Label = gtk_label_new(_("Save All"));
    gtk_container_add(GTK_CONTAINER(ShowSaveAllButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowSaveAllButton,2,3,6,7);

    ShowQuitButton = gtk_check_button_new();
    HBox = gtk_hbox_new(FALSE,2);
    Icon = Create_Pixmap_Icon(exit_xpm);
    Label = gtk_label_new(_("Quit"));
    gtk_container_add(GTK_CONTAINER(ShowQuitButton),HBox);
    gtk_box_pack_start(GTK_BOX(HBox),Icon,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(HBox),Label,FALSE,FALSE,0);
    gtk_table_attach_defaults(GTK_TABLE(Table),ShowQuitButton,1,3,7,8);

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowSpinButton),     SHOW_SPIN_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowGoButton),       SHOW_GO_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowFirstButton),    SHOW_FIRST_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowPrevButton),     SHOW_PREV_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowNextButton),     SHOW_NEXT_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowLastButton),     SHOW_LAST_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowScanButton),     SHOW_SCAN_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowScanAllButton),  SHOW_SCAN_ALL_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowRemoveButton),   SHOW_REMOVE_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowRemoveAllButton),SHOW_REMOVE_ALL_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowUndoButton),     SHOW_UNDO_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowUndoAllButton),  SHOW_UNDO_ALL_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowRedoButton),     SHOW_REDO_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowRedoAllButton),  SHOW_REDO_ALL_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowSaveButton),     SHOW_SAVE_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowSaveAllButton),  SHOW_SAVE_ALL_BUTTON);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowQuitButton),     SHOW_QUIT_BUTTON);

    /* Set the sensitivity of the previous check buttons */
    Show_Command_Check_Button_Toggled();

    /* Set yellow color to tooltips */
    UseColoredTooltips = gtk_check_button_new_with_label(_("Set yellow background for tooltips"));
    gtk_box_pack_start(GTK_BOX(VBox),UseColoredTooltips,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseColoredTooltips),USE_COLORED_TOOLTIPS);
    gtk_tooltips_set_tip(Tips,UseColoredTooltips,_("If activated, the background of tooltips will "
        "be yellow colored, overriding your window manager."),NULL);



    /*
     * Misc
     */
    Label = gtk_label_new (_("Misc"));
    Frame = gtk_frame_new (_("Misc"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),4);


    /* Filename Options */
    Frame = gtk_frame_new (_("Filename Options"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    ReplaceIllegalCharactersInFilename = gtk_check_button_new_with_label(_("Replace illegal characters in filename"));
    gtk_box_pack_start(GTK_BOX(vbox),ReplaceIllegalCharactersInFilename,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ReplaceIllegalCharactersInFilename),REPLACE_ILLEGAL_CHARACTERS_IN_FILENAME);
    gtk_tooltips_set_tip(Tips,ReplaceIllegalCharactersInFilename,_("Convert illegal characters (for "
        "windows filesystems as '\\', ':', ...) of the filename to avoid problem when renaming the file. "
        "This is usefull when renaming the file from the tag with the scanner."),NULL);


    /* Tag Options */
    Frame = gtk_frame_new (_("Tag Options"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    DateAutoCompletion = gtk_check_button_new_with_label(_("Auto completion of date if not complete"));
    gtk_box_pack_start(GTK_BOX(vbox),DateAutoCompletion,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(DateAutoCompletion),DATE_AUTO_COMPLETION);
    gtk_tooltips_set_tip(Tips,DateAutoCompletion,_("Try to complete the year field if you enter "
        "only the last numerals of the date (for instance, if the current year is 2005: "
        "5 => 2005, 4 => 2004, 6 => 1996, 95 => 1995, ...)."),NULL);

    NumberTrackFormated = gtk_check_button_new_with_label(_("Write the track field on two characters ('05', '09', '10', ...)"));
    gtk_box_pack_start(GTK_BOX(vbox),NumberTrackFormated,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(NumberTrackFormated),NUMBER_TRACK_FORMATED);
    gtk_tooltips_set_tip(Tips,NumberTrackFormated,_("If activated, the track field is written with "
        "two characters. Else it keeps the 'raw' track value."),NULL);


    /* Character Set */
    Frame = gtk_frame_new (_("Character Set"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);

    vbox = gtk_vbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    UseCharacterSetTranslation = gtk_check_button_new_with_label(_("Enable character set translation"));
    gtk_box_pack_start(GTK_BOX(vbox),UseCharacterSetTranslation,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseCharacterSetTranslation),USE_CHARACTER_SET_TRANSLATION);
    gtk_tooltips_set_tip(Tips,UseCharacterSetTranslation,_("If activated, the character set "
        "translation is enabled"),NULL);
    gtk_signal_connect_after(GTK_OBJECT(UseCharacterSetTranslation),"toggled",
        (GtkSignalFunc)Use_Character_Set_Translation_Toggled,NULL);

    // Combo boxes...
    hbox = gtk_hbox_new(FALSE,4);
    gtk_container_add(GTK_CONTAINER(vbox),hbox);
    Label = gtk_label_new (_("Convert character set from :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    FileCharacterSetEntry = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),FileCharacterSetEntry,TRUE,TRUE,0);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(FileCharacterSetEntry)->entry,_("Character set used for "
        "files on hard disk."),NULL);
    Label = gtk_label_new (_("to :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    UserCharacterSetEntry = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),UserCharacterSetEntry,TRUE,TRUE,0);
    gtk_tooltips_set_tip(Tips,GTK_COMBO(UserCharacterSetEntry)->entry,_("Character set used to "
        "display tag data in the user interface."),NULL);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(FileCharacterSetEntry)->entry),FALSE);
    gtk_entry_set_editable(GTK_ENTRY(GTK_COMBO(UserCharacterSetEntry)->entry),FALSE);
    gtk_combo_set_value_in_list(GTK_COMBO(FileCharacterSetEntry),TRUE,FALSE);
    gtk_combo_set_value_in_list(GTK_COMBO(UserCharacterSetEntry),TRUE,FALSE);
    list = Charset_Create_List();
    gtk_combo_set_popdown_strings(GTK_COMBO(FileCharacterSetEntry),list);
    gtk_combo_set_popdown_strings(GTK_COMBO(UserCharacterSetEntry),list);
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(FileCharacterSetEntry)->entry),Charset_Get_Title_From_Name(FILE_CHARACTER_SET));
    gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(UserCharacterSetEntry)->entry),Charset_Get_Title_From_Name(USER_CHARACTER_SET));
    //gtk_widget_set_usize(FileCharacterSetEntry,80,-1);
    //gtk_widget_set_usize(UserCharacterSetEntry,80,-1);
    Use_Character_Set_Translation_Toggled();

    /* Message Dialog Position */
    Frame = gtk_frame_new (_("Message Dialog Position"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    hbox = gtk_hbox_new(TRUE,4);
    gtk_container_add(GTK_CONTAINER(Frame),hbox);
    gtk_container_border_width(GTK_CONTAINER(hbox),4);

    MessageBoxPositionNone = gtk_radio_button_new_with_label(NULL,_("No particular position"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionNone,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionNone),MESSAGE_BOX_POSITION_NONE);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionNone,_("Let the Window Manager to place the windows."),NULL);

    MessageBoxPositionCenter = gtk_radio_button_new_with_label(
        gtk_radio_button_group(GTK_RADIO_BUTTON(MessageBoxPositionNone)),_("Center of the screen"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionCenter,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionCenter),MESSAGE_BOX_POSITION_CENTER);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionCenter,_("Windows should be placed in the center "
        "of the screen."),NULL);

    MessageBoxPositionMouse = gtk_radio_button_new_with_label(
        gtk_radio_button_group(GTK_RADIO_BUTTON(MessageBoxPositionNone)),_("Mouse position"));
    gtk_box_pack_start(GTK_BOX(hbox),MessageBoxPositionMouse,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(MessageBoxPositionMouse),MESSAGE_BOX_POSITION_MOUSE);
    gtk_tooltips_set_tip(Tips,MessageBoxPositionMouse,_("Windows should be placed at the current "
        "mouse position."),NULL);



    /*
     * Scanner
     */
    Label = gtk_label_new (_("Scanner"));
    Frame = gtk_frame_new (_("Scanner"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    /* Save the number of the page. Asked in Scanner window */
    OptionsNoteBook_Scanner_Page_Num = gtk_notebook_page_num(GTK_NOTEBOOK(OptionsNoteBook),Frame);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),4);

    /* Character conversion for the scanner */
    Frame = gtk_frame_new (_("Character Conversion"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    ConvertUnderscoreAndP20IntoSpace = gtk_check_button_new_with_label(_("Convert underscore "
        "character '_' and string '%20' to space ' '"));
    ConvertSpaceIntoUnderscore = gtk_check_button_new_with_label(_("Convert space ' ' to underscore '_'"));
    gtk_box_pack_start(GTK_BOX(vbox),ConvertUnderscoreAndP20IntoSpace,FALSE,FALSE,0);
    gtk_box_pack_start(GTK_BOX(vbox),ConvertSpaceIntoUnderscore,      FALSE,FALSE,0);
    gtk_signal_connect_object(GTK_OBJECT(ConvertUnderscoreAndP20IntoSpace),"toggled",
        Scanner_Convert_Check_Button_Toggled_1,GTK_OBJECT(ConvertSpaceIntoUnderscore));
    gtk_signal_connect_object(GTK_OBJECT(ConvertSpaceIntoUnderscore),"toggled",
        Scanner_Convert_Check_Button_Toggled_1,GTK_OBJECT(ConvertUnderscoreAndP20IntoSpace));

    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConvertUnderscoreAndP20IntoSpace),
        CONVERT_UNDERSCORE_AND_P20_INTO_SPACE);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConvertSpaceIntoUnderscore),
        CONVERT_SPACE_INTO_UNDERSCORE);
    gtk_tooltips_set_tip(Tips,ConvertUnderscoreAndP20IntoSpace,_("If activated, the conversion "
        "will take place when applying a mask."),NULL);
    gtk_tooltips_set_tip(Tips,ConvertSpaceIntoUnderscore,_("If activated, the conversion "
        "will take place when applying a mask."),NULL);


    /* Properties of the scanner window */
    Frame = gtk_frame_new (_("Scanner Window"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    ScanWindowOnTop = gtk_check_button_new_with_label(_("Scanner window always on top"));
    gtk_box_pack_start(GTK_BOX(vbox),ScanWindowOnTop,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ScanWindowOnTop),SCAN_WINDOW_ON_TOP);
    gtk_tooltips_set_tip(Tips,ScanWindowOnTop,_("If activated, the window which contains the masks "
                        "will stay always over the main window."),NULL);

    // Scanner Window Position
    hbox = gtk_hbox_new(FALSE,4);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

    SetScannerWindowPosition = gtk_check_button_new_with_label(_("Set scanner window position"));
    gtk_box_pack_start(GTK_BOX(hbox),SetScannerWindowPosition,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetScannerWindowPosition),SET_SCANNER_WINDOW_POSITION);
    msg = g_strdup_printf(_("If activated, the scanner window will appear at the specified "
                "coordinates relative to the main window. Use it if you want to keep the same "
                "position of the scanner window each times you open it. If deactivated, the "
                "window manager determines the position."));
    gtk_tooltips_set_tip(Tips,SetScannerWindowPosition,msg,NULL);
    g_free(msg);

    Label = gtk_label_new (_("X :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    ScannerWindowX = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowX,FALSE,FALSE,0);
    gtk_widget_set_usize(ScannerWindowX,40,-1);
    Label = gtk_label_new (_("Y :"));
    gtk_box_pack_start(GTK_BOX(hbox),Label,FALSE,FALSE,0);
    ScannerWindowY = gtk_entry_new_with_max_length(4);
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowY,FALSE,FALSE,0);
    gtk_widget_set_usize(ScannerWindowY,40,-1);
    ScannerWindowButton = Create_Button_With_Icon_And_Label(grab_xpm,_(" Get current position "));
    gtk_box_pack_start(GTK_BOX(hbox),ScannerWindowButton,FALSE,FALSE,0);
    gtk_signal_connect (GTK_OBJECT(ScannerWindowButton),"clicked",
        (GtkSignalFunc)Get_Scanner_Window_Position,NULL);
    /* Load values */
    sprintf(temp,"%i",SCANNER_WINDOW_X);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowX),temp);
    sprintf(temp,"%i",SCANNER_WINDOW_Y);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowY),temp);
    // Placed at the end of the block because we must have all widgets built
    gtk_signal_connect(GTK_OBJECT(SetScannerWindowPosition),"clicked",
            GTK_SIGNAL_FUNC(Scanner_Window_Position_Check_Button_Toggled),NULL);
    Scanner_Window_Position_Check_Button_Toggled();


    /* Other options */
    Frame = gtk_frame_new (_("Fields"));
    gtk_box_pack_start(GTK_BOX(VBox),Frame,FALSE,FALSE,0);
    vbox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),vbox);
    gtk_container_border_width(GTK_CONTAINER(vbox),2);

    // Overwrite text into tag fields
    OverwriteTagField = gtk_check_button_new_with_label(_("Overwrite fields when scanning tag"));
    gtk_box_pack_start(GTK_BOX(vbox),OverwriteTagField,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(OverwriteTagField),OVERWRITE_TAG_FIELD);
    gtk_tooltips_set_tip(Tips,OverwriteTagField,_("If activated, the scanner will replace existing text "
        "in fields by the new one. If deactivated, only blank fields of the tag will be filled."),NULL);

    // Set a default comment text
    hbox = gtk_hbox_new(FALSE,2);
    gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
    SetDefaultComment = gtk_check_button_new_with_label(_("Set this text as default comment:"));
    gtk_box_pack_start(GTK_BOX(hbox),SetDefaultComment,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),SET_DEFAULT_COMMENT);
    gtk_tooltips_set_tip(Tips,SetDefaultComment,_("Activate this option if you want to put the "
        "following string into the comment field when using the 'Fill Tag' scanner."),NULL);
    DefaultComment = gtk_combo_new();
    gtk_box_pack_start(GTK_BOX(hbox),DefaultComment,TRUE,TRUE,0);
    gtk_signal_connect(GTK_OBJECT(SetDefaultComment),"toggled",
            GTK_SIGNAL_FUNC(Set_Default_Comment_Check_Button_Toggled),NULL);
    if (DEFAULT_COMMENT==NULL)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),FALSE);
    Set_Default_Comment_Check_Button_Toggled();
    /* History list */
    History_List = Load_Default_Tag_Comment_Text_List();
    History_List = Add_String_To_Glist(History_List,DEFAULT_COMMENT);
    if (History_List)
        gtk_combo_set_popdown_strings(GTK_COMBO(DefaultComment),History_List);
    gtk_object_set_data(GTK_OBJECT(DefaultComment),"History",History_List);
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultComment)->entry)),"activate",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultComment));
    gtk_signal_connect_object(GTK_OBJECT(GTK_ENTRY(GTK_COMBO(DefaultComment)->entry)),"focus_out_event",
        Add_To_Combo_Box_History,GTK_OBJECT(DefaultComment));


    /*
     * Confirmation
     */
    Label = gtk_label_new (_("Confirmation"));
    Frame = gtk_frame_new (_("Confirmation"));
    gtk_notebook_append_page (GTK_NOTEBOOK(OptionsNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),5);

    VBox = gtk_vbox_new(FALSE,2);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);
    gtk_container_border_width(GTK_CONTAINER(VBox),5);

    ConfirmBeforeExit = gtk_check_button_new_with_label(_("Confirm exit from program"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmBeforeExit,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmBeforeExit),CONFIRM_BEFORE_EXIT);
    gtk_tooltips_set_tip(Tips,ConfirmBeforeExit,_("If activated, opens a dialog box to ask "
        "confirmation before exiting the program."),NULL);

    ConfirmWriteTag = gtk_check_button_new_with_label(_("Confirm writing of file tag"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmWriteTag,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmWriteTag),CONFIRM_WRITE_TAG);

    ConfirmRenameFile = gtk_check_button_new_with_label(_("Confirm renaming of file"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmRenameFile,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmRenameFile),CONFIRM_RENAME_FILE);

    ConfirmWritePlayList = gtk_check_button_new_with_label(_("Confirm writing of playlist"));
    gtk_box_pack_start(GTK_BOX(VBox),ConfirmWritePlayList,FALSE,FALSE,0);
    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ConfirmWritePlayList),CONFIRM_WRITE_PLAYLIST);



    /* 
     * Buttons box of Option Window
     */
    ButtonBox = gtk_hbutton_box_new ();
    gtk_box_pack_start(GTK_BOX(OptionsVBox), ButtonBox, FALSE, FALSE, 4);

    gtk_button_box_set_layout (GTK_BUTTON_BOX (ButtonBox), GTK_BUTTONBOX_END);
    gtk_button_box_set_spacing (GTK_BUTTON_BOX (ButtonBox), 15);


    /* OK Button */
    Button = Create_Button_With_Pixmap(BUTTON_APPLY);
    gtk_container_add(GTK_CONTAINER(ButtonBox),Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Ok_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip(Tips,Button,_("Apply changes (but don't save) and close this window"),NULL);

    /* Save Button */
    Button = Create_Button_With_Pixmap(BUTTON_SAVE);
    gtk_container_add(GTK_CONTAINER(ButtonBox), Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Save_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_tooltips_set_tip(Tips,Button,_("Save changes and close this window"),NULL);

    /* Cancel Button */
    Button = Create_Button_With_Pixmap(BUTTON_CANCEL);
    gtk_container_add(GTK_CONTAINER(ButtonBox), Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)OptionsWindow_Cancel_Button,NULL);
    GTK_WIDGET_SET_FLAGS(Button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default (Button);
    gtk_tooltips_set_tip(Tips,Button,_("Close this window without saving"),NULL);


    /* Show all in the options window */
    gtk_widget_show_all(OptionsWindow);

    /* Load the default page */
    gtk_notebook_set_page(GTK_NOTEBOOK(OptionsNoteBook),OPTIONS_NOTEBOOK_PAGE);
}


void Set_Main_Window_Size_Toggled (void) 
{
    gtk_widget_set_sensitive(MainWindowWidth, GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
    gtk_widget_set_sensitive(MainWindowHeight,GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
    gtk_widget_set_sensitive(MainWindowButton,GTK_TOGGLE_BUTTON(SetMainWindowSize)->active);
}

void Set_Pane_Handle_Position1_Toggled (void)
{
    gtk_widget_set_sensitive(PaneHandlePosition1,GTK_TOGGLE_BUTTON(SetPaneHandlePosition1)->active);
    gtk_widget_set_sensitive(PaneHandleButton1,  GTK_TOGGLE_BUTTON(SetPaneHandlePosition1)->active);
}

void Set_Pane_Handle_Position2_Toggled (void)
{
    gtk_widget_set_sensitive(PaneHandlePosition2,GTK_TOGGLE_BUTTON(SetPaneHandlePosition2)->active);
    gtk_widget_set_sensitive(PaneHandleButton2,  GTK_TOGGLE_BUTTON(SetPaneHandlePosition2)->active);
}

void Scanner_Window_Position_Check_Button_Toggled (void) 
{
    gtk_widget_set_sensitive(ScannerWindowX,     GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
    gtk_widget_set_sensitive(ScannerWindowY,     GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
    gtk_widget_set_sensitive(ScannerWindowButton,GTK_TOGGLE_BUTTON(SetScannerWindowPosition)->active);
}

void Set_Default_Comment_Check_Button_Toggled (void) 
{
    gtk_widget_set_sensitive(DefaultComment,GTK_TOGGLE_BUTTON(SetDefaultComment)->active);
}

void Show_Command_Check_Button_Toggled (void)
{
    gtk_widget_set_sensitive(ShowSpinButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowGoButton,       GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowFirstButton,    GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowPrevButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowNextButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowLastButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowScanButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowScanAllButton,  GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowRemoveButton,   GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowRemoveAllButton,GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowUndoButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowUndoAllButton,  GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowRedoButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowRedoAllButton,  GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowSaveButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowSaveAllButton,  GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
    gtk_widget_set_sensitive(ShowQuitButton,     GTK_TOGGLE_BUTTON(ShowCommandButtons)->active);
}

void Use_Character_Set_Translation_Toggled (void)
{
    gtk_widget_set_sensitive(FileCharacterSetEntry,GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active);
    gtk_widget_set_sensitive(UserCharacterSetEntry,GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active);
}

void Sorting_File_Option_Menu_Activate_Item (GtkWidget *widget, ET_Sorting_Type *st)
{
    SORTING_FILE_MODE = GPOINTER_TO_INT(st);
}


/* Callback from Open_OptionsWindow */
void OptionsWindow_Key_Press (GtkWidget *window, GdkEvent *event)
{
    GdkEventKey *kevent;

    if (event && event->type == GDK_KEY_PRESS)
    {
        kevent = (GdkEventKey *)event;
        switch(kevent->keyval)
        {
            case GDK_Escape:    
            {
                OptionsWindow_Quit();
                break;
            }
        }
    }
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Ok_Button(void)
{
    if (!Check_Config()) return;
    Apply_Changes();
    OptionsWindow_Quit();
    Statusbar_Message(_("Changes applied"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Save_Button(void)
{
    if (!Check_Config()) return;
    Save_Changes();
    OptionsWindow_Quit();
    Statusbar_Message(_("Configuration saved"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Cancel_Button(void)
{
    OptionsWindow_Quit();
    Statusbar_Message(_("Configuration unchanged"),TRUE);
}

/* Callback from Open_OptionsWindow */
void OptionsWindow_Quit(void)
{
    if (OptionsWindow)
    {
        GList *list;
        
        /* Save combobox history lists before exit */
        list = gtk_object_get_data(GTK_OBJECT(DefaultPathToMp3),"History");
        Save_Default_Path_To_MP3_List(list);
        
        list = gtk_object_get_data(GTK_OBJECT(DefaultComment),"History");
        Save_Default_Tag_Comment_Text_List(list);
        
        /* Now quit */
        gtk_widget_destroy(OptionsWindow);
        OptionsWindow = (GtkWidget *)NULL;
        gtk_widget_set_sensitive(MainWindow, TRUE);
    }
}


/*
 * Check_Config: Check if config informations are correct
 */
#include <sys/stat.h>
#include <unistd.h>
gint Check_DefaultPathToMp3 (void)
{
    gchar *path;
    struct stat stbuf;

    path = g_strdup(gtk_entry_get_text_1(DefaultPathToMp3));
    if (!path || strlen(path)<1)
    {
        g_free(path);
        return 1;
    }

    if ( stat(path,&stbuf)==0 && S_ISDIR(stbuf.st_mode) )
    {
        g_free(path);
        return 1;    /* Path is good */
    }else
    {
        gchar *msg = g_strdup_printf(_(" The selected path for 'Default path to MP3 files' isn't "
            "valid!\n (%s) "),(stat(path,&stbuf)==0)?_("Not a directory"):g_strerror(errno) );
        GtkWidget *msgbox = msg_box_new (_("Confirm..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        g_free(path);

        return 0;
    }
}
gint Check_Size (void)
{
    if ( atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowHeight))) > gdk_screen_height() )
    {
        gchar *msg = g_strdup_printf(_(" Window height (%d) is bigger than screen height (%d)! "),
                atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowHeight))),gdk_screen_height());
        GtkWidget *msgbox = msg_box_new (_("Size Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        return 0;
    }
    if ( atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowWidth))) > gdk_screen_width() )
    {
        gchar *msg = g_strdup_printf(_(" Window width (%d) is bigger than screen width (%d)! "),
                atoi(gtk_entry_get_text(GTK_ENTRY(MainWindowWidth))),gdk_screen_width());
        GtkWidget *msgbox = msg_box_new (_("Size Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        return 0;
    }
    /* Size is good */
    return 1;
}
gint Check_CharacterSetTranslation (void)
{
    gchar *from = Charset_Get_Name_From_Title(gtk_entry_get_text_1(FileCharacterSetEntry));
    gchar *to   = Charset_Get_Name_From_Title(gtk_entry_get_text_1(UserCharacterSetEntry));

    if ( GTK_TOGGLE_BUTTON(UseCharacterSetTranslation)->active && (test_conversion_charset(from,to)!=TRUE) )
    {
        gchar *msg = g_strdup_printf(_("The character set translation from '%s'\n"
                                       "to '%s' isn't supported!"),from,to);
        GtkWidget *msgbox = msg_box_new (_("Error..."),msg,MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        g_free(msg);
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(UseCharacterSetTranslation),FALSE);
        return 0;
    }
    return 1;
}
gint Check_DefaultComment (void)
{
    gchar *file;

    file = gtk_entry_get_text_1(DefaultComment);
    if (!file || strlen(file)<1)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(SetDefaultComment),FALSE);

    return 1;    /* A blank entry is ignored */
}

gint Check_Config (void)
{
    if (   Check_DefaultPathToMp3() 
        && Check_Size() 
        && Check_CharacterSetTranslation() 
        && Check_DefaultComment()
       )
        return 1;    /* No problem detected */
    else
        return 0;    /* Oups! */
}



/*
 * Open the file selection window
 */
static void Options_Browser_Open (GtkWidget *widget)
{
    gchar *tmp = NULL;

    if (FileSelection)
    {
        gdk_window_show(FileSelection->window);
        return;
    }

    if (widget==DefaultPathToMp3)
    {
        FileSelection = gtk_file_selection_new(_("Select default directory..."));
        gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSelection)->file_list,FALSE);
        tmp = gtk_entry_get_text_1(widget);
    }else if(widget==TranslationTablePath)
    {
        FileSelection = gtk_file_selection_new(_("Select file for character translation table..."));
        gtk_widget_set_sensitive(GTK_FILE_SELECTION(FileSelection)->file_list,TRUE);
        tmp = gtk_entry_get_text_1(widget);
    }else
        return;

    gtk_window_set_modal (GTK_WINDOW(FileSelection),TRUE);
    gtk_window_set_transient_for(GTK_WINDOW(FileSelection),GTK_WINDOW(OptionsWindow));
    gtk_signal_connect(GTK_OBJECT(&(GTK_FILE_SELECTION(FileSelection)->window)),
                       "delete_event",GTK_SIGNAL_FUNC(Options_Browser_Destroy),FileSelection);

    tmp = gtk_entry_get_text_1(widget);
    if (tmp && *tmp)
        gtk_file_selection_set_filename(GTK_FILE_SELECTION(FileSelection),tmp);

    gtk_signal_connect_object(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->ok_button),
                           "clicked",GTK_SIGNAL_FUNC(Options_Browser_Ok_Button),GTK_OBJECT(widget));
    gtk_signal_connect(GTK_OBJECT(GTK_FILE_SELECTION(FileSelection)->cancel_button),
                           "clicked",GTK_SIGNAL_FUNC(Options_Browser_Destroy),FileSelection);

    gtk_widget_show(FileSelection);
}

/* Callback from Options_Browser_Open */
static void Options_Browser_Ok_Button (GtkWidget *widget)
{
    gchar *tmp;

    tmp = gtk_file_selection_get_filename(GTK_FILE_SELECTION(FileSelection));

    if (GTK_IS_COMBO(widget))
    {
        gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(widget)->entry),tmp);
    }else if(GTK_IS_ENTRY(widget))
    {
        gtk_entry_set_text(GTK_ENTRY(widget),tmp);
    }

    gtk_widget_destroy(FileSelection);
    FileSelection = (GtkWidget *)NULL;
}

/* Callback from Options_Browser_Open */
void Options_Browser_Destroy (void)
{
    gtk_widget_destroy (FileSelection);
    FileSelection=(GtkWidget *)NULL;
}


/* 
 * Get current size of main window and complete "window size" fields
 */
void Get_Main_Window_Size (void)
{
    gint height;
    gint width;
    gchar temp[MAX_STRING_LEN];

    gdk_window_get_size(MainWindow->window,&width,&height);
    sprintf(temp,"%i",height);
    gtk_entry_set_text(GTK_ENTRY(MainWindowHeight),temp);
    sprintf(temp,"%i",width);
    gtk_entry_set_text(GTK_ENTRY(MainWindowWidth),temp);
}



/* 
 * Get current position of pane handle
 */
void Get_Pane_Handle_Position1 (void)
{
    gchar temp[MAX_STRING_LEN];

    sprintf(temp,"%i",GTK_PANED(MainWindowHPaned)->child1_size);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition1),temp);
}
void Get_Pane_Handle_Position2 (void)
{
    gchar temp[MAX_STRING_LEN];

    sprintf(temp,"%i",GTK_PANED(BrowserHPaned)->child1_size);
    gtk_entry_set_text(GTK_ENTRY(PaneHandlePosition2),temp);
}



/* 
 * Get current position of scanner window with regards to main 
 * window and complete "window position" fields.
 */
void Get_Scanner_Window_Position (void)
{
    gint x,x1;
    gint y,y1;
    gchar temp[MAX_STRING_LEN];

    if (!MainWindow) return;
    if (!ScannerWindow)
    {
        GtkWidget *msgbox = msg_box_new (_("Error..."),_("The scanner window must be "
            "open to get its current position!"),MSG_ERROR,BUTTON_OK,0);
        msg_box_hide_check_button(MSG_BOX(msgbox));
        msg_box_run(MSG_BOX(msgbox));
        gtk_widget_destroy(msgbox);
        return;
    }

    gdk_window_get_position(MainWindow->window,&x,&y);
    gdk_window_get_position(ScannerWindow->window,&x1,&y1);
    sprintf(temp,"%i",x1-x);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowX),temp);
    sprintf(temp,"%i",y1-y);
    gtk_entry_set_text(GTK_ENTRY(ScannerWindowY),temp);
}


void Update_Button_Visibility_Into_Command_Bar (void)
{
    if (SHOW_SPIN_BUTTON)
    {
        gtk_widget_show(SpinButton);
        if (SHOW_GO_BUTTON)          gtk_widget_show(GoButton);
        else                         gtk_widget_hide(GoButton);
    }else
    {
        gtk_widget_hide(SpinButton);
        gtk_widget_hide(GoButton);
    }
    if (SHOW_FIRST_BUTTON)       gtk_widget_show(FirstButton);
    else                         gtk_widget_hide(FirstButton);
    if (SHOW_PREV_BUTTON)        gtk_widget_show(PrevButton);
    else                         gtk_widget_hide(PrevButton);
    if (SHOW_NEXT_BUTTON)        gtk_widget_show(NextButton);
    else                         gtk_widget_hide(NextButton);
    if (SHOW_LAST_BUTTON)        gtk_widget_show(LastButton);
    else                         gtk_widget_hide(LastButton);
    if (SHOW_SCAN_BUTTON)        gtk_widget_show(ScanButton);
    else                         gtk_widget_hide(ScanButton);
    if (SHOW_SCAN_ALL_BUTTON)    gtk_widget_show(ScanAllButton);
    else                         gtk_widget_hide(ScanAllButton);
    if (SHOW_REMOVE_BUTTON)      gtk_widget_show(RemoveButton);
    else                         gtk_widget_hide(RemoveButton);
    if (SHOW_REMOVE_ALL_BUTTON)  gtk_widget_show(RemoveAllButton);
    else                         gtk_widget_hide(RemoveAllButton);
    if (SHOW_UNDO_BUTTON)        gtk_widget_show(UndoButton);
    else                         gtk_widget_hide(UndoButton);
    if (SHOW_UNDO_ALL_BUTTON)    gtk_widget_show(UndoAllButton);
    else                         gtk_widget_hide(UndoAllButton);
    if (SHOW_REDO_BUTTON)        gtk_widget_show(RedoButton);
    else                         gtk_widget_hide(RedoButton);
    if (SHOW_REDO_ALL_BUTTON)    gtk_widget_show(RedoAllButton);
    else                         gtk_widget_hide(RedoAllButton);
    if (SHOW_SAVE_BUTTON)        gtk_widget_show(ApplyButton);
    else                         gtk_widget_hide(ApplyButton);
    if (SHOW_SAVE_ALL_BUTTON)    gtk_widget_show(ApplyAllButton);
    else                         gtk_widget_hide(ApplyAllButton);
    if (SHOW_QUIT_BUTTON)        gtk_widget_show(QuitButton);
    else                         gtk_widget_hide(QuitButton);

    if (   !SHOW_SPIN_BUTTON
        && !SHOW_FIRST_BUTTON  && !SHOW_PREV_BUTTON && !SHOW_NEXT_BUTTON && !SHOW_LAST_BUTTON
        && !SHOW_SCAN_BUTTON   && !SHOW_SCAN_ALL_BUTTON
        && !SHOW_REMOVE_BUTTON && !SHOW_REMOVE_ALL_BUTTON
        && !SHOW_UNDO_BUTTON   && !SHOW_UNDO_ALL_BUTTON
        && !SHOW_REDO_BUTTON   && !SHOW_REDO_ALL_BUTTON
        && !SHOW_SAVE_BUTTON   && !SHOW_SAVE_ALL_BUTTON
        && !SHOW_QUIT_BUTTON)
    {
        SHOW_COMMAND_BUTTONS = 0;
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(ShowCommandButtons),SHOW_COMMAND_BUTTONS);
        gtk_widget_hide_all(CommandArea);
    }
    /* Force resizing window to replace the shown buttons */
    if (CommandArea)
        gtk_widget_queue_resize (CommandArea);
}


/*
 * Manage Check buttons into Scanner tab: conversion group
 */
void Scanner_Convert_Check_Button_Toggled_1 (GtkObject *object_rec, GtkObject *object_emi)
{
    if (!object_rec && !object_emi) return;

    if (GTK_TOGGLE_BUTTON(object_emi)->active == TRUE)
        gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(object_rec),
                        !GTK_TOGGLE_BUTTON(object_emi)->active);

}


