/*  $Header: /cvsroot/dvipdfmx/src/colorsp.c,v 1.8 2004/03/11 11:50:19 hirata Exp $
    
    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/

#if HAVE_CONFIG_H
#include "config.h"
#endif

#include "system.h"
#include "mem.h"
#include "error.h"

#include "pdfdev.h"
#include "pdfparse.h"

#include "colorsp.h"

static int
get_values (char **start, char *end, double *values, int count)
{
  char *number;
  int   i;

  for (i = 0; i < count; i++) {
    number = parse_number(start, end);
    if (!number)
      break;
    else {
      values[i] = atof(number);
      RELEASE(number);
    }
  }

  return i;
}

static void
do_color_special (char **start, char *end)
{
  pdf_color colorspec;
  char *command, *token;

  skip_white(start, end);
  command = parse_ident(start, end);
  if (command) {
    if (!strcmp(command, "push")) { /* Handle a push */ 
      skip_white(start, end);
      token = parse_ident(start, end);
      if (token) {
	if (!strcmp(token, "rgb")) { /* Handle rgb color */
	  colorspec.space_id = PDF_COLOR_DEV_RGB;
	  if (get_values(start, end, &(colorspec.values[0]), 3) == 3)
	    dev_begin_dev_color(&colorspec);
	} else if (!strcmp(token, "cmyk")) { /* Handle cmyk color */
	  colorspec.space_id = PDF_COLOR_DEV_CMYK;
	  if (get_values(start, end, &(colorspec.values[0]), 4) == 4)
	    dev_begin_dev_color(&colorspec);
	} else if (!strcmp(token, "gray")) { /* Handle gray */
	  colorspec.space_id = PDF_COLOR_DEV_GRAY;
	  if (get_values(start, end, &(colorspec.values[0]), 1) == 1)
	    dev_begin_dev_color(&colorspec);
	} else if (!strcmp(token, "hsb")) {
	  WARN("color special: hsb not implemented.");
	} else { /* Must be a "named" color */
	  dev_begin_named_color(token);
	}
	RELEASE(token);
      }
    } else if (!strcmp(command, "pop")) { /* Handle a pop */
      dev_end_color();
    } else { /* Assume this is a default color change */
      token = command;
      if (!strcmp(token, "rgb")) { /* Handle rgb color */
	colorspec.space_id = PDF_COLOR_DEV_RGB;
	if (get_values(start, end, &(colorspec.values[0]), 3) == 3)
	  dev_set_def_dev_color(&colorspec);
      } else if (!strcmp(token, "cmyk")) { /* Handle cmyk color */
	colorspec.space_id = PDF_COLOR_DEV_CMYK;
	if (get_values(start, end, &(colorspec.values[0]), 4) == 4)
	  dev_set_def_dev_color(&colorspec);
      } else if (!strcmp(token, "gray")) { /* Handle gray */
	colorspec.space_id = PDF_COLOR_DEV_GRAY;
	if (get_values(start, end, &(colorspec.values[0]), 1) == 1)
	  dev_set_def_dev_color(&colorspec);
      } else if (!strcmp(token, "hsb")) {
	WARN("color special: hsb not implemented.");
      } else { /* Must be a "named" color */
	dev_set_def_named_color(token);
      }
    }
  }
  RELEASE(command);
}

static void
do_background_special (char **start, char *end)
{
  pdf_color colorspec;
  char *token;

  skip_white (start, end);
  if ((token = parse_ident (start, end))) {
    if (!strcmp(token, "rgb")) { /* Handle rgb color */
      colorspec.space_id = PDF_COLOR_DEV_RGB;
      if (get_values(start, end, &(colorspec.values[0]), 3) == 3)
	dev_bg_dev_color(&colorspec);
    } else if (!strcmp (token, "cmyk")) { /* Handle cmyk color */
      colorspec.space_id = PDF_COLOR_DEV_CMYK;
      if (get_values(start, end, &(colorspec.values[0]), 4) == 4)
	dev_bg_dev_color(&colorspec);
    } else if (!strcmp (token, "gray")) { /* Handle gray */
      colorspec.space_id = PDF_COLOR_DEV_GRAY;
      if (get_values(start, end, &(colorspec.values[0]), 1) == 1)
	dev_bg_dev_color(&colorspec);
    } else if (!strcmp(token, "hsb")) {
      WARN("color special: hsb not implemented.");
    } else { /* Must be a "named" color */
      dev_bg_named_color(token);
    }
    RELEASE(token);
  }
}

/*
 * The two specials papersize and landscape are applied only if
 * they were in the first page of the DVI file. Otherwise ignored.
 * See dvi_paper_size() in dvi.c for more details. */

/* Color_special() handles color specials and also
   handles papersize and landscape specials since
   there's no good place to put them  */

int
color_special (char *buffer, UNSIGNED_QUAD size)
{
  char *start = buffer, *end;
  int result = 0;

  end = buffer + size;
  skip_white(&start, end);
  if (!strncmp(start, "color", strlen("color"))) {
    start += strlen("color");
    result = 1; /* This is a color special */
    do_color_special(&start, end);
  } else if (!strncmp(start, "background", strlen("background"))) {
    start += strlen("background");
    result = 1; /* This is a color special */
    do_background_special(&start, end);
  } else if (!strncmp(start, "landscape", strlen("landscape"))) {
    result = 1;
  } else if (!strncmp(start, "papersize", strlen("papersize"))) {
    result = 1; 
  }

  return result;
}
